/********************************************************************
 * C Users Group (U.K) C Source Code Library File CUGLIB.011        *
 * Inquiries to: M. Houston, 36 Whetstone Clo. Farquhar Rd.         *
 * Edgbaston, Birmingham B15 2QN ENGLAND			    *
 ********************************************************************
 * File name: bsplit.c
 * Program name: bcombine
 * Source of file: written by Martin Houston
 * Purpose: 
 *
 * bsplit: a Binary version of the Unix split command.
 * Instead of working on text lines like split does bsplit will
 * fragment the input file into evenley sized pieces (except for
 * any left over from the input).
 *
 * bsplit [-nbytes] [file [name]]
 *
 * - can be given for file if standard input is to be used
 * bytes is taken as a long decimal value
 * name is the prefix used for the files created.
 * The first file created will be {name}aa, the second {name}ab and so on.
 *
 * Changes: <who what when & why major changes have been made>      
 */
#include <stdio.h>
#include <fcntl.h>

#define CHUNKSIZE 10240L	/* 10K default for n */
extern long atol();

/*
 * Get the next name in the series.
 */
static char *namegen(seed)
char *seed;
{
	static int count = 0;
	static char1 = 'a';
	static char2 = 'a';
	char result[40];

	if(strlen(seed) > (sizeof(result) - 2))
	    seed[sizeof(result) - 2] = 0; /* truncate so result will fit */

	sprintf(result,"%s%c%c", seed, char1, char2);
	if(++char2 > 'z')
	{
	    char2 = 'a';
	    if(++char1 > 'z')
	    {
		fprintf(stderr,"bsplit has run out of file names!\n");
		exit(0);
	    }
	}

	return result;
}

main(argc, argv)
int argc;
char **argv;
{

	int fdesc = 0;
	long filesize = CHUNKSIZE;
	char *filename = "x";	/* default of no name specified */

	if(argc > 1)
	{
		if((argv[1][0] == '-') && (argv[1][1] == 'n'))
		{
			filesize = atol(&(argv[1][2]));
			argv++;	/* move count on */
			argc--;
		}
		if(argc > 1)
		{
		    if(argv[1][0] == '-')
			fdesc = dup(0);
		    else
		        fdesc = open(argv[1], O_RDONLY);
		    if(fdesc < 0)
		    {
			fprintf(stderr,"bsplit cannot open %s\n", argv[1]);
			exit(0);
		    }
		    argv++;	/* move count on */
		    argc--;
		}
		if(argc > 1)
		    filename = argv[1];
	}

	splitit(fdesc, filesize, filename);
}

splitit(input, chunksize, seed)
int input;
long chunksize;
char *seed;
{
	static char buf[20480];	/* io buffer */
	char *outname;
	int rcnt, wcnt;
	int outfd;
	long byteswritten = 0L;
	char boundflag;

	outname = namegen(seed);
	if((outfd = open(outname, O_WRONLY| O_CREAT, 0666)) < 0)
	{
	    fprintf(stderr,"bsplit cannot open %s\n", outname);
	    exit(0);
	}
	do
	{
	    if(byteswritten >= chunksize)
	    {
		close(outfd);
	        outname = namegen(seed);
	        if((outfd = open(outname, O_WRONLY| O_CREAT, 0666)) < 0)
	        {
	            fprintf(stderr,"bsplit cannot open %s\n", outname);
	            exit(0);
	        }
		byteswritten = 0L;
            }
	    boundflag = 0;
	    if((chunksize - byteswritten) < (long)sizeof(buf))
		rcnt = (int)(chunksize - byteswritten);
	    else
		rcnt = sizeof(buf);
	    if(rcnt > 0)
		rcnt = read(input, buf, rcnt);
	    else
		boundflag = 1; /* run out of data */
	    if(rcnt > 0)
	    {
	        wcnt = write(outfd, buf, rcnt);
		if(wcnt != rcnt)
	        {
	            fprintf(stderr,"bsplit write failure on %s\n", outname);
	            exit(0);
	        }
	    }
	    byteswritten += (long)wcnt;
	}
	while(boundflag || rcnt > 0);
}

