/********************************************************************
 * C Users Group (U.K) C Source Code Library File CUGLIB.011        *
 * Inquiries to: M. Houston, 36 Whetstone Clo. Farquhar Rd.         *
 * Edgbaston, Birmingham B15 2QN ENGLAND			    *
 ********************************************************************
 * File name: bcombine.c
 * Program name: bcombine
 * Source of file: written by Martin Houston
 * Purpose: 
 *
 * bcombine: a program that undoes the affect of bsplit
 *
 * bcombine [name[file]]
 *
 * name is the prefix used for the files read in.
 * file is the destination for the re-combined file.
 * Standard out is used if this is not specified.
 * The first file read will be {name}aa, the second {name}ab and so on.
 *
 * Changes: <who what when & why major changes have been made>      
 ********************************************************************/
#include <stdio.h>
#include <fcntl.h>
#define BS 20480
#define SS 40

extern long atol();

/*
 * Get the next name in the series.
 */
static char *namegen(seed)
char *seed;
{
	static int count = 0;
	static char1 = 'a';
	static char2 = 'a';
	char result[SS];

	if(strlen(seed) > (SS - 2))
	    seed[SS - 2] = 0; /* truncate so result will fit */

	sprintf(result,"%s%c%c", seed, char1, char2);
	if(++char2 > 'z')
	{
	    char2 = 'a';
	    if(++char1 > 'z')
	    {
		fprintf(stderr,"bcombine has run out of file names!\n");
		exit(0);
	    }
	}
	return result;
}

main(argc, argv)
int argc;
char **argv;
{

	int fdesc = dup(1);     /* std out */
	char *filename = "x";	/* default of no name specified */

	
	if(argc > 1)
	{
	    filename = argv[1];
	    argv++;	/* move count on */
	    argc--;
	    if(argc > 1)
	    {
		if(argv[1][0] != '-')
		{
		    fdesc = open(argv[1], O_WRONLY | O_CREAT, 0666);
		    if(fdesc < 0)
		    {
			fprintf(stderr,"bcombine cannot open %s\n", argv[1]);
			exit(0);
		    }
		}
	    }
	}

	combineit(fdesc, filename);
}

combineit(output, seed)
int output;
char *seed;
{
	static char buf[BS];	/* io buffer */
	char *inname;
	int rcnt, wcnt;
	int infd;

	inname = namegen(seed);
	if((infd = open(inname, O_RDONLY)) < 0)
	{
	    close(output); /* end of the line */
	    exit(0);
	}
	while((rcnt = read(infd, buf, BS)) > 0)
	{
	    wcnt = write(output, buf, rcnt);
	    if(rcnt < 0)
	    {
		/* don't stop processing */
		fprintf(stderr, "bcombine: read error\n");
	    }
	    if(wcnt < rcnt)
	    {
		fprintf(stderr, "bcombine: write error\n");
	    }
	    if(rcnt < BS)
	    {
		close(infd);
	        inname = namegen(seed);
	        if((infd = open(inname, O_RDONLY)) < 0)
	        {
		    close(output);
	            exit(0);
	        }
            }
	}
}

