
/*
YAMP - Yet Another Matrix Program
Version: 1.3 
Author: Mark Von Tress, Ph.D.
Date: 03/07/92

Copyright(c) Mark Von Tress 1992
Portions of this code are (c) 1991 by Allen I. Holub and are used by
permission

DISCLAIMER: THIS PROGRAM IS PROVIDED AS IS, WITHOUT ANY
WARRANTY, EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED
TO FITNESS FOR A PARTICULAR PURPOSE. THE AUTHOR DISCLAIMS
ALL LIABILITY FOR DIRECT OR CONSEQUENTIAL DAMAGES RESULTING
FROM USE OF THIS PROGRAM.

*/


#include "dist.h"

/********************************* end noncentral chi-square */
void list_choice(void)
  {
      printf("0. ) quit\n");
      printf("1. ) beta( x, a, b)\n");
      printf("2. ) non-central beta(x,a,b,l)\n");
      printf("3. ) non-central f(f,df1,df2,l)\n");
      printf("4. ) central f(f,df1,df2)\n");
      printf("5. ) inverse standard normal(p)\n");
      printf("6. ) standard normal(z)\n");
      printf("7. ) inverse non-central f(p,df1,df2,l)\n");
      printf("8. ) inverse central f(p,df1,df2)\n");
      printf("9. ) non-central t(t,df,l)\n");
      printf("10.) central t(t,df)\n");
      printf("11.) inverse non-central t(p,df,l)\n");
      printf("12.) inverse central t(p,df)\n");
      printf("13.) gamma(x,a,b)\n");
      printf("14.) non-central chi-square(x,df,l)\n");
      printf("15.) central chi-square(x,df)\n");
      printf("16.) inverse non-central chi-square(p,df,l)\n");
      printf("17.) inverse central chi-square(p,df)\n");
   }
void evaluate_probs( int choice )
   {
   double x,a,b,p,df1,df2,df,lam,f,t;
   x=a=b=p=df1=df2=df=lam=f=t=0.0;

 switch ( choice ){
  case  0:{exit(0);
	   break;
	   }
  case  1:{printf("\nx  : "); scanf("%lf",&x);
	   printf("a  : ");   scanf("%lf",&a);
	   printf("b  : ");   scanf("%lf",&b);
	   printf("beta dist ");
	   printf("p  : %5.4f\n",betai(a,b,x));
	   break;
	   }
  case  2:{printf("\nx  : "); scanf("%lf",&x);
	   printf("a  : ");   scanf("%lf",&a);
	   printf("b  : ");   scanf("%lf",&b);
	   printf("l  : ");   scanf("%lf",&lam);
	   printf("non-central beta dist ");
	   printf("p  : %5.4f\n",ncbeta(x,a,b,lam));
	   break;
	   }
  case  3:{printf("\nf  : "); scanf("%lf",&f);
	   printf("df1: ");   scanf("%lf",&df1);
	   printf("df2: ");   scanf("%lf",&df2);
	   printf("l  : ");   scanf("%lf",&lam);
	   printf("non-central f ");
	   printf("p  : %5.4f\n",ncf(f,df1,df2,lam));
	   break;
	   }
  case  4:{printf("\nf  : "); scanf("%lf",&f);
	   printf("df1: ");   scanf("%lf",&df1);
	   printf("df2: ");   scanf("%lf",&df2);
	   printf("central f ");
	   printf("p  : %5.4f\n",probf(f,df1,df2));
	   break;
	   }
  case  5:{printf("\np  : "); scanf("%lf",&p);
	   printf("inverse normal ");
	   printf("x  : %f\n",probnormi(p));
	   break;
	   }
  case  6:{printf("\nx  : "); scanf("%lf",&x);
	   printf("standard normal ");
	   printf("p  : %5.4f\n",probnorm(x));
	   break;
	   }
  case  7:{printf("\np  : "); scanf("%lf",&p);
	   printf("df1: ");   scanf("%lf",&df1);
	   printf("df2: ");   scanf("%lf",&df2);
	   printf("l  : ");   scanf("%lf",&lam);
	   printf("inverse non-central f ");
	   printf("f  : %10.4f\n",ncfinv(p,df1,df2,lam));
	   break;
	   }
  case  8:{printf("\np  : "); scanf("%lf",&p);
	   printf("df1: ");   scanf("%lf",&df1);
	   printf("df2: ");   scanf("%lf",&df2);
	   printf("inverse central f ");
	   printf("f  : %10.4f\n",probfi(p,df1,df2));
	   break;
	   }
  case  9:{printf("\nt  : "); scanf("%lf",&t);
	   printf("df1: ");   scanf("%lf",&df);
	   printf("lam: ");   scanf("%lf",&lam);
	   printf("non-central t ");
	   printf("p  : %5.4f\n",nct(t,df,lam));
	   break;
	   }
  case 10:{printf("\nt  : "); scanf("%lf",&t);
	   printf("df1: ");   scanf("%lf",&df);
	   printf("central t ");
	   printf("p  : %5.4f\n",probt(t,df));
	   break;
	   }
  case 11:{printf("\np  : "); scanf("%lf",&p);
	   printf("df : ");   scanf("%lf",&df);
	   printf("lam: ");   scanf("%lf",&lam);
	   printf("inverse non-central t ");
	   printf("t  : %10.4f\n",ncti(p,df,lam));
	   break;
	   }
  case 12:{printf("\np  : "); scanf("%lf",&p);
	   printf("df1: ");   scanf("%lf",&df);
	   printf("inverse central t ");
	   printf("t  : %10.4f\n",probti(p,df));
	   break;
	   }
  case 13:{printf("\nx  : "); scanf("%lf",&x);
	   printf("a  : ");   scanf("%lf",&a);
	   printf("b  : ");   scanf("%lf",&b);
	   printf("gamma dist ");
	   printf("p  : %5.4f\n",gammp(x,a,b));
	   break;
	   }
  case 14:{printf("\nx  : "); scanf("%lf",&x);
	   printf("df : ");   scanf("%lf",&df);
	   printf("lam: ");   scanf("%lf",&lam);
	   printf("non-central chi-square ");
	   printf("p  : %5.4f\n",ncchi(x,df,lam));
	   break;
	   }
  case 15:{printf("\nx  : "); scanf("%lf",&x);
	   printf("df : ");   scanf("%lf",&df);
	   printf("central chi-square ");
	   printf("p  : %5.4f\n",probchi(x,df));
	   break;
	   }
  case 16:{printf("\np  : "); scanf("%lf",&p);
	   printf("df : ");   scanf("%lf",&df);
	   printf("lam: ");   scanf("%lf",&lam);
	   printf("inverse non-central chi-square ");
	   printf("x  : %10.4f\n",ncchii(p,df,lam));
	   break;
	   }
  case 17:{printf("\np  : "); scanf("%lf",&p);
	   printf("df : ");   scanf("%lf",&df);
	   printf("inverse central chi-square ");
	   printf("x  : %10.4f\n",probchii(p,df));
	   break;
	   }
  default: printf( " try again \n");
  } /* end switch */
}
main()
 {
   int choice = 1, another = 1;
   while( choice ){
      list_choice();
      printf("enter your choice:  "); scanf("%d",&choice);
      another = 1;
      while( another && choice ){
           printf("enter the parameters\n");
	   evaluate_probs(choice);
	   printf("another ( 0=no, 1=yes ): "); scanf("%d",&another);
      }
    }
  exit(0);
}
