
/*
YAMP - Yet Another Matrix Program
Version: 1.3 
Author: Mark Von Tress, Ph.D.
Date: 03/07/92

Copyright(c) Mark Von Tress 1992
Portions of this code are (c) 1991 by Allen I. Holub and are used by
permission

DISCLAIMER: THIS PROGRAM IS PROVIDED AS IS, WITHOUT ANY
WARRANTY, EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED
TO FITNESS FOR A PARTICULAR PURPOSE. THE AUTHOR DISCLAIMS
ALL LIABILITY FOR DIRECT OR CONSEQUENTIAL DAMAGES RESULTING
FROM USE OF THIS PROGRAM.

*/


#include "virt.h"

MStack *Dispatch = new MStack;


int main()
{

  VMatrix g;
  int n = 100;
  g = Fill( n,2, 1);
  for( int i = 1; i <=n; i++ ) {
     g.M( i,1 ) = ((double) i);
     g.M( i,2 ) = 1.0e-8*((double) random(i+1));
  }

  g.Nameit("graph matrix");
  GMatrix Agraph(g);
  Agraph.title  = "Test title 1";
  Agraph.title2 = "test title 2";
  Agraph.xname = "x axis";
  Agraph.yname = "y axis";
  Agraph.RectangleOn = FFALSE;
  Agraph.Href( 36.0 );
  Agraph.Vref( 60.0 );
  Agraph.Show();
  for( i = 1; i <=n; i++ ) {
     g.M( i,2 ) = 0.5*g.m(i,2);
  }
  Agraph.AddVec( g, '+' );
  Agraph.RectangleOn = TTRUE;
  Agraph.YGridOn = TTRUE;
  Agraph.XGridOn = TTRUE;
  Agraph.ClearHref( );
  Agraph.ClearVref( );
  Agraph.Show();
  closegraph(); 		/* Return the system to text mode	*/
  vclose();
  return(0);
}










//////////////////////////////////////////////////
