
#
# Make file for BCC. Make sure to correct the definitions for
# your machine.
#
# This makefile constructs virtlib.lib using the
# large memory model, debug info off, no fast floating point,
# and all other defaults, ie emulation, and standard
# optimizations. 

CURDIR = C:\MATH\MATPP
INCDIR = C:\TC\INCLUDE

.PATH.obj = $(CURDIR)

#		*Translator Definitions*
CC = bcc -c +TO_LIB.CFG
TLINK = tlink

#		*List Macros*
EXES = virtop.obj virt.obj virtgraf.obj dist.obj
CCS  = virt.h dist.h virt.cpp virtop.cpp virtgraf.cpp dist.cpp

#               *Implicit Rules*
.cpp.obj:
  $(CC) -c {$< }



#		*Explicit Rules*
#        all must be the first explicit rule

all: to_lib.cfg virtlib.lib to_lib.mak $(CCS) $(EXES) 
     del to_lib.cfg

virtop.obj: virtop.cpp

virt.obj: virt.cpp

virtgraf.obj: virtgraf.cpp

dist.obj: dist.cpp

virtlib.lib: to_lib.mak $(EXES)
   tlib virtlib.lib /C +-virt +-virtop +-virtgraf +-dist, virtlib.lis

#		*Compiler Configuration File*
# change -DVIRTGRAF to -DVIRTGRAF;IN_RAM for in ram version
# make sure to build the library with the same defines

to_lib.cfg: to_lib.mak 
  copy &&|
-ml
-v-
-vi-
-ff-
-DVIRTGRAF
-n$(CURDIR)
-I$(INCDIR)
| to_lib.cfg



