/********************************************************************
 * C Users Group (U.K) C Source Code Library File CUGLIB.005        *
 * Inquiries to: M. Houston, 36 Whetstone Clo. Farquhar Rd.         *
 * Edgbaston, Birmingham B15 2QN ENGLAND			    *
 ********************************************************************
 * File name: m_solve.c
 * Program name: library modules only
 * Source of file: The Public Domain Software Library.
 * Purpose: Matrix maths function
 * Changes: <who what when & why major changes have been made>      
 ********************************************************************/

static char *sccsid = "@(#)m_solve.c	4/16/82 (U of Maryland, FLB)";

#include "mat.h"

struct matrix *
m_solve(a, b)
register struct matrix *a, *b;
{
register struct matrix *a_trans, *t, *t_inv, *t2, *x;

if ((a->m_rows) < (a->m_cols)) {
	printf("m_solve: too few equations\n");
	return(M_NULL);
	}

if ((a->m_rows) != (b->m_rows)) {
	printf("m_solve: arguments don't match: %d, %d.\n", a->m_rows, b->m_rows);
	return(M_NULL);
	}

if (b->m_cols != 1) {
	printf("m_solve: arg2 must have 1 column.\n");
	return(M_NULL);
	}

a_trans = m_transpose(a);		/* A' */
t = m_multiply(a_trans, a);		/* A' A */
t_inv = m_invert(t);			/* (A' A)-1 */
free(t);
if (t_inv == M_NULL) {
	printf("m_solve: no solution\n");
	return(M_NULL);
	}
t2 = m_multiply(t_inv, a_trans);	/* (A' A)-1 A' */
free(t_inv);
free(a_trans);
x = m_multiply(t2, b);			/* (A' A)-1 A' B */
free(t2);

return(x);
}
