

                         Version 2.0


          Version 1 of rulebase was developed at the
          IT & Expert Systems Unit for use on our
          Expert Systems courses and on externally
          funded applications.  It has since been
          used by other institutions on their Expert
          Systems courses and for training Knowledge
          Engineers, running successfully with over
          600 rules.


          Version 2.0  was developed in response to
          the request for extra features from
          existing users.  A more controllable
          applications user interface has been
          introduced with user controlled colours
          and windows, an arithmetic capability has
          been included in the rules and the system
          extensively reworked for greater memory
          efficiency.


                   IT & Expert System Unit
                      Aston Science Park
                      Birmingham B7 4EG
                  Telephone:  021 333 34901
                      Fax:  021 333 3170



          May 1992



                             Copyright



     Copyright resides with Birmingham City Council.

     Copies of rulebase purchased as a single licensed
     user are subject to the following restrictions:
          The software is for use by one person on any
          one machine at any time.
          Except for one back-up copy, no additional
          copies of the software can be made.
          No additional copies of the documentation can
          be made.

     Copies of rulebase purchased under a site
     licensing agreement are subject to the following
     restrictions:
          The software and documentation may be used by
          any number of people and on any number of
          machines within the site identified at the
          time of purchase.
          The software and documentation can be freely
          copied for use within the site but may not be
          sold, loaned or otherwise distributed off the
          site.


Contents


1  Introduction to Expert Systems
    1.1  What is an Expert System
        1.1.1  Knowledge
        1.1.2  Forward and Backward Chaining
    1.2  Using this manual
    1.3  Overview of rulebase


2  Installing rulebase
    2.1  System  Requirements
    2.2  Installing rulebase on a hard disk
    2.3  Installing rulebase on dual floppy disk drives


3  Using rulebase for the first time
    3.1  Starting rulebase
    3.2  Using the Menu System
    3.3  Loading the Rules (the Knowledge Base)
    3.4  Consulting
    3.5  Optional Responses
        3.5.1  Facts
        3.5.2  How
        3.5.3  Why
    3.6  Displaying Rules
    3.7  Displaying Queries
    3.8  Quitting


4  Editing
    4.1  Starting the Editor and Loading Rules
    4.2  Creating and modifying rules
    4.3  Saving the knowledge base
    4.4  Testing
    4.5  Printing
    4.6  Questions
    4.7  Correcting Errors

                              1


5  Further Features of rulebase
    5.1  Consulting
    5.2  Explain Text
    5.3  More about Responding to rulebase
    5.4  More about Displaying conclusions
    5.5  Text files
        5.5.1  Displaying text from a file
        5.5.2  Editing Text
        5.6  Displaying graphics
    5.7  Cutpic
    5.8  DOS Facility


6  Modifying a Knowledge Base
    6.1  Asking the User to enter a reply
    6.2  Rules with Several possible responses.
    6.3  Manipulation of Files
    6.4  Saving facts
    6.5  Loading facts
    6.6  Linking knowledge bases together
    6.7  Using keys
    6.8  Modifying the CUSTOMS knowledge base


7  Building a simple knowledge base
    7.1 Building a PICNIC knowledge base
        7.1.1  Creating Rules
        7.1.2  Building your knowledge base
        7.1.3  Consulting
        7.1.4  Editing the knowledge base
        7.1.5  Adding Questions
    7.2  Building a HOLIDAY knowledge base
        7.2.1  Creating Rules
        7.2.2  Building your knowledge base
        7.2.3  Adding questions
        7.2.4  Adding explanations
    7.3 Capturing Expertise
        7.3.1 Types of Problems for Expert Systems
        7.3.2  Organising the problem


8 Using other Software Applications from rulebase
    8.1  Word processors
    8.2  dBase
    8.3  Lotus 123
    8.4  .exe files

                              2

9  rulebase Reference Section
    9.1 Statements in a knowledge base
    9.2  Rules
        9.2.1  The 'OR' operator
        9.2.2  The 'is only
        9.2.3  Conflict resolution (Rule Ordering)
        9.2.4  Circular arguments
        9.2.5  Contradictory rules
    9.3  Conclusion options
    9.4  Negative conditions
    9.5  Questions
    9.6  'One of' or 'Any of'
    9.7  'enter reply
    9.8  Explanations
    9.9  Formatting Printed Text
    9.10  True Conditions
    9.11  Use of 'anything'
    9.12  Queries
    9.13  Facts
    9.15  Use of variables
    9.16  rulebase Applications
    9.17  Lookup tables
    9.18  Performing Calculations
    9.19  Controlling Windows
        9.19.1  User Input
        9.19.1.1  User Input Window Defaults
        9.19.1.2  User Input Window Cascade
        9.19.2  User Output
        9.19.2.1  User Output Window Cascade
        9.19.2.2  Removing Report Border


Appendices
    A.  The Animals knowledge base
    B.  The Carfault Knowledge Base
    C.  The Customs Knowledge Base
    D.  The PICNIC knowledge base
    E.  The Holiday knowledge base
    F.  rulebase Editor Command Summary



Part One

Introduction to Expert Systems


1.1  What is an Expert System?

An expert is a person having special knowledge or skill.  We
all make use of a variety of experts.  Whether it is a car
that will not start, a central heating system which does not
heat, a suit which does not fit or a pain that keeps
recurring, we call on the appropriate expert.  All these
experts seem to work in a similar way.  They ask a lot of


                              3

Introduction


questions! Each is using his/her specialist knowledge to
precisely identify your particular situation. For example the
questions a doctor may ask you are different from those asked
of the previous patient and different again from those asked
of the next.  The expert's knowledge enables him/her to ask
the questions which will help diagnose your problem but ignore
many questions which do not help in the diagnosis.

An Expert System is a computer program that captures valuable
knowledge and makes it available for consultation by non-
experts.  It usually consists of:

     a set of rules called the knowledge base;
     a rule interpreter (often called an Inference Engine);
     an editor to create and modify the rules.

The inference engine can be used with different knowledge
bases so the Expert System can provide expertise in any field
of knowledge, provided of course that the necessary rules have
been written.

Consulting an expert system is not unlike consulting a human
expert.  The expert asks questions depending on previous
responses and background knowledge.  The expert and the expert
system both eventually arrive at a conclusion.  They both
should be able to report on what conclusions have been reached
at any stage of the consultation, justify why a particular
question is being asked and explain how they arrive at
particular conclusions.

A non-expert can consult the Expert System with a problem in
much the same way as a human expert would be consulted, using
a question and answer technique whereby the expert asks
questions  and the non-expert responds.  This process is
controlled by the Expert System using it's Inference Engine.

























                              4

Introduction


Throughout a consultation, the expert system is accountable to
the non-expert and should be able to report what conclusions
have been deduced at any stage, justify 'why' a particular
question is being asked, explain 'how' conclusions are arrived
at and give explanations as to why it is asking a particular
question.

The Knowledge Base is kept separate from the Inference Engine
to allow the system's knowledge to be updated independently
from the rest of the system.

An Expert Systems Shell is an Inference Engine, an empty
Knowledge Base and usually an editor to enter a Knowledge
Base, although this can often by done with a word processor.

To build a knowledge base it is necessary to make use of an
expert's knowledge to formulate a set of rules which best
represent that knowledge.  This can be a specialist task in
its own right.  Once established the knowledge base needs to
be thoroughly tested by the expert to ensure that the expert
system always reaches consistent conclusions.



1.1.1  Knowledge

Knowledge used in expert systems (as opposed to its use in
philosophical discussion) falls into three basic types, which
will be referred to as (i) facts (ii) rules and (iii) control.
Together, these form the knowledge base of the expert system.

  i) Facts
  These are simple descriptions about the world.
  For example: It is raining.

  ii) Rules
  Rules are used to manipulate and process facts.
  rulebase uses what is known as production rules of the form:
     IF condition AND condition AND ... THEN conclusion.

  For example:
     IF it is raining AND you must go out THEN take a
  umbrella.

  iii) Control
  This determines which procedures and rules to apply in a
  given situation.
  For example:
     If car lights do not work then check for electrical
  fault.










                              5

Introduction


1.1.2  Forward and Backward Chaining

Rules can be processed using forward and backward chaining.

Forward Chaining:

Here the inference engine uses the knowledge base to try to
prove as many conclusions as possible by applying all facts
from the knowledge base to all the conditions of all the
rules.  Any conclusions that are proven are added to the
inference engine's store of "current facts".  These current
facts are repeatedly applied to all the conditions of all the
rules to prove more conclusions, which are used to update the
current facts, and so on until it is no longer possible to
generate new facts.


Backward Chaining:

Here the inference engine starts by trying to prove a
hypothesis.  It does this by selecting rules in the knowledge
base that have the hypothesis in their conclusion and trying
to prove the conditions contained in any of these rules, using
the current facts and any other rules in the knowledge base.
This inevitably involves setting up conditions as sub-
hypotheses and trying to find rules to verify these sub-
hypotheses.  When the current facts and knowledge base are
unable to prove or disprove an hypothesis/sub-hypothesis, the
inference engine will ask the user for help.

rulebase starts by backward chaining.  To do this is needs an
hypothesis or "query".  If there are queries in the knowledge
base then these are used, otherwise it generates its own by
inspecting the rules to determine what it doesn't know.
When rulebase proves an hypothesis, it updates its current
facts and automatically forward chains to generate further
facts that then follow.
It then reverts to backward chaining.



1.2  Using this manual to learn rulebase

This manual guides you through three simple knowledge bases so
you can quickly find out how an expert system works and
practice using the features of rulebase.  The three knowledge
bases are called ANIMALS, CARFAULT and CUSTOMS.

You will also build two simple knowledge bases called PICNIC
and HOLIDAY.










                              6

Introduction


1.3  Overview of rulebase

rulebase is an easy to use yet powerful Expert Systems Shell.
It's main features include:

   A pop-up menu system;

   A Wordstar like editor which includes searching, replacing,
   merging, printing and block operations.  This editor is
   used to generate knowledge bases and simple text files;

   Knowledge bases in normal production rule form:
     IF condition AND condition AND ... condition THEN
   conclusion;

   Rule operators 'and', 'or' and 'not';

   Conclusions with the following features:
      display any number of graphics on screen with text if
      required,
      display text to screen, file or printer,
      display files of text to screen, file or printer,
      switch to a new knowledge base,
      quit rulebase,
      save the current knowledge and resume at a later date,
      call any MSDOS command,
      call and execute software packages with parameter
      passing -  e.g: dBase, Lotus;

   Any number of the above features in a conclusion:
     e.g: call a graphic, display text, execute dBase, ...;

   Automatic generation of user questions;

   User defined questions for any condition in any rule;

   User defined windows and colours for reports and questions;

   User defined explanations for any rule;

   An option to look-up facts from a database;

   An option to generate run-time user applications;

   An option to ask a single choice questions -
     e.g: question - 'What colour is the liquid?'
          answer    - 'Choose one from (green, yellow, red)';

   An option to ask multi-choice questions -
     e.g: question - 'What colour is the liquid?'
          answer    - 'Choose any from (green, yellow, red)';

   An option to record data input by the user -
     e.g: question - 'What is your name'
          answer    - 'Enter reply';





                              7

Introduction


   Response options that include 'none of these' and 'I don't
   know' which force the inference mechanism to try to find
   alternative lines of reasoning;

   An option to set up queries in the knowledge base to
   control rulebase's backward chaining;






















































                              8

Introduction


   Forward chaining;

   An option to enter known facts into the knowledge base;

   Formatted reports to printer, screen or file;

   Automatic syntax checking of a knowledge base and the
   flagging of errors to aid debugging;

   Automatic numbering and re-numbering of the knowledge base
   rules;

   An inference mechanism that forces the expert system to
   explain and justify its reasoning using:

      Facts -  to report what information has been deduced,
      How -  to explain how a fact has been deduced,
      Why -  to explain why a question is being asked.
             Multiple why's will backtrack through the systems
             line of reasoning giving explanations at each
             level;

   Chaining multiple knowledge bases and passing facts between
   them;

   The ability to modify graphics to make them suitable for
   use in the knowledge base;

   Calls to MSDOS from the system at any time without losing
   any work done up to that point;

   Variable substitution (see $Fah-value$ in example below);

   Arithmetic in rules.
   e.g: IF Fahrenheit temperature is $Fah-value$
          THEN Celsius temperature is (+ (* $Fah-value$ (/ 9
   5)) 32)























                              9

Installing rulebase


Part two:

Installing rulebase



2.1  System  Requirements

rulebase can be supplied on either a 3.5" or 5.25" disk.  It
will run on any IBM compatible system supporting CGA graphics
or better, with 512K bytes or more of memory.  It can be used
from a floppy disk although some of the more advanced features
are only practicable with a hard disk.



2.2  Installing rulebase on a hard disk

Switch on your computer system as normal and put your rulebase
distribution disk into your floppy disk drive (normally drive
A:).
You should now see the hard disks systems prompt (C:> or
similar).
Type:
          md rulebase    <enter>
          cd rulebase    <enter>
          copy a:*.*     <enter>



2.3  Installing rulebase on dual floppy disk drives

If you intend to use the program from a floppy disk it is
important to make a working copy of your distribution disk.
Always use the copy and keep the original in a safe place in
case you ever need it.
Write protect your distribution disk.

Firstly format a new disk.
Switch on your computer system as normal using a "system disk"
in drive A:.
Put your new disk in drive B: and type:
          b:   <enter>
          format    <enter>

When the format is complete (after replying 'N' to the prompt
"Format another (Y/N)?") put your rulebase distribution disk
in Drive drive A:.
Type:
          copy a:*.* <enter>










                              10

Installing rulebase


Keep the distribution disk in a safe place and use your
working copy of rulebase


























































                              11

Using rulbase for the first time


Part Three:

Using rulebase for the first time

The Expert System's inference engine needs a knowledge base,
or set of rules, before it can become an "expert".
In this section you will use the rulebase menu system to load
in a simple set of rules (called ANIMALS), consult these rules
and modify them.



3.1  Starting rulebase

If you have installed rulebase as described in the previous
chapter type:
          rulebase      <enter>

If you are using a hard disk machine both the rulebase program
and any knowledge bases will be on the hard disk.
If you are using floppy drives you must ensure that your
rulebase working disk is in drive A:.  The knowledge bases can
be on the same disk or on a separate disk in drive B:.



3.2  Using the Menu System

When the program starts you will see a title screen with a
message to:
          "Press the Space-Bar to continue"

When you press the space-bar you will see the following screen
with the Main Menu options shown across the bottom.


























                              12

Using rulbase for the first time


'Editor' is highlighted.

To select a menu item:
   Press the space-bar or use the arrow keys to highlight an
   option and select it by pressing <enter>.
   Or press the initial letter of the option (E,R,T or Q).

   Pressing M, or <Esc> from a sub-menu will return you to the
   Main Menu.
   Pressing <Esc> one or more times will always return you to
   the Main Menu.

The information displayed at the top of the screen shows the
current disk drive and directory and the name of the rules in
use, initially 'None'.



3.3  Loading the Rules (the Knowledge Base)

To load a set of rules use the Run Rules sub-menu.
From the Main Menu press:
   R   (Run Rules)
   L   (Load Rules)


















Enter the Rules name:    ANIMALS   <enter>

A message "Checking file.  Please wait... " is displayed for a
moment and the Run Rules sub-menu is re-displayed.














                              13

Using rulbase for the first time


Notice the name of the knowledge base, ANIMALS.KBX, is
displayed at the top right of the screen.


















The following rules have been loaded:

      Rule 1
          IF animal AND horns AND moos THEN cow;
      Rule 2
          IF bleats AND animal AND horns THEN goat;
      Rule 3
          IF animal AND wool THEN sheep;
      Rule 4
          IF animal AND baas THEN sheep;
      Rule 5
          IF bird AND clucks THEN hen;
      Rule 6
          IF bird AND quacks THEN duck;
      Rule 7
          IF animal AND barks THEN dog;
      Rule 8
          IF animal AND miaows THEN cat;
      Rule 9
          IF four legs THEN animal;
      Rule 10
          IF feathers THEN bird;
      Rule 11
          IF lays eggs THEN bird;
      Rule 12
          IF sheep AND horns THEN ram;














                              14

Using rulbase for the first time


3.4  Consulting a Simple Knowledge Base

The rules you have just loaded are to help identify various
animals. The 'Run Rules' sub-menu is still displayed with 'Use
rules' highlighted.
If you have moved around the menu system since loading the
rules you can always re-select the Run Rules sub-menu by
pressing 'R" from the Main Menu.

          Press:  U   (Use rules)

Imagine you are looking at a animal but don't know what it is.
You will be asked a sequence of questions to help you identify
it.  Imagine you are looking at a dog (but don't yet know it's
called "dog"). You can see and hear various features which can
be used to determine what animal it is.

The Expert System displays

          Is this true : four legs?




Notice the markers on the 'Yes' option.
Use the cursor keys to move the marker up or down the menu.

Select 'Yes' by pressing the Space-Bar when the markers are in
the correct position.

Press the Space-Bar again to cancel an incorrect selection.

Press <enter> to confirm your choice.

          Is this true :horns?




Select 'No' and confirm your choice with <enter>.

          Is this true: feathers?





Answer No.












                              15

Using rulbase for the first time


Reply to the next questions that the animal does not lay eggs
and barks.

rulebase displays its conclusion 'dog' and asks the "Would you
like to try again?".


















     Press:  Y   (Yes)
     Press:  U   (Use rules)

Now consult rulebase thinking of a feathered animal, which
makes a quacking noise.



3.5  Optional Responses

During a question and answer session there are several
responses you can make.  Select your answer using the arrowed
keys or type the first letter of one of the following:

   (W)hy -     If you want to know 'why' you are being asked a
         question.  Repeated 'whys' will cause rulebase to
         backtrack on it's line of reasoning and report the
         steps it took in arriving at the current question.

   (F)acts -   if you want a list of everything deduced so
         far.  A 'not' indicates a negative deduction.

   (H)ow -     if you want to know how any fact has been
         deduced.
         After selecting 'How' you will be asked to enter your
         'query'.  This is the fact you are interested in.
         For example:     H  (How) Duck <enter>

Case is not important but spelling is!








                              16

Using rulbase for the first time


When a result has been found and reported, you are also given
       the option of:
   (Y)es -     to begin a new consultation to identify another
         animal (in this example).

   (N)o  -     to return to the Run Rules sub-menu.

   (M)ore -    to look for 'more' results.
         'More' continues with the consultation looking for
         alternative conclusions, if any.


















Having reached the conclusion that you are thinking of a duck,
we can find out what facts have been deduced.






























                              17

Using rulbase for the first time


3.5.1  Facts

Press:  F    (Facts).

A list of current facts will be displayed.


















Notice that after answering only 4 questions rulebase has
deduced a number of facts.  Some of these are positive (e.g.
BIRD) while some are negative (not ANIMAL).

You can press 'F' (Facts) at any time during the consultation
as well as when the consultation is complete.































                              18

Using rulbase for the first time


3.5.2  How

To see how rulebase arrived at a particular conclusion, for
example duck:
     Press:  H  (How)  duck   <enter>


















In other words rulebase is using rule 6 to conclude 'duck'.
You told it that it quacked but you haven't said it is a
'bird'.
     Press:  H  (How)  bird   <enter>


















rulebase has used the presence of feathers (which you entered
earlier) to conclude the creature was a 'bird', before it used
another fact to identify 'duck'.












                              19

Using rulbase for the first time


     Press:  H  (How)  feathers   <enter>.

You could also try (H)ow 'not animal'.

You can use H(ow) at any time during or at the end of a
consultation.

When you have finished exploring 'Facts' and 'How', press Y
(Yes) in answer to the question:
      'Would you like to try again?'.



3.5.3  Why

Select U (Use rules) from the 'Run rules' sub-menu.

Select 'Yes' for  "Is this true: four legs?"

When asked "Is this true: horns?":
     Press:  W   (for Why).

The reason for asking the current question is displayed.


















Press Space-bar to continue.

Press  'W'  for why again.

Notice that repeatedly pressing 'W' will display the current
line of reasoning.













                              20

Using rulbase for the first time


Reply 'Yes' for  "Is this true Horns?".

Press  H (How) to find out how horns has been deduced.
How:  horns  <enter>

rulebase responds:
          How horns?
          You told me Yes.

Notice that the question "Is this true Horns" has been
generated by rulebase.  More meaningful questions can be
defined by the user (see section 4.6).

Explanatory text may be included with a question and displayed
at the user's request.  This provides a way of explaining what
a question means or helping the user decide which response is
more appropriate in a situation (see section 5.2).

Try identifying a few more animals (cow, ram, hen or cat).
Try a four legged duck! (four legs, no horns, feathers, no
clucks, quacks).  Such  a creature is possible in this very
limited knowledge base (see section 4.2 for a solution to
this).

Try identifying a pig.
What noise does it make?  What does eat?  Does it have hair?
It certainly does not have feathers!

rulebase will display:
     "I have insufficient data to help you"

The knowledge base does not contain rules to help in this
situation.  An expert system can only be as good as the rules
supplied.  This situation is analogous to an expert who has
never encountered this particular animal.  He/she must either
admit the animal cannot be identified or study to increase
his/her knowledge.

The knowledge base can be edited to include additional rules
to identify new ANIMALS (see section 4).




















                              21

Using rulbase for the first time


3.6  Displaying Rules

Use the 'Rules List' option from the 'Run Rules' sub-menu if
you want to browse through the rules.  Note that it is not
possible to edit the rules when using this option.

While  you are still using the ANIMALS knowledge base:
     Press:  Esc    (Escape key) to return to the Main Menu.
     Press:  R to select the 'Run Rules' sub-menu
     Press:  R to select the 'Rules List' option.

A list of rules currently in use is displayed.
Knowledge bases can consist of many pages of rules.
     <PgDn>  or Space-Bar moves on to the next page.
     <PgUp>  moves back to the previous page.
     <Home>  jumps back to the first page.
     <End>   jumps to the last page.
     <Esc>   returns to the Main Menu.

The rules used by ANIMALS are quite understandable even if the
language seems a little clumsy.
Browse through the rules using 'PgUp' and 'PgDn'.

Notice how the rules link together.
Try to get a 'feel' for how this knowledge base will perform.

Production rules are not the only way of representing
knowledge but they are the most common.  They have the
following format:

     IF condition {AND condition} THEN conclusion;

There may be more than one condition:
     e.g. IF feathers THEN bird;
     e.g. IF animal AND baas THEN sheep;
     e.g. IF animal THEN NOT bird;

The conclusion of one rule is frequently used as a condition
of other rules:
     e.g. IF four legs THEN animal;
          IF animal AND barks THEN dog;

A large number of rules build up the reasoning which is the
basis of any knowledge base.

Notice that each rule is terminated with a semi-colon (;).
rulebase will report any rule without a semi-colon as an
error.












                              22

Using rulbase for the first time


3.7  Displaying Queries

After you have looked at the rules in the ANIMALS knowledge
base, press <Esc> to return to the Run Rules sub-menu.

     Select:  Q    (Queries List)


















These Queries are the hypotheses which rulebase will try to
prove, in the order shown.  rulebase will use the rules to try
and prove or disprove each of these in turn.

Queries can be defined in the knowledge base by the user:

     e.g. Query sheep, cow;

In this case rulebase will only try and prove these two
possibilities.
If no queries are given in a knowledge base, as in the case of
ANIMALS, then rulebase will generate its own list of queries.
It does this by inspecting the knowledge base and making a
list of every conclusion not contained in a condition of any
other rule.

In a very simple knowledge base, like ANIMALS, rulebase must
either identify one of these animals or conclude:
     "I have insufficient data to help you".

With complex knowledge bases rulebase will use alternative
rules to look for conclusions when questions are answered with
"Don't know".

Using 'More' after a consultation will cause rulebase to look
for alternative conclusions.










                              23

Using rulbase for the first time


3.8  Quitting rulebase

When you have just completed a consultation the following
message is displayed:
       "Would you like to try again?".

     Press:  N   (No)

From the Main Menu:

     Press   Q   (Quit)

If you want to quit while consulting a knowledge base, press
<Esc> several times to return to the Main Menu, then (Q)uit as
above.













































                              24

Editing a Knowledge Base


Part Four:

Editing a Knowledge Base


A rulebase knowledge base is created and developed using
rulebase's self-contained editor.  This section introduces the
editor and the way in which a small knowledge base consisting
of a few rules can be expanded and gradually developed into a
larger, more complex one.



4.1  Starting the Editor and Loading Rules

From the Main Menu select the E (Editor).




















The Editor sub-menu offers options to edit Rules, edit Text or
to Print a listing of the rules or text on your printer.

From the Editor sub-menu:

     Select:  R   (Rules).


















                              25

Editing a Knowledge Base


At the bottom of the screen you are asked to enter a filename.
If rulebase is already using a knowledge base, this name is
displayed and can be selected for editing by pressing <enter>.
If you enter the name of an existing knowledge base it will be
loaded from disk for you to edit.
If you enter a name for which there is no existing knowledge
base then you will see a blank screen ready for you to type in
a new set of rules.

You are going to edit the ANIMALS knowledge base.  If you
already have ANIMALS loaded (see Rules in top right hand
corner box)
     Press:  <enter>

If you haven't:
     type:   animals  <enter>

You can now enter new rules and edit existing rules.

If you are familiar with Wordstar (or other word processors)
you will find it easy to use the rulebase Editor.
A full list of the editing commands is given in Appendix F.

Using the Editor:
Notice that the name of the rules you are editing is displayed
at the bottom of the screen along with the row and column
number of the cursor position.

The word 'Insert' or 'replace' in the bottom right indicates
that the Editor is in INSERT or REPLACE mode.
To toggle between the two modes press the <Ins> key or hold
down the <Ctrl> key and press V (referred to as 'control-V and
normally written ^V).

In INSERT mode, additional text typed at the cursor position
will be inserted.
In REPLACE mode you change text by overtyping.

The <Backspace> and <Del> keys will operate in the normal way
for removing unwanted text.

Use the cursor keys to move the cursor to any part of the
text.

Other word processing techniques such as saving and copying
blocks of text are available in the rulebase Editor (see
Appendix F for a complete list).













                              26

Editing a Knowledge Base


4.2  Creating and modifying rules

From the editor sub-menu load in the rules - ANIMALS - if you
have not already done so.

The animals knowledge base is quite limited.  For example, it
allows four-legged ducks!

Modify the knowledge base to prevent this by adding the rule:

     IF four legs THEN NOT bird;

Remember to end each rule with a semi-colon (;) otherwise
rulebase's automatic rule checking will report an error.

Put this new rule anywhere you like!  rulebase does not care
where.
Unlike conventional programming the order of the rules in the
knowledge base is NOT important.  Changing the order of the
rules should not change the way the expert system performs.

When you are entering rules, you do not need to type in the
words 'Rule 1', 'Rule 2' etc.  rulebase will number the rules
for you when it compiles them.

Typing in free format and not case sensitive - ie. use spaces,
blank lines and capital letters for your own readability;
rulebase will ignore them!

You can enter as many rules as you like but the more rules you
enter without testing the more likely you are to produce
unpredictable results.  It is wiser to check that the existing
rules are producing sensible conclusions before adding more
rules.
As you become more experienced with rulebase you will develop
more confidence in writing rules and will not need to check as
frequently.

The next step is to save your knowledge base.





















                              27

Editing a Knowledge Base


4.3  Saving the knowledge base

First check that you have typed in each rule correctly and
that each rule ends with a semi-colon.  Case is not important
but spelling is!
Hold down the <Ctrl> key and press K.

This use of the control key with another key is normally
referred to as 'control-k' and shown as ^K
This convention will be used from now on.

You are offered three choices:
     A - abandon        D - save        S - save/re-edit

There are times when you want to 'abandon' rules you have used
to try something out.
When you have finished entering your rules you will want to
'save' them and leave the editor.
When entering a large number of rules if is sensible to
'save/re-edit' occasionally a precaution against system
failure, before continuing to edit them.

On this occasion:
     Press:  D  (save the rules).

The message 'Checking file.  Please wait...', appears briefly
followed by 'Saving file' before the Editor sub-menu
reappears.

If you have an error:
You will hear a beep and the bottom line will display:

     '* Error. Syntax error in Rules. Press SPACE-BAR to
continue.'

Press the Space-Bar to return to the Editor sub-menu and re-
select your rules.
rulebase will have automatically numbered your rules and
marked any rule containing an error with  '** Error **'.

Use the editor to correct what is most likely to be a typing
error (or the lack of a semi-colon at the end of a rule).

There is no need to remove the '** Error **' marker.

When you have corrected the mistakes:

     Press ^KD to save the file (save and quit).

The rules will be re-numbered and their syntax checked again.










                              28

Editing a Knowledge Base


Following a ^KD  all rules are re-numbered in ascending order.
Any previous numbering is replaced.  This also applies when
adding new rules.
rulebase takes care of all rule numbers.

Rules loaded from the Run Rules sub-menu are subjected to this
error checking.

When your rules have been corrected and saved you will be
returned to the Editor sub-menu.

Return to the Main Menu and use Run Rules to test your rules
(see section 4.4).



4.4  Testing the knowledge base

From the Main Menu:

     Press: R  (Run rules)
            U  (Use rules)

Your current rules, the ones last edited or last run, are used
automatically, so there is no need to load the rules again
(unless you wish to use another knowledge base).  The name of
the current rules is shown in the top right corner.


Use the rules a number of times until you are quite sure that
the conclusions always match your responses.
Return to the Editor to edit the knowledge base as required.

If the conclusions are NOT what you expect then refer to
section 4.7 (Correcting errors) for more assistance.

When you have finished modifying the knowledge base, return to
the Editor sub-menu and print out the rules.






















                              29

Editing a Knowledge Base


4.5  Printing the Rules

Select the Editor sub-menu.

Check that your printer is connected, switched on and 'on-
line' and that the paper is at the 'top of form'.

     Select:  P  (Print)

The rules will be printed, automatically paged with the page
number and name of the knowledge base on each page.



4.6  Questions

rulebase will automatically display questions based on the
rules in the form:
               "Is this true ... ?"

rulebase can display questions in a more meaningful way.

The question:  "Does your subject have four legs?"

is much more readable than:

               "Is this true : four legs?"

It is clearly much easier to consult a knowledge base when the
questions are presented in a readable sentence.

To do this, questions are linked to rules in the knowledge
base.

The question  "Is this true: four legs"  comes from the rule:

     Rule 9
     IF four legs THEN animal;

To link a question to this rule, use:

     key "four legs"
     Question "Does your subject have four legs?";

Note the ';' at the end.















                              30

Editing a Knowledge Base


It does not matter where you put the question in your
knowledge base, but it makes the knowledge base more readable
by either putting all the questions together at the beginning
or putting each question near its corresponding rule.

A question does not have a rule number.

The key identifies a condition contained in a rule so that a
rule with, say, three conditions could have three questions
associated with it.

Edit the knowledge base to include the question shown above.

Save the knowledge base using ^KD and test the system.

You may like to add another question to make the question
generated by Rule 11 more readable.

     Rule 11
     IF lays eggs THEN bird;

For example:

     key "lays eggs"
     question "Does your creature lay eggs?";

Test your changes.

Print your knowledge base if it is working properly.
If you have any problems after you have checked for errors
(see section 4.7 below), then refer to appendix A for the
original version of the knowledge base ANIMALS.




























                              31

Editing a Knowledge Base


4.7  Correcting Errors

rulebase can only use the rules in the knowledge base if they
make sense (to rulebase!).  Whenever you save rules,
rulebase's automatic check can seem frustrating when you are
keen to try out your knowledge base, but it is far better to
have the rules checked at this stage than find out later that
they don't work.

Problems are of two broad types: those which are detected by
rulebase's automatic checking and those which are not.

The first type are usually spelling and typing errors and are
easier to correct.

The second type are those which have entirely correct syntax
and so pass rulebase's check but result in strange or
incorrect conclusions because the rules contain logical or
factual errors (remember the four-legged duck).

When rulebase marks a rule as containing an error, first check
that it ends with a semi-colon and then look at the rule
carefully.
Problems can be caused if you have mis-typed any keyword such
as IF, AND, THEN, QUESTION, KEY.

Any text between keywords (see section  9.1) which contains a
rulebase keyword, used in its everyday sense, will cause a
problem unless the text between the keywords is enclosed in
double quotes(").  The quotation marks separate text from
keywords.

For example the rule:
     IF today is Monday
         THEN shop is then open;

Will cause an error because it uses the word 'then' in the
conclusion of the rule.  Then is a keyword.

The following will work:

     IF today is Monday
         THEN "shop is then open";

If a rule has a condition which is contained in the conclusion
of another rule, be careful that the two are spelt exactly the
same, otherwise rulebase cannot link them together.  A key in
a question clause must be identical to the rule's condition
otherwise the question clause will not be used.











                              32

Editing a Knowledge Base


Logical errors are more difficult to identify.  Always be
systematic and trace the sequence of reasoning to identify the
rule where it breaks down.
Careful use of  the How, Why and Facts options will show what
is happening.

Facts can be entered directly into the knowledge base.

This provides a means of testing the rules which use
particular facts.  If the conclusions are sensible when a Fact
is put in the knowledge base but not sensible without it, then
the problem lies in the rules which establish that fact.

Facts can be included in the knowledge base using the
following syntax:

     FACT | FACTS [NOT | NO] fact {, [NOT | NO] fact};

For example:
     FACT four legs;
     FACTS NOT bird, lays eggs;







































                              33

Further Features of rulebase


Part Five:

Further Features of rulebase




The ANIMALS knowledge base contains rules in the simplest form
possible.  rulebase generated the questions from the rules and
displayed the conclusions automatically.  A more realistic use
of rulebase would make use of the alternatives for displaying
questions, responding to those questions and displaying the
conclusions.  You are now going to use a different knowledge
base to look at some more features of rulebase.

Load the rules from the main-menu:

     Press: R  (Run Rules)
            L  (Load Rules)

Enter the filename:   CARFAULT <enter>

     Select:  R  (Rules list)

The knowledge base is listed below:

Rule 1
If you need help and car starts
    or not you need help
        and car starts
       then car ok
          and display text "You don't need any help"
          and display graphic "Your car works!"
          and display graphic "It must be more like this:"
          and display graphics roller
          and display graphic "rather than this:"
          and display graphic beetle;

key car starts
question Does your car start?;

Rule 2
If help needed
     then you need help
         and display text rulebase.hlp;















                              34

Further Features of rulebase


key help needed
question "Do you need any help using rulebase?"
explanation "If you answer 'Yes' then a help file will be
         printed for you to browse through.";

Rule 3
If not car starts
    and engine rotates is normally
     then check spark;

Rule 4
If not car starts and engine rotates is slowly
    or not car starts
        and "engine rotates is not at all"
       then check battery;

key engine rotates
question "How does your engine rotate when you turn the
ignition key?"
one of normally, slowly, "not at all";

Rule 5
If check battery
    and not lights work
     then battery is flat
         and display text "Your battery is flat";

key lights work
question Do your lights work when switched on
explanation "I am trying to find out if your battery is
         flat.#Answer 'No' if the lights do not work or they
         are dim";

Rule 6
If battery is flat
     then charge battery
         and display text "Charge your battery";

Rule 7
If not battery is flat
    and engines rotates slowly
     then check starter;

Rule 8
If check battery
    and lights work
     then check starter;













                              35

Further Features of rulebase


Rule 9
if check starter
    and starter jammed
     then release starter
         and display text "Put the car in gear and rock it
backwards and forwards";

Rule 10
If check starter
    and not starter jammed
     then check engine;

Rule 11
If check engine
    and check starter
    and engine seized
     then hard luck
         and display text "You have got big problems!";

Rule 12
If "engine rotates is slowly'
     then not engine seized and not starter jammed;

Rule 13
If check spark
    and not spark at plugs
     then ignition fault
         and display text "You have an ignition fault.";

Rule 14
If check spark
    and spark at plugs
     then check petrol;

Rule 15
If check petrol
    and petrol in carb
     then engine flooded
         and display text "Your engine is flooded.";

Rule 16
If engine flooded
     then cure engine flooded
         and display text "Dry your spark plugs and try
again.";















                              36

Further Features of rulebase


Rule 17
If check petrol
    and not petrol in carb
     then check tank;
Rule 18
If check tank
    and petrol in tank
     then check pump;

{Comment: Comments are enclosed in "{}" and are ignored by
rulebase}

Rule 19
If check tank
    and not petrol in tank
     then put petrol in tank
         and display text "Put some petrol in your tank";

Rule 20
If check pump
    and pump ok
     then carburettor fault
         and display text "You have a carburettor fault.";

Rule 21
If carburettor fault
    or ignition fault
     then call mechanic
         and display text "Call a mechanic."
         and display graphic " Sell this.."
         and display graphic beetle
         and display graphic " and buy this.."
         and display graphic roller
         and display graphic " or buy this.."
         and display graphic brumxpic;

Rule 22
If petrol flows at carburettor when engine turns
     then pump ok;

Rule 23
If check pump
    and not pump ok
     then petrol pump fault
         and display text "You have a petrol pump fault."















                              37

Further Features of rulebase


5.1  Consulting CARFAULT

Use CARFAULT with the following two problems.

Car problem 1:
Your car will not start, the engine rotates slowly, and the
lights are not working.

Car problem 2:
Your car will not start, the engine rotates slowly, the lights
are working and there is no spark at the plugs.

Try other responses and browse through the rules.

Notice:
     How the rules link together;
     The range of possible conclusions (between a 'then' and
     the end of a rule which always terminates with a ';');
     How the questions link with the rules.

The new features are explained below.



5.2  Explain Text

As you consult this knowledge base notice the following
message sometimes appears at the bottom right of the screen:
     "Press E for explanation"

When you press E, the "explanation" is displayed at the top of
the screen.

When writing the rules, the author can include helpful
explanations with questions. Users can use these explanations
to assist their decision on the appropriate responses.

The explanation may be as little as one or two words,  or a
short sentence, or pages of explanation held in a text file .

When preparing explanation text, don't worry about line
length.  rulebase will take care of this and automatically
adjust the text to fit on the screen without chopping words in
two.
You can include a new line if you want by placing a # in the
text (see the question after rule 5).














                              38

Further Features of rulebase


Rules 2 and 5 in CARFAULT are followed by question and
explanation clauses.

Rule 5
If check battery
    and not lights work
     then battery is flat
         and display text "Your battery is flat";

key lights work
question Do your lights work when switched on
explanation "I am trying to find out if your battery is
         flat.#Answer 'No' if the lights do not work or if
         they are dim";

Note: A # will cause a carriage return in the display.

Rule 2
If help needed
     then you need help
         and display text rulebase.hlp;

key help needed
question "Do you need any help using rulebase?"
explanation "If you answer 'Yes' then a help file will be
         printed for you to browse through.";



5.3  More about Responding to rulebase

The following question is used in CARFAULT after rule 4.

key engine rotates
question "How does your engine rotate when you turn the
ignition key?"
one of normally, slowly, "not at all";

Note: The option "not at all" is inside quotation marks as it
contains the KEYWORD "not".

This question on engine rotation offers a variety of possible
responses.  A simple Yes or No answer is not adequate for this
question so the rule includes alternatives which are more
sensible in this situation:  'normally', 'slowly' or 'not at
all'.
Only one of these alternatives can be selected by the user in
this example (controlled by the keyword one of).
In other situations a question may allow more than one
alternative to be selected using the keyword any of (see
section 6.2).









                              39

Further Features of rulebase


The alternatives contained in the list, after one of, are all
contained somewhere in the knowledge base, linked to engine
rotates in the form: engine rotates is slowly, engine rotates
is normally, "engine rotates is not at all" (see rules 3, 4,
7, 12).
Each acts as an attribute of engine rotates in effect telling
you more about it.
Hence engine rotates is the key and all possible attributes
found in the knowledge base make up the alternatives list, as
shown above.

When setting up your questions, there is the possibility of
misspelling, or not noticing a particular attribute and
missing it off the list, which could lead to errors when the
expert system runs. To prevent this happening rulebase can
create its own list of alternatives by using the word
anything.

For example:

key engine rotates
question "How does your engine rotate when you turn the
ignition key?"
one of anything;

This form of a question will have exactly the same effect as
the one shown previously.
Using anything forces rulebase to look through its knowledge
base and create its own list of alternatives.  It will not
miss any out and will spell them correctly.

A "None of These" option can be added as an alternative for
the user.
If this is  chosen by the user then all the other alternatives
are assumed not true.

An "Unknown" option can also be added as an alternative in
case the user does not know the response.
If this is chosen by the user then it will cause the inference
mechanism to find alternative routes through the rules.

For example:
key engine rotates
question"How does the engine rotate when you turn the ignition
key?"
one of anything, none of these, unknown;














                              40

Further Features of rulebase


5.4  More about Displaying conclusions

Rules can contain more than one conclusion separated by 'and'.

For example:
If check battery
    and not lights work
     then battery is flat
         and display text "Your battery is flat";

key lights work
question "Do your lights work when switched on";

The conclusion 'battery is flat' is a fact that follows from
the rule and can be used as a condition in a later rule.
The second conclusion following the 'and' causes text to be
displayed on screen.

The general form is:

If condition
     then conclusion
         and display text "message text";

In all rules, a fact must follow the keyword 'then'.
When rulebase uses a rule, it decides which conclusions are
true and which are not true and stores these facts as current
facts.

Several screen messages can be displayed in sequence by
repeating the display message clause (display text ...):

If condition
     then conclusion
         and display text "first message text"
         and display text "second message text"
         and display text "third message text";

See rule 21 of CARFAULT for an example of this.





















                              41

Further Features of rulebase


5.5  Text files

5.5.1  Displaying text from a file

Including lengthy text in rules can make the rules
inconveniently long and unwieldy.
This can be overcome by storing the text in a file and using
rulebase to display the file when needed.  The text file can
be prepared using the text option in the rulebase Editor or
any word-processor or text editor that can produce ASCII
files.
Don't worry about fitting the text on screen.  rulebase will
take care of this.

If you use the CARFAULT rules and answer Yes to "Do you need
any help using rulebase", you will see screens of text from
the file rulebase.hlp.

The rule used is:
Rule 2
If help needed
     then you need help
         and display text rulebase.hlp;

key help needed
question "Do you need any help using rulebase?"
explanation "If you answer 'Yes' then a help file will be
         printed for you to browse through";

The general format is similar to displaying text, with a
filename instead of a message.
Do not use quotations marks around the file name:

If condition
     then conclusion
         and display text filename.ext;

Several files of text could be displayed in sequence by adding
additional clauses to the conclusion separated by 'and'.
When text is displayed to the screen and is too big to fit on
one screen then rulebase will automatically 'page' the
information.
These pages can be viewed using the PgUp, PgDn, Home and End
keys.
Pressing the <Esc> key terminates the display and continues
with the consultation.














                              42

Further Features of rulebase


5.5.2  Editing Text Files

The rulebase Editor can be used to create and edit text files
by selecting Text from the Editor sub-menu.  Using this option
rulebase does not check the syntax when the text is saved.

Text files can be printed from the editor by using the Print
option.



5.6  Displaying graphics

If you work through CARFAULT responding that your car does not
start and all the faults shown are not the problem, rulebase
will eventually conclude you have a serious carburettor,
ignition or engine fault.

The graphics feature is used to suggest light-heartedly that
you buy a better car!

As with display text you can display a graphic from file or
you can display text in graphics mode.  Each 'graphic' display
occupies only half the screen so that the text can be used
alongside a picture to describe it.

The general form of the rule is:

If condition
     then conclusion
         and display graphic picname
         and display graphic "label text";

Graphic displays, occupying half a screen each, are displayed
alternately so a sequence of clauses can be used to display a
sequence of diagrams, with labels.

Graphics files can be prepared for use by rulebase using the
Cutpic facility in the Toolbox menu (see the next section).





















                              43

Further Features of rulebase


5.7  Cutpic

Note: this option may not work on some IBM compatibles.

This facility allows you to include a graphics picture in the
conclusion of any rule in your knowledge base.   rulebase
needs a picture that only takes up half a screen or less (see
previous section).  Cutpic enables you to 'cutdown' a full-
screen graphic.

You will need a picture previously saved as a BSV file.
This can be done in either of the following ways:

1.   Prepare  a picture using your favourite Paint package.
     e.g. PC Paintbrush;
     PC Paint; Windows Paint; Gem Paint; Mac Paint ...
     Convert your picture to a BSV file using the facility
     provided by the package.

     If the package does not have this facility, use the
     shareware package OPTIKS or ICONVERT to convert to BSV
     format (supplier details below).

2.   Use the shareware package PRESENT to draw your picture.
     This has the facility to save as a BSV file.


Once you have prepared your BSV file and saved it to disk,
select the Cut picture option from the Toolbox sub-menu of
rulebase and proceed as follows:

1.   Enter the name of your picture file (extension defaults
     to BSV).

2.   Use a mouse to cut the portion of the picture you want as
     follows:
     Move the mouse to position the cursor at the starting
     position (top left corner of cut);
     Press the mouse left button to start the cut;
     Move the mouse to position the cursor at the bottom right
     corner of the cut;
     Your cut is automatically limited to half a screen;
     Press the mouse right button to stop the cut.

3.   Enter a file name to save and identify your cut (e.g.
     brumxpic - see rule 21).
     Note the extension is forced to PBX.

4.   Use this name in the conclusion of any rules, as
required, using the syntax:
          Display Graphic <picture name>









                              44

Further Features of rulebase


Rule 21
If carburettor fault
   or ignition fault
     then call mechanic
         and display text "Call a mechanic."
         and display graphic " Sell this.."
         and display graphic beetle
         and display graphic " and buy this.."
         and display graphic roller
         and display graphic " or buy this.."
         and display graphic brumxpic;

Shareware is readily available from shareware libraries and
from bulletin boards.  The following supplier is one of many:

          The Public Domain Shareware Library
          Winscombe House
          Beacon Road
          Crowborough
          Sussex.  NT6 1UL
      Tel:   0892 663298      Fax:   0892 667473



5.8  DOS Facility

Any DOS command can be executed from rulebase without having
to leave rulebase.  This can be useful, for example, to check
what knowledge bases are available with the DOS command:
     dir *.kbx

Select Toolbox from the main menu.

Select the Dos command option.

Either:
     Type a single Dos command.
     Press <Space-Bar> to return to the Main Menu
Or
     To enter more than one Dos command press <enter>.
     Return to rulebase when ready by typing 'exit'.




















                              45

Modifying a Knowledge Base


Part Six:

Modifying a Knowledge Base

CUSTOMS is a small knowledge base containing rules about duty
free and duty paid allowances.
You are going to look at more features of rulebase, edit the
knowledge base and add rules of your own.

Start rulebase and load the knowledge base CUSTOMS.

The following rules will be loaded:

key bought
question "Which of the following have you bought?"
any of spirits, wine, cigarettes;

Rule 1
If from inside EC
     then duty paid
         and display text < customs.txt > "Your allowances
are:#";

Rule 2
If not from inside EC
     then duty free
         and display text < customs.txt > "Your allowances
are:#";

key country
question "From which country have you arrived?"
enter reply;

Rule 3
If country is Belgium
    or country is Denmark
    or country is France
    or country is Germany
    or country is Greece
    or country is Italy
    or country is Ireland
    or country is Luxembourg
    or country is The Netherlands
    or country is Holland
    or country is Portugal
    or country is Spain
     then from inside EC;













                              46

Modifying a Knowledge Base


Rule 4
If bought is spirits and duty paid
     then spirits allowance needed
         and display text < customs.txt /a> "spirits allowance
is 1.5 litres #";

Rule 5
If bought is spirits and duty free
     then spirits allowance needed
         and display text < customs.txt /a> "spirits allowance
is 1 litre #";

Rule 6
If bought is wine and duty paid
     then wine allowance needed
         and display text < customs.txt /a> "wine allowance is
5  litre #";

Rule 7
If bought is wine and duty free
     then wine allowance needed
         and display text < customs.txt /a> "wine allowance is
2 litre #";

Rule 8
If bought is cigarettes and duty free
     then cigarette allowance      needed
         and display text < customs.txt /a> "cigarettes
allowance is 200 #";

Rule 9
If bought is cigarettes and duty paid
     then cigarette allowance needed
         and display text < customs.txt /a> "cigarettes
allowance is 300 #";

Rule 10
If country is anything and allowance needed
     then allowance checked
         and display text customs.txt;

Rule 11
If spirits allowance needed
   or wine allowance needed
   or cigarette allowance needed
     then allowance needed;














                              47

Modifying a Knowledge Base


6.1  Asking the User to enter a reply

Users may not be sure which countries are now in the EC.  The
knowledge base can determine whether or not the country
concerned is inside or outside the EC.

The following question asks the user about the country:

key country
question "From which country have you arrived?"
enter reply;

Rule 3
If country is Belgium
    or country is Denmark
    or country is France
    or country is Germany
    or country is Greece
    or country is Italy
    or country is Ireland
    or country is Luxembourg
    or country is The Netherlands
    or country is Holland
    or country is Portugal
    or country is Spain
     then from inside EC;

The question before rule 3 prompts the user for a typed entry.
Whatever is typed will be stored as a fact for later
processing in the form 'key is reply'.
The key 'country' acts like a variable and will be assigned an
attribute of whatever text is entered by the user after being
prompted with the question:

     'From which country have you arrived?'

For example, if the reply is 'Holland' then 'country is
Holland' is added to the current facts.  This can then be used
by other rules.
In the example above, the fact 'from inside EC' would be
stored following rule 3.

Notice the use of the word or in rule 3 shown above.
Its use is as in normal language.
If any one of the conditions linked by or is found to be true
(country is Belgium, country is Denmark, ...), then the
conclusion will follow and be added to the current facts













                              48

Modifying a Knowledge Base


6.2  Rules with Several possible responses.

The CUSTOMS rules display the relevant allowance when the user
enters a "purchase".  A traveller may have bought a variety of
items.
rulebase allows a "list" of purchases to be entered from the
following question:

     key bought
     question "Which of the following have you bought?"
     any of spirits, wine, cigarettes;

Depending on the user's response, any of the following
conclusions would follow:
"bought is spirits", "bought is wine", "bought is cigarettes".
The key bought can be assigned one or more of these values;
ie. any of spirits, wine, cigarettes.

As discussed previously in 5.3, the list of options, spirits,
wine, cigarettes, can be replaced by the word anything.  This
will force rulebase to search the knowledge base for every
occurrence of the key bought and compile its own list of all
the attributes it finds linked to 'bought' by the word 'is'
(see rules 4, 5, 6, 7, 8, 9).

Try using CUSTOMS with various combinations of spirits, wine
or cigarettes.



6.3  Manipulation of Files

Conclusions can be written to and appended to a file.
This file containing several conclusions can then be
displayed.
In other words a 'report' can be assembled to a file  during a
consultation and displayed at the end.

There are three stages:

  (i)     a file is opened and written to.
  (ii)    the file is added to (appended).
  (iii)   the file is displayed on the screen (or to a
printer).
















                              49

Modifying a Knowledge Base


(i) To open and write to a file the format is :
     IF ... THEN fact AND display text <filename> "String of
characters";

For example:
  Rule 1
  If... then ... AND display text <customs.txt> "Your
allowances are:#";

This conclusion will open a file named "customs.txt" and write
the string enclosed in quotes to the file.  The #  inserts a
carriage return, so that subsequent lines will eventually be
displayed on separate lines.

Note:  A filename of 'PRN' will send the display to an
available printer.

(ii) to append output to an existing file the format is:
     IF ... THEN fact AND display text <filename /a>;

For example:
  Rule 4
  If ... then ... and display text <customs.txt /a> "spirits
allowance is 1.5 litres#";

This format is similar to opening the file, with the addition
of the "/a" after the filename.  This causes text inside the
quotation marks to be appended to the existing file.

(iii) To display a file on the screen the format is:
     IF ... THEN fact AND  display text filename;

For example:
  Rule 10
  If country is anything and allowance needed
     then ... and display text customs.txt;

Notice  '<'  and  '>'  are not used around the filename.

Notice the use of country is anything in this rule.  Its use
means "use the knowledge base to find a value for the key"
(country in this case).  This value could be prompted for by
a question similar to the one in CUSTOMS after Rule 2.

Notice the use of allowance checked in rule 10.
When used in a conclusion it will always be true even if any
conditions in the rule fail!
This provides a simple way of forming a sequence of conditions
and recording 'whatever checked' as a fact to indicate this
rule has been used.










                              50

Modifying a Knowledge Base


6.4  Saving facts to a file

As rulebase uses rules it establishes that certain facts are
true and others are not.  These are referred to as current
facts and they can be saved to file as an option in a
conclusion to a rule.
The format is:
     If... then ... and save-facts filename;

For example:
   Rule 10
     If country is anything and allowance needed
         then allowance checked
             and display text customs.txt
             and save-facts allow.tax;

In this example an extra line has been added to rule 10 which
will save the current facts to a file called 'allow.tax'.

Later on, these current facts can be loaded back into a
knowledge base (see 6.5 below).
In effect, this provides a mechanism for saving an environment
at any point and backtracking to it at some later point in a
consultation, for whatever reason.



6.5  Loading facts into a knowledge base

Facts previously saved by rulebase using a save-facts clause
(see 6.4 above) can be loaded back at some later stage of a
consultation using the control clause "load-facts".
The format is:
     If ... then ... and load-facts filename;

A knowledge base may be in use that is related to CUSTOMS that
needs the facts established from an earlier consultation of
CUSTOMS.
It is possible to stop consulting one knowledge base, start up
a new knowledge base and then use the facts from the first
knowledge base (see 6.6 below).

If you want to clear the current facts to start a new
consultation, use the "load-facts clear" control clause:
     If ... then ... and load-facts clear and ... ;















                              51

Modifying a Knowledge Base


6.6  Linking knowledge bases together

This feature enables one knowledge base to call another.
Any knowledge base with more than 200 rules becomes difficult
to maintain.
It is far better to write your knowledge base in modules,
where each module concentrates on some self contained aspect
of the system.

For example, with a complete car fault diagnostic system, one
knowledge base could concentrate of engine faults, another on
gearbox faults, another on transmission, and so on.  A main
module knowledge base would be used to link all these sub-
modules together and each sub-module would return to the main
module.


Linking knowledge bases is carried out using the control
clause "use rules".
The format is:
     if ... then ... and use rules filename.KBX;

This causes the current rules to be abandoned and a new
consultation to be started with the new rules.

For example:
     if ... then ... and save-facts filename
                         and use rules rulename.kbx;

Note that in rulebase all knowledge bases have the extension
'.KBX'.

The current facts are not changed with this control clause.
A new consultation starts using the current facts accumulated
from the previous knowledge base.
If you want to clear the current facts, use the "load-facts
clear" before the use rules control clause:
     If ... then ... and load-facts clear
                     and use rules rulesnom.kbx;

This technique can be used to organise the development of
large knowledge bases.
The more specialised knowledge bases would be written by
different experts.
Facts can be passed from one knowledge base to another as
required.














                              52

Modifying a Knowledge Base


6.7  Using keys in text

Any text displayed in a question, explanation, control clause
'display text' and control phase 'display graphic' can be
formatted by inserting carriage return codes and attributes of
keys (variables) contained in the current facts.
Carriage returns are inserted using # as we have seen.
The attribute of a key can be inserted by enclosing the name
of the key between $ signs.

For example:
   If name is anything and town is anything
     then person checked
         and display text "Hi $name$.# So you live in $Town$
do you.";

   Key name
   Question "Enter your name"
   Enter reply;

   Key town
   Question "Please enter your home town $name$."
   Enter reply
   Explanation "I need to know where $name$ lives.";

With this example, if the name "Rachael" is entered when
prompted:
      "Enter your name",
then the next prompt will be:
     "Please enter your home town Rachael?".

An explanation is available:
     "I need to know where Rachael lives".

If the town of 'Tipton' is then entered, the final printout
will be:
     Hi Rachael
     So you live in Tipton do you.



6.8  Modifying the CUSTOMS knowledge base - an exercise

This exercise gives you the opportunity to modify the existing
knowledge base CUSTOMS.

CUSTOMS gives the customs allowances for cigarettes, wine and
spirits but does not include perfume.
Allowance for perfume bought inside the EC is 90 ml, and if
bought outside, 60 ml (duty free).
Modify the knowledge base to include perfume (See Appendix C
for an answer).








                              53

Building a simple knowledge base


Part Seven:

Building a simple knowledge base


In this section we will build two simple knowledge bases.

7.1 Building a PICNIC knowledge base

The first knowledge base is to give advice about the
desirability, or otherwise, of holding an outdoor picnic.
The 'knowledge' it will contain could be stated in English as:

1.   Holding a picnic in rainy conditions is likely to end up
     being a washout.

2.   Sunny conditions and dry ground are ideal for a picnic.

3.   You might get piles if you hold a picnic in dull weather
     on damp ground.

4.   It would be a bit risky holding a picnic in dull weather
     even if the ground is dry.

5.   If it is sunny and the ground is damp any plans for a
     picnic are best postponed for a couple of hours.



7.1.1  Creating Rules

These statements are simple enough to translate directly into
rulebase rules.

     if weather is rainy
          then picnic is likely to be a washout;

     if weather is sunny
        and ground is dry
          then picnic is ideal;

Note that the layout of the rules.  Carriage return and tab
characters are not important to rulebase, but it can make the
knowledge base more readable to YOU.

In these two rules we have identified three keys: weather,
ground and picnic.  The key 'weather' can have can have one of
two attributes: 'rainy' or 'sunny'.  The key 'ground' can have
the attribute 'dry'.  The key 'picnic' can have one of two
attributes: 'likely to be a washout' or 'ideal'.
Keys are linked to attributes by the word 'is'.









                              54

Building a simple knowledge base


7.1.2  Building your knowledge base

Start Up rulebase
Select:  E   (Editor) - from the Main Menu
Select:  R   (Rules)

You will be asked for the rules name.
Enter:   PICNIC

You will see a blank screen ready for you to type in your
rules.

Type in the two rules above.
Remember you do not have to type in the rule numbers as
rulebase will add these for you later.

When you have typed in the two rules check that each rule ends
with a ';' and that you have spelt all the words correctly.
You are now ready to save your knowledge base.

Press:  ^KD   (Hold Ctrl key down and then press K then D) to
save your rules

If you have an error:

     Press <Space-Bar> to continue.
     Select:  R  (Rules) from the Editor sub-menu
     Press <enter> to select PICNIC .
     Any incorrect rule has '** Error **' before it.
     Correct the errors.
     Press ^KD to save the rules.
     If you have any problems refer to section 4.7 (correcting
     errors) or to the listing of PICNIC (Appendix D).

If you do not have an error:

     Well done!  You can now consult the knowledge base and
test your rules.






















                              55

Building a simple knowledge base


7.1.3  Consulting the knowledge base

   Select:  R   (Run rules) from the main menu
   Select:  U   (Use rules)

When you have finished consulting this little knowledge base
then you will be ready to edit it, and to add more rules.



7.1.4  Editing the knowledge base

   Select:  E  (Editor) from the Main Menu
   Select:  R  (Rules)
   Press:  <ENTER>  to select PICNIC .

Complete the next three rules yourself and type them in.  If
you have any difficulty then use the listing of PICNIC as a
guide (Appendix D).

     if weather is dull
        and ground is damp
          then picnic is .........;

     if weather is dull
        and ........ is dry
          then ..................;

     if ..... is .......
        and .........is ......
          then picnic is ........;

Save the rules and then consult the knowledge base.



























                              56

Building a simple knowledge base


7.1.5  Adding Questions

When PICNIC is working correctly then the next step is to add
meaningful questions

We need questions for the keys 'weather' and 'ground'.

Here is the weather question:
          key weather
          question "How would you describe today's weather?"
          one of anything;

Return to the Editor and add this question to your rules list.

Construct the 'ground' question and type this in as well.
Save and test your knowledge base.
Print out the knowledge base using the Editor sub-menu

When your knowledge base is working correctly try modifying it
to include other factors that might affect whether or not the
picnic should go ahead.



7.2  Building a HOLIDAY knowledge base

This knowledge base is to give advice about the cost of
holidays in Paris, depending on the mode of travel and the
length of stay.  The knowledge domain is summarised in the
table below:

   +--------------------------------------+
   |       | 2 nights| 5 nights| 7 nights |
   |-------+---------+---------+----------|
   | Air   |  250   |  325   |  375    |
   |       |         |         |          |
   | Train |  150   |  225   |  275    |
   |       |         |         |          |
   | Coach |  100   |  175   |  225    |
   +--------------------------------------+




















                              57

Building a simple knowledge base


7.2.1  Creating Rules

A valid rule from the table above might be:
   if travel is by air
      and number of nights is 7
          then cost is 375;
Similarly:
   if travel is by air
      and number of nights is 5
          then cost is 325;

   if travel is by coach
      and number of nights is 2
          then cost is 100;

Here we have identified three keys: travel, number of nights
and cost.
So far:
The key 'travel' can have one of two attributes: 'by air' and
'by coach';
The key 'number of nights' can have one of three attributes:
7, 5 or 2;
The key 'cost' can have one of three attributes: 375, 325 or
100.

Complete the rules for this knowledge base.



7.2.2  Building your knowledge base

Enter your rules into a new knowledge base called HOLIDAY
using rulebase's Editor.
Save the rules and then test your HOLIDAY knowledge base.



7.2.3  Adding questions

When you run HOLIDAY you will notice that the questions are
not very meaningful.  This can be improved by adding
questions.
For example:
   key travel
   question "How do you wish to travel to Paris?"
   one of anything;

Write a similar question for "number of nights" and include
these in your HOLIDAY knowledge base.











                              58

Building a simple knowledge base


7.2.4  Adding explanations

It might be useful to have some explanations added to your
questions.
For example in the travel question you might have:
   key travel
   question "How do you wish to travel to Paris?"
   one of anything
   explanation " The journey by air takes 1 hour.#
            The train journey takes 8 hours.# The coach
            journey takes 11 hours";

Notice that the ';' is now at the end of the explanation as
the explanation is 'attached' to the question.

Test this change and then try adding another explanation
yourself.

Try modifying the rules.


7.3 Capturing Expertise

7.3.1 Types of Problems for Expert Systems

Expert Systems work by asking the user a series of questions
designed to progressively narrow down the answers to a
problem.
Problems that involve determining one of many possible
solutions are well suited to Expert Systems.
Examples of problems of this type are:
     identification problems (ANIMALS);
     decision making (CUSTOMS);
     diagnosis, such as medical or car repair (CARFAULT).

If your problem can be formulated to fit the question "What is
...?"  (what is the biological family; what allowances am I
allowed; what is the car fault) and you have a clear idea of
how to differentiate between the possible answers, then you
can probably use an Expert System.

It is very important that the size of the problem chosen is
manageable.
As the knowledge base grows larger, it must be constructed and
tested in separate modules (see 6.6).  If the problem cannot
be broken into sub-problems, the resulting Knowledge Base will
be almost impossible to debug.













                              59

Building a simple knowledge base


7.3.2  Organising the problem

It is important to define an overall structure of a solution
before writing individual rules in a Knowledge base.
An Expert System is unlikely to conduct a successful
consultation session with a random collection of rules.

One way to think about your problem is to imagine that you
have been asked to solve a problem by someone on the telephone
who has called you as an expert in some field of knowledge.
The caller is not an expert and so does not know what
information will help you identify the problem.  You will have
to ask questions to get the caller to supply the facts you
need to solve the problem.

Two methods of organising knowledge have been looked at
briefly so far: Tables (HOLIDAY) and English statements
(PICNIC).
No single method can be ideal for all problems.  Just as with
computer programming, no single design methodology and program
language is suitable for every application.  A designer needs
to have a variety of tools to work with so that the most
appropriate can be used for a particular job.

Another method of organising knowledge is called a 'decision
tree' which is best illustrated by an example such as car
fault diagnosis.

A mechanic might group car faults into fuel, electrical and
mechanical, and might start off by trying to identify in which
of these groups your fault lies.

He/she might further subdivide these into:
     fuel:     carburettor; supply (petrol tank); petrol pump.
     electrical:    battery; ignition.
     mechanical;    funny noises; engine seizure.

These might be further subdivided and so on.

Based on this, the following decision tree might be generated:




















                              60

Building a simple knowledge base






























































                              61

Building a simple knowledge base


The following rules could be directly generated from this
decision tree.

If car starts
     then car "No help needed";

If not car starts
   and engine rotates is normally
     then battery is ok
        and check ignition;

If not car starts
   and not engine rotates is normally
     then check battery;

If check battery
   and no lights work
     then battery is flat;

If check battery
   and lights work
     then check ignition
        and battery is ok.;

If check ignition
   and no spark at plugs
     then ignition fault;

If check ignition
   and spark at plugs
     then check petrol;

If check petrol
   and no petrol in tank
     then put petrol in tank;

If check petrol
   and petrol in tank
     then check carburettor;

If check carburettor ...


These rules would need testing and then developed, and then
further tested and further developed and so on until the
knowledge base performed satisfactorily.














                              62

Using other Software


Part Eight

Using other Software

Applications from rulebase


One of the more powerful features of rulebase is the ability
to start other applications software automatically.
The software must be in the same directory as rulebase so this
capability is only likely to be of practical benefit to hard
dis users.
Programs can be started with one or more parameters which the
application uses as soon as it starts.



8.1  Word processors

Many word processors will automatically open a named document
if the filename is provided when starting the word processor.
For example:

     ws test        or        word test

Typing these from the system prompt will start the appropriate
word processor (Wordstar or Word) and then load the document
file 'test' ready for editing.

rulebase can automatically open an application with the
required document using a control clause in the conclusion of
a rule.
The control clause has the format:

     if ... then ... and execute wp.exe filename.doc;

wp.exe would be replaced by word.exe when using 'WORD' and by
ws.exe when using 'WORDSTAR' etc.
'filename.doc' indicates the name of the word processed
document to be edited.

Suppose a suitable knowledge base was being used to advise
consumers on complaining about faulty goods and inadequate
services.  The expert system could be used to establish the
relevant details of the circumstances and then produce the
appropriate 'standard letter' of complaint.  Different letters
would be required to suit the circumstances.













                              63

Using other Software


There may be one or more rules in the form:

     If ... then thislett needed
                 and execute ws.exe thislett;

Once the conditions in the rule were satisfied, Wordstar
(ws.exe) would be started and the document 'thislett' would be
loaded.  The consumer would only need to enter the name (and
address) of the supplier, print a copy of the letter, sign it
and post it.

Users may require some written instructions which could be
provided by an additional rule:
     If ... then thislett needed
                 and display text <PRN> Instruct.txt
                 and execute ws.exe thislett;

This will cause Instructions (from the file instruct.txt) to
be printed before the letter is completed using the word
processor.  A different user, responding differently to a
consultation would be offered a different letter.



8.2  dBase

dBase is a popular and powerful database package.

rulebase can execute a dBase program automatically with a
control clause of the form:

     if ... then ... and execute dbase.exe program.prg;

where program.prg is the filename of a dBase program.

Parameters can be passed from rulebase to dBase by creating a
text file in rulebase (see the CUSTOMS knowledge base, section
6.3) and then executing dBase.
For example:
     if ... then ... and display text <pass.txt> "Jack, Jill#"
                     and execute dbase.exe program1.prg;

This would put the names 'Jack' and 'Jill' in a file called
'pass.txt' and then execute dBase using the program
'program1.prg'.















                              64

Using other Software


The dBase program 'program1.prg' would contain instructions,
to pick up data from the file 'pass.txt'.

For example:
     use pass
     append from pass.txt delimited

In this dBase program, the dBase data file called pass.dbf is
used (use pass) and the data in the file 'pass.txt', that has
been created in rulebase, is appended to it.

Now the data has been transferred to dBase, all of the
facilities of dBase are available to process it.

Data can be returned to rulebase by transferring data from a
text file of facts, created in dBase (or any other package),
to the current facts of a rulebase application.

This file of facts must be in the correct format as follows:
     ( fact1  "long fact2 in quotes"  fact3 ...  factN )

The opening and closing parenthesis are needed.

As many facts as you like can be transferred but notice that
facts longer than one word must be enclosed in double quotes
(").

The facts file is used to update the current facts of rulebase
using the following control clause:
     if ... then ... and import-facts faxfile.txt;

Here 'faxfile' is the file containing the facts.




























                              65

Using other Software


8.3  Lotus 123

When Lotus is started up, it automatically loads auto123, if
such a sheet exists.
Lotus can be started using a rulebase control clause with the
following format:
     if ... then ... and execute 123.exe;

As with dBase parameters can be passed to Lotus by writing
them to a file before Lotus is started:

     if ... then ... and display text <lotus.txt> "1.9#"
               and execute 123.exe;

Data can be returned to rulebase using the iimport-facts
control clause as described above in 8.2. above.



8.4  .exe files

Using similar techniques to those described above in 8.1, 8.2
and 8.3, rulebase can call any executable program, pass data
to it and receive data from it, using a text file.

The general format is:
     if ... then ... and execute prognom;

Here 'prognom' is the name of the program to be executed.































                              66

rulebase Reference Section


Part Nine:

rulebase Reference Section



This section contains a formal description of rulebase and all
its features


9.1 Statements in a knowledge base

A knowledge base consists of a set of statements.
Each statement is free format, terminated by a ';'.
Each statement is one of the following types:

     rule, question, query  or fact

These four types are defined below using the following
notation:

     [] indicates zero or one occurrences of the contents.
     |  means 'logical or'.
     {} indicates zero or more occurrences of the contents.

Keywords are shown in capitals. The full list of keywords is:

RULE, IF, THEN, AND, OR, NO, NOT, KEY, QUESTION, EXPLANATION,
FACT, FACTS, QUERY, QUERIES, ONE OF, ANY OF, ENTER TEXT.

Identifiers are shown in lower case and consist of any text
optionally enclosed in double-quotes (").
If the identifier text includes any keywords, commas (,) or
semi colons (;) then all the text must be enclosed in double-
quotes.  Quotes are used to separate the text from the
keywords.

For example:
     IF "colour is green, red or blue" AND flower THEN ...
     IF  NOT "colour is black and blue" AND ...

Reserved words have special meanings.  The following are
reserved words (or phrases) and should be used with caution:

     is, is only, checked, reply, none of these, unknown,
     anything, screen window is, screen colour is, menu colour
     is, inverse menu colour is.













                              67

rulebase Reference Section


9.2  Rules

A rule is used to define a conclusion, which is true providing
the given conditions are true.

Rules have the following syntax:
    IF [NOT | NO] condition {AND | OR  [NOT | NO] condition}
    THEN [NOT | NO] conclusion {AND  [NOT | NO] conclusion} ;

Valid examples would be:

     IF creature and four legs THEN animal;
     IF animal AND barks THEN it is a Dog;
     IF animal AND lives in a kennel
         OR an animal AND it barks
            THEN a dog AND NOT a Cat AND NOT a Bird ;
     IF "text contains IF, then, or any keyword" THEN use
     quotes;

The order of conditions in a rule is not important.
Ignore rule numbers since these will be taken care of by
rulebase.

A condition can consist of a key linked to an attribute.
For example:

     colour is green

Here 'colour' is the key and 'green' the attribute.
This allows 'choice' questions as shown in the Carfault rules
with the key 'engine rotates' (after rule 4).

See section 9.5 for more information on Questions.



























                              68

rulebase Reference Section


9.2.1  The 'OR' operator

The 'OR' operator allows alternative ways of achieving the
same conclusion to be expressed in a single rule.

For example:

     IF an animal AND lives in a kennel
        OR an animal AND it barks
          THEN a dog AND NOT a Cat AND NOT a Bird ;

This example will give exactly the same result as:

     IF an animal AND lives in a kennel
          THEN a dog AND NOT a Cat AND NOT a Bird ;

     IF an animal AND it barks
          THEN a dog AND NOT a Cat AND NOT a Bird ;

This is the only use of the OR operator: to avoid having to
repeat the same conclusion more than once.
If you have a knowledge base where two or more rules have the
same conclusion, then these can be combined by using the OR
operator.

Brackets can not be used to indicate precedence.

For example:

    If a AND b OR c AND d THEN x;

This always means:   If (a AND b) OR (c AND d) THEN x;

It can never mean:   If a AND (b OR c) AND d THEN x;


























                              69

rulebase Reference Section


9.2.2  The 'is only' clause

This clause is useful in expressing exclusive conditions, for
a particular key, in a simple form.
For example say a key called 'class' can be assigned any
number of attributes from the set (A, B, C, D, E ).

For example:
     IF class is A and class is B THEN X;

This means X is true if 'class is A' and 'class is B' and you
don't care whether 'class is D', or 'class is E' as well.
If you wanted X to be true if 'class is A' and 'class is B',
only and nothing else, you would have to use:

     IF class is A AND class is B
         AND NOT class is C AND NOT class is D AND NOT class
     is E
          THEN X;

This type of exclusivity often occurs in classification
problems and can make a knowledge base difficult to read and
more prone to errors.

This clumsy notation can be avoided using the 'is only'
clause.

The following rule is equivalent to the last example given
above:

     If class is only A, B THEN X;

The 'is only' clause can be used any number of times in a
rule, as required.
For example:
     IF class is only A, B AND environment is only P
         THEN Y;

This means that Y follows if 'class is A' and 'class is B' and
'class' is nothing else, and 'environment is P' and nothing
else.



















                              70

rulebase Reference Section


9.2.3  Conflict resolution (Rule Ordering)

When an Expert Systems has a choice as to which one of a
number of possible rules to try, it needs some strategy to
decide the order in which to use the rules.
This is known as conflict resolution.

For example:
     IF animal AND baas THEN sheep;
     IF animal AND gives wool THEN sheep;

     QUERY sheep;

In this example there are two rules that can be used to prove
'sheep'.
Which to use first is a conflict resolution problem.

There are many conflict resolution strategies in general use,
each with its own advantages and disadvantages.

For example:
  (i) Use the rule with the least number of conditions.
  (ii) Use the rule with the greatest number of known
     conditions.
  (iii) Use the rule containing the most recently deduced
     condition.
  (iv) Use rules in the order they occur in the knowledge
     base.

This list is not exhaustive.

rulebase uses strategy (iv).
It will try all relevant rules, in turn, in the order they
occur in the knowledge base.
Other than this, the order of the rules in a knowledge base is
not significant (but see 9.12 Queries).
























                              71

rulebase Reference Section


9.2.4  Circular arguments

Consider the following rules:
     Rule 1  IF a THEN b;
     Rule 2  IF b THEN a;

From rule 1:  to prove 'b' is true, we need to prove 'a' is
true.
We can prove 'a' is true from rule 2, by proving 'b' is true.
We can prove 'b' is true form rule 1, by proving 'a' is true.
We can prove 'a' is true form rule 2 by ...

This is a circular argument similar to an endless loop in a
conventional programming language.

Don't worry.  rulebase can detect circular arguments.

In the above example rulebase will simply ask the user whether
or not 'a' is true.  If 'a' is true then 'b' will be true as
well from rule 2.



9.2.5  Contradictory rules

Consider the following rules:
     Rule 1  IF a THEN b;
     Rule 2  IF b THEN not a;

From rule 1:  if 'a' is true then 'b' will be true.
Now if 'b' is true then, from rule 2, 'a' is not true, which
contradicts our original assumption in rule 1!

rulebase will always assume that the latest information it has
(from the user or its rules) is correct.  This is similar to
the approach taken by most humans!
Therefore, these two rules by themselves, will result in two
facts being added to the current facts: a is not true, b is
true.

Of course things can get much more complicated if there are
other rules in the knowledge base linking 'a' and 'b'.
rulebase will always assume that 'last is correct'.

If you insist on using contradictory rules then expect strange
results!

If you do get strange results and you suspect contradictory
rules, then use the 'How', 'Facts' and 'Why' features of
rulebase to determine the logical error in your knowledge
base, and correct it.









                              72

rulebase Reference Section


9.3  Conclusion options

Conclusions contain facts and the following control clauses
that follow from the rule's conditions being true.
Control clauses are not stored as facts but are used for the
effect that they have.  Further explanation can be found in
the sections indicated.


display text "text in quotes"
     Displays text on the screen in 80 ch mode (see section
     5.4).

e.g. IF ... THEN ... AND display text "Your battery is flat";


display text FileName
     Display the contents of the text file 'FileName' on the
     screen in 80 ch. mode.  Don't worry about paging large
     files of text.  rulebase will automatically page the text
     and allow you to browse through it using the PgUp, PgDn,
     Home and End keys.
     The Esc key will end the display (see section 5.5).

e.g. IF ... THEN ... AND display text rulebase.hlp;


display text < FileName > ...
     An output file can be specified between '<' and '>'. This
     will cause the output to be directed to the named file
     rather than the screen.  A filename of PRN will direct
     the output to a printer if one is connected (see section
     6.3.)

e.g. IF ... THEN ... AND display text <customs.txt> "Your
allowances are:#";

     To print a file use:
     IF ... THEN ... AND display text <PRN> customs.txt;


display text < FileName  /a > ...
     The inclusion of the '/a' will append the output to an
     existing file (see section 6.3.).

e.g. IF ... THEN ... AND display text < customs.txt /a >
                      "spirits allowance is 1.5 litres#";













                              73

rulebase Reference Section


display graphic CutPicFile
     Display the picture CutPicFile on half the screen.
     CutPicFile is produced by the Toolbox option 'Cutpic'
     (see sec. 5.7).

e.g. IF ... THEN ... AND display graphic picname;


display graphic "text in quotes"
     Display text on half the screen in 40 ch. graphics mode.
     This feature allows pictures and text to be displayed
     together, side by side.  A sequence of display graphic
     clauses will cause the displays to alternate between the
     left and right sides of the screen, pausing between
     screen fulls (see section 5.6).

e.g. IF ... THEN ... AND display graphic picname
                     AND display graphic "Label text";


use rules RulesName
     Replace the existing knowledge base with RulesName.kbx
     and continue the inferencing session with these new rules
     (see sec. 6.6).
     Changing knowledge base does not affect the current
     facts.  The current facts will of course change as the
     new rules are used.

e.g. IF ... THEN ... AND use rules rulename.kbx;


save-facts SaveName
     Save the current environment to the file named SaveName
     (see section 6.4).

e.g. IF ... THEN ... AND save-facts savename;


load-facts FileName
     Replace the current environment with that stored in the
     file named FileName (see section 6.5).

e.g. IF ... THEN ... AND load-facts filename;

     There is a special case:
     IF ... THEN ... AND load-facts clear

     This will clear the environment of all current facts and
     start a new consultation.











                              74

rulebase Reference Section


import-facts FileName
     Update the current facts by adding facts from the text
     file named FileName.
     The format of the text file being imported is:
          (fact1  "long fact2 in quotes"  fact3 ...  factN)

     The enclosing parenthesis are necessary and long facts
     containing spaces must be enclosed in quotes.

e.g. IF ... THEN ... AND load-facts filename;


quit rulebase
     Immediately leave rulebase and return to the program that
     called it (usually DOS).

e.g. IF ... THEN ... AND quit rulebase;


dos DosInstr
     Obey the dos instruction 'DosInstr' and then return to
     rulebase.

e.g. IF ... THEN ... AND dos dir/w;


execute SoftwareName
     Load and execute the software 'SoftwareName' from the
     current directory and then return to rulebase (see
     section 8).

e.g. IF ... THEN ... AND execute ws read.me

This will call Wordstar with the file read.me if they are in
the current directory.


Notes on Conclusions:

A conclusion must always have at least one fact that is not
one of the above control clauses.
This allows rulebase to record that a rule has actually
succeeded (fired).
This fact must be first in the conclusion with any control
clauses following.















                              75

rulebase Reference Section


The conclusion 'Key Checked'

A conclusion of the form 'key checked' will always be stored
as a true fact irrespective of whether or not any of the
conditions are true.  This feature is useful to record that a
particular rule has been used.

e.g. IF GCSE is anything AND RSA is anything AND BTEC is
anything
          THEN qualifications checked;

In this case 'qualifications checked' would be recorded as a
fact once facts about GCSE, RSA and BTEC had been accumulated.


Anything Attribute

The use of the attribute 'anything' is a don't care situation.

For example, 'GCSE is anything' will always be true.
Its effect is to force rulebase to find a value for GCSE in
either the knowledge base or from the user.
The above rule is forcing a sequence of operations, namely
find a value for GCSE, followed by a value for RSA, followed
by a value for BTEC in that order.



9.4  Negative conditions and conclusions.

Any negative condition or conclusion must start with the word
NOT or NO.

For example:

     IF NO light is green THEN stop at traffic lights;
     IF NOT from inside EEC THEN duty free;
     IF four legs THEN NOT bird;

NOT and NO are interchangeable.

This is poor English but humans use so may different ways of
expressing negative information that it's difficult to allow
for them all.
















                              76

rulebase Reference Section


9.5  Questions

Question statements are used to associate meaningful questions
to any condition (key) used in a rule.

If a condition is not known to the computer and cannot be
proven from the knowledge base, then the inference mechanism
will 'ask the user' for information about it.

If there is a question with a key that corresponds to the
condition, then this question is used to 'ask the user'.

Conditions, as they appear in rules are stored as facts when
proven.  This system allows abbreviations to be used as
conditions and more detailed information about a condition
(key) to be put in a question statement.

If there is no question associated with a condition then
rulebase will generate its own if it needs to 'ask the user'
about this condition.
This will be in the form:
     Is this true: <condition> ?

The order and position of questions in the 'Rules' is not
important but for readability:
either all questions should be together at the beginning/end
     of the knowledge base;
or questions should be next to the rule(s) to which they
     apply.

Questions have the following syntax;

KEY [NOT | NO] key
QUESTION question
[ONE OF option {, option}]
[ANY OF option {, option}]
[ENTER REPLY]
[EXPLANATION explanation text]
[SCREEN WINDOW IS window-definition
               |FULL|TOP|BOTTOM|LEFT|RIGHT|TOP LEFT|TOP
               RIGHT|BOTTOM LEFT| BOTTOM RIGHT]
[SCREEN COLOUR IS colour-id ON colour-id]
[MENU COLOUR IS colour-id ON colour-id]
[INVERSE MENU COLOUR IS colour-id ON colour-id];

Where 'colour-id' is: BLACK |BLUE |GREEN |CYAN |RED |MAGENTA
|BROWN |GREY |DARK-GREY |LIGHT-BLUE |LIGHT-GREEN |LIGHT-CYAN
|LIGHT-RED |LIGHT-MAGENTA |YELLOW |WHITE












                              77

rulebase Reference Section


Example 1:
     IF ... AND weather is sunny THEN ... ;

     KEY weather
     QUESTION "Would you describe todays weather as sunny?";

Example 2:
     IF ... AND weather is sunny THEN ... ;

     KEY weather
     QUESTION "Which one of the following best describes
todays weather?"
     ONE OF sunny, cloudy, rainy;

This last example will associate the chosen 'weather' (sunny,
cloudy, rainy) with the condition 'weather is whatever'.
For example: If 'cloudy' is chosen, then the fact 'weather is
cloudy' is stored as a current fact and the example rule shown
will fail since weather is not sunny.

Case is not important and quotes are optional except when the
text contains a keyword.

Example 3:
     IF ... AND qualification is BTEC THEN ... ;

     KEY qualification
     QUESTION "Choose any of the following qualifications:"
     ANY OF qualopts.opx
     EXPLANATION "Your qualifications are needed to
     help choose a course for you.";

In this example the user can link the key 'qualification' with
any number of the options that are stored in the file
qualopts.opx.

Typically, qualopts.opx might contain:
     (GCSE  BTEC  RSA  "GCE ADVANCED")

Each option chosen will be stored as a separate fact
(qualification is GCSE ...) for later use.



















                              78

rulebase Reference Section


Example 4:
     IF ... AND qualification is BTEC THEN ... ;

     KEY qualification
     QUESTION "Choose any of the following qualifications:"
     ANY OF anything
     EXPLANATION "Your qualifications are needed to
     help choose a course for you."
     EXPLANATION explanation text]
     SCREEN WINDOW IS 5 10 16 50
     SCREEN COLOUR IS green on brown
     MENU COLOUR IS white on blue
     INVERSE MENU COLOUR IS red on white;

In this example, the following display characteristics have
been set:
   SCREEN WINDOW - The menu will occupy a window on the screen
          with its top left hand corner 5 characters down and
          10 characters from the left, 16 characters deep and
          50 characters wide.
   SCREEN COLOUR - Green writing on a brown background.
   MENU COLOUR    - white writing on a blue background.
   INVERSE MENU COLOUR - When an item is chosen from the menu,
          it will be shown as red writing on a white
          background.



9.6  'One of' or 'Any of'

The options following ONE OF or ANY OF can be:
     (i) listed in the question (examples 2 above)
     (ii) contained in a file with the extension ".OPX" which
     can be created by the editor (example 3 above)
     (iii) automatically created by rulebase (example 4
     above).

'One of'
If this option is used in a question then one, and only one,
item can be selected from the list that follows 'ONE OF':

e.g. IF ... AND colour is green THEN ... ;

     KEY colour
     QUESTION "Which one of the following colours is your
liquid?"
     ONE OF yellow, red, green;













                              79

rulebase Reference Section


'Any of'
If this option is used then one, or more, items can be
selected from the list:

e.g. IF ... AND qualification is BTEC THEN ... ;

     key qualification
     question "Choose any of the following qualifications:"
     any of GCSE, RSA, BTEC, GCE A-level


Option lists from a file
A text file with extension '.OPX' can be used to store the
option list.  This allows a long list to be included more
easily.  The name of the file follows the ONE OF or ANY OF.

The text file format is:
     (option1  "long option2 in quotes"  option3 ... optionN)

The file can be created using the text option from the Editor
sub-menu or created by another program.
The brackets are compulsory.

e.g. Key course
     question "Choose one of the following courses"
     one of OptFile.opx:

Here OptFile.opx contains the option list.  For example:  (
Maths  English  History )


Automatic options generation
When creating option lists it is very easy to make spelling
mistakes or forget to include a possible option.   rulebase
will create its own option list for a question if 'anything'
is included in the option list.
If this is used then rulebase will go through the knowledge
base looking for every occurrence of the key followed by the
word 'is' and add the attribute (after the word 'is') to the
option list for this key.

e.g.  IF colour is blue AND ... ;
      IF colour is green AND ... ;

     key colour
     question "What colour is your liquid"
     one of anything;

This will add 'blue' and 'green' to the option list for the
key 'colour'.










                              80

rulebase Reference Section


'none of these' option

If this is included as an option and chosen by the user, then
all the other options are assumed not true.

e.g. key colour
     question "What colour is your liquid"
     one of anything, "none of these";

If a user chooses 'none of these' this will mean that the
colour is not green, not yellow, and not blue.


'unknown' option
Choosing the option 'unknown' in the above example will cause
rulebase to find alternative routes through the rules.



9.7  'enter reply'

This clause can be used to update the current facts by
information entered by the user:

e.g. key name
     question "Please type in your name"
     enter reply;

This example will prompt the user to type an entry.  Whatever
is typed will be added to the current facts for later
processing in the form 'key is reply'.

If 'Jill' is entered in the last example then 'name is Jill'
is added to the current facts.  This can be used in other
rules such as :
     IF name is Jill AND ...

Keys can be used in any displayed text (reports, explanations,
...) by enclosing the key in dollar signs ($):

e.g. IF ... THEN ... AND  display text 'Hello $name$.  How are
you?'.

This will display the message:

     Hello Jill. How are you?














                              81

rulebase Reference Section


9.8  Explanations

Explanations can be attached to any question using an
explanation clause:

e.g. key name
     question "Please enter your name"
     enter reply
     explanation "Your name is needed for the $type$ report.";

Notice the key 'type' has been included in this explanation
text.
If an attribute for the key 'type' exists in the current
facts, then it will be inserted in the explanation text at the
point shown ($type$).
For example, if 'type is employee absence' is stored in the
current facts then the explanation will be:

     Your name is needed for the employee absence report.

If the explanation is long, it can be entered into a text file
using the Editor sub-menu.  The file must have the extension
'.EXX'.  The file name is then used in the explanation clause.

e.g. key name
     question "Choose a colour"
     one of anything
     Explanation expname.exx;     {'expname.exx' contains the
explanation test}



9.9  Formatting Printed Text

Text displayed on the screen from a question, an explanation,
display text clause and display graphic clause is
automatically centred when printed.  All line-feeds and
carriage returns in the text are ignored.
Carriage returns can be forced by placing a '#' at any point
in the text.

Attributes of keys in the current facts can be included in
this text by enclosing the key name in dollar signs ($).
No spaces are allowed between the $.

For example.  If 'name is Hannah' has been stored in the
current facts then the text:
     IF ... THEN ... AND display text "Hi $name$.# How are
you?"

will display:
     Hi Hannah
     How are you.







                              82

rulebase Reference Section


9.10  True Conditions

A condition is true if:

   1.  rulebase can prove it true either from it's accumulated
      facts (current facts) or from the rules, or
   2.  the user responds to a question in a positive way.

e.g. IF litmus paper is red THEN liquid is acidic;

     key litmus paper
     question "What colour is litmus paper when dipped into
the liquid?"
     one of red, blue;

If the user responds 'red,' then the conclusion 'liquid is
acidic' will be true and stored as a positive current fact.

If all rules with the same conclusion fail (each rule contains
at least one condition that is not true) then a negative facts
is stored (not liquid is acid).

This is similar to human reasoning when something is assumed
to be not true if all knowledge about it not true.



9.11  Use of 'anything'

There is a special case.  A condition of the form 'key is
anything' will always be true.  This is useful for collecting
information from the user.
For example:
     IF name is anything THEN name given;

     key name
     question "What is your name?"
     enter reply;

This will ask the user to enter their name ('John' for
example) and will store 'name is John' and 'name given' in the
current-facts.

These facts can then be used later.  For example:

     IF name is John THEN display text "Hello $name$";














                              83

rulebase Reference Section


9.12  Queries

Queries are used to direct rulebase's backward chaining
inference mechanism.
If any queries are given then rulebase will try to prove only
these and will ignore any rules not needed to do this.  This
feature is useful with a large knowledge base where a user is
only interested in using a subset of it.
For example in a complete car fault diagnosis system, a
particular user may only be interested in gearbox faults.  In
this case rulebase would be told to query 'gearbox faults'.

If no queries are given then rulebase will use all the rules
and try to prove everything it can, starting at the beginning
of the knowledge base and working through to the end.  In this
case, the order of the rules in the knowledge base could be
important.

Queries have the following format:

QUERY | QUERIES [NOT | NO] query {, [NOT | NO] query} ;

For example:
     QUERY ignition fault ;
     QUERIES ignition fault, "car fault", NO petrol in tank ;

The queries being used by rulebase can be seen from the 'Run
Rules' sub-menu using the 'Queries List' option.
Try to keep the queries list to a minimum.  A long query list
will slow down rulebase.
It is usually quite easy to reduce them to one.

For example, if your queries list is:
     cow, cat, dog, hen

These can be combined into the single query 'creature found'
with the control rule:

     IF cow OR cat OR dog OR hen THEN creature found;





















                              84

rulebase Reference Section


9.13  Facts

Known facts can be set up in a knowledge base before rulebase
begins its inferencing.  This will stop rulebase asking
questions about conditions or conclusions that are known to be
true.

Facts have the following syntax:
     FACT | FACTS [NOT | NO] fact {, [NOT | NO] fact} ;

For example:
          FACT engine rotates ;
          FACTS NOT battery is flat, "engine rotates" ;



9.14  Comments

Comment lines can appear anywhere in the rules, starting with
a "{" and
ending with a "}".
e.g.     {This is a comment}

All comments are ignored by rulebase and are used to document
a knowledge base.
There must be no ";" between the {}.

Note:  During development rules in a knowledge base can be
'commented out' by enclosing each line with {"   "}.  This
saves deleting rules that may be needed again at a later
stage.





























                              85

rulebase Reference Section


9.15  Use of variables

rulebase allows you to include in text the attributes of keys
stored in the current facts.
You can use them in question text, explanation text, and
display text (including files) by enclosing the key name in
dollar signs ($).

For example, there are times when you want to display some
text on the screen, or put names in a file but you do not know
what the text is or what the names are until certain rules
have been processed.

In the example below, the rule asks for two names referred to
as name1 and name2.

     IF name1 is anything AND name2 is anything
          THEN pass data
              AND display text <pass.txt> "$name1$, $name2$#"
              AND execute dbase.exe pass.prg;

     KEY name1
     QUESTION "Enter 1st name"
     ENTER REPLY;

     KEY name2
     QUESTION "Enter 2nd name"
     ENTER REPLY;

The actual names entered by the user, for example Hannah and
Rachael, are stored in the current-facts as 'name1 is Hannah'
and 'name2 is Rachael'.

The example writes these to a text file called pass.txt
separated by a comma (,) and terminated by a carriage return,
the hash (#) character.

dBase is then called and this file used in a dBase program
called 'pass.prg'.





















                              86

rulebase Reference Section


9.16  rulebase Applications

If rulebase is started with the name of a knowledge base (for
example 'rulebase animals') then this knowledge base will run
automatically and not allow the users access to any of the
'shell' options such as the Toolbox or Editor.

This can be set up in a batch file so that the application can
be called by a single name.

The only way out of an application is by pressing the 'Esc'
key one or more times until the application is restarted and
the first question re-displayed.
Press Ctrl-F10 (hold down the 'ctrl' key and press the F10
key).
You will be prompted:

     "Are you sure you want to quit (Y/N)

Answering:   "Y"    will quit the application.








































                              87

rulebase Reference Section


9.17  Lookup tables / database Access

rulebase can lookup data from a data file with the following
format:

     (
     ("field0"  "field1" ... "fieldn")           record1
     ("field0"  "field1" ... "fieldn")           record2
          ...
     ("field0"  "field1" ... "fieldn")           last record.
     )

The key field of each record is always the first field
(field0).
The brackets are needed.
A lookup file is opened using a question statement:

     KEY file-id
     QUESTION "whatever..."
     ONE OF DataFile.OPX;

Where DataFile.OPX is the name of the data file.
This question statement is used with a condition in a rule
that uses the key "file-id".

When the question is used, the user will be given a menu of
all key fields from which to choose one.  Choosing one will
make this record the current record.

e.g. IF student is anything ... THEN ...;

     Key student
     Question "Choose student name"
     One of stu-recs.OPX;

Once a current record has been chosen by the user, a lookup
clause is used as a conclusion or condition in a rule to
extract data from the current record.

The lookup clause format is:

     ...AND lookup FactKey in file-id [/R]

Where FactKey is the name used to store the value found as:
FactKey is FieldValue.
     file-id is the Key used in the related question clause.
     R is an optional field number, with the first field of a
record numbered 0.
If /R is omitted, or greater than the number of fields in the
record, then the record number defaults to the last field.










                              88

rulebase Reference Section


For example, an ASCII data file could be set up containing
names, addresses and ages of a group of people, using the text
option of the Editor sub-menu of rulebase (or any word-
processor):

     (
     ("Jack" "20 the Street" "19")
     ("Jill" "42 The Grove" "18")
     ("Bill" "The Nick" "52")
     )

The file is saved as PEOPLE.OPX.

The question to open this file might be:
     KEY people-rec
     QUESTION "Please choose a name:"
     ONE OF people.OPX;

and might be linked to the rule
     Rule 26
     IF ... AND people-rec is anything AND ... THEN ... ;

Data can be extracted from the file by:
     Rule 55
     IF ... THEN...
          AND lookup rec-name in people-rec /0
          AND lookup rec-address in people-rec/1
          AND lookup rec-age in people-rec /2
          AND display text
            "Your name is $rec-name$#  your address is $rec-
            address$# and your age is $rec-age$.## Bye;

For example: When rule 26 is used by rulebase, the option list
offered to the user will be:
     Jack,  Jill,  Bill

The user will be prompted:    Please choose a name:
Suppose "Jill" is chosen.
This will store 'people-rec is Jill" in the current facts and
made Jill's record the current record.

When rule 55 fires, the following facts will then be added to
the current facts:
     rec-name is Jill,  rec-address is 42 The Grove,  rec-age
     is 18.

A lookup clause used as a condition in a rule is always true.

If the lookup fails, then the complete, original lookup clause
is stored as a current fact.










                              89

rulebase Reference Section


9.18  Performing Calculations

Calculations can be included in rules.

The operators + (add), - (subtract), * (multiply) and /
(division) are supported by rulebase using pre-fix notation.

For example:
   num1 is 3;            {Set num1 to the value 3}
   num2 is 4;            {Set num2 to the value 4}
   ans1 is (+ num1 num2 5)    {ans1 = num1 + num2 + 5 = 12}
   ans2 is (- num1 num2 3)    {ans2 = num1 - num2 - 3 = -4}
   ans3 is (* num1 num2 2)    {ans3 = num1 x num2 x 2 = 24}
   ans4 is (/ num1 num2 3)    {ans4 = (num1 / num2) / 2 =
   0.25}
   celsius is (* (/ 5 9) (- fah 32))    {celsius = 5/9 x (fah
   - 32)


Numeric comparisons can be included in rules.

The comparitors '<' (less than) and '>' (greater than) are
supported by rulebase.

For example:
   IF ... AND num1 is < 4 ...
   IF ... AND num1 is > 3 ...

The following knowledge base SUMDEM demonstrates the use of
this notation:

key num1
question "Enter a value for num1:"
enter reply;

key num2
question "Enter a value for num2:"
enter reply;

Rule 1
If num1 is anything
   and num2 is anything
   then ans1 is (+ num1 num2)
        and ans2 is (+ num1 (* 3 num2))
        and ans3 is (/ ans1 num2)
        and display text
          "num1 is $num1$,# num2 is $num2$,# ans1 = (+ num1
num2) is $ans1$,#
           (+ num1 (* 3 num2)) is $ans2$,# (/ ans1 num2) is
$ans3$";










                              90

rulebase Reference Section


Rule 2
if num1 is > 6 then ok and display text "$num1$ > 6";

Rule 3
if num1 is < 6 then ok and display text "$num1$ < 6";

Rule 4
if num1 is 6 then ok and display text "$num1$ = 6";

Rule 5
if not num1 is > 6 then ok and display text "$num1$ not > 6";

Rule 6
if not num1 is < 6 then ok and display text "$num1$ not < 6";

Rule 7
if not num1 is 6 then ok and display text "$num1$ not = 6";


Load this knowledge base into rulebase and test it to see the
effect of these rules.







































                              91

rulebase Reference Section


9.19  Controlling Windows during User Input and Output

During user input and output the size and colour of the
windows used can be defined in the knowledge base.


9.19.1  User Input

The basic tool for controlling user input is the key/question
statement which has the following format:

KEY [NOT | NO] key
QUESTION question
[ONE OF option {, option}]
[ANY OF option {, option}]
[ENTER REPLY]
[EXPLANATION explanation text]
[SCREEN WINDOW IS window-definition|FULL|TOP|BOTTOM|LEFT|RIGHT
               |TOP LEFT|TOP RIGHT|BOTTOM LEFT| BOTTOM RIGHT]
[SCREEN COLOUR IS colour-id ON colour-id]
[MENU COLOUR IS colour-id ON colour-id]
[INVERSE MENU COLOUR IS colour-id ON colour-id];


Where 'colour-id' is:
          BLACK |BLUE |GREEN |CYAN |RED |MAGENTA |BROWN |GREY
          |DARK-GREY |LIGHT-BLUE |LIGHT-GREEN |LIGHT-CYAN
          |LIGHT-RED |LIGHT-MAGENTA |YELLOW |WHITE


Four window control clauses are available here: SCREEN WINDOW,
SCREEN COLOUR, MENU COLOUR and INVERSE MENU COLOUR.

The order of these clauses is not important.


























                              92

rulebase Reference Section


(a) SCREEN WINDOW

This controls the position on the screen and size of the main
window used to contain the whole menu display.
It is defined using four numbers: ROW COLUMN ROWS COLUMNS:

   ROW - This defines the starting row position; how many
      characters down from the top of the screen to put the
      top left corner.
      The top of the screen is referred to as row zero (0) and
      the bottom of the screen is row 24.
   COLUMN - This defines the starting column position; how
      many characters across from the left side of the screen
      to put the top left corner.
      The extreme left of the screen is referred to as
      character zero (0) and the extreme right is character
      80.
   ROWS - How many characters down does the window extend.
      This has a minimum value of 12 and a maximum of 24.
   COLUMNS - How many characters across does the window
      extend.
      This has a minimum value of 40 and maximum of 80.

ROW + ROWS must be less than 24.
COLUMN + COLUMNS must be less than 80.
If the window is less than the values defined above then an
error message will report the window as being too small.

Nine standard windows are pre-defined for you:
   FULL           - 0  0  24 80    {Full screen - the default
   used}
   TOP            - 0  0  12 80    {Top half of screen}
   BOTTOM         - 12 0  12 80    {Bottom half of screen}
   LEFT           - 0  0  24 40    {Left half of screen}
   RIGHT          - 0  40 24 40    {Right half of screen}
   TOP LEFT       - 0  0  12 40    {Top left quarter of
   screen}
   TOP RIGHT      -  0 40 12 40    {Top right quarter of
   screen}
   BOTTOM LEFT - 12 0 12 40 {Bottom left quarter of screen}
   BOTTOM RIGHT   - 12 40 12 30    {Bottom right quarter of
   screen}


















                              93

rulebase Reference Section


(b) SCREEN COLOUR

This is the overall main window colour and is defined as:
     'text colour' ON 'background colour'.

The colours available are:
   BLACK |BLUE |GREEN |CYAN |RED |MAGENTA |BROWN |GREY |DARK-
   GREY |LIGHT-BLUE |LIGHT-GREEN |LIGHT-CYAN |LIGHT-RED
   |LIGHT-MAGENTA |YELLOW |WHITE

For example:
   black on grey    - black text on a grey background (default
   setting);
   grey on blue     - grey text on a blue background;
   red on grey - red text on a grey background;

The following background colours will cause the text to flash
on and off:
   |DARK-GREY |LIGHT-BLUE |LIGHT-GREEN |LIGHT-CYAN |LIGHT-RED
   |LIGHT-MAGENTA |YELLOW |WHITE


For example:
     green on yellow     - green flashing text on a yellow
     background.

The default setting is black on grey.

Take care!  If the text colour is the same as the background
colour then the text will not be visible.
For example:
     blue on blue


(c) MENU COLOUR

This is the actual colour of the options shown on the menu and
is defined in the same way as SCREEN COLOUR above.

The default setting is 'white on blue'.




















                              94

rulebase Reference Section


(d) INVERSE MENU COLOUR

This is the colour used to show chosen options on a menu and
is defined in the same way as SCREEN COLOUR.

The default setting is 'white on red'.

The INVERSE MENU COLOUR should be different from the MENU
COLOUR otherwise you will not be able to see which options are
chosen!


Example 1:
   IF ... AND weather is sunny THEN ... ;

   KEY weather
   QUESTION "Which one of the following best describes todays
             weather?"
   ONE OF anything
   EXPLANATION "The weather conditions govern whether or not
                the picnic will be a success"
   SCREEN WINDOW IS 5 5 16 60
   SCREEN COLOUR IS yellow on red
   MENU COLOUR IS blue on grey
   INVERSE MENU COLOUR IS red on grey;

Example 2:
   IF ... AND ground is dry THEN ... ;

   KEY ground
   QUESTION "Which one of the following best describes todays
             ground conditions?"
   ONE OF anything
   INVERSE MENU COLOUR IS red on grey
   SCREEN COLOUR IS yellow on red
   EXPLANATION "The ground conditions govern whether or not
                the picnic will be a success"
   MENU COLOUR IS blue on grey
   SCREEN WINDOW IS bottom left;





















                              95

rulebase Reference Section


9.19.1.1  User Input Window Defaults


The following defaults are initially used by rulebase:

   SCREEN WINDOW      - FULL       {0 0 24 80}
   SCREEN COLOUR      - black on grey
   MENU COLOUR        - white on blue
   INVERSE MENU COLOUR   -  white on red;

These can be changed by the user with facts established in the
normal way either using the FACT statement or as conclusions
in rules.

The formats are:
DEFAULT QUESTION WINDOW IS window-definition
               |FULL|TOP|BOTTOM|LEFT|RIGHT|TOP LEFT|TOP
               RIGHT|BOTTOM LEFT| BOTTOM RIGHT

DEFAULT QUESTION COLOUR IS colour-id ON colour-id]

DEFAULT MENU COLOUR IS colour-id ON colour-id]

DEFAULT INVERSE MENU COLOUR IS colour-id ON colour-id];

Where 'colour-id' is:
          BLACK |BLUE |GREEN |CYAN |RED |MAGENTA |BROWN |GREY
          |DARK-GREY |LIGHT-BLUE |LIGHT-GREEN |LIGHT-CYAN
          |LIGHT-RED |LIGHT-MAGENTA |YELLOW |WHITE


For example:
   FACTS default question window is 4 4 12 40, default
        question colour is blue on green, default menu colour
        is red on green, default inverse menu colour is green
        on red;

   IF ... THEN ...
        AND default question window is left
        AND default question colour is cyan on green
        AND default menu colour is red on grey
        AND default inverse menu colour is grey on red;

Defaults will be used unless values are specifically specified
in the key/question statement as described above.















                              96

rulebase Reference Section


9.19.1.2  User Input Window Cascade

Input windows can be made to automatically appear as
overlapping pages on the screen.

This is called a  'cascade'.

This feature can be set up by establishing the following fact
in the normal way either using the FACT statement or as
conclusions in rules:

   QUESTION WITH CASCADE

For example:
   fact question with cascade;

   IF ... THEN ... AND question with cascade;

The cascade feature remains set until either the next 'page'
will not fit on the screen or it is unset by the following
fact:

   NOT QUESTION WITH CASCADE

For example:
   IF ... THEN ... AND not question with cascade and ... ;

The default is 'not question with cascade'.
































                              97

rulebase Reference Section


9.19.2  User Output (reports using DISPLAY TEXT)

The normal way of producing reports in rulebase is with the
DISPLAY TEXT clause in the conclusion of a rule.

For example:
   IF ... THEN ... AND display text customs.txt;

This statement will display the contents of the file
'customs.txt' to the screen in a box with a border, and title
centred in the top line of the border.

The report will use the following display defaults:
   Display window   - FULL;
   Display colour   - black on grey;
   Display title    - 'Report'.

These defaults can be changed by establishing facts in the
normal way either using the FACTS statement or as conclusions
in a rule.

The format is:
   DEFAULT DISPLAY WINDOW IS window-definition
                  |FULL|TOP|BOTTOM|LEFT|RIGHT|TOP LEFT|TOP
                  RIGHT|BOTTOM LEFT| BOTTOM RIGHT

   DEFAULT DISPLAY COLOUR IS colour-id ON colour-id]

   Where 'colour-id' is:
      BLACK |BLUE |GREEN |CYAN |RED |MAGENTA |BROWN |GREY
      |DARK-GREY |LIGHT-BLUE |LIGHT-GREEN |LIGHT-CYAN |LIGHT-
      RED |LIGHT-MAGENTA |YELLOW |WHITE

   DEFAULT DISPLAY TITLE IS "title-text"


For example:
   FACTS default display window is 4 4 12 40, default display
        colour is blue on grey, default display title is
        "Account Report";

   IF ... THEN...
        AND default display window is right
        AND default display colour is grey on blue
        and default display title is "Monthly Report";















                              98

rulebase Reference Section


Once set, these defaults will be used by all subsequent
reports unless they are temporarily set for the current rule
only using the following format:

   CURRENT DISPLAY WINDOW IS window-definition
                  |FULL|TOP|BOTTOM|LEFT|RIGHT|TOP LEFT|TOP
                  RIGHT|BOTTOM LEFT| BOTTOM RIGHT

   CURRENT DISPLAY COLOUR IS colour-id ON colour-id]

   Where 'colour-id' is:
      BLACK |BLUE |GREEN |CYAN |RED |MAGENTA |BROWN |GREY
      |DARK-GREY |LIGHT-BLUE |LIGHT-GREEN |LIGHT-CYAN |LIGHT-
      RED |LIGHT-MAGENTA |YELLOW |WHITE

   CURRENT DISPLAY TITLE IS "title-text"


These current settings apply only to the rule in which they
are defined.

For example:
   IF ... THEN...
        AND display text mthsum.txt     {uses default
        settings}
        AND current display window is bottom right
        AND current display colour is red on blue
        AND current display title is "January Report"
        AND display text janrep.txt
        AND current display window is top left
        AND current display colour is red on grey
        AND current display title is "February Report"
        AND display text febrep.txt
        AND ... ;


























                              99

rulebase Reference Section


9.19.2.1  User Output Window Cascade

Report windows produced using the 'display text' clause can be
made to automatically appear as overlapping pages on the
screen.  This is called a  'cascade'.

This feature can be set up by establishing the following fact
in the normal way either using the FACT statement or as
conclusions in rules:

   DISPLAY WITH CASCADE

For example:
   FACT display with cascade;

   IF ... THEN ... AND display with cascade;


The cascade feature remains set until either the next 'page'
will not fit on the screen or it is unset by the following
fact:

   NOT DISPLAY WITH CASCADE

For example:
   IF ... THEN ... AND not display with cascade AND ... ;

The default is 'not display with cascade'.



9.19.2.2  Removing Report Border

If the title, 'default' or 'current' as described above, is
set to "no border" then the report controlled by the 'title'
setting will be shown without any border or title.

For example:
   IF ... THEN...
        AND current display window is bottom right
        AND current display title is "no border"
        AND display text "This message will start in the
        middle of the screen"

















                             100

Appendices


Appendices


A.  The Animals knowledge base:

Rule 1
IF animal AND horns AND moos THEN cow;

Rule 2
IF bleats AND animal AND horns THEN goat;

Rule 3
IF animal AND wool THEN sheep;

Rule 4
IF animal AND baas THEN sheep;

Rule 5
IF bird AND clucks THEN hen;

Rule 6
IF bird AND quacks THEN duck;

Rule 7
IF animal AND barks then dog;

Rule 8
IF animal AND miaows THEN cat;

Rule 9
IF four legs then animal;

Rule 10
IF feathers THEN bird;

Rule 11
IF lays eggs THEN bird;

Rule 12
IF sheep AND horns THEN ram;




















                             101

Appendices


B.  The Carfault Knowledge Base

Rule 1
If you need help and car starts
    or not you need help and car starts
     then car ok
         and display text "You don't need any help"
         and display graphic "Your car works!"
         and display graphic "It must be more like this:"
         and display graphics roller
         and display graphic "rather than this:"
         and display graphic beetle;

key car starts
question Does your car start?;

Rule 2
If help needed
     then you need help
         and display text rulebase.hlp;

key help needed
question "Do you need any help using rulebase?"
explanation "If you answer 'Yes' then a help file will be
          printed for you to browse through.";

Rule 3
If not car starts
    and engine rotates is normally
     then check spark;

Rule 4
If not car starts and engine rotates is slowly
    or not car starts and "engine rotates is not at all"
     then check battery;

key engine rotates
question "How does your engine rotate when you turn the
ignition key?"
one of normally, slowly, "not at all";

Rule 5
If check battery
    and not lights work
     then battery is flat
         and display text "Your battery is flat";














                             102

Appendices


key lights work
question Do your lights work when switched on
explanation "I am trying to find out if your battery is flat"
answer 'No' if the lights do not work or they are dim";

Rule 6
If battery is flat
     then charge battery
         and display text "Charge your battery";

Rule 7
If not battery is flat
    and engines rotates slowly
     then check starter;

Rule 8
If check battery
    and lights work
     then check starter;

Rule 9
if check starter
    and starter jammed
     then release starter
         and display text "Put the car in gear and rock it
backwards and forwards";

Rule 10
If check starter
    and not starter jammed
     then check engine;

Rule 11
If check engine
    and check starter
    and engine seized
     then hard luck
         and display text "You have got big problems!";

Rule 12
If "engine rotates is slowly'
     then not engine seized and not starter jammed;


















                             103

Appendices


Rule 13
If check spark
    and not spark at plugs
     then ignition fault
         and display text "You have an ignition fault.";

Rule 14
If check spark
    and spark at plugs
     then check petrol;

Rule 15
If check petrol
    and petrol in carb
     then engine flooded
         and display text "Your engine is flooded.";

Rule 16
If engine flooded
     then cure engine flooded
         and display text "Dry your spark plugs and try
again.";

Rule 17
If check petrol
    and not petrol in carb
     then check tank;

Rule 18
If check tank
    and petrol in tank
     then check pump;

{Comment: Comments are enclosed in "{}" and are ignored by
rulebase}

Rule 19
If check tank
    and not petrol in tank
     then put petrol in tank
         and display text "Put some petrol in your tank";

Rule 20
If check pump
    and pump ok
     then carburettor fault
         and display text "You have a carburettor fault.";













                             104

Appendices


Rule 21
If carburettor fault
    or ignition fault
     then call mechanic
         and display text "Call a mechanic."
         and display graphic " Sell this.."
         and display graphic beetle
         and display graphic " and buy this.."
         and display graphic roller
         and display graphic " or buy this.."
         and display graphic brumxpic;

Rule 22
If petrol flows at carburettor when engine turns
     then pump ok;

Rule 23
If check pump
    and not pump ok
     then petrol pump fault
         and display text "You have a petrol pump fault."







































                             105

Appendices


C.  The Customs Knowledge Base


key bought
question "Which of the following have you bought?"
any of spirits, wine, cigarettes;

Rule 1
If from inside EC
     then duty paid
         and display text < customs.txt > "Your allowances
are:"#";

Rule 2
If not from inside EC
     then duty free
         and display text < customs.txt > "Your allowances are
:#";

key country
question From which country have you arrived?
enter reply;

Rule 3
If country is Belgium
    or country is Denmark
    or country is France
    or country is Germany
    or country is Greece
    or country is Italy
    or country is Ireland
    or country is Luxembourg
    or country is The Netherlands
    or country is Holland
    or country is Portugal
    or country is Spain
     then from inside EC;

Rule 4
If bought is spirits
    and duty paid
     then spirits allowance needed
         and display text < customs.txt /a> "spirits allowance
is 1.5 litres #";
















                             106

Appendices


Rule 5
If bought is spirits
    and duty free
     then spirits allowance needed
         and display text < customs.txt /a> "spirits allowance
is 1 litre #";

Rule 6
If bought is wine
    and duty paid
     then wine allowance needed
         and display text < customs.txt /a> "wine allowance is
5  litre #";

Rule 7
If bought is wine
    and duty free
     then wine allowance needed
         and display text < customs.txt /a> "wine allowance is
2 litre #";

Rule 8
If bought is cigarettes
    and duty free
     then cigarette allowance needed
         and display text < customs.txt /a> "cigarettes
allowance is 200 #";

Rule 9
If bought is cigarettes
    and duty paid
     then cigarette allowance needed
         and display text < customs.txt /a> "cigarettes
allowance is 300 #";

Rule 10
If country is anything
    and allowance needed
     then allowance checked
         and display text customs.txt;

Rule 11
If spirits allowance needed
    or wine allowance needed
    or cigarette allowance needed
        then allowance needed;














                             107

Appendices


D.  The PICNIC knowledge base

Rule 1
if weather is rainy
     then picnic is likely to be a washout;

Rule 2
if weather is sunny
    and ground is dry
     then picnic is ideal;

Rule 3
if weather is dull
    and ground is damp
     then having a picnic might give you piles;

Rule 4
if weather is dull
    and ground is dry
     then picnic is a bit risky;

Rule 5
if weather is sunny
    and ground is damp
     then picnic is best postponed a couple of hours;

key weather
question "How would you describe todays weather?"
one of anything;

key ground
question "How would you describe the ground today?"
one of anything;



























                             108

Appendices


E.  The Holiday knowledge base

key travel
question "How do you wish to travel to Paris?"
one of anything;
explanation "The journey by air takes 1 hour #.
          The train journey takes 8 hours #.
          The coach journey takes 11 hours";

key number of nights
question "How many night do you want to spend in Paris?"
one of anything;

Rule 1
if travel is by air
    and number of nights is 7
     then cost is 375;

Rule 2
if travel is by air
    and number of nights is 2
     then cost is 275;

Rule 3
if travel is by air
    and number of nights is 5
     then cost is 225;

Rule 4
if travel is by train
    and number of nights is 7
     then cost is 275;

Rule 5
if travel is by train
    and number of nights is 5
     then cost is 225;

Rule 6
if travel is by train
    and number of nights is 2
     then cost is 150;


















                             109

Appendices


Rule 7
if travel is by coach
    and number of nights is 7
     then cost is 225;

Rule 8
if travel is by coach
    and number of nights is 5
     then cost is 175;

Rule 9
if travel is by coach
    and number of nights is 2
     then cost is 100;














































                             110

Appendices


F.  rulebase Editor Command Summary

The editor used by rulebase is a Wordstar like editor with the
following commands, where ^ indicates holding down the key
marked 'Ctrl'.
E.g. ^S means type 'S' while holding down the 'Ctrl' key:

Cursor control:
arrowed keys  - one character in the direction indicated
^arrowed keys - one word in direction indicated
Home     - beginning of current line,     End     - end of
current line
^Home    - beginning of page      ^End    - end of page
^QE      - beginning of page      ^QX     - end of page
^S       - left a character       ^D      - right a character
^E       - up a character         ^X      - down a character
^A       - left a word            ^F      - right a word
^QS      - beginning of current line      ^QD     - end of
current line
^PgUp    - beginning of text      ^PgDn   - end of text
^QR      - beginning of text      ^QC     - end of text

Scroll control:
^Z       - up a line              ^W      - down a line
PgUp     - up a page,             PgDn    - down a page
^C       - up a page              ^R      - down a page

Delete control:
backspace                         -  character left    ^G   -
current character
^T       - current word           ^Y      - current line
^QY      - to end of line         ^KY     - delete block
^U       - undelete last delete

Quit/Save control
^KS      - save without quitting
^KQ      - quit without saving    ^KD     - save and quit (see
9.3)
^KB      - mark block start       ^KK     - mark block end
^KV      - move block to cursor   ^KC     - copy block at
cursor
^KR      - read file to cursor    ^KW     - write block to
file

Note that all knowledge bases are saved with the default
extension KBX.

Search/replace
^QF      - find string
^QA      - replace next string    ^L      - find next
occurrence
^QL      - replace all strings








                             111

Appendices


Block control
^OB      - mark block beginning   ^OE     - mark block end
^OR      - read block             ^OW     - write block
^OC      - copy block at cursor   ^OM     - move block to
cursor
^OD      - delete block

Others
Ins      - insert mode switch     ^V      - insert mode switch
^QP      - jump to last edit
^I       - tab right              ^QI     - tab left
^P       - escape character       ^M      - new line
















































                             112

Appendices


G.    Menu Summary

     Editor:   Wordstar like editor (see section 9).
     Rules:    edit Rules.
     Text:     edit a text file.
     Print:    print Rules or a text file.
     Main menu:     return to top level menu.

     Run rulebase:
     Use Rules:     start inferencing using the current rules.
     Rules list:    list the current rules to the screen.
     Queries list:  list the current queries to the screen.
               These are what rulebase is trying to prove.
     Load rules:    load a new set of rules from disk.
     Main menu:     return to main menu.

     Toolbox:
     Dos command:   communicate with DOS and return to
               rulebase.
     Cut picture:   prepare a picture for use in the rules.
     Main menu: return to maim menu.

     Quit or help:
     Help rulebase: display a help file to screen
               (RULEBASE.HLP).
     Main menu:     return to main menu.
     Quit to dos:   quit rulebase and return to dos.
               All information not saved is lost.

     Other menu options:
     Yes       - if what it asks is true;
     No        - if what it asks is not true;
     Unknown   - if you don't know the answer;
     (W)hy     - if you want to know 'why' you are being asked
               a question. Repeated 'whys' will cause the
               Inference Engine to backtrack on it's line of
               reasoning and report the steps it took in
               arriving at the current question;
     (F)acts   - if you want a list of everything it has
               deduced so far.
               A 'not' indicates a negative deduction;
     (H)ow     - if you want to know how it has deduced any of
               its facts.
               After selecting 'How' you will be asked to
               enter your 'query'.
               This is the fact you are interested in.
               For example: - Enter query: animal <RETURN>
               Case is not important but spelling is!
     (M)ore    - if you want rulebase to look for 'more'
               results.
     None of these   if none of the offered options is true.
     (E)xplanation  - to show any available explanation.








                             113
