/*
 * Rename an existing MSDOS file
 *
 * Emmet P. Gray			US Army, HQ III Corps & Fort Hood
 * ...!uunet!uiucuxc!fthood!egray	Attn: AFZF-DE-ENV
 * fthood!egray@uxc.cso.uiuc.edu	Directorate of Engineering & Housing
 * 					Environmental Management Office
 * 					Fort Hood, TX 76544-5057
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include "msdos.h"

void
mren(argc, argv)
int argc;
char *argv[];
{
	int entry, ismatch, nogo, fargn, verbose;
	char filename[13], *newfile;
	char new[13], *temp, drive;
	char *pathname;
	unsigned char *target;
	struct directory *dir;

	fargn = 1;
	verbose = 0;
	if (argc > 1) {
		if (!strcmp(argv[1], "-v")) {
			fargn = 2;
			verbose = 1;
		}
	}
	if (argc != fargn + 2) {
		fprintf(stderr, "Mtools version %s, dated %s\n", mversion, mdate);
		fprintf(stderr, "Usage: %s [-v] sourcefile targetfile\n", argv[0]);
		exit(1);
	}
	mcwd = fix_mcwd();

	drive = get_drive(argv[1]);
	if (init(drive, 2)) {
		fprintf(stderr, "%s: Cannot initialize '%c:'\n", argv[0], drive);
		exit(1);
	}
	strcpy(filename, get_name(argv[fargn]));
	pathname = get_path(argv[fargn]);
	if (subdir(drive, pathname))
		exit(1);

	temp = get_name(argv[fargn + 1]);
	target = dos_name(argv[fargn + 1], verbose);

	strcpy(new, unix_name(target, target + 8));
	nogo = 0;
					/* the name supplied may be altered */
	if((strcmp(temp, new) && verbose) &&
	   (ask_confirmation("Do you accept \"%s\" as the new filename (y/n) ? ", new)))
		exit(0);

					/* see if exists and do it */
	ismatch = 0;
	dir = 0;
	for (entry = 0; entry < dir_entries; entry++) {
		dir = dir_read(entry);
					/* if empty */
		if (dir->name[0] == 0x0)
			break;
					/* if erased */
		if (dir->name[0] == 0xe5)
			continue;
					/* if volume label */
		if ((dir->attr & 0x08))
			continue;
					/* you may rename a directory */
		newfile = unix_name(dir->name, dir->ext);

					/* if the new name already exists */
		if (!strcmp(new, newfile)) {
			fprintf(stderr, "%s: File \"%s\" already exists\n", argv[0], new);
			exit(1);
		}
					/* if the old name exists */
		if (match(newfile, filename)) {
			ismatch = 1;
			break;
		}
	}
	if (!ismatch) {
		fprintf(stderr, "%s: File \"%s\" not found\n", argv[0], filename);
		exit(1);
	}
					/* so go ahead and do it */
	strncpy((char *) dir->name, (char *) target, 8);
	strncpy((char *) dir->ext, (char *) target + 8, 3);
	dir_write(entry, dir);

	dir_flush();
	disk_flush();
	close(fd);
	exit(0);
}
