/*
 * Mount an MSDOS disk
 *
 * written by:
 *
 * Alain L. Knaff			
 * knaff@mururoa.imag.fr		
 *
 * for mtools package, written by:
 *
 * Emmet P. Gray			US Army, HQ III Corps & Fort Hood
 * ...!uunet!uiucuxc!fthood!egray	Attn: AFZF-DE-ENV
 * fthood!egray@uxc.cso.uiuc.edu	Directorate of Engineering & Housing
 * 					Environmental Management Office
 * 					Fort Hood, TX 76544-5057
 */

#include <stdio.h>

#ifdef linux
#include <errno.h>
#include <unistd.h>
#include <stdlib.h>
#include "msdos.h"
#include "patchlevel.h"
#include <linux/fd.h>
#include <sys/stat.h>

extern int errno;

void
mmount(argc, argv)
int argc;
char *argv[];
{
	char directory[9];
	char drive;
	char *mountpoint;

					/* first argument */
	if (argc > 3) {
		fprintf(stderr, "%s: too many arguments\n", argv[0]);
		fprintf(stderr, "Mtools version %s, dated %s\n", VERSION, DATE);
		fprintf(stderr, "Usage: %s: [-w] msdosdrive [mountpoint]\n", argv[0]);
		exit(1);
	}
	
	mcwd = fix_mcwd();

	if (argc<2)
	  drive = get_drive("");
	else 
	  drive = get_drive(argv[1]);

	if (init(drive, 0)) {
	  fprintf(stderr, "%s: Cannot initialize '%c:'\n", argv[0], drive);
	  exit(1);
	}

	/* make mount point */
	if ( argc <= 2 ){
	  sprintf(directory,"/mount/%c",drive);
#if 0
	  if ( mkdir(directory,0755) < 0 && errno != EEXIST ){
	    perror("make mount point");
	    exit(1);
	  }
#endif
	  mountpoint = directory;
	}else
	  mountpoint=argv[2];

	fprintf(stderr,"%s\n", ans);

	/* and finally mount it */
	execlp("mount", 
	       "mount", "-t", "msdos", ans, mountpoint,0);

	perror("exec mount");
	exit(1);
}

#else /* linux */

#include "msdos.h"

void
mmount()
{
  fprintf(stderr,"This command is only available for LINUX \n");
  exit(1);
}
#endif /* linux */

