/*
 * Delete an MSDOS file
 *
 * Emmet P. Gray			US Army, HQ III Corps & Fort Hood
 * ...!uunet!uiucuxc!fthood!egray	Attn: AFZF-DE-ENV
 * fthood!egray@uxc.cso.uiuc.edu	Directorate of Engineering & Housing
 * 					Environmental Management Office
 * 					Fort Hood, TX 76544-5057
 */

#include <stdio.h>
#include <signal.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include "msdos.h"

extern void got_signal();

void
mdel(argc, argv)
int argc;
char *argv[];
{
	int i, ismatch, entry, nogo, verbose, fargn, got_one, missed_one;
	unsigned int start;
	char *filename, *newfile;
	char *pathname, drive, last_drive;
	struct directory *dir;
					/* catch signals */
	signal(SIGINT, (SIG_TYPE(*) ()) got_signal);
	signal(SIGTERM, (SIG_TYPE(*) ()) got_signal);
	signal(SIGQUIT, (SIG_TYPE(*) ()) got_signal);

	got_one = 0;
	missed_one = 0;

	if (argc > 1 && !strcmp(argv[1], "-v")) {
		verbose = 1;
		fargn = 2;
	}
	else {
		verbose = 0;
		fargn = 1;
	}
	if (argc < 2 || (argv[1][0] == '-' && !verbose)) {
		fprintf(stderr, "Mtools version %s, dated %s\n", mversion, mdate);
		fprintf(stderr, "Usage: %s [-v] msdosfile [msdosfiles...]\n", argv[0]);
		exit(1);
	}
	last_drive = 'x';
	mcwd = fix_mcwd();

	for (i = fargn; i < argc; i++) {
		drive = get_drive(argv[i]);
		if (drive != last_drive) {
			if (last_drive != 'x') {
				fat_write();
				dir_flush();
				disk_flush();
			}

			if (init(drive, 2)) {
				fprintf(stderr, "%s: Cannot initialize '%c:'\n", argv[0], drive);
				missed_one++;
				continue;
			}
			last_drive = drive;
		}
		filename = get_name(argv[i]);
		pathname = get_path(argv[i]);
		if (subdir(drive, pathname)) {
			missed_one++;
			continue;
		}

		nogo = 0;
		ismatch = 0;
		for (entry = 0; entry < dir_entries; entry++) {
			dir = dir_read(entry);
					/* if empty */
			if (dir->name[0] == 0x0)
				break;
					/* if erased */
			if (dir->name[0] == 0xe5)
				continue;
					/* if dir or volume label */
			if ((dir->attr & 0x10) || (dir->attr & 0x08))
				continue;

			newfile = unix_name(dir->name, dir->ext);
					/* see it if matches the pattern */
			if (match(newfile, filename)) {
				if (verbose)
					printf("Removing %s\n", newfile);
				ismatch = 1;
				if ((dir->attr & 0x01) &&
				    (ask_confirmation("%s: \"%s\" is read only, erase anyway (y/n) ? ", argv[0], newfile)))
					continue;
				start = dir->start[1] * 0x100 + dir->start[0];
				if (fat_free(start))
					break;
				dir->name[0] = 0xe5;
				dir_write(entry, dir);
				got_one++;
			}
		}
		if (fat_error) {
			missed_one++;
			break;
		}

		if (!ismatch) {
			fprintf(stderr, "%s: File \"%s\" not found\n", argv[0], filename);
			missed_one++;
		}
	}
					/* write the FAT, flush the buffers */
	fat_write();
	dir_flush();
	disk_flush();
	close(fd);
	if (got_one && missed_one)
		exit(2);
	if (missed_one)
		exit(1);
	exit(0);
}
