/* -*- c -*- */

%{

#include <malloc.h>
#include <stdio.h>
#include <string.h>

/* #define DEBUG */

FILE *out = NULL;

char buf[2048], sectname[256], labeltxt[256];
char firstname[256], outname[256];

int filenum = 1;
int tmpfn;

int getstr( char *str, int n )
  {
#ifdef DEBUG
    fprintf( stderr, "DEBUG: yytext: <<%s>>\n", yytext );
#endif
    if( strlen( yytext ) == n )
      return 0;
    strncpy( str, yytext+n, yyleng-(n+5));
    str[ yyleng-(n+5) ] = 0;
    return 1;
  }

struct lprec
  {
    char *label;
    int fileno;
    struct lprec *next;
  };

typedef struct lprec lprec;

lprec *putlp();
lprec *getlp();

lprec *lp_table = (lprec *)0;
lprec *tmplp;

lprec *
putlp( char *lbl, int fn )
  {
    lprec *ptr;
    ptr = (lprec *) malloc (sizeof (lprec));
    ptr->label = (char *) malloc (strlen (lbl) +1 );
    strcpy( ptr->label, lbl );
    ptr->fileno = fn;
    ptr->next = (struct lprec *)lp_table;
    lp_table = ptr;
    return ptr;
  }

lprec *
getlp( char *lbl )
  {
    lprec *ptr;
    for (ptr = lp_table; ptr != (lprec *) 0;
	 ptr = (lprec *)ptr->next)
      if (strcmp (ptr->label,lbl) == 0)
	return ptr;
    return 0;
  }

%}

%s SECT

%%

^"<@@title>".*$ 	{

strcpy( sectname, yytext+9 );
printf( "<title>%s</title>\n<h1>%s</h1>\n",
       sectname, sectname );
}

^"<@@sect>".*$		{ 

if( !getstr( sectname, 8 ) )
  {
    BEGIN(SECT);
  }
else
  {
    if( out ) 
      {
	fclose( out );
      }
    sprintf( outname, "%s-%d.html", firstname, filenum++ );
    out = fopen( outname, "w" );
    fprintf( out, "<title>%s</title>\n", sectname );
    fprintf( out, "<h1>%s</h1>\n", sectname );
    fprintf( stdout, "<h2><a href=\"%s\">%s</a></h2>\n", outname,
	    sectname );
  }
}


^"<@@chapt>".*$		{

getstr( sectname, 9 );
sectname[ yyleng-14 ] = 0;
printf( "<h1>%s</h1>\n", sectname );
}

^"<@@endchapt>".*$	;

^"<@@endsect>".*$	{

fclose(out); out = NULL;
}

<SECT>^"<@@label>".*$	{
  
  strcpy( sectname, yytext+9 );
  if (!getlp( sectname ))
    {
      fprintf( stderr, "Problem with @@label!\n" );
    } 
  else
    {
      strcpy( labeltxt, sectname );
    }
}

^"<@@label>".*$		{
  
  strcpy( sectname, yytext+9 );
  if (!getlp( sectname ))
    {
      fprintf( stderr, "Problem with @@label!\n" );
    } 
  else
    {
      if( out )
	{
      fprintf( out, "<a name=\"#%s\">\n", sectname );
    }
      else
	{
	  printf( "<a name=\"#%s\">\n", sectname );
	}
    }
}


^"<@@labelp>".*$	{

#ifdef DEBUG
fprintf( stderr, "DEBUG: yytext = <<%s>>\n", yytext );
#endif
if (sscanf( yytext, "<@@labelp>%[^#]#%d", sectname, &tmpfn ) != 2)
{
  fprintf( stderr, "Problem with @@labelp!\n" );
#ifdef DEBUG
fprintf( stderr, "DEBUG: sectname = <<%s>>\n", sectname );
fprintf( stderr, "DEBUG: tmpfn = <<%d>>\n", tmpfn );
#endif
} else
putlp( sectname, tmpfn );

}

^"<@@ref>".*$		{

strcpy( sectname, yytext+7 );
if (!(tmplp = getlp( sectname )))
{
  fprintf( stderr, "Problem with @@ref!\n" );
} 
else
{
  
  if( out )
    {
      fprintf( out, "<a href=\"%s-%d.html#%s\">\n", firstname, tmplp->fileno,
	      sectname );
    }
  else
    {
      printf( "<a href=\"%s-%d.html#%s\">\n", firstname, tmplp->fileno,
	     sectname );
    }
}
}

<SECT>^.*$		{ 

getstr( sectname, 0 );

if( out ) 
{
  fclose( out );
}
sprintf( outname, "%s-%d.html", firstname, filenum++ );
out = fopen( outname, "w" );
fprintf( out, "<title>%s</title>\n", sectname );
if( strlen( labeltxt ))
{
  fprintf( out, "<a name=\"#%s\">\n", labeltxt );
  labeltxt[0] = 0;
}
fprintf( out, "<h1>%s</h1>\n", sectname );
fprintf( stdout, "<h2><a href=\"%s\">%s</a></h2>\n", outname,
	sectname );

BEGIN(0);
}

.*|\n			{

if( out )
{
  fprintf( out, "%s", yytext );
}
else
{
  ECHO;
}
}



%%

void
main( int argc, char **argv )
{
  if( argc >= 2 )
    {
      strncpy( firstname, argv[1], 256 );
    }
  else
    {
      strcpy( firstname, "$$" );
    }

  yylex();

  if( out ) fclose( out );      

  exit( 0 );
}
