/*:VRX         Main
*/
/*  Main
*/
    signal on novalue
    signal Main
novalue:
    parse source . . source
    call VRMessage "", "Novalue error in" source "line" SIGL, "Error!"
    _VREReturnValue = 32000
    signal _VRELeaveMain

Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary: procedure
    name = arg( 1 )

    window = VRLoad( VRWindow(), VRWindowPath(), name )
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
return window

/*:VRX         AddRecord
*/
/*  Add a record for an object to the container.
*/
AddRecord: procedure expose Fields. Classes.
    parse arg object, objPos
    if( VRMethod( "Application", "SupportsProperty", object, "Caption" ) ) then do
        text = VRGet( object, "Caption" )
    end
    else if( VRMethod( "Application", "SupportsProperty", object, "Value" ) ) then do
        text = VRGet( object, "Value" )
    end
    else do
        text = ""
    end  
    name = VRGet( object, "Name" )
    icon = IconNb( object )
    record = VRMethod( "CN_Objects", "AddRecord", , "Last", name, icon )

    call VRMethod "CN_Objects", "SetFieldData", record, Fields.!tab, VRGet( object, "TabIndex" )
    call VRMethod "CN_Objects", "SetFieldData", record, Fields.!handle, object
    call VRMethod "CN_Objects", "SetFieldData", record, Fields.!pos, objPos
    call VRMethod "CN_Objects", "SetFieldData", record, Fields.!icon, icon
    call VRMethod "CN_Objects", "SetFieldData", record, Fields.!name, name
    call VRMethod "CN_Objects", "SetFieldData", record, Fields.!text, text
return

/*  Return the resource number for an icon.
*/
IconNb: procedure expose Classes.
    parse arg object
    class = VRGet( object, "ClassName" )

    select
        when( class = "Pointer" ) then do
            num = '#100:VREDIT'
        end
        when( class = "DescriptiveText" ) then do
            num = '#101:VREDIT'
        end
        when( class = "GroupBox" ) then do
            num = '#102:VREDIT'
        end
        when( class = "PushButton" ) then do
            num = '#103:VREDIT'
        end
        when( class = "RadioButton" ) then do
            num = '#104:VREDIT'
        end
        when( class = "CheckBox" ) then do
            num = '#105:VREDIT'
        end
        when( class = "ImagePushButton" ) then do
            num = '#106:VREDIT'
        end
        when( class = "ImageRadioButton" ) then do
            num = '#107:VREDIT'
        end
        when( class = "PictureBox" ) then do
            num = '#108:VREDIT'
        end
        when( class = "ListBox" ) then do
            num = '#109:VREDIT'
        end
        when( class = "ComboBox" ) then do
            num = '#110:VREDIT'
        end
        when( class = "DropDownComboBox" ) then do
            num = '#111:VREDIT'
        end
        when( class = "EntryField" ) then do
            num = '#112:VREDIT'
        end
        when( class = "MultiLineEntryField" ) then do
            num = '#113:VREDIT'
        end
        when( class = "SpinButton" ) then do
            num = '#114:VREDIT'
        end
        when( class = "ValueSet" ) then do
            num = '#115:VREDIT'
        end
        when( class = "Slider" ) then do
            num = '#116:VREDIT'
        end
        when( class = "Notebook" ) then do
            num = '#117:VREDIT'
        end
        when( class = "Container" ) then do
            num = '#118:VREDIT'
        end
        when( class = "DDEClient" ) then do
            num = '#119:VREDIT'
        end
        when( class = "Timer" ) then do
            num = '#120:VREDIT'
        end
        otherwise do
            num = FindOtherIcon( class )
        end
    end
return num 

FindOtherIcon: procedure expose Classes.
    num = ""
    class = translate( arg(1) )
    if( Classes.0 = 0 )then do
        call VRMethod 'Application', 'ListClasses', 'Classes.', 'L'
        if( Classes.0 = 0 )then do
            return num
        end
    end
    do i = 1 to Classes.0
        parse var Classes.i "classname='"name"'" . "picturepath='"path"'" "dllname='"dll"'" .
        if( translate( name ) = class )then do
            if( pos( ':', path ) \= 0 )then do
                num = path
            end; else do
                num = path || ':' || dll
            end
            i = Classes.0 + 1
        end
    end
return num
/*:VRX         Fini
*/
Fini:
    window = VRWindow()
    call VRSet window, "Visible", 0
    drop window
return 0

/*:VRX         Halt
*/
Halt:
    signal _VREHalt
return


/*:VRX         Init
*/
/*  Assume invoked as a VRXEDIT macro so
        InitArgs.0 = 2
        InitArgs.1 = <object>
        InitArgs.2 = <editWindow>
*/
Init: procedure expose InitArgs. Fields. Classes.
    Classes.0 = 0

    window = VRWindow()
    call VRSet "CN_Objects", "Painting", 0
    call VRSet VRGet( window, "Parent" ), "Pointer", "Wait"

    /*  Set up the fields
    */
    Fields.!tab = VRMethod( "CN_Objects", "AddField", "ULong" )
    Fields.!handle = VRMethod( "CN_Objects", "AddField", "String" )
    Fields.!pos = VRMethod( "CN_Objects", "AddField", "String" )
    Fields.!icon = VRMethod( "CN_Objects", "AddField", "Icon" )
    Fields.!name = VRMethod( "CN_Objects", "AddField", "String", "Name" )
    Fields.!text = VRMethod( "CN_Objects", "AddField", "String", "Caption/Value" )

    call VRMethod "CN_Objects", "SetFieldAttr", Fields.!tab, "Visible", 0
    call VRMethod "CN_Objects", "SetFieldAttr", Fields.!handle, "Visible", 0
    call VRMethod "CN_Objects", "SetFieldAttr", Fields.!pos, "Visible", 0
    call VRMethod "CN_Objects", "SetFieldAttr", Fields.!icon, "ReadOnly", 1
    call VRMethod "CN_Objects", "SetFieldAttr", Fields.!name, "ReadOnly", 1
    call VRMethod "CN_Objects", "SetFieldAttr", Fields.!text, "ReadOnly", 1, "VertSeparator", 0

    call ListObjects InitArgs.2
    call VRSet VRGet( window, "Parent" ), "Pointer", "<Default>"

    if( VRGet( "CN_Objects", "Count" ) = 0 ) then do
        call VRMessage window, "No objects with the TabIndex property.", "Set tab order", "I"
        call Quit
    end
    else do
        call VRMethod "CN_Objects", "SortRecords"
        call VRSet "CN_Objects", "Painting", 1
        call VRMethod window, "CenterWindow"
        call VRSet window, "Visible", 1
        call VRMethod window, "Activate"
    end
return

/*  List objects which have the TabIndex property.
*/    
ListObjects: procedure expose Fields. Classes.
    parse arg parent, parentPos
    object = VRGet( parent, "FirstChild" )
    do while( object <> "" )
        if( TabObject( object ) ) then do
            call AddRecord object, parentPos || ObjectPos( object )
        end 
        else if( VRGet( object, "ClassName" ) = "GroupBox" ) then do
            call ListObjects object, parentPos || ObjectPos( object )
        end
        object = VRGet( object, "Sibling" )
    end
return

/*  Determine if an object has the 'tabindex' property.
*/
TabObject: procedure
    parse arg object
    tabobj = VRMethod( "Application", "SupportsProperty", object, "TabIndex" )
    if( \tabobj ) then do
        signal TabDone
    end
    if( VRGet( object, "ClassName" ) <> "DescriptiveText" ) then do
        signal TabDone
    end
    if( Pos( "~", VRGet( object, "Caption" ) ) = 0 ) then do
        tabobj = 0
    end
TabDone:
return tabobj

ObjectPos: procedure
    parse arg object
    top = Right( VRGet( object, "Top" ), 10 )
    left = Right( VRGet( object, "Left" ), 10 )
return top || left

/*:VRX         PB_Auto_Click
*/
/*  Set the TabIndex of all objects on the window based
    on position and grouping.
    
    The basic tab order is left to right, top to bottom
    except that when you enter a group you traverse all of
    its objects before you start the next group.
    
    Assume InitArgs.2 is the editWindow.
*/
PB_Auto_Click:
    call VRSet "CN_Objects", "DetailSort", Fields.!pos
    call VRMethod "CN_Objects", "SortRecords"
return

/*:VRX         PB_Cancel_Click
*/
PB_Cancel_Click:
    call Quit
return

/*:VRX         PB_OK_Click
*/
/*  Set the tab index of each object to its position in
    the list of objects.
*/
PB_OK_Click:
    call VRMethod "CN_Objects", "GetRecordList", "All", "objects."
    do i = 1 to objects.0
        handle = VRMethod( "CN_Objects", "GetFieldData", objects.i, Fields.!handle )
        call VRSet handle, "TabIndex", i
    end
    call Quit
    drop i handle objects.
return

/*:VRX         Quit
*/
Quit:
    window = VRWindow()
    call VRSet window, "Shutdown", 1
    drop window
return

/*:VRX         Window1_Close
*/
Window1_Close:
    call Quit
return

