PROGRAM Area2PoP;
{ͻ}
{ Converts AREAS.BBS to PORTAL.ARE              Last changed: 31.03.93  SA }
{                                                                          }
{                         (C) Copyright 1989-93 by                         }
{       Dan Wulff, Jens Sandalgaard, Steen Christensen & Sren Ager        }
{                                                                          }
{ This source can be distributed freely, as long as it is done in a        }
{ lawfull and friendly manner.                                             }
{ͼ}

USES Dos, OpString, PopTypes;

VAR
  BasePath : PathStr;
  Update   : BOOLEAN;

PROCEDURE Convert;
VAR
  AreasBbs : Text;
  AreasDat : File Of AreasType;
  AreasRec : AreasType;
  Tmp,InStr    : String;
  x : Byte;
  Ok : Integer;

  PROCEDURE FindArea;
  VAR
    Ar:AreasType;
    curpos:LONGINT;
    Found:BOOLEAN;
  BEGIN
    curpos:=FILEPOS(AreasDat);
    SEEK(AreasDat,0);
    Found:=FALSE;
    WHILE NOT EOF(AreasDat) AND NOT Found DO
    BEGIN
      READ(AreasDat,ar);
      IF Ar.EchoNames[1]=AreasRec.EchoNames[1] THEN
      BEGIN
        Found:=TRUE;
        curpos:=FILEPOS(AreasDat)-1;
        Ar.Directory:=AreasRec.Directory;
        Ar.SendTo[1]:=AreasRec.SendTo[1];
        Ar.SendTo[2]:=AreasRec.SendTo[2];
        AreasRec:=Ar;
      END;
    END;
    IF NOT Found THEN curpos:=FILESIZE(AreasDat);
    SEEK(AreasDat,curpos);
  END;

BEGIN
  WriteLn;
  WriteLn('Areas.bbs To Portal of Power converter v'+Ver);
  WriteLn('(c) Copyright 1992 by The Portal Team');
  WriteLn;
  Assign(AreasBbs, 'AREAS.BBS');
  Reset(AreasBbs);
  IF IOResult<>0 THEN Halt(1);
  Assign(AreasDat, 'PORTAL.ARE');
  Reset(AreasDat);
  IF IOResult<>0 THEN
  BEGIN
    ReWrite(AreasDat);
    Update:=FALSE;
  END;
  ReadLn(AreasBbs, InStr);
  WriteLn('Converting:');
  WHILE Not Eof(AreasBbs) DO
  BEGIN
    ReadLn(AreasBbs, InStr);
    IF (Length(INstr)>0) and not (InStr[1] IN [';','-']) THEN
    BEGIN
      FillChar(AreasRec, SizeOf(AreasRec), 0);
      WITH AreasRec DO
      BEGIN
        IF (InStr[1]<>'#') And (StUpCase(Copy(InStr,1,2))<>'P ') THEN
        BEGIN
          Tmp:=Copy(InStr,1,Pos(' ',InStr)-1);
          Val(Tmp,x,ok);
          IF Ok=0 THEN Directory:=BasePath+Tmp ELSE Directory:=AddBackSlash(Tmp);
        END;
        InStr:=Copy(InStr,Pos(' ',InStr),255);
        InStr:=TrimLead(InStr);
        EchoNames[1]:=StUpCase(Copy(InStr,1,Pos(' ',InStr)-1));
        InStr:=Copy(InStr,Pos(' ',InStr),255);
        InStr:=TrimLead(InStr);
        SendTo[1]:=InStr;
        Write(EchoNames[1],' ':10,#13);
      END;
      IF AreasRec.EchoNames[1]<>'' THEN
      BEGIN
        IF Update THEN FindArea;
        Write(AreasDat,AreasRec);
      END;
    END;
  END;
  writeln;
  Close(AreasDat);
  Close(AreasBbs);
END;

PROCEDURE ShowHelp;
BEGIN
  WRITELN;
  WRITELN('Available switches:');
  WRITELN;
  WRITELN('/B[path]   Specifies an alternate path for message bases of Hudson format');
  WRITELN('/U         Update existing, and add non-existing areas');
  WRITELN;
  HALT;
END;

PROCEDURE ParseCmdLine;
VAR
  i:BYTE;
  s:STRING;
BEGIN
  BasePath:='';
  Update:=FALSE;
  FOR i:=1 TO ParamCount DO
  BEGIN
    s:=StUpCase(ParamStr(i));
    IF s[1] IN ['-','/'] THEN
    BEGIN
      CASE s[2] OF
        'B'  : BasePath:=AddBackSlash(COPY(s,3,255));
        '?'  : ShowHelp;
        'U'  : Update:=TRUE;
        ELSE
        BEGIN
          WRITELN('Invalid parameter "'+s[2]+'"');
          HALT(2);
        END;
      END;
    END;
  END;
END;

BEGIN
  ParseCmdLine;
  Convert;
END.
