{ PROGRAM RSTMODEM REV. 1.1}
{ HANGS UP AND RESETS MODEM OR SENDS A SPECIFIED COMMAND TO MODEM}
{ WRITTEN 4/2/91 BY FRANK LONGMORE}
{ Async code Written by:  Kevin R. Bulgrien- COMM_TP4 Version 1.01 -01/31/89  }
{  1.00, 11/88 Original code uploaded to GEnie's Borland Roundtable           }
{ Much of this code adapted by Frank Longmore and incorporated into RSTMODEM  }

{$I+}    {I/O checking on}
{$R-}    {Range checking off}
{$V-}
{$S-}    {Stack checking off}
{$B-}    {Boolean complete evaluation off}
{$D-}
{$N-}    {No numeric coprocessor}
{$M 65500,16384,655360} {Turbo 3 default stack and heap}

program rstmodem;

USES
dos, crt;

CONST
  MaxSize = 511;

TYPE                                                                            {-8250 Communications Chip   }
  INS8250 = RECORD                                                              { -------------------------- }
              THR : INTEGER;                                                    { Transmit Holding Register  }
              RHR : INTEGER;                                                    { Receive Holding Register   }
              DLL : INTEGER;                                                    { Divisor Latch Register LSB }
              IER : INTEGER;                                                    { Interrupt Enable Register  }
              DLM : INTEGER;                                                    { Divisor Latch Register MSB }
              IIR : INTEGER;                                                    { Interrupt ID Register      }
              LCR : INTEGER;                                                    { Line Control Register      }
              MCR : INTEGER;                                                    { Modem Control Register     }
              LSR : INTEGER;                                                    { Line Status Register       }
              MSR : INTEGER;                                                    { Modem Status Register      }
            END;
  ComSettingsRecord = RECORD                                                    {-Used to hold the current   }
                       Baud : BYTE;                                             { settings of COM1 or COM2   }
                       Parity : BYTE;
                       Stop : BYTE;
                       Bits : BYTE;
                     END;

  ComSettingsType = ARRAY [1..2] OF ComSettingsRecord;                          {-COM1 & COM2 Settings       }
  BaudType = (B110,B150,B300,B600,B1200,B2400,B4800,B9600,B19200,B38400);       {-Baud rates supported       }
  ParityType = (None, Odd, Null, Even, MarkOff, Mark, SpaceOff, Space);         {-Parity types supported     }
  ComBuffersType = ARRAY [1..2, 0..MaxSize] OF BYTE;                            {-The input buffers for COM1 }
  OutBuffer = STRING [255];

CONST
  RS232 : ARRAY [1..2] OF INS8250 = ( ( THR:$3F8; RHR:$3F8; DLL:$3F8;           {-COM1 addresses of the 8250 }
                                        IER:$3F9; DLM:$3F9; IIR:$3FA;           { registers so that they may }
                                        LCR:$3FB; MCR:$3FC; LSR:$3FD;           { be accessed by name.       }
                                        MSR:$3FE ),
                                      ( THR:$2F8; RHR:$2F8; DLL:$2F8;           {-COM2 addresses of the 8250 }
                                        IER:$2F9; DLM:$2F9; IIR:$2FA;           { registers so that they may }
                                        LCR:$2FB; MCR:$2FC; LSR:$2FD;           { be accessed by name        }
                                        MSR:$2FE ) );
VAR
  which_num      : string[24];
  which_num_int  : integer;
  modem_command  : string[24];
  Char_count     : integer;     {counts the characters received from comm port}
  Exit_TERM      : BOOLEAN;     {true to exit term procedure after ALT-X}
  Dummy          : CHAR;        {black hole to feed unwanted keystrokes into}
  IntInstalled   : ARRAY [1..2] OF BOOLEAN;                                     {-TRUE if interrupt in place }
  OldIntVector   : ARRAY [1..2] OF POINTER;                                     {-Original COMx int. vectors }
  InHead, InTail : ARRAY [1..2] OF WORD;                                        {-Input buffer pointers      }
  Carrier : ARRAY [1..2] OF BOOLEAN;                                            {-TRUE if Carrier Detected   }
  ComSettings : ComSettingsType;                                                {-COM1 & COM2 line settings  }
  InBuffer : ComBuffersType;                                                    {-Input circular queue buffer}
  ExitSave : POINTER;                                                           {-Saves original ExitProc    }
  MaxPorts : WORD;                                                              {-Number of usable COM ports }
  Regs : REGISTERS;                                                             {-8088 CPU Registers         }
  CurrentCom : BYTE;                                                            {-COM port currently logged  }

PROCEDURE TITLE_SCREEN;
BEGIN
  WRITELN('RSTMODEM.EXE ver. 1.1 - by F. Longmore');
  WRITELN('Resets modem with ATH0, AT&F, ATZ or sends specified command to modem');
END;

PROCEDURE CHECK_PARAMS;
BEGIN
  IF (PARAMCOUNT < 1) or (PARAMCOUNT > 2) THEN
  BEGIN
    writeln('USAGE: RSTMODEM (COMM PORT #) [OPTIONAL MODEM COMMAND]');
    write('Which comm port has the modem? (1 or 2) ');
    readln(Which_num);
  END ELSE
  BEGIN
    Which_num := Paramstr(1);
  END;
  CurrentCom := Pos(Which_num,'12');
  if paramcount = 2 then modem_command := Paramstr(2);
END;

PROCEDURE DisableInts; INLINE ($FA);                                            {-Disable hardware interrupts}

PROCEDURE EnableInts; INLINE ($FB);                                             {-Enable hardware interrupts }

PROCEDURE SetupRS232 (Com, Baud, Parity, StopBits, DataBits : BYTE);
CONST                                                                           {-These values set the baud  }
  BaudTable : ARRAY [0..9] OF WORD = ($0417, $0300, $0180, $00C0, $0060,        { rate of the 8250 when they }
                                      $0030, $0018, $000C, $0006, $0003);       { are written to DLL & DMM.  }
TYPE
  BaudType = (B110,B150,B300,B600,B1200,B2400,B4800,B9600,B19200,B38400);       {-Baud rates supported       }
  ParityType = (None,Odd,Null,Even,MarkOff,Mark,SpaceOff,Space);                {-Parity settings supported  }
VAR                                                                             {-Temporary variable to hold }
  Parameters : BYTE;                                                            { correct LCR register value }
BEGIN
  IF (Com <= MaxPorts)                                                          {-Check validity of Com      }
    THEN BEGIN
           DisableInts;                                                         {-Always when writing to 8250}
           PORT [RS232 [Com].MCR] := $00;                                       {-DTR & RTS off while setting}
           PORT [RS232 [Com].LCR] := PORT [RS232 [Com].LCR] OR $80;             {-Allow access to DLL & DLM  }
           PORT [RS232 [Com].DLL] := LO (BaudTable [Baud]);                     {-Set the baud rate          }
           PORT [RS232 [Com].DLM] := HI (BaudTable [Baud]);
           Parameters := (DataBits - 5) AND $03;                                {-Build the value to write   }
           Parameters := Parameters OR (((StopBits - 1) SHL 2) AND $04);        { to Line Control Register.  }
           Parameters := Parameters OR ((Parity SHL 3) AND $38);
           PORT [RS232 [Com].LCR] := Parameters;                                {-Set parity, data/stop bits }
           PORT [RS232 [Com].MCR] := $0B;                                       {-DTR & RTS back on          }
           EnableInts;                                                          {-Done writing to 8250 regs. }
         END
    ELSE BEGIN
           WRITELN (#13,#10, 'Error!  COM', Com, ' not available', #10);        {-Mostly here for debugging  }
         END;                                                                   { purposes                   }
END;

{$F+}                                                                           {-Interrupt handlers MUST be }
PROCEDURE IntHandler; INTERRUPT;                                                { FAR calls.                 }
{$F-}
VAR                                                                             {-The COMx port which is to  }
  IntCom : BYTE;                                                                { be used.                   }
BEGIN
  PORT [$20] := $0B;                                                            {-Allow access to 8259 ISR   }
  IntCom := 3 - ((PORT [$20] AND $18) SHR 3);                                   {-Detect interrupting port   }
  CASE PORT [RS232 [IntCom].IIR] AND $06 OF
    0 : BEGIN                                                                   {-Modem Status Change Int.   }
          Carrier [IntCom] := ($80 AND PORT [RS232 [IntCom].MSR] = $80);        {-Save status of Carrier     }
        END;
    2 : BEGIN                                                                   {-Transmit Register Empty    }
        END;
    4 : BEGIN                                                                   {-Receive Register Full      }
          PORT [RS232 [IntCom].LCR] := PORT [RS232 [IntCom].LCR] AND $7F;       {-Allow THR,RBR & IER access }
          IF (InTail [IntCom] + 1) MOD (MaxSize + 1) <> InHead [IntCom]
            THEN BEGIN                                                          {-If the buffer is not full, }
                   InBuffer [IntCom,InTail[IntCom]] := PORT [RS232[IntCom].RHR];{ add the character and set  }
                   InTail [IntCom] := (InTail [IntCom] + 1) MOD (MaxSize + 1);  { the queue buffer pointer   }
                 END
            ELSE BEGIN                                                          {-If the buffer is full, the }
                   IF (PORT [RS232 [IntCom].RHR] = $00) THEN { DO Nothing };    { data is read & not stored  }
                 END;
        END;
    6 : BEGIN                                                                   {-Line Status change & Error }
        END;
  END;
  PORT [$20] := $20;                                                            {-Notify 8259 that interrupt }
END;                                                                            { has been completed.        }

PROCEDURE InstallInt (Com : BYTE);
BEGIN
  IF NOT IntInstalled [Com] AND (Com <= MaxPorts)                               {-Don't install the handler  }
    THEN BEGIN                                                                  { twice or if nonexistant.   }
           DisableInts;
           InTail [Com] := 0;                                                   {-Set input buffer to empty  }
           InHead [Com] := 0;
           Carrier [Com] := ($80 AND PORT [RS232 [Com].MSR] = $80);             {-Read Carrier Detect status }
           PORT [RS232 [Com].LCR] := PORT [RS232 [Com].LCR] AND $7F;            {-Allow THR,RBR & IER access }
           PORT [RS232 [Com].IER] := $00;                                       {-Disable 8250 interrupts    }
           IF PORT [RS232 [Com].LSR] <> 0 THEN { Nothing };                     {-Reset interrupts that were }
           IF PORT [RS232 [Com].RHR] <> 0 THEN { Nothing };                     { waiting to be processed    }
           GETINTVEC ($0D - Com, OldIntVector [Com]);                           {-Save old interrupt vector  }
           SETINTVEC ($0D - Com, @IntHandler);                                  {-Load new interrupt vector  }
           IntInstalled [Com] := TRUE;                                          {-The interrupt is installed }
           CASE Com OF
             1 : PORT [$21] := PORT [$21] AND $EF;                              {-Enable 8259 IRQ4 handling  }
             2 : PORT [$21] := PORT [$21] AND $F7;                              {-Enable 8259 IRQ3 handling  }
           END;
           PORT [RS232 [Com].LCR] := PORT [RS232 [Com].LCR] AND $7F;            {-Allow THR,RBR & IER access }
           PORT [RS232 [Com].IER] := $01;                                       {-Enable 8250 interrupts     }
           PORT [RS232 [Com].MCR] := $0B;                                       {-Set DTR & RTS so the other }
           EnableInts;                                                          { device knows we are ready  }
         END                                                                    { to recieve data            }
    ELSE BEGIN
           WRITE (#13, #10, 'Error!  COM', Com, ' ');
           IF IntInstalled [Com]
             THEN WRITELN ('interrupt already installed',#10)                   {-Mostly here for debugging  }
             ELSE WRITELN ('not available',#10)                                 { purposes.  Remove in your  }
         END;                                                                   { final program if you want. }
END;

PROCEDURE RemoveInt (Com : BYTE);
BEGIN
  IF IntInstalled [Com]                                                         {-Don't remove if interrupt  }
    THEN BEGIN                                                                  { has not been installed     }
           DisableInts;
           CASE Com OF
             1 : PORT [$21] := PORT [$21] OR $10;                               {-Disable 8259 IRQ4 handling }
             2 : PORT [$21] := PORT [$21] OR $08;                               {-Disable 8259 IRQ3 handling }
           END;
           PORT [RS232 [Com].LCR] := PORT [RS232 [Com].LCR] AND $7F;            {-Allow THR,RBR & IER access }
           PORT [RS232 [Com].IER] := $00;                                       {-Disable 8250 interrupts    }
           PORT [RS232 [Com].MCR] := $00;                                       {-Set DTR & RTS off.  Remove }
           SETINTVEC ($0D - Com, OldIntVector [Com]);                           { if modem shouldn't hang up }
           IntInstalled [Com] := FALSE;                                         { when you use RemoveInt.    }
           EnableInts;                                                          {-The original interrupt is  }
         END                                                                    { restored by SETINTVEC.     }
    ELSE BEGIN                                                                  {-Mostly here for debugging  }
           WRITE (#13, #10, 'Error!  COM', Com, ' ');                           { purposes.  Remove in your  }
           WRITELN ('interrupt is not installed', #10);                         { program if you wish.       }
         END;
END;

FUNCTION Equipment : WORD;
BEGIN
  INTR ($11, Regs);
  Equipment := Regs.AX;
END;

{$F+}                                             {-VERY IMPORTANT!  When the  }
PROCEDURE RemoveIntOnExit;                        { program quits normally or  }
{$F-}                                             { abnormally, the interrupt  }
BEGIN                                             { handlers are uninstalled   }
  IF IntInstalled [1]                             { if they are still set up.  }
    THEN RemoveInt (1);
  IF IntInstalled [2]
    THEN RemoveInt (2);
  ExitProc := ExitSave;                           {-Return control to the      }
END;                                              { original exit procedure    }

PROCEDURE WriteCOM (Com : BYTE; Data : OutBuffer);
VAR
 LoopVar,                                                                       {-Pointer to output char     }
 TimeLoop : WORD;                                                               {-Timeout counter variable   }
 TimeOut : BOOLEAN;                                                             {-True if unable to send     }
BEGIN
  LoopVar := 0;
  TimeOut := FALSE;
  WHILE (LoopVar < LENGTH (Data)) AND NOT TimeOut DO                            {-Send the data one char at  }
    BEGIN                                                                       { a time unless the port was }
      TimeLoop := 0;                                                            { timed out.                 }
      LoopVar := LoopVar + 1;
      WHILE (TimeLoop < 65535) AND ((PORT [RS232 [Com].LSR] AND $20) <> $20) DO {-Do not try to send data if }
        TimeLoop := TimeLoop + 1;                                               { the THR is not empty yet.  }
      IF TimeLoop <> 65535
        THEN BEGIN
               DisableInts;
               PORT [RS232 [Com].LCR] := PORT [RS232 [Com].LCR] AND $7F;        {-Allow THR,RBR & IER access }
               PORT [RS232 [Com].THR] := ORD (Data [LoopVar]);                  {-Put the data to send in    }
               EnableInts;                                                      { the THR                    }
             END
        ELSE BEGIN
               TimeOut := TRUE;                                                 {-WriteCOM aborts if the THR }
               WRITELN (#13,#10, 'Timeout on COM', Com);                        { takes too long to become   }
             END;                                                               { empty so you can send more }
    END;                                                                        { data                       }
END;

{ This function is an example of how to get a character from the serial port. As is, if the buffer is empty, }
{ it waits until a character arrives, so this will not work for the TTY emulation. The interrupts are always }
{ disabled when the buffer pointers are checked or modified.  Beware!  Do not completely disable interrupts  }
{ in the wait loop or else you never will get a character if there is not one there already.                 }
FUNCTION ReadCOM (Com : BYTE) : CHAR;
VAR
  CharReady : BOOLEAN;                                                          {-TRUE if there is data in   }
BEGIN                                                                           { the input buffer           }
  CharReady := FALSE;
  REPEAT                                                                        {-Wait for data to arrive    }
    DisableInts;
    CharReady := InTail [Com] <> InHead [Com];                                  {-Check to see if buffer is  }
    EnableInts;                                                                 { empty                      }
  UNTIL CharReady;
  DisableInts;
  ReadCOM := CHR(InBuffer [Com, InHead [Com]]);                                 {-Read a character of data   }
  InHead [Com] := (InHead [Com] + 1) MOD (MaxSize + 1);                         {-Update the buffer pointer  }
  EnableInts;
END;

PROCEDURE ReadMODEM (Com : BYTE);
VAR
  CharReady : BOOLEAN;
BEGIN
  CharReady := FALSE;
  REPEAT
    DisableInts;
    Write(CHR(InBuffer [Com, InHead [Com]]));
    InHead [Com] := (InHead [Com] + 1) MOD (MaxSize + 1);
    EnableInts;
    DisableInts;
    CharReady := InTail [Com] <> InHead [Com];
    EnableInts;
  UNTIL NOT CharReady;
END;

{ This provides a simple terminal emulation that might be used to prove that these routines really work, and }
{ that they are not hard to use.  I got to playing, and perhaps it got a bit more complex than necessary...  }
{ but then again, who said it had to be quick and dirty.  The LocalEcho parameter determines if characters   }
{ typed on the keyboard should be echoed to the screen.                                                      }
{ THIS PROCEDURE IS NOT CALLED BY RSTMODEM PROGRAM, JUST INCLUDED HERE IN CASE SOMEONE CAN USE IT            }
PROCEDURE TTY (LocalEcho : BOOLEAN);
VAR
  ExitTTY,                                                                      {-TRUE when ready to quit    }
  DataReady  : BOOLEAN;                                                         {-TRUE if buffer not empty   }
  OldCarrier : ARRAY [1..2] OF BOOLEAN;                                         {-Helps detect carrier change}
  Buffer     : CHAR;                                                            {-A character buffer         }
BEGIN
  OldCarrier [1] := NOT Carrier [1];                                            {-Make Carrier Detect Status }
  OldCarrier [2] := NOT Carrier [2];                                            { so it will be displayed    }
  DataReady := FALSE;                                                           {-Initialize everything      }
  ExitTTY := FALSE;
  Buffer := #0;
  CLRSCR;
  WRITELN ('Terminal emulator commands', #10);                                  {-Brief summary of command   }
  WRITELN ('<ALT C>  Toggle Port in use COM1/COM2');                            { keys that can be used      }
  WRITELN ('<Alt E>  Toggle Local Echo On/Off');
  WRITELN ('<Alt X>  Exit');
  REPEAT                                                                        {-Terminal emulation starts  }
    DisableInts;
    DataReady := (InTail [CurrentCom] <> InHead [CurrentCom]);                  {-If data has been received, }
    EnableInts;                                                                 { print one character        }
    IF DataReady
      THEN BEGIN                                                                { CHR(12) is interpreted as  }
        DisableInts;                                                            { a FormFeed, and so clears  }
        Buffer := CHR(InBuffer [CurrentCom, InHead [CurrentCom]]);              { the screen                 }
        InHead [CurrentCom] := (InHead [CurrentCom] + 1) MOD (MaxSize + 1);
        EnableInts;                                                             { Input buffer is updated    }
        CASE Buffer OF
          #12 : CLRSCR;
          ELSE  WRITE (Buffer);
        END; {case}
      END;
    IF (OldCarrier [CurrentCom] <> Carrier [CurrentCom])                        {-If a change in carrier     }
      THEN BEGIN                                                                { detect occurs, notify the  }
             WRITELN;                                                           { user of the new status     }
             IF Carrier [CurrentCom]
               THEN WRITELN ('CARRIER DETECTED (COM', CurrentCom, ')')
               ELSE WRITELN ('NO CARRIER (COM', CurrentCom, ')');
             OldCarrier [CurrentCom] := Carrier [CurrentCom];
           END;                                                                 {-If a key has been pressed, }
    IF KEYPRESSED                                                               { process it                 }
      THEN BEGIN
             Buffer := READKEY;
             IF (Buffer = #00) AND KEYPRESSED                                   {-Extended key codes require }
               THEN BEGIN                                                       { another read               }
                      Buffer := READKEY;
                      CASE Buffer OF
                        #46 : IF (1 + ORD (CurrentCom = 1)) <= MaxPorts         {-<ALT C> lets you toggle    }
                                THEN BEGIN                                      { between ports if the new   }
                                       CurrentCom := 1 + ORD (CurrentCom = 1);  { port exists                }
                                       WRITELN (#13,#10, 'COM', CurrentCom);
                                     END
                                ELSE BEGIN
                                       WRITE (#13,#10, 'COM');
                                       WRITE (1 + ORD (CurrentCom = 1));
                                       WRITELN (' not available');
                                     END;
                        #18 : LocalEcho := NOT LocalEcho;                       {-<ALT E> toggles Local Echo }
                        #45 : ExitTTY := TRUE;                                  {-<ALT X> exits the program  }
                        ELSE  WriteCOM (CurrentCom, CHR(27) + Buffer);          {-Other extended key codes   }
                      END;                                                      { are sent to the port       }
                    END
               ELSE BEGIN                                                       {-Normal key codes are sent  }
                      CASE Buffer OF                                            { or translated and sent     }
                        #12 : BEGIN
                                WriteCOM (CurrentCom, Buffer);                  {-FormFeed clears screen if  }
                                IF LocalEcho THEN CLRSCR;                       { local echo is on           }
                              END;
                        #13 : BEGIN                                             {-A carriage return also     }
                                WriteCOM (CurrentCom, Buffer + CHR(10));        { sends a line feed          }
                                IF LocalEcho THEN WRITELN;
                              END;
                        ELSE  BEGIN                                             {-All other characters are   }
                                WriteCOM (CurrentCom, Buffer);                  { sent as typed              }
                                IF LocalEcho THEN WRITE (Buffer);
                              END;
                      END;
                    END;
           END;
  UNTIL ExitTTY;                                                                {-Continue emulation until   }
END;                                                                            { <ALT X> is pressed.        }

PROCEDURE RESET_MODEM;
BEGIN
  WriteCom(CurrentCom,'ATH0' + #10 + #13); {hang up modem, if off hook}
  Delay(800);                              {delay 800 msec.}
  WriteCom(CurrentCom,'AT&F' + #10 + #13); {reset modem to factory defaults}
  Delay(800);                              {delay 800 msec.}
  WriteCom(CurrentCom,'ATZ' + #10 + #13);  {send reset modem command}
  Delay(800);                              {delay 800 msec.}
END;

PROCEDURE COMMAND_MODEM;
BEGIN
  WriteCom(CurrentCom,modem_command + #10 + #13); {send paramstring #2 to modem}
  Delay(800);                              {delay 800 msec.}
END;

BEGIN {main program}
  title_screen;
  ExitSave := ExitProc;                        {-VERY IMPORTANT!  This lets }
  ExitProc := @RemoveIntOnExit;                { the program halt safely.   }
  MaxPorts := (Equipment AND $0E00) SHR 9;     {-Find # of system COM ports }
  IntInstalled [1] := FALSE;                   {-No interrupt handlers are  }
  IntInstalled [2] := FALSE;                   { installed on start up      }
  If MaxPorts < 1 THEN
  BEGIN
    WRITELN ('Error!  No serial ports installed in this computer');
    EXIT;
  END;
  check_params;
  IF (CurrentCom < 1) or (CurrentCom > 2) then
  BEGIN
    Writeln('ERROR! Must be Comm1 or Comm2!');
    Exit;
  END;
  IF (CurrentCom = 1) and (MaxPorts >= 1)
  THEN BEGIN
    SetupRS232(1, ORD(B1200), ORD(Even),1,7);
    InstallInt(1);
  END;
  IF (CurrentCom = 2) and (MaxPorts >= 2)
  THEN BEGIN
    SetupRS232(2, ORD(B1200), ORD(Even),1,7);
    InstallInt(2);
  END;
  IF PARAMCOUNT < 2 THEN
  BEGIN
    WRITELN('Initializing modem...');
    RESET_MODEM;
    ReadMODEM(CurrentCom);
    WRITELN('Reset strings sent to Comm' + Which_num);
  END;
  IF PARAMCOUNT = 2 THEN
  BEGIN
    WRITELN('Initializing modem...');
    COMMAND_MODEM;
    ReadMODEM(CurrentCom);
    WRITELN(modem_command + ' sent to Comm' + Which_num);
  END;
    { IMPORTANT:  RemoveIntOnExit is always called when the program terminates! }
    {-RemoveIntOnExit invoked by removing interrupts!}
END.
