// MSGOBJ.CPP: private functions

#include <ctype.h>
#include <dos.h>
#include <fcntl.h>
#include <io.h>
#include <iostream.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#ifdef __WINDOWS__
#include <windows.h>
#endif
#include "config.h"
#include "msgobj.h"


int message_frame::open_area(void)
{
  lasterror=MSGERR_NOERR;
  if(area==-1)
    {
      lasterror=MSGERR_ENOAREASEL;
      return -1;
    }
  if(current_area==area) return 0;
  close_area();
  switch(AREATYPE(area))
    {
      case 0:
        sprintf(fname,"%sMpkt%04x.Pip",AREAPATH(area),area);
        #ifdef DEBUG
          cout << "Opening " << fname << "\n";
        #endif
        #ifdef __WINDOWS__
          filepkt=OpenFile(fname,O_BINARY|O_CREAT|O_RDWR|O_DENYALL);
        #else
          filepkt=open(fname,O_BINARY|O_CREAT|O_RDWR|O_DENYALL);
        #endif
        if(filepkt==-1)
          {
            lasterror=MSGERR_ENOFILE;
            return -1;
          }
        sprintf(fname,"%sMptr%04x.Pip",AREAPATH(area),area);
        #ifdef DEBUG
          cout << "Opening " << fname << "\n";
        #endif
        #ifdef __WINDOWS__
          fileptr=OpenFile(fname,O_BINARY|O_CREAT|O_RDWR|O_DENYALL);
        #else
          fileptr=open(fname,O_BINARY|O_CREAT|O_RDWR|O_DENYALL);
        #endif
        if(fileptr==-1)
          {
            lasterror=MSGERR_ENOFILE;
            return -1;
          }
        sprintf(fname,"%sDestPtr.Pip",AREAPATH(area));
        #ifdef DEBUG
          cout << "Opening " << fname << "\n";
        #endif
        #ifdef __WINDOWS__
          filedest=OpenFile(fname,O_BINARY|O_CREAT|O_RDWR|O_DENYALL);
        #else
          filedest=open(fname,O_BINARY|O_CREAT|O_RDWR|O_DENYALL);
        #endif
        if(filedest==-1)
          {
            lasterror=MSGERR_ENOFILE;
            return -1;
          }
        break;
      default:
        lasterror=MSGERR_NOTIMPL;
        return -1;
    }
  current_area=area;
  current_msg=-1; 
  return 0;
}


int message_frame::close_area(void)
{
  if(current_area==-1)
    {
      lasterror=MSGERR_ENOAREAOPEN;
      return -1;
    }
  switch(AREATYPE(area))
    {
      case 0:
        close(filepkt);
        close(fileptr);
        close(filedest);
        break;
      default:
        lasterror=MSGERR_NOTIMPL;
        return -1;
    }
  #ifdef DEBUG
    cout << "Closing area " << current_area << "\n";
  #endif
  current_area=-1;
  current_msg=-1;
  lasterror=MSGERR_NOERR;
  return 0;
}


int message_frame::pip_msg_post(char huge*text,char*from,char*to1,char*subj,unsigned int attr,address_class fromaddr,address_class destaddr,int modify,char *tearline,char *origin)
{
  MSGPTR hdr;
  MSGPKTHDR mpkt;
  DESTPTR pt;
  char to[36],date[20],fn[80];
  struct date dt;
  struct time tm;
  mpkt.fromnode=fromaddr.node;
  mpkt.fromnet=fromaddr.net;
  mpkt.pktype=10 /*2*/ ;
  mpkt.attribute=attr|SET_PKT_LOCAL; /* from us */
  strcpy(to,to1);
  if (!stricmp(AREATAG(area),"#NETMAIL"))
    {
      if(*destaddr.uucp)
        {
          destaddr.zone=UUCPZONE;
          destaddr.net=UUCPNET;
          destaddr.node=UUCPNODE;
          destaddr.point=0;
          strcpy(to,"UUCP");
        }
      mpkt.tonode=destaddr.node;
      mpkt.tonet=destaddr.net;
      mpkt.point=destaddr.point;
    }
  else
    {
      mpkt.tonode=0;
      mpkt.tonet=0;
      mpkt.point=0;
    }
  lseek(filepkt,filelength(filepkt)-2,SEEK_SET); hdr.pos=tell(filepkt);
  hdr.next=hdr.prev=0;
  hdr.status=SET_MPTR_FROMUS; /* from us */
  if(modify==-1)
    lseek(fileptr,filelength(fileptr),SEEK_SET);
  else
    lseek(fileptr,modify*sizeof(hdr),SEEK_SET);
  pt.area=area;
  pt.msg=tell(fileptr)/sizeof(hdr);
  strcpy(pt.to,to);
  pt.next=0;
  write(fileptr,&hdr,sizeof hdr);
  write(filepkt,&mpkt,sizeof mpkt);
  getdate(&dt); gettime(&tm);
  sprintf(date,"%02d %3s %02d  %02d:%02d:%02d",dt.da_day,mname[dt.da_mon-1],dt.da_year%100,tm.ti_hour,tm.ti_min,tm.ti_sec);
  write0((unsigned char*)date,filepkt);
  write0((unsigned char*)to,filepkt);
  write0((unsigned char*)from,filepkt);
  write0((unsigned char*)subj,filepkt);
  if (!stricmp(AREATAG(area),"#NETMAIL"))
    {
      if(destaddr.zone!=MYZONE)
        {
          sprintf(fn,"\1INTL %d:%d/%d %d:%d/%d\r",destaddr.zone,destaddr.net,destaddr.node,fromaddr.zone,fromaddr.net,fromaddr.node);
          write(filepkt,fn,strlen(fn));
        }
      if(destaddr.point)
        {
          sprintf(fn,"\1TOPT %d\r",destaddr.point);
          write(filepkt,fn,strlen(fn));
        }
      if(fromaddr.point)
        {
          sprintf(fn,"\1FMPT %d\r",fromaddr.point);
          write(filepkt,fn,strlen(fn));
        }
    }
  if (*AREATAG(area)!='#') /* echomail area */
    {
      if(find_origin(text)==NULL)
        {
          if(!tearline)
            tearline="--- MsgObj\r";
          if(!origin)
            origin="Origin line unspecified. Added by MessageObject";
          sprintf(fn,"--- %s\r",tearline);
          strcat(text,fn);
          sprintf(fn," * Origin: %s (%d:%d/%d.%d",origin,fromaddr.zone,fromaddr.net,fromaddr.node,fromaddr.point);
          if(strlen(fn)>77)
            sprintf(fn," * Origin: Original origin line too long! (%d:%d/%d.%d)\r",fromaddr.zone,fromaddr.net,fromaddr.node,fromaddr.point);
          strcat(text,fn);
          if (strlen(fn)+strlen(fromaddr.domain)<77)
            sprintf(fn,"@%s)\r",fromaddr.domain);
          else
            sprintf(fn,")\r");
          strcat(text,fn);
        }
    }
  if(*destaddr.uucp)
    {
      sprintf(fn,"To: %s\r\n\r",destaddr.uucp);
      write(filepkt,fn,strlen(fn));
     }
  pipstring((unsigned char*)text,filepkt);
  write(filepkt,"\0\0",2);
  lseek(filedest,filelength(filedest),SEEK_SET);
  write(filedest,&pt,sizeof pt);
  return 0;
}


int message_frame::not_in_seen_by(AUDIT *seen_by,uint net,uint node,uint point,int totnr)
{
  int i;
  for (i=0; i!=totnr; i++,seen_by++)
    if ((seen_by->net==net) && (seen_by->node==node) && (seen_by->point==point)) return 0;
  return -1;
}



