#include <stdio.h>
#include <string.h>
#include <io.h>
#include <fcntl.h>
#include <dos.h>
#include <stdlib.h>


#define v407


int    usernum,             /* user number for the user */
       age,                 /* age of the user */
       screenchars,         /* chars/line user has specified */
       screenlines,         /* lines/screen user has specified */
       sl,                  /* sec lev for user (0-255) */
       so,                  /* non-zero if user is sysop (sl=255) */
       cs,                  /* non-zero if user is co-sysop */
       okansi,              /* non-zero if user can support ANSI */
       incom,               /* non-zero if user is calling remotely */
       uploaded,            /* # files uploaded */
       downloaded,          /* # files downloaded */
       com_speed,           /* com port baud rate */
       modem_speed,         /* modem baud rate */
       comport;             /* com port user is on */
char   name[81],            /* name/alias of user */
       realname[81],        /* real name of user */
       callsign[10],        /* amateur radio callsign of user */
       sex,                 /* sex of user, M or F */
       laston[81],          /* date user was last on */
       gfiles[81],          /* directory for text files, ends in \ */
       data[81],            /* directory for non-text files, ends in \ */
       sysoplog[81],        /* full path & filename for sysop log */
       systemname[81],      /* name of BBS */
       sysopname[81],       /* name of sysop */
       parity[10],          /* parity 8N1 or 7E1 */
       curspeed[81];        /* speed user is on at, "KB" if local */
double gold,                /* gold user has */
       timeallowed,         /* number of seconds before user logged off */
       version;             /* version of WWIV running under */
long   timeon,              /* number of seconds since midnight logged on */
       timespent,           /* number of seconds spent online so far */
       uk,                  /* # k uploaded */
       dk;                  /* # k downloaded */


#ifdef v407

/* function pointers for BBS functions.  ONLY used for 4.07 or later. */

void far interrupt (*inli)(char far *, char far *, int, int);
void far interrupt (*checka)(int far *, int far *);
void far interrupt (*pla)(char far *, int far *);
void far interrupt (*outchr)(char);
void far interrupt (*outstr)(char far *);
void far interrupt (*nl)();
void far interrupt (*pl)(char far *);
int  far interrupt (*empty)();
char far interrupt (*inkey)();
unsigned char far interrupt (*getkey)();
void far interrupt (*input)(char far *, int);
void far interrupt (*inputl)(char far *, int);
int  far interrupt (*yn)();
int  far interrupt (*ny)();
void far interrupt (*ansic)(int);
char far interrupt (*onek)(char far *);
void far interrupt (*prt)(int, char far *);
void far interrupt (*mpl)(int);

void far * far *funcs;

#endif

int read_in_data(char *fn)
{
  char buf[1024];
  char *ptr[50],*ss,s[81];
  int i,f,len,i1;
  float fl;
  unsigned short c_s, c_o;

  for (i=0; i<50; i++)
    ptr[i]=NULL;
  f=open(fn,O_RDONLY | O_BINARY);
  if (f<0) {
    return(-1);
  }
  i1=1;
  ptr[0]=buf;
  len=read(f,(void *)buf,1024);
  close(f);
  for (i=0; i<len; i++)
    if (buf[i]==13) {
      buf[i]=0;
      ptr[i1++]=&buf[i+2];
    }
  while (*ptr[6]==32)
    ++(ptr[6]);
  while (*ptr[15]==32)
    ++(ptr[15]);

  usernum=atoi(ptr[0]);
  strcpy(name,ptr[1]);
  strcpy(realname,ptr[2]);
  strcpy(callsign,ptr[3]);
  age=atoi(ptr[4]);
  sex=*ptr[5];
  sscanf(ptr[6],"%f",&fl);
  gold=(double)fl;
  strcpy(laston,ptr[7]);
  screenchars=atoi(ptr[8]);
  screenlines=atoi(ptr[9]);
  sl=atoi(ptr[10]);
  so=atoi(ptr[11]);
  cs=atoi(ptr[12]);
  okansi=atoi(ptr[13]);
  incom=atoi(ptr[14]);
  sscanf(ptr[15],"%f",&fl);
  timeallowed=(double)fl;
  strcpy(gfiles,ptr[16]);
  strcpy(data,ptr[17]);
  strcpy(sysoplog,gfiles);
  strcat(sysoplog,ptr[18]);
  strcpy(curspeed,ptr[19]);
  if (curspeed[0]!='K')
    modem_speed=atoi(curspeed);
  comport=atoi(ptr[20]);
  if (ptr[21])
    strcpy(systemname,ptr[21]);
  if (ptr[22])
    strcpy(sysopname,ptr[22]);
  if (ptr[23])
    timeon=atol(ptr[23]);
  if (ptr[24])
    timespent=atol(ptr[24]);
  if (ptr[25])
    uk=atol(ptr[25]);
  if (ptr[26])
    uploaded=atoi(ptr[26]);
  if (ptr[27])
    dk=atol(ptr[27]);
  if (ptr[28])
    downloaded=atol(ptr[28]);
  if (ptr[29])
    strcpy(parity,ptr[29]);
  if (ptr[30])
    com_speed=atoi(ptr[30]);

  version=-1.0;
  ss=getenv("BBS");
  if (strncmp(ss,"WWIV",4)) {
#ifdef v407
    printf("\nThis program MUST be run under WWIV v4.07 or later.\n");
    exit(0);
#else
    printf("\nWARNING: Not running under WWIV\n");
    return(0);
#endif
  }
  strcpy(s,&(ss[6]));
  i=(s[0]-'0')*100+(s[2]-'0')*10+(s[3]-'0');
  version=((double)i)/100.0;

#ifdef v407

  if (i<407) {
    printf("\nThis program requires WWIV v4.07 or later.\n");
    exit(0);
  }

  if (i<421)
    funcs=(void far *)getvect(0x6a);
  else {
    ss=getenv("WWIV_FP");
    if (!ss) {
      printf("\nWWIV_FP env-var not set.\n\n");
      exit(0);
    }
    c_s=strtol(ss,NULL,16);
    c_o=strtol(ss+5,NULL,16);
    if (c_s && c_o) {
      funcs=(void far *)MK_FP(c_s, c_o);
    } else {
      printf("\nWWIV_FP not set to valid value.\n\n");
      exit(0);
    }
  }
  inli=funcs[0];
  checka=funcs[1];
  pla=funcs[2];
  outchr=funcs[3];
  outstr=funcs[4];
  nl=funcs[5];
  pl=funcs[8];
  empty=funcs[9];
  inkey=funcs[10];
  getkey=funcs[11];
  input=funcs[12];
  inputl=funcs[13];
  yn=funcs[14];
  ny=funcs[15];
  ansic=funcs[16];
  onek=funcs[17];
  prt=funcs[18];
  mpl=funcs[19];

#endif

  return(0);
}


void main(int argc, char *argv[])
{
  char s[81];

  if (argc<2)
    strcpy(s,"CHAIN.TXT");
  else
    strcpy(s,argv[1]);

  if (read_in_data(s)==-1) {
    printf("\nData file not found\n\n");
    abort();
  }


  printf("user #%d\n",usernum);
  printf("username %s\n",name);
  printf("realname %s\n",realname);
  printf("callsign %s\n",callsign);
  printf("age %d\n",age);
  printf("sex %c\n",sex);
  printf("gold %f\n",gold);
  printf("laston %s\n",laston);
  printf("screensize %dx%d\n",screenchars,screenlines);
  printf("sl %d\n",sl);
  printf("sysop %s\n",so?"Yes":"No");
  printf("cosysop %s\n",cs?"Yes":"No");
  printf("ansi %s\n",okansi?"Yes":"No");
  printf("incom %s\n",incom?"Yes":"No");
  printf("timeallowed %f\n",timeallowed);
  printf("gfiles %s\n",gfiles);
  printf("data %s\n",data);
  printf("sysoplog %s\n",sysoplog);
  printf("curspeed %s\n",curspeed);
  printf("com port %d\n",comport);
  printf("systemname %s\n",systemname);
  printf("sysopname %s\n",sysopname);
  printf("timeon %ld\n",timeon);
  printf("timespent %ld\n",timespent);
  printf("uk %ld\n",uk);
  printf("uploaded %d\n",uploaded);
  printf("dk %ld\n",dk);
  printf("downloaded %d\n",downloaded);
  printf("parity %s\n",parity);
  printf("com_speed %u\n",com_speed);
  printf("modem_speed %u\n",modem_speed);


#ifdef v407
  sprintf(s,"Running under WWIV v%4.2f.",version);
  nl();
  pl(s);
  nl();
#endif

}
