;-----------------------------------------------------------------------
; DL!DnWtr.RS - Robocomm 4.x script: Download Weather Map
;........................................................................
; Author:   Rick Matthews
; Date:     06/27/93
; Version:  2.1
;
; Notes:    If today's weather map exists in the free file area
;           (TOD.GIF), this script will download it into the configured
;           RoboComm download directory.  The file will be renamed
;           YYYYMMDD.GIF, where YYYY = year, MM = Month, and DD = Day.
;           This naming convention will put the gif files in day order
;           when sorted alphabetically.  You need a GIF viewer (such as
;           VPIC) in order to display the maps.  It is up to the user to
;           maintain the desired number of weather map GIFs and to
;           delete unwanted files.
;
;-----------------------------------------------------------------------
TITLE "Download Today's Weather Map from Datalink"

; Check to see if we have already downloaded today's map

        IF EXIST "%DLDIR%%YEAR%%NMONTH%%DOM%.GIF"   GOTO DONEIT

; Go Look for the map

        MESSAGE "Looking for Today's Weather Map"
        WHEN "TOD.GIF"          GOTO GETMAP
        SEND "*"
        WAITFOR "<D>ownload"    FAILURE GOTO NOGO
        MESSAGE "Today's Weather Map Not Found < < < <"
        SEND "|="
        WAITFOR "Command"       FAILURE GOTO NOGO
        EXIT 0

:GETMAP

        MESSAGE "Today's Map Found, Initiating Download..."
        CLEAR
        TIMEOUT 15
        SEND "TOD.GIF|"
        WAITFOR "Start Signal"  FAILURE GOTO NOGO
        DOWNLOAD "%DLDIR%%YEAR%%NMONTH%%DOM%.GIF" OVERWRITE
        MESSAGE "Map Downloaded and Named %YEAR%%NMONTH%%DOM%.GIF"
        WAITFOR "<D>ownload"
        SEND "|="
        WAITFOR "Command"
        TIMEOUT 170
        EXIT 0

:NOGO

        MESSAGE "Download of map aborted."
        SEND "||="
        EXIT 1

:DONEIT

        MESSAGE "%DLDIR%%YEAR%%NMONTH%%DOM%.GIF Already Exists"
        EXIT 0
