;-----------------------------------------------------------------------
; DL!DnQWK.RS - Robocomm 4.x script to download mail from DataLink
;.......................................................................
; Author:   Rick Matthews
; Date:     07/04/93
; Version:  2.0
;-----------------------------------------------------------------------
TITLE "Download QWK packets from DataLink"

WHEN "TO CONTINUE"              SEND "|"
WHEN "-Press Any Key-"          SEND "|"
WHEN "-More-"                   SEND "|"
WHEN "breaking in to chat"      SEND "Script file, cannot respond.|"

; This retrieves waiting mail

:GetPacket
MESSAGE "Requesting QWK Packet"
SEND "Q"
WAITFOR "Main Menu Command"
SEND "D"
TIMEOUT 180
WHEN "there are no new messages" GOTO NoInComing
WHEN "Would you like to receive" SEND "Y|"
WAITFOR "Awaiting Start Signal"
MESSAGE "Beginning download of %QWKDIR%%ID%.QWK"

; If you do not run your mail reader between sessions, you will in all
; likelyhood have a QWK packet already existing when you begin your
; download.
; Keep 3 old QWK packets by default.
; Edit this if desired.
IF EXIST "%QWKDIR%%ID%.QWK" RENUMBER "%QWKDIR%%ID%.QWK" 3

DOWNLOAD "%QWKDIR%%ID%.QWK"
TIMEOUT 60
WAITFOR "MAIN MENU COMMAND"

; If we didn't download a QWK packet we are finished.

IF NOT EXIST "%QWKDIR%%ID%.QWK"         GOTO Thats_it

; Extract the NEWFILES.DAT file from the QWK packet

MESSAGE "Extracting NEWFILES.DAT from QWK packet."
RUN "pkunzip %QWKDIR%%ID%.QWK %QWKDIR% newfiles.dat"
IF NOT EXIST "%QWKDIR%newfiles.dat"     GOTO No_New_Files

; Convert the DataLink format into a RoboComm-digestable format.

MESSAGE "Converting files list to RoboComm format."
RUN "dir4robo %QWKDIR%newfiles.dat"

MESSAGE "Erasing NEWLIST.DAT and NEWFILES.DAT."
ERASE "%QWKDIR%newlist.dat"
ERASE "%QWKDIR%newfiles.dat"
SEND "|"
GOTO Thats_It

:NoInComing
MESSAGE "No QWK Packet To Download."
SEND "|"
GOTO Thats_It

:No_New_Files
MESSAGE "****************************************************"
MESSAGE "*                                                  *"
MESSAGE "*    PKUNZIP did not locate a NEWFILES.DAT in      *"
MESSAGE "*    the QWK packet and reported an ERROR 11.      *"
MESSAGE "*             There are no new files.              *"
MESSAGE "*                                                  *"
MESSAGE "****************************************************"

:Thats_It
SEND "Q"
WAITFOR "Command"
EXIT 0
;
; End of Script
;
