

















AceComm (tm)





User's Guide



Copyright (c) 1991-1994 by MGP Software.

All rights reserved.  No part of this publication may be reproduced, stored in
a retrieval system, or transmitted by any means, electronic, mechanical,
photocopying, recording, or otherwise, without express written permission from
MGP Software.  The software described in this publication is furnished under a
license agreement and may be used or copied only in accordance with the terms
of that agreement.

This publication and its associated software are sold without warranties,
either expressed or implied, regarding their merchantability or fitness for any
particular application or purpose.  The information in this publication is
subject to change without notice and does not represent a commitment on the
part of MGP Software.  In no event shall MGP Software be liable for any loss of
profit or any other commercial damage, including but not limited to special,
incidental, consequential, or other damages resulting from the use of or the
inability to use this product, even if MGP Software has been notified of the
possibility of such damages.


First Printing, January 1994

AceComm version 1.81











All brand and product names mentioned in this publication are trademarks or
registered trademarks of their respective holders.






                T a b l e   o f   C o n t e n t s


Chapter 1  Introduction........................................1
              QUICK START......................................3
Chapter 2  Modem Setup.........................................8
Chapter 3  AceComm Start up/ Terminal Area....................12
              Pop Up Reference................................14
Chapter 4  PRM-data Menus Area................................16
              Area Controls / Options Menus...................17
              Memory Manager..................................19
              Internal Protocol Options.......................21
              Dialing Area Options............................23
              Terminal Area Options...........................25
              Serial Port Setup...............................27
              Port Select/Configure...........................28
              UART Line Control...............................30
              Modem Response Strings..........................34
              Modem Commands..................................36
              Modem Control...................................37
              Default Video Emulation.........................38
              Key Translation Sequence file (.KTS)............39
              Keyboard MACRO Assignments......................40
              Directories in Use Menu.........................44
              External Programs Setup.........................46
              Auto Engage Sequence Triggers...................49
              "Intelligent Auto Log On Technology" (Tm).......52
              Mass Menu Attribute Changes.....................55
              EMSI/IEMSI data.................................58
Chapter 5  INTERNAL / EXTERNAL PROTOCOLS......................63
              Internal, Defined-External Receiving Units......63
              Internal, External Sender Protocols.............68
Chapter 6  Telephone Directory Area...........................72
Chapter 7  File List/Utility Area.............................81
Chapter 8  Point Mail Functions...............................84
Chapter 9  Auto Answer Setups.................................88
Chapter 10 Event Schedules....................................89
Chapter 11 "Mondo Menus" (Tm).................................90
Chapter 12 Mouse Support......................................93
Chapter 13 ACECOMM DATA FILES.................................94
              ACE.PRM / .CTL..................................94
              KTS files.......................................95
              KBD files.......................................96
              REQ/FLO,LST,SCR,FON files.......................97
Chapter 14 AceComm Macro Language.............................99
Chapter 15 Macros list.......................................101



                T a b l e   o f   C o n t e n t s


              Local User Input (LUI) Functions...............101
              Character I/O Functions........................107
              Flags..........................................112
              File Functions.................................114
              Data Transfer functions........................116
              Modem/Dialing/Fon.Record.......................120
              Misc Functions.................................124
Chapter 16 MACRO Parameter Macros............................127
              Expandable PRM-data Macros.....................127
              Expandable Macro Functions.....................132
Chapter 17 Scripts...........................................133
              AutoScriptGen (Tm).............................134
              Conditionals, Labels, Gotos, Data Area.........137
Chapter 18 Whats New?........................................140
Chapter 19 WARRANTY..........................................142
Chapter 20 LICENSE...........................................143
Chapter 21 AceComm Registration..............................147
Chapter 22 Order Form........................................148

































Chapter 1  Introduction



What is AceComm?

AceComm is a communications program especially designed for today's high speed
modems.  AceComm provides a default setup that is ready to run with most Hayes
compatible modems. The AceComm package contains a modem install utility, that
will install most Hayes compatible modems into AceComm.

AceComm supports a macro driven keyboard which features complete key
redefinition.  AceComm's macro language provides the user a powerful interface
to the AceComm internal functions, as well as many computer services.

AceComm's terminal area provides a key driven and or menu driven interface.
With AceComm's key-redef and macro language, complete control over any complex
task is just a key press away.

AceComm supports user definable menus.  Menus that can be made to display and
offer user definable functions.  Menus that are available as popup menus at any
time from the terminal area.

AceComm supports an internal point mail system which uses the EMSI handshake
protocol.

A time (event) scheduler supports the point mail system and any other automated
process the user wants to define.  The scheduler is capable of beginning and
ending events as they come around on the clock.

An automatic script generating function can record complex on line sessions
to script files needing little to know editing.

Intelligent Auto Log On Technology (tm) is capable of automating log on.






AceComm Utilities

AceComm comes with several utilities for added support.  Utilities for modem
install, backing up the configuration files, creating unique keyboard
emulation, converting BBS lists and many other services that enhance and extend
the overall AceComm services.  Some of these utilities are considered as part
of the default setup, and will be present in the AceComm directory upon
install.  Other utilities will be placed into a sub directory of there own.  We
call these "Extra Utilities".




       Page 1              AceComm (tm) v 1.81


Chapter 1  Introduction


AceComm Extra Utilities

The Acecomm package comes with several support utilities which add to and
enhance the standard installation.  The utilities are located in a compressed
file named ACEUTIL. Here you will find a USBBS list to ACE.FON file converter
capable of converting the whole list or 1 area code. ANSI/AVATAR filter for
removing video control codes from a file outputting to another file. Custom
keyboard video emulation compiler can create keyboard emulation files from
ascii definition files (examples provided). AceComm's point mail system is
supported by several utilities that make interface AceComm to a FIDONET
NodeList. AceComm's NodeList handler is said to be the best and faster of all
programs offering point mail services.






































       Page 2              AceComm (tm) v 1.81


Chapter 1  Introduction

           QUICK START


QUICK START INSTRUCTIONS FOR AceComm & Utilities
Last revised 1/16/94

Distribution DISK

The AceComm package is distributed in a compressed format.  The compression
utility used with AceComm is the current version of LHA (this writing LHA213).
AceComm package and sub-packages are compressed as SelF eXtracting "SFX"
files.  This means the compressed file "ARCHIVE" uses an .EXE file extension.
This SFX format allows you the user to simply type the name of an archive.  The
archive's SFX code will execute, and extract the files to their un-compressed
form.

Electronic Distribution

Many BBS systems will store the distributed SFX file inside an archive envelope
of their default archive.  The AceComm BBS provides the AceComm package in ARJ
and ZIP format.  SFX files as described above are appropriately renamed and
contained inside the main package, as regular compressed files.




INSTALL.BAT

The easiest way to AceComm is to just run INSTALL.BAT.  The batch file will run
ACTL.EXE.  ACTL.EXE assembles ACE.CTL into ACE.PRM.  ACE.CTL is an ascii
control file that can be edited with any text editor or created later with the
PRM2CTL.EXE utility (included).  ACTL creates sub directories defined inside
ACE.CTL.  Directories defined in the default setup are CAP, FON, FILES, KTS,
SCR, and MAIL.  INSTALL.BAT copies FON files into FON, KTS files into KTS, DOC
files into a DOC sub directories.  INSTALL.BAT then runs ACE.EXE All setup data
can be configured from inside AceComm.  Install.bat will get you up and
running, you may need to set the com port to match that of your modem.




QUICK SETUP STEPS

If you down loaded AceComm
     go to    "Step 1 for Electronic distributed files"

Step  1  for Distribution DISK




       Page 3              AceComm (tm) v 1.81


Chapter 1  Introduction

           QUICK START (continued)

   - Un compress the AceComm package into it's own sub directory.
     This example assumes the filename ACE170.EXE

     ACE170 means version 1.70

     .EXE means AceComm is distributed as a SelF eXtracting
     archive (SFX)
                Example

        At the DOS prompt type:  md \ace
        At the DOS prompt type:  copy ACE170.EXE \ACE
        At the DOS prompt type:  cd \ace
        At the DOS prompt type:  ACE170

     The basic setup files will be ready in a sub directory ACE.  Other files
     that include SFX in the filename and end in .EXE file extension, are also
     SelF eXtracting archives.  These files are enhancements to the basic
     setup.



Step 1 for Electronic distributed files

     If you down loaded AceComm from a BBS the archive will be in another format
     such as ACE170.ARJ or ACE170.ZIP.  If this is the case you will need to
     use the compression utility that corresponds to the file extension to
     de-compress the AceComm package.

                Example for ACE170.ZIP

        At the DOS prompt type:  md \ace
        At the DOS prompt type:  copy ACE170.ZIP \ACE
        At the DOS prompt type:  cd \ace
        At the DOS prompt type:  PKUNZIP ACE170

     The basic setup files will be ready in a sub directory ACE.  Other
     archives files that included are enhancements to the basic setup.




Step 2
   - Read ACTL.DOC  (1 page)

   - Run ACTL.EXE (assemble ACE.CTL into ACE.PRM)




       Page 4              AceComm (tm) v 1.81


Chapter 1  Introduction

           QUICK START (continued)

                Example ACTL ace.ctl

   ACTL.EXE need only be run when creating a new PRM file is desired.  All
   PRM-data is configurational from within inside AceComm.

   Note: AceComm will invoke ACTL.EXE directly when no ACE.PRM file is found in
         the start up directory.


Step 3
   - Run ACE.EXE
        At the DOS prompt type:  ACE





OPTIONAL
Not required for QUICK START

After having become familiar with AceComm, you may decide to edit ACE.CTL for
some personal defaults.  This will allow future compilations to use your custom
setup instructions.  ACE.CTL can store personal and custom setup data for times
when a new ACE.PRM file is generated.  This will be most used when upgrading
AceComm versions.

A utility PRM2CTL.EXE is provided to clone your PRM file into an ascii control
file.  PRM2CTL will save your custom setup to a file that ACTL.EXE can later
use to build the custom PRM file back.  This is also the means used for
upgrading AceComm versions.



The following are enhancements to the AceComm package

a) FON_SFX.EXE (distributed)  FON.ZIP/ARJ (BBS)
   FON_SFX contains several sample .BBS, FON, and .NOD files.

   It is suggested that FON_SFX be un-compressed inside a sub directory to the
   AceComm directory

                Example: C:\ACE\FON

        At the DOS prompt type:  md \ace\fon
        At the DOS prompt type:  copy FON_SFX.EXE \ace\fon
        At the DOS prompt type:  cd \ace\fon



       Page 5              AceComm (tm) v 1.81


Chapter 1  Introduction

           QUICK START (continued)

        At the DOS prompt type:  FON_SFX
        At the DOS prompt type:  cd \ace

   NOTE: ACTL creates these directories if defined in ACE.CTL and
         not found.

b) KTS_SFX.EXE (Distributed)  KTS.ZIP/ARJ (BBS)
   KTS_SFX contains the KTS files included in the default setup, as well as the
   ascii versions.  Ascii version KTS files share the filename with KTS files,
   but use .ASC extension.

   It is suggested that KTS_SFX be un-compressed inside a sub directory to the
   AceComm directory

                Example: C:\ACE\KTS

        At the DOS prompt type:  md \ace\kts
        At the DOS prompt type:  copy KTS_SFX.EXE \ace\kts
        At the DOS prompt type:  cd \ace\kts
        At the DOS prompt type:  KTS_SFX
        At the DOS prompt type:  cd \ace

   (.KTS files are the Key Translation Sequence files for terminals) This file
   contains ascii versions of .KTS files.  ASC files are compiled into KTS
   files using KTS.EXE.


c) UTIL_SFX.EXE (Distributed)  UTIL.ZIP/ARJ (BBS)
   UTIL_SFX contains several utilities that enhance the AceComm package.  Each
   utility has it's .DOC file.

   It is suggested that UTIL_SFX be un-compressed inside a sub directory to the
   AceComm directory

                Example: C:\ACE\UTIL

        At the DOS prompt type:  md \ace\util
        At the DOS prompt type:  copy UTIL_SFX.EXE \ace\util
        At the DOS prompt type:  cd \ace\util
        At the DOS prompt type:  UTIL_SFX
        At the DOS prompt type:  cd \ace


   MDMI.EXE Modem install utility, installs modem setup data directly into
   ACE.PRM




       Page 6              AceComm (tm) v 1.81


Chapter 1  Introduction

           QUICK START (continued)


   CBF.EXE can compile direct FBL output into a FON file.


   UBF.EXE can compile the USBBS listing into a FON file.  UBF can optionally
   extract any area code from the USBBS listing.


   IDX.EXE creates a very small index file so that AceComm can use a RAW
   NODELIST file for mailer mode/file requests.


   FBL.EXE creates a .BBS and .NOD file from the raw nodelist for a given NET
   HOST


   KTS.EXE compiles a Key Translation Sequence file from ascii to binary
   format.


   ANSI.EXE filters ANSI and AVATAR video control sequence codes from files.
   ANSI.EXE can also be used to view the files.



























       Page 7              AceComm (tm) v 1.81


Chapter 2  Modem Setup



High Speed Modems

Modems with connect speeds of 9600 and above and offer data compression and or
error correction are capable of transferring data at much faster rates that the
ordinary 9600 baud modem.

Todays modems including v.32 and v.32bis and beyond are all capable of data
compression and offer data rates much faster than the 9600 connect speed.  To
make proper use of these Hi-Speed modems the user needs understand a little
about the modem.  Lets take a v.32bis modem as example.  V.32bis modems are
very common and the price rivals that of 2400 baud modems of a few years ago.
The V.32bis modem offers connect speeds up to 14400 and can transfer compressed
data using various built in compression protocols at rates averaging and beyond
1650 cps for pre compressed files, and 2000-3000+ with un-compressed files.


Locking the Port

It is necessary to use what is referred to as a "locked port" when operating a
14400 v32 bis modem.  A "locked port" refers to having the software (AceComm)
set the port at a rate faster than the highest possible connect speed, and then
leave the port speed alone.  Modems setup to use a "locked port" will make the
translation between connect speed and computer speed.  Here we refer to
"connect speed" as the speed at which the modem connects to the other modem,
and computer speed refers to the port setting.


Locked Ports and Flow Control

In order to support connect speeds of 14400, the modem needs be setup to use
flow control.  Flow control enables the modem to be connected to the remote
modem at a different speed than the computer-to-modem speed.  When modems
connect at 14400 we refer to the connect speed as modem-to-modem speed.  14400
is not a speed that the port (UART) can be set to.  Valid port speeds include
9600, 19200, 38400 and 57600.  To take advantage of 14400 connect speeds, the
port needs be set to at least 19200.  AceComm supports setting the port to
19200, 38400, 57600, or 115200 and locking it here.  This is referred to as
"Locking the port".  19200 is a preferable starting speed.  The faster you lock
your port, the faster your computer needs to be in combination with a buffered
(16550) UART.  An average 286/(386SX) 16 Mhz computer using a standard 16450
UART chip can run a 14400 modem with the port locked at 19200.  Replace the
16450 single byte buffer UART chip with a 16550 16 byte buffer chip and the
same computers can run the port at 38400.

When the port is set to 19200, the UART is setup to make data available to the
computer software (AceComm) at 19200 bits per second (BPS).  This allows



       Page 8              AceComm (tm) v 1.81


Chapter 2  Modem Setup

AceComm to fetch a character from the port at a faster rate than the modem can
theoretically make the character available.  Theoretically because with todays
data compression technology, Hi-Speed modem are capable of delivering text
files at rates well above the connect speed.

The faster you set your port, the more quickly the UART assembles a character
from the modem.  Thus faster port rates require faster computers and or
buffered (16550) UART chips.

This is why we recommend 19200 a good starting point.  You may be able to
download compressed files with the port locked at 38400, but an un-compressed
file will be assembled so much faster with the modem's own compression services
that errors may occur.  You may experience errors with un-compressed files, and
normally do fine with compressed (.ARJ,.ZIP etc).  At 19200 you will probably
be fine either way.  At 38400 and 56700 un-compressed data files can arrive
much faster than your computer _may_ be capable of responding to.




Modem Setup

Modem defaults may not always be ready for use with using a locked port rate.
Most factory defaults are ready to go work with flow control and locked port
rates.  The AceComm voice support line gets plenty of calls from users whose
modems are not configured properly.

Lets examine a Supra v32 bis modem.  The AT commands below will work with
almost all Hayes compatible v.32 / v.32bis modems.

The Supra modem can be set to a factory default which is suited to locked port
rates by issuing the commands AT&F2 <CR>.  The command "AT&F2" loads a factory
configuration for IBM compatible modems.  The "&F2" configuration is
appropriate for error correction and data compression with Supra modems.
Consult your modem manual for the proper &Fn param for your modem.





Generic Hayes Compatible Modem Setup


&C1      DCD indicates carrier from modem
&D2      Modem follows DTR signal
&K3      RTS/CTS hardware flow control
&Q5      Asynchronous reliable (error correction) mode




       Page 9              AceComm (tm) v 1.81


Chapter 2  Modem Setup

The above commands will work with most Hayes compatible modems.



Modem INIT Strings

Lets begin by making certain the modem is off hook and ready to receive an INIT
string.

           ATH0^M

The AT command "H0" brings the modem off hook.  Most modems need be off hook to
except AT commands.  "^M" is what AceComm translates into a <CR> character.

typing ATH1 <CR> from terminal mode puts the modem on hook. (busy)
typing ATH0 <CR> from terminal mode puts the modem off hook.

We may have the modem off hook (busy) for any number reasons.  It is a good
idea to begin our INIT string with ATH0^M and a small delay.  A small delay
gives the modem a chance to respond before we send another INIT string .  We
can create small delays in out INIT strings using ~ characters.  AceComm
creates a 1/4 second delay for each occurrence of ~ character.

ATH0^M~~~~ATE0M0&C1&D2&K3&Q6

AceComm will append INIT strings with the command terminator.  Normally <CR> or
as AceComm wants to see it ^M is the command terminator.  The above string
includes 1 embedded command terminator but leaves AceComm to append the final
<CR> to the end of the string.  The above modem INIT string is actually 2 init
strings chained together.  The above modem INIT string should make most Hayes
compatible modems ready to operate with FLOW control at a LOCKED port rate of
19200.


Saving to NV RAM

We do not need to include "&F2" in our init string every time.  It is likely
that other AT commands will be included in your modem init string.  M0 turns
the speaker off, certain tweaking to some of the S registers alters both
performance and connect response strings.  Custom modem configurations can be
saved to the modem using the "&W" command.  When this is done, the modem init
string can become simply ATZ <CR>.  Follows is our INIT string with &W tacked
on.

ATH0^M~~~~ATE0M0&C1&D2&K3&Q6&W

AceComm supports a SETUP field in the modem commands menu.  The setup field is
designed for modem command lines that are to be used occasionally, and



       Page 10              AceComm (tm) v 1.81


Chapter 2  Modem Setup

preferably to setup the modem with the "&W" AT command.  AT&F&W <CR> recalls
the factory default configuration and saves it to nonvolatile memory.  This
setup can then be recalled using ATZ <CR>.

NV RAM is not designed to be written to everyday.  You want to configure your
modem from time to time with &W and then use ATZ and whatever tweaks, as your
normal INIT string.  You can get by just fine by simply using the default INIT
string developed above, leaving off the &W command.  &W is for modem
configurations that require several lines of INIT strings.  &W is an AT command
you should know about, but may very well not ever need to use.



AceComm's Modem Install Utility

The AceComm package provides a modem install utility.  MDMI.EXE will display a
menu of modem brands along with the setup strings for each.  You may choose
your modem type from the list.  MDMI.EXE will write directly to the ACE.PRM
file (AceComm's binary configuration file).
































       Page 11              AceComm (tm) v 1.81


Chapter 3  AceComm Start up/ Terminal Area



AceComm can be started from the DOS prompt, from a batch file, inside
MS-Windows, DESQView, OS/2 etc.

AceComm locates itself on the drive, and locates the ACE.PRM file. Memory is
allocated for ACE.PRM. ACE.PRM is read into memory. the KBD file is overlays
onto ACE.PRM data. Multiple KBD files are supported, one KBD files is loaded
at any one time.

The ACE.PRM file may be located in the current directory or the directory that
ACE.EXE resides in.  AceComm is capable of running from a remote directory.
AceComm will find itself and include the path to itself for it's data files.
It is recommended that all of the AceComm files be kept in the same directory
and sub directories.

Upon reading the ACE.PRM file into memory, a CRC check is made to validate
certain data, an ID byte is checked for version compatibility.  Finally the size
is checked to make sure all data is available.  AceComm will display an
appropriate error message upon failure in any of these checks.

AceComm reads in the current .KBD (keyboard definition) file.  Default
.KBD file is ACE_DEF.KBD. KBD files contain all macro assigns and total
keyboard setup. Not to be confused with KTS files. KTS files store keyboard
translation sequence definitions (keyboard terminal emulation) and are
associated with the current video type.

AceComm reads the current associated KTS file at program start.

AceComm installs onto the serial port defined inside the aCE.PRM data, and
initializes the modem. The user is now in the terminal area. An optional flag
located inside PRM-data Options(Terminal-Options) menu will have Acecomm
report directly into the Telephone List Area. Default is to remain in the
Terminal Area.


















       Page 12              AceComm (tm) v 1.81


Chapter 3  AceComm Start up/ Terminal Area



----------------------------------------------------------------



OK


...


 AceComm  2,19200L,7E1  Av/An  08:06:48am  ALT-V =Key Ref,
----------------------------------------------------------------

AceComm begins presenting to the user it's TERMINAL Area screen.  TERMINAL is
the area in which all other areas are accessible, and where serial I/O takes
place for the user.  Above is a sample of the AceComm TERMINAL screen upon
start up.  A status line is present, when it's flag is SET(default).  If on
line, the 'AceComm' would be replaced with 'CARRIER, and other information
particular to the current setup, and host.  Note the 'L' after baud(19200)
indicates LOCK BAUD is SET.  'AV/AN' indicates the current active VIDEO
EMULATION.

Hold down the ALT key for a Pop Up Reference to key-combos available from the
TERMINAL area.  Releasing the ALT key and the POP-UP REFERENCE disappears.  The
Pop Up Reference menu is called using the <ViewKeyCombos_> MACRO.  ALT-V is
assigned the <ViewKeyCombos_> MACRO in AceComm's default keyboard setup
ACE_DEF.KBD file.  The default Keyboard is completely re definable by
re-defining the KEY-COMBO a different MACRO(S) (see below)





















       Page 13              AceComm (tm) v 1.81


Chapter 3  AceComm Start up/ Terminal Area

           Pop Up Reference


(TERMINAL screen below with POP UP REFERENCE)


KBD Macro Assignments, current file: ACE_DEF.KBD
>ALT-A <AutoScrGen_>
 ALT-B <BackBuffer_>
 ALT-C <CaptureFile_>
 ALT-D <FonListDialer_>
 ALT-E <SendStr> ATE^M <HostEcho>
 ALT-F <FileLister_>[DIR_DNLDS]
 ALT-G <FileRequest_>
 ALT-H <MdmHangUp_>
 ALT-I
 ALT-J <CommandShell_>
 ALT-K
 ALT-L <RunProg> list
 ALT-M <SendStr>ath1^M <ChgDir>mail\ged <RunProg>GOLDED <ChgDir>[DIR_START]
 ALT-N <ChgDir>c:\mail\qm <RunProg>QM toss <ChgDir>[DIR_START]
 ALT-O <PrmDataMenus_>
 ALT-P <PrmDataMenus_>
 ALT-Q
 ALT-R <RunScript_>
 ALT-S <ScrnSnapshot_>
 ALT-T <ScrnTag_>
(PgDn) Display  Template  Quit  Help <>v^

o The AceComm keyboard is macro driven

o The Popup Reference displays each key press that has been assigned to a
  MACRO, or MACROS.

o Current .KBD file is displayed, AceComm supports unlimited .KBD files.
  Current .KBD filename is always displayed at the right side of the Terminal
  Area's status line.

AceComm's Keyboard is re definable.  Each key press can be re assigned a
different function, or set of functions.  To accomplish keyboard re definition,
AceComm uses descriptive text symbols called MACROS.  MACROS are enclosed
inside of angled brackets.

The Pop Up Reference menu displays the current .KBD file's MACRO(S)
assignments.  A .KBD file contains a copy of all key-press MACRO(S)
assignments.  AceComm supports unlimited .KBD files.  Each key press
combination can be assigned a MACRO(S).  AceComm allows the user to re define
the keyboard functions if so desired.  AceComm provides a rich set of MACRO



       Page 14              AceComm (tm) v 1.81


Chapter 3  AceComm Start up/ Terminal Area

           Pop Up Reference (continued)

functions for all of AceComm's internal functions.  A complete MACRO list with
descriptions is contained in the MACRO.DOC file.

- PgDn or <CR> will display the next key set at top of screen.

- Display toggles the display from a text description and the actual macro
  assignments

  The key press is displayed to the left, with it's MACRO assignment to the
  right.  The example below shows the MACRO for AceComm's configurations area
  is assigned to ALT-P.

     ALT-P <PrmDataMenus_>              <= MACRO assign
     ALT-P Configuration Area           <= descriptive text

- Template allows you to print a list of keys that have MACRO assignments.  The
  default filename is "PRN".  You may find it handy to print to a FILE,
  (key.prn) or similar, this way you can format the TEMPLATE, for a more custom
  print job.






























       Page 15              AceComm (tm) v 1.81


Chapter 4  PRM-data Menus Area



D:\ACE\ACE.PRMĿ
PRM-data   Sub-Menu Areas ĳ
>Area controls / Options menus      
 Serial Port/Modem Setup            
 KeyBoarD Macro Assignments         
 Directories in Use Menu            
 External Programs Setup            
 Auto Engage Sequence Triggers      
 Intelligent Auto Log On Technology 
 Paint Screens - Video Controls     
 EMSI handshake data                
 Point Mail Setup                   
 AutoAnswer Mode Setup              
 Event Schedules                    
 AutoSave is ON                     
 Select  Quit  Help <>v^ٰ



o MACRO for this menu is: <PrmDataMenus_> (default assignment is to both ALT
  O & ALT P)

o All PRM-data changes are auto-saved when Auto-Save flag is "ON" (default)

o Each sub-menu contains context sensitive HELP

Virtually any data contained inside the ACE.PRM file is accessible and
configurational from the PRM-data area.  Above is the menu you will see after
pressing key-combo <PrmDataMenus_> is assigned to from the TERMINAL area.

Note: If you toggle "AutoSave" to Off, you will select the "Save Changes"
      option before exiting AceComm, if you want the toggled option to remain
      toggled.  Otherwise, AceComm will be back to "AutoSave" when re-started.
















       Page 16              AceComm (tm) v 1.81


Chapter 4  PRM-data Menus Area

           Area Controls / Options Menus



Area controls / Options menusĿ
 Telephone book on start up               No   
 Allow enhanced keyboard detection        Yes  
 Allow mouse detection                    Yes  
 Mouse horizontal sensitivity             6    
 Mouse vertical sensitivity               4    
 Auto Save Changes                        On   
 Screen Saver timeout value (minutes)     4    
 Keep Log file                            On   
 All Sounds Override Switch <> Sounds are On   
 Ignore DCD on INIT & Dial                No   
Sub Menusĳ
 Control Memory Use                            
>Internal Protocol Options                     
 Dialing Options                               
 Terminal Area Options                         
 Edit  Quit  Help <>v^ٰ


o The controls are enable/disable flags, some of which can also contain a value
  for timers.

o Sub menus contain more categorized controls


Most controls are a series of flags which tell AceComm when to use some of the
features, and when not to.  Flags with the ON/OFF status are toggles, and will
be toggled here in this menu.

Notice the "Screen Saver" flag description contains the number 5,
rather than an ON/OFF.  Selecting Screen Saver mode 0 = OFF.


Allow enhanced keyboard detection        Yes

  AceComm will detect and use enhanced BIOS keyboard functions.  Some systems
  may not fully support this mode properly.  This flag allows locking out
  AceComm's use of enhanced BIOS keyboard functions.


Allow mouse detection                    Yes

  Setting this to "NO" will cause AceComm to act as if a mouse is non existent,
  the mouse driver is never initialized, no mouse menu is presented in the



       Page 17              AceComm (tm) v 1.81


Chapter 4  PRM-data Menus Area

           Area Controls / Options Menus (continued)

  Terminal Area.


Mouse horizontal sensitivity             6

  Mouse sensitivity is already set in the mouse driver.  This value is internal
  to AceComm only


Mouse vertical sensitivity               4

  Mouse sensitivity is already set in the mouse driver.  This value is internal
  to AceComm only


Auto Save Changes                        On

  When "ON" AceComm will save PRM-data changes to the ACE.PRM file.  When "OFF"
  the prompt inside the main PRM-data menu must be selected for PRM-data
  changes to be recorded to file.  This pertains to actual PRM-data below the
  menu system data.  Menu area attributes are ALWAYS SAVED, with exception to
  "Mass Menu Area" changes, these must be affected using the appropriate
  selection from inside "Mass Menu".


Screen Saver timeout value (minutes)     5

  Screen Blanking function.  Screen Saver can be set from 0 - 10.  Values above
  0 are minutes without a key press to AceComm blanking the screen.  Screen is
  restored with a key press.  Un-blank-key-press is valid.  Use ALT alone for
  non-destructive key press to un-blank the screen.

  See also "Screen Saver if Data Carrier Detect" from Terminal Area Options
  menu.


Keep Log file                            On

  Toggle AceComm use logging ON/OFF.


All Sounds Override Switch <> Sounds are Off

  Toggle, enable/disable all sounds. Master override.





       Page 18              AceComm (tm) v 1.81


Chapter 4  PRM-data Menus Area

           Memory Manager




D:\ACE\ACE.PRMͻ
General Controls/Menusͻ
                                               
                                               
                                               
Control Memory Useͻ   
>XMS (kb) ok to use           64             
 Scroll Back (kb) to use      64             
 Swap for <RunProgram>        On             
 Swap for <CommandShell_>     On             
Current Memory Useͺ   
 XMS allocated                65536       ͺ
 XMS free at load             2424832        
Ⱥ ACE.EXE load                 227040         
 Scroll Back allocated        65536          
 PRM file  allocated          36025          
Ⱥ Rx buffer allocated          8192        ͼ
 Tx buffer allocated          256         
 Select  Quit  Help <>v^ͼ



o With version 1.7, AceComm begins managing memory usage.

o AceComm can swap the scroll back buffer memory to XMS prior to allocating
  large chunks of memory for other operations.

o EMS will be supported in the next release.

o XMS and EMS are supported for the SWAP functions.


XMS (kb) ok to use

  AceComm's internal memory manager can save overall memory requirements by
  swapping some internal data to XMS memory when about to perform another
  memory hungary task.


Scroll Back (kb) to use

  Up to 64 kb (64 x 1024) memory can be used for the back buffer.  Future
  versions of AceComm will begin allowing multiple 64 kb memory be used for



       Page 19              AceComm (tm) v 1.81


Chapter 4  PRM-data Menus Area

           Memory Manager (continued)

  scroll back buffer.  The first 64 kb memory is conventional memory.


Swap for <RunProgram>                    On

  XMS, EMS, DISK swapping for the AceComm executable will take place when this
  flag is set "ON".  When SWAPPING is active, AceComm 's SIO is deactivated
  while <RunProgram> MACRO is active.

  Notes: AceComm is currently using Ralf Brown's SWAP functions for the SWAP
         service.  SWAP is the only code inside AceComm executable that is not
         written entirely by MGP Programming Services.  SWAP has proven to be
         the most dependable code of this type that has been tested in our
         executable files.  MGP Software would like to thank Ralf Brown for
         permission to use his SWAP code in our products.


Swap for <CommandShell_>              On

  XMS, EMS, DISK swapping for the AceComm executable will take place when this
  flag is set "ON".  When SWAPPING is active, AceComm 's SIO is deactivated
  while <CommandShell_> MACRO is active.

  Notes: The Notes for <RunProgram> apply to this MACRO

























       Page 20              AceComm (tm) v 1.81


Chapter 4  PRM-data Menus Area

           Internal Protocol Options




Internal Protocol OptionsĿ
>Auto Engage                       Yes    
 File Rename                       Yes    
 File Resume                       Yes    
 Bell after internal protocol      3      
 Time release from protocol        No     
 Select  Quit  Help <>v^ٰ


Auto Engage                              Yes

  Activate/deactivate Auto engage sequence triggers & Associated AutoM
  MACROS.  (enable/disable auto downloads) Does not affect auto log on.


File Rename                              Yes

  For internal Zmodem.  Rename "Yes" existing files when last modification
  time/date don't match.  AceComm will create a new filename.  When file times
  don't match, we can assume that although the filenames are the same, they
  were created at different times, and probably contain different data.

  Example:
          The file "114-35.QWK" exists in our receive directory.  The incoming
          filename is "114-35.QWK" also.  AceComm's internal zmodem will then
          compare file times and if they match, it is safely these files are
          the same and a file size check is done to see if we can resume the
          download.

          If the file times don't match, AceComm's internal zmodem will try and
          create a filename "114-35.QW0", if this filename exists, "114-35.QW1"
          etc.  Thus we can have several *same* filenames in our receive
          directory without overwriting them.
  Example:
          You download the "allfiles.lst" from the same BBS every week.  The
          filename is always the same, the file times differ.  AceComm will
          name duplicates names as "allfiles.lst", "allfiles.ls0",
          "allfiles.ls1" etc.


File Resume                              Yes

  For internal Zmodem.  Resume "Yes" existing files, data is appended to the



       Page 21              AceComm (tm) v 1.81


Chapter 4  PRM-data Menus Area

           Internal Protocol Options (continued)

  file, "OFF", the file is created new, any existing file of the same name is
  over written.  *If* the file modification time matched.  Otherwise with File
  Rename function would have created it's unique filename.  In the event the
  file sizes are same, the file is skipped when the resume flag is set to yes.

  Example:
          You started down loading a file and were interrupted for some reason
          aborting the download.  You log back on at a later time, and using
          Acecomm's internal zmodem begin to download the file once again.
          AceComm's internal zmodem will see if the file times match, and
          considers the to be the same file.  Internal zmodem will tell the
          host zmodem to begin sending from the position where the file was
          aborted from.  The file can be "Resumed", thus saving the time
          involved in down loading the entire file all over again.


Ring bell after internal protocol        3

  Internal protocols will sound an alarm before returning to Terminal Area.  A
  value of "0" disables any sound after internal protocols.  A value of "1"
  plays a Victory tune.  Values from 2-30 become seconds to sound the internal
  bell.  See also <RingBell> 5 MACRO


Time release from protocol               No

  Time slices for Windows/ OS/2, DV, and DOS are supported.  This flag applies
  to the DV and DOS time releases.  Releasing time to Windows/ OS/2 using the
  interrupt 2fh function causes so many missed interrupts that AceComm never
  releases int 2fh time slices during an internal protocol function.  Time
  slices are otherwise given up generously.


















       Page 22              AceComm (tm) v 1.81


Chapter 4  PRM-data Menus Area

           Dialing Area Options



Dialing OptionsĿ00
>Inter byte delay                         1    
 Modem Response Timeout when dialing      60   
 Seconds between re-dial                  1    
 DTR state between re-dial                Off  
 Ring BELL on Dial/Connect                1    
 Re-dials in mail mode                    64   
 Select  Quit  Help <>v^


Inter Byte Delay                         1

  Add (value x 55 millisecond) delay between modem command characters.  With a
  value of '0' modem command strings are sent just as fast as the UART's
  Transmit Hold Register is Empty (THRE).  (I've observed Supra modems behave
  much better using a value of 1 for inter byte delay when in continuous
  re-dial)


Modem Response Timeout when dialing      60

  Master timeout when dialing.  Overrides your modem's own S7 register.

  Notes: It may be best to set this value several seconds above your modem's S7
         register.


Seconds between re dials                 1

  AceComm will pause this many seconds between receiving a modem response
  string, or timing out, and sending the next dial string to the modem.  The
  variable can be toggled from 0 seconds to 90 seconds.


Ring BELL on Dial/Connect                1

  Seconds to ring BELL on successful detection of either DCD or a connect
  message response from the modem.


Re-dials in mail mode                    64

   Number of re-dials before giving up to terminal mode.  A mail schedule will
   go back into the dialer every few minutes anyway.  If the scheduled mail



       Page 23              AceComm (tm) v 1.81


Chapter 4  PRM-data Menus Area

           Dialing Area Options (continued)

   event ends, re-dial continues for this setting times.
















































       Page 24              AceComm (tm) v 1.81


Chapter 4  PRM-data Menus Area

           Terminal Area Options



      Terminal Area Optionsͻ
      >Status line                              On     
       Mouse menu                               Yes    
       Screen Saver if Data Carrier Detect      No     
       Terminal Area screen color (TTY mode)    7      
       Drop DTR when quitting ACECOMM           No     
       Log modem response while off line        Yes    
       Strip high bit from incoming             Off    
       Default Video Emulation                  Av/An  
       Edit  Quit  Help <>v^ͼ

Status line                              On

  Toggle AceComm 's STATUS LINE On/Off

  Notes: AutoScrGen (Tm) will assert the STATUS LINE, and restore it on when
         through.  The RunScript function will do the same.


Mouse Menu                              Yes

  Display 1 line mouse menu on Terminal Area screen


Screen Saver if Data Carrier Detect      No

  Screen Blanking service disabled during modem status DCD bit detected to be
  ASSERTED.


Terminal Area screen color (TTY mode)    7

  This setting allows changing the Terminal Screen color that is initially
  active when AceComm is started.  The color will remain constant through TTY
  video emulation.


Drop DTR when quitting AceComm            No
  AceComm will or will not drop DTR when the <EndACECOMM> [n] MACRO is run.
  Most modems will by default, drop carrier along with a drop in DTR.  DTR is a
  bit in the modem control register of the UART.  Setting this to "YES" will
  cause AceComm to drop DTR when ever <EndACECOMM> [n] MACRO is executed.





       Page 25              AceComm (tm) v 1.81


Chapter 4  PRM-data Menus Area

           Terminal Area Options (continued)

Log modem response while off line        No

  AceComm can log modem response strings that come in.  This flag will tells
  AceComm if it should log the responses.  This is for off line only.  This
  flag is most use full when you want to know when your phone rings, AceComm
  will TIME STAMP PRM-data Area MDM_RESPONSE_RING responses strings.  Many
  modem ROMS are now featuring caller ID.  Modems that have caller ID ability
  will be able to present to the terminal screen the caller ID info, if
  available.  This information will also be logged along with the TIME STAMPED
  "RING".


Strip high bit from incoming             Off

  "Off" data received from the modem is un altered.  "ON" data is stripped of
  any bits above the decimal value 128.


Default Video Emulation                  Av/An

  This selection brings up another menu.  The menu displays the available video
  terminal emulation modes.  Along with their associated KTS files.  This
  setting affects the default video terminal setting for AceComm.  Individual
  FON RECORDS contain their own video terminal settings.

























       Page 26              AceComm (tm) v 1.81


Chapter 4  PRM-data Menus Area

           Serial Port Setup




Serial Port/Modem SetupĿ
 Port Number Select      2            
 Line Control Setup      19200L,8N1   
 Modem Response Strings               
>Modem Command Strings                
 Modem Control Setup                  
 Select  Quit <>v^ٰ



o The "Serial Port Setup Menu" contains sub-menus for all of AceComm's serial
  port and serial port related configurations.

o Information presented to the right of menu selections are current settings.
  The 'L' appended to BAUD indicates LOCK BAUD is SET "ON".  If you run a
  Hi-Speed modem, then you will be leaving LOCKBAUD set "ON".






























       Page 27              AceComm (tm) v 1.81


Chapter 4  PRM-data Menus Area

           Port Select/Configure




Ŀ
 PRM-data   Sub-Menu Areas ĳ
 Port          Address IRQ   Detected Ŀ
ڳ>1             03F8h    4      Yes           
 2             02F8h    3   In use           
 3             03E8h    4       No           
 4             02E8h    3       No           
 5             0230h    4       No           
 6             0238h    4       No           
 7             0240h    4       No           
  8             0248h    4       No           
  Other stuff ĳ
  RBuf          8192                          
  TBuf          256                           
  FIFO trigger  8                             
ĳ TX            Off                           
 CTS/RTS       On                            
 XON/XOFF      On                            
 Install  Edit  Quit  Help <>v^ٰ


Port numbers are merely symbolic for identification.  Port addresses and the
Interrupt ReQuest line for the address is configurational.

      Install option, AceComm will close the active port and install it's SIO
  on the port selected.  MDM_INIT string is sent to modem.

      Edit option, you will be prompted for port address and IRQ.  Address is a
  HEX number.  Entering a decimal value will fail.

      Rbuf/Tbuf are the buffer size used for serial I/O.  Normally there won't
  be any advantage to raising the TBuf size.  RBuf size will be adequate at
  about 1024 bytes for all normal use.  The larger value (default) will allow
  storage of incoming during Back buffer, Tagger etc.  RBuf range is from 1k to
  32k, TBuf 128 bytes to 32k.  The Zmodem sending unit's window size is equal
  to TBuf size.  Window size is not data-frame size.  Window size means "how
  much data do we let build up into the TX buffer at any one time.  RBuf/TBuf
  can be changed at any time, on line or not.  It is recommended that the HOST
  be still when re-sizing RBuf/TBuf.  RBuf/TBuf changes take immediate affect.

      FIFO trigger is the number of bytes buffered before a First In First Out
  UART chip will alert the CPU by way of interrupt.  FIFO UART operation is
  automatically enabled when a FIFO UART is detected.  AceComm always checks
  for FIFO UART presence whenever installing onto a PORT.  FIFO trigger level



       Page 28              AceComm (tm) v 1.81


Chapter 4  PRM-data Menus Area

           Port Select/Configure (continued)

  changes take immediate affect.  Trigger level of "1" affectively disables the
  FIFO affect.  The setting for "8" will give the best performance under
  multi taskers.

      TX is a flag that tells AceComm to use interrupt driven output.
  Interrupt driven input is always on.  The TX toggle takes immediate affect.
  If you FAST computer/modem setup is capable of overwhelming the other end
  when sending data, toggling TX "OFF" may improve the situation.

      CTS/RTS hardware handshaking / FLOW control Hardware handshaking may
  normally be left ON (default).  High speed modems using fast data rates and
  typically locked port rates will require software to use FLOW control.

      XON/XOFF software handshaking / FLOW control Many HOST software will
  recognize XON/XOFF FLOW control.  You may need software handshaking enabled
  for proper FLOW control while performing ascii uploads.

      Notes: AceComm uses FLOW control flags (above) primarily to detect when
             not to send data to the modem.

             AceComm will automatically use both forms of FLOW control when it
             detects the receive buffer getting full.



























       Page 29              AceComm (tm) v 1.81


Chapter 4  PRM-data Menus Area

           UART Line Control


     Serial Port Setup Menu ͻ
     Port Number Select      1            
     UART Line Control ͻ 
    >Data Bits          8               
     Parity             None            
     Stop Bits          1               
     Max/Lock Baud Rate 19200           
     Lockbaud           On              
     Select  Quit  Help ͼͼ


The UART's line control register can be set for several different data
arrangements.  Most common being 8 data bits, no parity bit, 1 stop bit.  Most
BBS systems will use the 8N1 configuration.  The UART uses the line control
information when assembling incoming bits into a byte.  Setting this
information from the PRM-data area, the format is stored in the default
settings for AceComm to use.  When you look at the FON directory records you
will see that each record stores it's personal line control setting to be used
when dialing the record.  Data format is saved with each individual record in
the record's .FON file.  When using AceComm in HOST mode the default setting
will be used.  AceComm retains the default line control register setting in the
ACE.PRM file.  FON record line control settings are stored in their respective
.FON files.

BAUD rate is also something that will normally be attached to a FON record and
used when dialing the record.  This is of more concern to users of modems that
do not allow LOCKING the port.

LOCK BAUD is almost always available as an option when using a modem that can
support CONNECT rates above 2400 baud.  When using the LOCK BAUD option,
AceComm will leave the port speed alone when dialing.  The modem handles speed
translation between 'connect' and 'computer'.  LOCK BAUD ON is generally
preferable with modems that support it.  The status displays will reflect 'L'
appended to the baud rate when LOCK BAUD is set ON.  NOTE: the 'L' is not
appended in the Line Control Window's display above.













       Page 30              AceComm (tm) v 1.81


Chapter 4  PRM-data Menus Area

           UART Line Control (continued)



     Serial Port Setup Menu ͻ
     Port Number Select      1            
     UART Line Control ͻ 
     Data Bits ͻ
    >5                                 
     6                                 
     7                                 
     8                                 
     Select  Quit ͼ
     Serial Port Setup Menu ͻ
     Port Number Select      1            
     UART Line Control ͻ 
     Data Bits          8               
     Parity ͻ
    >None                              
     Odd                               
     Even                              
    Ⱥ Mark                              
       Space                             
       Select  Quit ͼ
     Serial Port Setup Menu ͻ
     Port Number Select      1            
     UART Line Control ͻ 
     Data Bits          8               
     Parity             None            
     Stop Bits ͻ
    >1                                 
     2                                 
     Select  Quit ͼ

Data Format

  Stop bits, Parity, Data bits.  Each character that comes in the serial port
  arrives as a series of BITS.  The BITS are assembled in your serial port's
  UART's SERIAL DATA UNIT SDU).

  AceComm's default setting of 8 data bits, no parity, and 1 stop bit is the
  most popular arrangement, and that which most BBS systems use.  You will
  change the Data Format when necessary for connecting with systems that don't
  use the standard 8N1.







       Page 31              AceComm (tm) v 1.81


Chapter 4  PRM-data Menus Area

           UART Line Control (continued)




Ŀ
 PRM-data   Sub-Menu Areas ĳ
 Area controls / Options menus        
Serial Port/Modem SetupĿ
 Port Number Select      2            
UART Line ControlĿ 
 Data Bits          8               
 Parity             None            
Baud SelectĿ           
>300                             ٰ
  1200                            
  2400                  ^ٳ
 A 4800                             
 E 9600                             
 A 19200                            
ĳ 38400                 ^ٰ
 57600                 
 115200                
 Select  Quit  Help ٰ



o Connect speeds such as 12000, 14400 etc.  are not actual data rates that the
  UART (serial port) can be set to.

o Modems capable of connecting at 9600 and above can usually be used with a
  "Locked port"

o Setting the Baud rate to 19200 for a 9600 baud modem will allow better
  performance when down loading data.

o Locking the port means selecting a baud rate higher than the highest connect
  speed the modem is capable of, and telling the communications software to
  lock it there.

o Using a locked port requires your modem be in full handshake mode.


   "14.4k, 16.8k modems"

  Q.) Why doesn't AceComm support my 14.4k modems connect speed of 14400 in
      the "Baud Select" menu?




       Page 32              AceComm (tm) v 1.81


Chapter 4  PRM-data Menus Area

           UART Line Control (continued)

  A.) 14400 is a data rate your modem is capable of.  The serial port in your
      computer cannot be set to 14400 baud.  In order to operate at 14400
      connect speeds, the serial port must be set to 19200, 38400, or 57600
      baud.

      o 14400 is your modems "Connection Rate" "Line Speed", "Modem-to-Modem
         Speed", "DCE Speed" are other synonyms for "Connection Rate"

      o 19200 is the closest "Computer Rate"

      o Selecting the closest "Computer Rate" is called using a "Locked" port

        When using a "Locked" port your modem makes the translation between
        "Connection Rate" and "Computer Rate" by using FLOW control (RTS/CTS
        hardware handshaking) Your serial port can be set to 19200, or 38400
        and left there (See LOCKBAUD)



"Selecting your highest port speed when LOCKing the port"

  Locking the port at 57600 with a high speed modem causes the UART to assemble
  a character off the bit stream VERY quickly.

  If you experience serial input errors with HIGH locked rates, drop down to
  38400 or even 19200.  The lower rate will cause the UART to make characters
  available at a reduced speed.  For instance a 12 MHZ AT will probably
  experience data overruns using a locked port above 19200 when down loading
  TEXT files with ZMODEM.

  A common miss-conception is when CRC errors occur with HIGH LOCKED PORT
  rates, that it is the UART unable to keep up.  This is simply not true.  The
  UART/modem combo is capable of out running the computer/software combo.  When
  using a TASK switcher such as WINDOWS or DESQVIEW, a lower PORT RATE such as
  19200 may very well be needed for efficient data transfers.

  The idea is to set the port to a speed that the computer/software combo is
  capable of responding to quickly enough.











       Page 33              AceComm (tm) v 1.81


Chapter 4  PRM-data Menus Area

           Modem Response Strings




Ŀ
 PRM-data   Sub-Menu Areas ĳ
 Area controls / Options menus        
Serial Port/Modem SetupĿ
 Port Number Select      2            
Modem Response StringsĿ
 OK              OK^M                
 RING            RING^M              
 NO_CARRIER      NO CARRIER          
 ERROR           ERROR               
  NO_DIAL_TONE    NO DIAL TONE        
  BUSY            BUSY                
  NO_ANSWER       NO ANSWER           
  RINGING         RINGING^M           
  VOICE           VOICE               
ĳ Connect 1       CONNECT             
>Connect 2       CARRIER             
 Connect 3       FAX                 
 Edit  Quit  Help <>v^ٰ



o AceComm uses text response strings only

o Connect strings will allow non-locked ports "auto adjust" AceComm leaves
   locked ports set to the selected LOCKBAUD rate.

Modem response strings are normally UPPER CASE.  Response strings are used by
AceComm when dialing to more quickly respond to BUSY, NO CARRIER etc.  HOSTMODE
will be waiting for a RING code.(1) The Response strings that can be matched
while dialing are displayed in the DIAL WINDOW as they come in.

AceComm will detect a connection after dialing, a few seconds quicker when able
to match a connect string with the modem's connect message.

High Speed modem users may configure the modem for more than 1 connect message
to be returned from the modem.  AceComm need only detect 1.  The connect string
fields are freely configurational, and follow no specific order.  Leave them,
or edit them as needed any way you see fit.

AceComm will fall out of re-dial on detection of carrier anyway.  For the LOCK
BAUD users, this detection is right away.  For those who use modems that don't
allow port LOCKING, and want auto baud rate adjustment to match the connect,



       Page 34              AceComm (tm) v 1.81


Chapter 4  PRM-data Menus Area

           Modem Response Strings (continued)

carrier is checked only after the dialing has timed out.  AceComm will be
trying it's best to get a CONNECT string so that the connect speed can be
checked.


(1) HOSTMODE also uses the UART's modem status register RI bit when detecting
     "RING".










































       Page 35              AceComm (tm) v 1.81


Chapter 4  PRM-data Menus Area

           Modem Commands




Ŀ
 PRM-data   Sub-Menu Areas ĳ
 Area controls / Options menus        
Serial Port/Modem SetupĿ
 Port Number Select      2            
Modem Command StringsĿ
>Setup              ATH0^M~~~~AT&F2^M~~~~ATE0&W0            
 Init               ATZ^M~~~~ATE0&C1&D2                     
 Dial Prefix        ATEQ0X4DT                               
 Dial Suffix                                                 
 Answer             ATA                                     
 Hangup             +++~~~~~ATH0                            
 Offhook            ATH1                                    
 Abort              ^M                                      
 Reset              ATZ                                     
 Command Echo       ATE1                                    
 Host Init          ATE                                     
 Cmd Enter          ^M                                      
 Edit  Select  Quit  Help <>v^ٰ



o Cmd Terminator is automatically appended to modem command strings.

Here we have the modem commands AceComm uses to interact with your modem.
Please note the bottom of the menu contains the "Cmd Terminator".  AceComm
appends this to all modem commands automatically.  Notice that "Init" has a ^M
followed by ~~~~ and another command.  This is an example of command stacking.

'^' is an escape character AceComm recognizes and translates byte following
into control characters.  ^M translates into a carriage return, <CR>, (13d).  A
character following '^' is either upper case or made upper case by AceComm,
then subtracted by 64 converting 'A' to 1 etc.

'~' translate into 1/4 second delays.

AceComm modem command lines are limited to 40 characters in length, including
the Cmd Terminator.  This is a standard maximum command length used by modem
manufacturers.







       Page 36              AceComm (tm) v 1.81


Chapter 4  PRM-data Menus Area

           Modem Control


   ACE.PRM Data  Edit-Menusͻ
    General Controls                       
    Serial Port Setup Menu ͻ
    Port Number Select      1            
    Line Control Setup      19200L,8N1   
    Modem Connect Strings                
    Modem Response Strings               
    Modem Command Strings                
    Modem Controlͻ 
   >DTR      On                        
   Ⱥ RTS      On                       ͼ
      GPO1     Off                      
      GPO2     On                       
      Loopback Off                      
     Modem Statusͺ
      CTS      On                       
      DSR      On                       
      RI       Off                      
      DCD      Off                      
      Select  Quit ͼ

Modem Control

o GPO2 must be set "ON" for interrupt to seen by the computer

o Normal operation requires LOOPBACK be left "OFF"

These controls are available for experienced users.  The "Modem Control" menu
will allow setting or re-setting each of the bits listed.  If you want
interrupts to continue to be recognized you shall make sure and leave GPO2
"ON".  GPO2 "OFF" will disable interrupts for the port, and AceComm will not
function properly.  Same with Loop back.  If in doubt, you can use the above
snapshot as a reference to correct bit setting of the modem control register.


Modem Status

o DSR will normally be SET when a modem is powered up.  AceComm will alert the
   user on DSR not SET when installing on a port.









       Page 37              AceComm (tm) v 1.81


Chapter 4  PRM-data Menus Area

           Default Video Emulation


   ACE.PRM Data  Edit-Menusͻ
    General Controls                       
    Serial Port Setup Menu ͻ
    Port Number Select      1            
    Line Control Setup      19200L,8N1   
    Modem Connect Strings                
    Modem Response Strings               
    Modem Command Strings                
    Modem Control Setup                  
   Default Video Emulationͻ
   ȺVideo Emulation  <>  Associated KTS fileͺ
      TTY                   TTY.KTS                      
      Ansi                  ANSI.KTS                     
     >Avatar                AVATAR.KTS                   
      VT102                 VT102.KTS                    
      New_Vid  Asso_KTS  Quit  View_Cur_KTS ͼ

o Video Terminal emulation is built into AceComm

o Associated KTS file is the Keyboard Translation Sequence file that will be
  loaded for the given Video Type.

o Keyboard Terminal emulation is defined inside of *.KTS files AceComm includes
  a separate utility KTS.EXE which allows the user to define KTS files for any
  Keyboard Terminal emulation desired.

AceComm emulates the selected VIDEO type.  "Associated KTS file" is the .KTS
file you want to use with the VIDEO selection.  Each time AceComm activates a
VIDEO type, the associated KTS file is loaded and becomes active on the
keyboard.  KTS keyboard definitions override MACRO assignments.

KTS (Key Translation Sequence) files contain assignments for a sequence of
characters to a key press.  When a key is pressed from inside TERMINAL area,
AceComm first checks to see if the key press has been defined in the current
KTS data.  If so, AceComm sends the assigned sequence of characters to the
modem.  The utility KTS.EXE (included) can be used to create new and or custom
KTS files.  See the included .ASC examples for defining and creating KTS
files.  Using KTS.EXE, the keyboard can be deigned to emulate any possible
combination of characters available to the system.  Key press assignments
defined in the KTS data area are given top priority, and thus take presides
over MACROS assigned to the same key.







       Page 38              AceComm (tm) v 1.81


Chapter 4  PRM-data Menus Area

           Key Translation Sequence file (.KTS)




VT102.KTSĿ
>TAB          ^I                   
 Del/.                            
ĳ Home/7       ^[[H                 
 PRM-data   Sub-Me Up/8         ^[[A                 
Area controls / O Left/4       ^[[D                 
 Telephone book on Right/6      ^[[C                 
 Allow enhanced ke End/1        ^[[K                 
 Allow mouse detec Down/2       ^[[B                 
 Mouse horizontal  Keypad-0     ^[Op                 
 Mouse vertical se Keypad-1     ^[Oq                 
 Auto Save Changes Keypad-2     ^[Or                 
 Screen Saver time Keypad-3     ^[Os                 
Terminal Area Op Keypad-4     ^[Ot                 
Default Video E Keypad-5     ^[Ou                 
Video Emulation Keypad-6     ^[Ov                 
 TTY             Keypad-7     ^[Ow                 
 Ansi            Keypad-8     ^[Ox                 
 Avatar          Keypad-9     ^[Oy                 
 Av/An           Keypad--     ^[Om                 
>VT102           Keypad-*     ^[Ol                 
 New_Vid  Asso_ Select  More  Quit  Help <>v^


KTS files contain a sequence of bytes to be sent to the modem when a particular
key press is made.  AceComm emulates a video type independently from the
keyboard emulation.  KTS files may be edited to emulate any combination
imaginable.  KTS files may be created and assigned to a video type using the
"Associate" option above.

AceComm comes with ready made KTS files.

   Notes: .KTS files are compiled from .ASC files.  .ASC files may be created,
          maintained, customized with a TEXT EDITOR in ASCII TEXT mode.  The
          utility KTS.EXE is provided for compiling .ASC files into .BIN
          files.  Rename the .BIN file with .KTS and copy the .KTS file into
          the directory pointed to in PRM-data for ".KTS".









       Page 39              AceComm (tm) v 1.81


Chapter 4  PRM-data Menus Area

           Keyboard MACRO Assignments



    KeyBoard MACRO Assignmentsķ
    Current Keyboard:ACE_DEF.KBDĺ
    >      F1 - F12               
       ALT-F1 - F12               
      CTRL-F1 - F12               
     SHIFT-F1 - F12               
      ALT+KEY Combo               
     CTRL+KEY Combo               
      Extended Keys               
     Select  Write  QuitĽ
o Each of the above key sets is available for assignment to a MACRO or MACRO
  stack.  The MACROS provide a wide range of services.  All of AceComm's
  functionality is available with MACROS.

o The "SHIFT-Fn" key-set is used by TAGGER to store TAGGED ITEMS

Menu options here allow each key press be re-assigned.  The keyboard can be
arranged thru the use of MACROS to resemble software you are more accustomed
to.  AceComm`s keyboard is totally MACRO driven.  Keyboard definitions are
stored in .KBD files.  ACE.CTL can be edited so future upgrades of AceComm will
automatically configure with your keyboard preference.


Write
  Prompts for a filename, and writes the current keyboard to a new KBD file, or
  updates an existing KBD file of the same name.

  When you choose "Write" the following occurs:

    AceComm  prompts  for  "filename"
    "filename"  is  forced a ".KBD"  extension
    "filename" is written in the same directory as ACE.PRM
    resides
    AceComm writes the contents of "Key MACRO Assignments" menu
    to the file
    AceComm re-reads the original KBD file.

  In short:
  - All changes, once written to a KBD file with "Write", pertain to the KBD
    file written to.
  - Making changes and not "Writing" them, will be saved to the current KBD
    file at program end.

To further explain, all changes made in this menu area to the keyboard
definitions, apply to the current KBD file.  If you exit the menu area, without



       Page 40              AceComm (tm) v 1.81


Chapter 4  PRM-data Menus Area

           Keyboard MACRO Assignments (continued)

choosing "Write", and say "ACE_DEF.KBD" is active, the changes will be stored
to "ACE_DEF.KBD" when you leave the PRM-data area.  If you choose "Write" from
the above menu, then the changes are stored to a new or existing KBD file, and
do not affect the current keyboard, as AceComm re-loads the current KBD file
after a "Write".  Unless you "Write" to the current KBD file, which is un
necessary, because AceComm will update it automatically anyway.

"SHIFT-Fn" is the key-set the TAGGER function assigns TAGGED ITEMS to.  When
you tag a word or line from the screen, the tagged item becomes associated with
the first available SHIFT-Fn key by way of the <SEND_SendStr> MACRO.


Ŀ
 F# Keys 
> 1<SendStr>[USER_NAME]^M
  2<SendStr>[FON_REC_PWD]^M
  3<SendStr>[LOCATION]^M
  4<SendStr>[VOICE_PNUM]^M
  5<SendStr>[PASSWORD]^M
  6<SetDTR> ON
  7<SendAscii> %PF
  8<Mondos>
  9<HelpMenu>
 10<TopBar>
 11<Mondo1>
 12<SendStr>75120,3306^M
 Edit  Zap  Quit <>v^
 Select  Quit  Help <>v^ٰ


Edit

  Allows editing the MACRO assignment.


Zap

  Clears field (Zaps) the MACRO assignment.











       Page 41              AceComm (tm) v 1.81


Chapter 4  PRM-data Menus Area

           Keyboard MACRO Assignments (continued)



   ACE.PRM Data  Edit-Menusͻ
    General Controls                       
    Serial Port Setup                      
   KeyBoard MACRO Assignmentsͻ        
 SHIFT F# Keys 
  1<SENDSTR>80XXX_92.ARJ
  2
  3
  4
> 5
  6
  7
  8
  9
 10
 11
 12
 Edit  Zap  Quit 

"SHIFT-Fn" key-set the TAGGER function assigns TAGGED ITEMS to.

When you tag a word or line from the screen, the tagged item becomes associated
with the first available SHIFT-Fn key by way of the <SEND_SendStr> MACRO.
























       Page 42              AceComm (tm) v 1.81


Chapter 4  PRM-data Menus Area

           Keyboard MACRO Assignments (continued)


ALT+KEY Combo
>ALT-A <AutoScrGen_>
 ALT-B <BackBuffer_>
 ALT-C <CaptureFile_>
 ALT-D <FonListDialer_>
 ALT-E <SendStr> ATE^M <HostEcho>
 ALT-F <FileLister_>[DIR_DNLDS]
 ALT-G <FileRequest_>
 ALT-H <MdmHangUp_>
 ALT-I
 ALT-J <CommandShell_>
 ALT-K
 ALT-L <RunProg> list
 ALT-M <SendStr>ath1^M <ChgDir>mail\ged <RunProg>GOLDED <ChgDir>[DIR_START]
 ALT-N <ChgDir>c:\mail\qm <RunProg>QM toss <ChgDir>[DIR_START]
 ALT-O <PrmDataMenus_>
 ALT-P <PrmDataMenus_>
 ALT-Q
 ALT-R <RunScript_>
 ALT-S <ScrnSnapshot_>
 ALT-T <ScrnTag_>
 Edit  More  Quit <>v^

PgDn/PgUp toggles display between above and below
























       Page 43              AceComm (tm) v 1.81


Chapter 4  PRM-data Menus Area

           Directories in Use Menu



    Directories in Use Menu
    >.FON files: D:\ACE
     .CAP files: D:\ACE
     .SCR files: D:\ACE
     .KTS files: D:\ACE
      Downloads: D:\ACE
       Nodelist: D:\ACE
      .REQ/.FLO: D:\AC
     Edit  Quit 

.FON

  Where AceComm expects .FON files to be.


.CAP

  Where AceComm will create and or re-open CAPTURE files.  A CAPTURE file is a
  means for "capturing" all port I/O to DISK.  When you open a capture file,
  AceComm records everything that comes into the serial port, exactly as it
  comes in.  Capture mode can be set to "Text" or "Raw".  "Raw" mode, no
  filtering, no translation of any kind takes place.(1) Video codes are
  recorded as they come in.  This allows capture of ANSI, AVATAR, RIP etc.
  screens.  "Text" mode, video control codes are filtered from the captured
  text.  AceComm does not overwrite CAPTURE files.  You have the option of
  renaming the file, or AceComm will append new data to the end of the
  file(2).  Time/Date stamps are always placed at the beginning of a capture
  file when opened.


.SCR

  Where AceComm will create and or look for .SCR files.  The MACRO <RunScript_>
  lists this directory.


.KTS
  Where AceComm expects to find it's KTS files.  It's ok to store
  your .ASC files in this directory.

Downloads

  This is the directory that AceComm 's internal protocols will receive into.
  AceComm will also list this directory when building upload LISTFILES.



       Page 44              AceComm (tm) v 1.81


Chapter 4  PRM-data Menus Area

           Directories in Use Menu (continued)



Nodelist

  When you select the FileRequest option, AceComm expects to find either (a) a
  valid RAW FIDO NODELIST and NLIST.IDX file(3).  or (b) a .NOD file(4)


.REQ/.FLO

  .REQ files are used when doing File Requests.  When you ask AceComm to make a
  File Request, the filename is created using the NET/NODE number in ascii hex,
  and the file extensions is ".REQ".

  .FLO files (Mail List File) are used when you want to Fil Attach to a
  NET/NODE.  File Attach may be any file(s), and will

  for point mail operators to send their mail bundle to the HOST.

(1) ANSI.EXE is a provided utility that can filter VIDEO CONTROL SEQUENCES from
     DISK files.

(2) If you have edited a CAPTURE file, or by other means used any utility that
     added the 26d character to the file, AceComm will not overwrite the END OF
     FILE character.  This may result in some editors not recognizing new data
     that follows the 26d character.  There exists utilities that can filter
     this and other characters from TEXT files.

(3) NLIST.IDX is a file created using the AceComm utility IDX.EXE.  IDX.EXE
     will create a small index into the RAW FIDO NODELIST file, for all
     ZONE:NET pairs.

(4) .NOD files are FBL output for a NET.  FBL.EXE is another AceComm utility.

















       Page 45              AceComm (tm) v 1.81


Chapter 4  PRM-data Menus Area

           External Programs Setup




Ŀ
 PRM-data   Sub-Menu Areas ĳ
 Area controls / Options menus        
 Serial Port/Modem Setup              
 KeyBoarD Macro Assignments           
External Programs SetupĿ      
>*.ARJ                              
 *.ARC                              
 *.LZH                        logy" 
 *.SDN                              
 *.ZIP                              
 *.ZOO                              
 *.EXE                              
 *.COM                              
 *.DOC                              
 All others                   ٰ
 External Upload Protocols    
 External Download Protocols  
 Select  Quit <>v^ ٰ


The extensions are used with the following menus, and are called when a
filename has been selected that contains the .EXT as listed.  Selections are
made while in <FileLister_> menu area.

Executable files are then handed over to AceComm's SPAWN function.
(<RunProgram> equivalent) SPAWN can find files along the DOS PATH.  SPAWN can
also determine a files extension (.COM,
.EXE) SPAWN will use XMS,EMS,DISK swapping if the option is selected.  SWAP for
SPWAN is selected from inside PRM-data "General Controls" menu.
















       Page 46              AceComm (tm) v 1.81


Chapter 4  PRM-data Menus Area

           External Programs Setup (continued)


   ACE.PRM Data  Edit-Menusͻ
    General Controls                       
    Serial Port Setup                      
    KeyBoard Text Macros                   
    Directories in use                     
    Executable files Menus ͻ        
   %Fn = *.ARJ
   ><RUNPROGRAM> ARJ a -s %FN %WK
    <RUNPROGRAM> ARJ x %FN %WK
    <RUNPROGRAM> ARJ v %FN %WK
   Ⱥ
    
     Select  Edit  Quit 
     *.COM                        
     *.DOC                        
     All others                   
     External Upload Protocols    
     External Download Protocols  
     Select  Quit ͼ

Sample menu when a "Highlighted" file's extension of ".ARJ".  AceComm changes
to the directory being listed, so that any WORK done by the utility is done in
the LISTED directory.  AceComm will use the SWAP functions if allowed.  (see
SWAP enable flags located inside "General Controls" Menu Area.
























       Page 47              AceComm (tm) v 1.81


Chapter 4  PRM-data Menus Area

           External Programs Setup (continued)


   ACE.PRM Data  Edit-Menusͻ
    General Controls                       
    Serial Port Setup                      
    KeyBoard Text Macros                   
    Directories in use                     
    Executable files Menus ͻ        
    *.ARJ                                
    *.ARC                                
    *.LZH                                
    *.SDN                                
   Ⱥ *.ZIP                        ͼ
     *.ZOO                        
    %FN = *.EXE
    ><RUNPROGRAM> %FN %WK
     <RUNPROGRAM> LIST %FN
    
    
    
     Select  Edit  Quit 

Sample menu for executable files.  Notice that the <RunProgram> MACRO will be
handed the current "Highlighted" filename with the %FN MACRO.  In the above
example the %WK argument will cause AceComm to wait for a key press afterward.
This allows the user to view any finishing screens generated from the
executable file argument to <RunProgram>.

This type of MACRO programming allows the user to fire up that QWK Mail Reader
(and what have you) on the fly without exiting AceComm.




















       Page 48              AceComm (tm) v 1.81


Chapter 4  PRM-data Menus Area

           Auto Engage Sequence Triggers




Ŀ
Auto Engage Sequence Triggers
Trigger Sequence -- Responding Macro Stack
>rz^M**^X            <RecvZmo>
 HS*^B               <RunProg>HSLINK -P%P -U[DIR_DNLDS] @UPLDS.LST
 ^H ^H ^H ^H ^H ^H   <RunProg>BIMODEM \L%P \R[DIR_DNLDS] Bimodem.Pth
 MPt ^V^H            <RunProg>MPT P%P N+ F+ R+ R [DIR_DNLDS]




 **EMSI_REQA77E      <SendEMSI_CLI>
 **EMSI_IRQ8E08      <SendEMSI_ICI>
Pre/Post AutoM Macros


 Edit  Quit  Help <>v^


o The last byte in a Sequence Trigger is the sequence scan trigger byte

o The last byte in a Sequence Trigger should end in an un common character (as
  designed above)

o EMSI_REQ detection can allow swift access to a BBS when mailer software
  answers the phone

o EMSI_IRQ is sent by BBS software to tell the caller it can do Interactive
  EMSI data handshaking

  The above defaults have been working very well for the protocols associated.


Sequence Trigger

  A sequence trigger is a character string that is used by a remote HOST,
  protocol etc.  as an attempt to engage some action from the other end.


Trigger Character

  AceComm scans back thru it's receive buffer for a trigger sequence with each
  occurrence of the "last byte of the sequence".  This means that AceComm will



       Page 49              AceComm (tm) v 1.81


Chapter 4  PRM-data Menus Area

           Auto Engage Sequence Triggers (continued)

  scan for the string each time it sees the trigger byte arrive from the
  modem.  For this reason a sequence trigger will end in a non-common byte.
  While 'rz^M' (^M being <CR>, 13 decimal) would be a valid sequence trigger,
  we don't want AceComm to search on every carriage return character that comes
  in.  Look at Bimodem's sequence trigger, we don't want to end the sequence
  with a <SP> character (^' is the control code for SPACE CHARACTER 32
  decimal).

  Characters 32(Space) and below need be escape encoded with the '^' ^A becomes
  1, ^B 2, ^C 3, ^M <CR>, ^` 32 <SP> etc.  When entering sequence text, you may
  simply type the <SP> character, AceComm will do the conversion for you.


**EMSI_REQA77E

  Most FIDONET mailer software will send an EMSI_REQ string to a caller.  This
  string is an attempt to determine the caller type.  AceComm's <SendEMSI_CLI>
  MACRO tells the mailer this is a human caller, bypassing the common "Press
  ESC to enter BBS" prompt.  DBridge mailer software is in complete and won't
  recognize this advanced EMSI handshaking.  All other mailer software does.


**EMSI_IRQ8E08

  IEMSI capable BBS systems will send an EMSI_IRQ string to a caller.
  Detection of EMSI_IRQ is responded to with IEMSI data handshaking.
  AceComm's <SendEMSI_ICI> MACRO handles IEMSI log on.  (see PRM-data IEMSI
  Setup menu)


Responding MACRO Stack

  The MACRO defined to the right of each sequence trigger will be used when a
  sequence has been detected.  This allows AceComm to be configured with auto
  download detection for up to 10 protocols.  MACRO STACKING is valid with
  AutoM MACROS.

  The sending of a carriage return as the last macro is use full for moving the
  BBS display upon return from the external protocol.  AceComm completely
  disables the serial port before calling any external programs.


PreAutoM MACRO

  The "PreAutoM" MACRO, if defined, will be processed prior to the AutoM MACRO
  about to be processed.  This allows for some extra maneuvering to be done



       Page 50              AceComm (tm) v 1.81


Chapter 4  PRM-data Menus Area

           Auto Engage Sequence Triggers (continued)

  which might otherwise be common to all AutoM MACROS anyway.  For instance the
  practice of changing to your "FILES" directory will insure that downloads are
  received into the "FILES" directory, even with protocols that do not allow
  file redirection.

  Notes: If you use PreAutoM MACRO for changing directories, remember that
         protocols such as BIMODEM which you may be up loading with at the same
         time, will need full path names to files they are to send.  Also
         protocols or what have you that use PRM, CFG etc.  files need know
         where to find these control files.


PostAutoM MACRO

  The "PostAutoM" MACRO, if defined will be processed immediately following the
  AutoM MACRO.  Again this is some extra MACRO processing power for those
  common to all AutoM MACRO jobs.


To Disable Auto Engage Sequence Triggers

  Located in the "Terminal Area Options" is a over ride flag with which Auto
  downloads may be completely disabled.  This flag affects all Sequence
  Trigger / AutoM MACROS pairs defined.

  Auto Engage                            On    <=-ENABLE
  Auto Engage                            Off   <=-DISABLE






















       Page 51              AceComm (tm) v 1.81


Chapter 4  PRM-data Menus Area

           "Intelligent Auto Log On Technology" (Tm)



"Intelligent Auto Log On Technology" (Tm)
Trigger Sequence -- Responding Macro Stack
>is your name:       <SendStr>[USER_NAME]^M~Y^M~[FON_PWD]^M
 Your FIRST name:    <SendStr>[USER_NAME]^MY^M~[FON_PWD]^M
 Host Name:          <SendStr>CIS^M~~~~[FON_ID]^M~~~~~~[FON_PWD]^M
 first name ?        <SendStr>[USER_NAME]^MY^M[FON_PWD]^M
 and LAST name:      <SendStr>[USER_NAME]^M~^M~[FON_PWD]^M
 last name?          <SendStr>[USER_NAME]^M~~[FON_PWD]^M
 first name?         <SendStr>[USER_NAME]^M~~[FON_PWD]^M
 (First and Last)    <SendStr>[USER_NAME]^M~~[FON_PWD]^M
...

Case  Off
 Edit  Toggle_Case  Quit  Help <>v^

o Each Fon.Record FLAGS can be toggled to perform auto log on by either use of
  a script file, or character sequence trigger and associated macro stack.

o AceComm responds to a sequence trigger by processing the macro stack.

o Log on sequence trigger scanning is available immediately after connect, and
  until the sequence has been found, or 2 minutes of on line time has passed.

o When a log on sequence has been processed, or 2 minutes of on line time has
  passed AceComm stops scanning for log on sequences for the remainder of the
  on line session.

o Sequence triggers are optionally CASE or nO cASE sensitive

On Dial/Connect Acecomm will, if the AutoL flag for the current Fon.Record is
SET, begin scanning incoming data for Auto Log On Sequence Triggers.  When any
of the 10 possible sequences is found, the sequence's associated macro stack is
processed.  Once a sequence has been found, scanning stops until the next
Dial/Connect.  If a sequence has not been found after the first 2 minutes of on
line time has passed, Intelligent Auto Log On (Tm) is disabled until the next
Dial/Connect.


Toggle_Case

  The setup menu contains an option where sequence trigger scanning can be made
  case sensitive.  AceComm's default setup is for scanning to be not case
  sensitive.




       Page 52              AceComm (tm) v 1.81


Chapter 4  PRM-data Menus Area

           "Intelligent Auto Log On Technology" (Tm) (continued)


Sequence Trigger

  A sequence trigger is a character string that is used by a remote HOST,
  protocol etc.  as an attempt to engage some action from the other end.


Trigger Character

  AceComm scans back thru it's receive buffer for a trigger sequence with each
  occurrence of the "last byte of the sequence".  This means that AceComm will
  scan for the string each time it sees the trigger byte arrive from the
  modem.  For this reason a sequence trigger will end in a non-common byte.
  While 'rz^M' (^M being <CR>, 13 decimal) would be a valid sequence trigger,
  we don't want AceComm to search on every carriage return character that comes
  in.  Look at Bimodem's sequence trigger, we don't want to end the sequence
  with a <SP> character (^' is the control code for SPACE CHARACTER 32
  decimal).

  Characters 32(Space) and below need be escape encoded with the '^' ^A becomes
  1, ^B 2, ^C 3, ^M <CR>, ^` 32 <SP> etc.  When entering sequence text, you may
  simply type the <SP> character, AceComm will do the conversion for you.


To Disable Auto Log On Sequence Triggers Located in the

  "Fon.Record Edit" FLAGS menu is a over ride flag with which Auto Log On for
  the record may be completely disabled.  This flag only affects the currently
  selected record.

 Closer Look

 is your name:       <SendStr>[USER_NAME]^M~Y^M~[FON_REC_PWD]^M
  |                   |        |                 |
  |                   |        |                 Fon.Record
  Sequence Trigger    |        |                 password field
                      |        |
                      |        IEMSI data field
                      |
                      Associated macro stack

 AceComm provides two different data macros for passwords

   [PASSWORD]  represents the IEMSI password field

[FON_REC_PWD]  represents the current Fon.Record



       Page 53              AceComm (tm) v 1.81


Chapter 4  PRM-data Menus Area

           "Intelligent Auto Log On Technology" (Tm) (continued)

               password field

Fon.Record password fields can be cloned for the entire FON file using the
"Mass_change" menu selection from inside the Telephone directory list area.













































       Page 54              AceComm (tm) v 1.81


Chapter 4  PRM-data Menus Area

           Mass Menu Attribute Changes




Paint Screens - Video ControlsĿ
 Status line color                         
 Curtain color                             
 Help screen color                         Ŀ
>Paint Menus                               ĳ
 Update All Menus                          s        
 Video snow checking   Off                          
 Video Rows (VGA)      Detect                       
"Update" uses values belowĳ         
       Border Attr     7                            
       Border Type     0                   s        
       Title Color     120                 hnology" 
      ITitle Color     10                  ls       
    Selector Color     2                            
  Left Field Color     3                            
 Right Field Color     7                            
        Burst Mode     Off                          
      Menu Chatter     Off                          
      Menu Whistle     Off                 ٰ
 Select  Quit <>v^ٰ

  Customizer        <ENTER>-Select 
    Paint_Border  Type_Border  Left_Field  Right_Field  Title  ITitle
 Selector  Display  Burst Off Chatter Off Whistle Off Quit <>v^


o Here you can play with the colors for this menu only, unless you choose the
  "Update All Menus" option


Status Line Color

  Toggle the AceComm status line back ground color (1 - 7)


Curtain Color

  Toggle color of back drops for various Areas


Customize

  All changes are limited to the current active menu "Mass Box".  Just as



       Page 55              AceComm (tm) v 1.81


Chapter 4  PRM-data Menus Area

           Mass Menu Attribute Changes (continued)

  selecting the "Customize" option from any other menu, changes are reflected
  and remain permanent.


Help Screen Colors

  AceComm's on line help uses 4 separate colors.  Certain error conditions can
  trigger a help screen to be displayed.  When this occurs, the error message
  is displayed at the top of the help screen, followed by the help screen's
  Title, help text, and bottom selector bar.


Update All Menus

  Selecting this option write a clone of the active menu "Mass Box" to *all*
  AceComm menus except the Fon List menu, and Dial/Edit Record menus.  The Fon
  List area menus have their own Paint options.


Snow (vertical retrace) checking     Off

  AceComm uses direct video buffer writes for all it display areas.  Most areas
  will be able to handle SNOW CHECKING properly before making screen updates.


Video Rows (VGA)                     Detect

   Video Rows (VGA)Ŀ
   >Detect                                    
    25 rows                                   
    28 rows                                   
    43 rows                                   
    50 rows                                   
    Select  Quit <>v^


The values on the right side of the menu are in decimal.  They may be copied
and used in the .CTL file as defaults.  (See ACE.CTL(1) "Menu Attributes")

  Customizer        <ENTER>-Select 
 Color_Border  Type_Border  Left_Field  Right_Field   More
................................................................
  Customizer        <ENTER>-Select 
 Title  ITitle  Selector  Burst On Chatter Off Whistle On






       Page 56              AceComm (tm) v 1.81


Chapter 4  PRM-data Menus Area

           Mass Menu Attribute Changes (continued)

(1) ACE.CTL may be renamed.  AceComm package contains the default ,CTL file
     ACE.CTL, but it may be renamed to another filename.















































       Page 57              AceComm (tm) v 1.81


Chapter 4  PRM-data Menus Area

           EMSI/IEMSI data



Ŀ
EMSI dataĳ
    Address  1:114/35                                 
   Sys Name  AceComm Software Support                 
       City  Phoenix, AZ                              
   Operator  Michael Phelps                           
  Sys Phone  (602) 846-2940                           
       Baud  19200                                    
      Flags  v32                                      
IEMSI dataĳ
> User Name  Michael Phelps                           
      Alias  Michael Phelps/(AceComm)                 
   Location  Phoenix, AZ  USA                         
     Data #  (602) 846-2940                           
    Voice #                                           
   Password  AceComm                                  
Sub Menusĳ
    CRT def  ANSI,24,80,0                             
  Protocols  Zap,ZMO                                  
 Capability  CHT,TAB,ASCII8                           
   Requests  NEWS,MAIL,FILE,HOT,CLR,HUSH,MORE,FSED    
 Edit  Quit  Help <>v^ٰ



o Electronic Mail Standard Identification (EMSI)

o EMSI is a widely used handshake protocol used with FIDONET mailer software

o Interactive Electronic Mail Standard Identification (IEMSI)

o IEMSI is an auto log on interface designed to present caller information to
  the HOST quickly and automatically.  Few BBS systems currently support
  IEMSI.  RA supports IEMSI log on.

o Interactive EMSI log on function is called with the <SendEMSI_ICI> MACRO
  function

o Data defined here will be used by the <SendEMSI_ICI> MACRO function

o All IEMSI data need not be defined.  The BBS system will prompt the user for
any invalid or missing information.

EMSI handshake data



       Page 58              AceComm (tm) v 1.81


Chapter 4  PRM-data Menus Area

           EMSI/IEMSI data (continued)


   The following data is presented to the remote mail system during EMSI
   handshaking.

   Address

   Sys Name AceComm Support

   City Phoenix, AZ

   Operator Michael Phelps

   Sys Phone (602) 846-2940

   Baud 14.4

   Flags v32b

   Password  --  Pre arranged between two systems.

   The following example will cause AceComm to fill in the EMSI data field for
   "password" with 'mailman' when the target system's address is 1:114/12.

                  Password 1:114/12 mailman


IEMSI handshake data

User Name and Alias

  Enter your name as you want it to appear to a BBS system.  There is also a
  PRM-data MACRO [USER_NAME] that uses this field.

  There is also a PRM-data MACRO [ALIAS] that uses this field.


Location

  City, State, Country

  There is also a PRM-data MACRO [LOCATION] that uses this field.


Data # and Voice #

  If you have no Data #, leave the field blank.  There is also a PRM-data



       Page 59              AceComm (tm) v 1.81


Chapter 4  PRM-data Menus Area

           EMSI/IEMSI data (continued)

  MACRO [DATA_PNUM] that uses this field.

  There is also a PRM-data MACRO [DATA_PNUM] that uses this field.


Password

  This is a default password, any FON.RECORD.PASSWORD always will override this
  IEMSI PASSWORD.

  There is also a PRM-data MACRO [PASSWORD] that uses this field.


Birthdate (currently unused)


CRT def    (current session only)

      CRT Defͻ
      >AVATAR/0+ / ANSI        
       ANSI X3.64              
       TTY (raw mode)          
       Select  Quit <>v^ͼ

  Consists of four sub-fields separated by commas, from left to right:TERMINAL
  EMULATION,ROWS,COLUMNS,NULS

  AceComm fills in the ROWS,COLUMNS,NULS fields automatically when building
  IEMSI data packets.

                       Example CRTDEF: AVT0,24,80,0

  TERMINAL EMULATION
  Video type
                              AVT0        (AVATAR/ANSI)
                              ANSI
                              TTY
  ROWS
         Video rows for current session only
  COLUMNS
         Video columns for current session only
  NULS
         00h character required after line feeds.


Protocols



       Page 60              AceComm (tm) v 1.81


Chapter 4  PRM-data Menus Area

           EMSI/IEMSI data (continued)


  Protocolsͻ
  >ZedZap (Zmodem to 8k)        Yes  
   Zmodem                       Yes  
   Select  Quit <>v^ͼ

  AceComm internal protocols support ZMO,ZAP fields.

  ZMO is normal zmodem

  ZAP is zmodem with up to 8k data frames.


Capability    (current session only)

  Capabilitiesͻ
  >Can do full screen chat      Yes  
   Can handle TAB characters    Yes  
   Can handle 8-bit characters  Yes  
   Select  Quit <>v^ͼ

  CHT       Can do full screen on line conversation (CHAT)

  TAB Can handle TAB (ASCII 09h) characters AceComm supports TAB

  ASCII8    Can handle 8-bit IBM PC ASCII characters


Requests      (current session only)

  Requestsͻ
  >Show bulletins,announcements Yes  
   Check for new mail           Yes  
   Check for new files          Yes  
   Hot-keys                     Yes  
   Screen clearing              Yes  
   Do not disturb               Yes  
   Page pausing, `More`         Yes  
   Full-screen editor           Yes  
   Select  Quit <>v^ͼ

  NEWS      Show bulletins, announcements, etc.

  MAIL      Check for new mail

  FILE      Check for new files



       Page 61              AceComm (tm) v 1.81


Chapter 4  PRM-data Menus Area

           EMSI/IEMSI data (continued)


  HOT       Hot keys "ON"

  CLR       Screen clearing

  HUSH      Do not disturb

  MORE      Page pausing, often referred to as "More"

  FSED      Full screen editor







































       Page 62              AceComm (tm) v 1.81


Chapter 5  INTERNAL / EXTERNAL PROTOCOLS

           Internal, Defined-External Receiving Units


Receiver Protocols
Internal
>Zmodem   1K/8K adoptive
 Ymodem   128/1K adoptive
 YmodemG
 Xmodem   128/1K adoptive
 Ascii file      XON/CTS
External (user defined)
 <RunProg>BIMODEM /L%P /R[DIR_DNLDS] Bimodem.Pth
 <RunProg>HSLINK -P%P -U[DIR_DNLDS] @UPLDS.LST
 <RunProg>MPT P%P N+ F+ R+ R [DIR_DNLDS]
 <RunProg>JMODEM %PF %WK
 <RunProg>DSZ port %P speed %B rz -mrr [DIR_DNLDS]





 Setup Menu (Externals)
Auto Engage Menu
 Setup Menu (Auto Engage)
EMSI Protocol
 Recv Mail / File Request
 Select  Options  Quit  Help <>v^


AceComm contains internal Xmodem, Xmodem 1k, Ymodem, Ymodem 1k, Ymodem G,
Zmodem, and a Zmodem variant ZedZap (8k).


Internal Batch Capable

  Batch protocols receive the incoming filenames as part of the file data sent
  from the sender.  AceComm will append filenames received from the remote
  sender to the directory path contained in the PRM-data area under "FILES".


Internal Single File

  Single file protocols require a filename be given locally, by the user.  The
  user is prompted for a filename between the menu selection and calling the
  internal protocol function.


External Menu



       Page 63              AceComm (tm) v 1.81


Chapter 5  INTERNAL / EXTERNAL PROTOCOLS

           Internal, Defined-External Receiving Units (continued)


  "Externals" are defined as menu selectable executable that will become
   arguments to the <RunProgram> MACRO.

   You may find it handy to assign some external protocols to a "Hot Key" from
   inside PRM-data Key Definition menu.

 External Protocols (DnLd) 
 <RunProg>BIMODEM /L%P /R[DIR_DNLDS] Bimodem.Pth
 <RunProg>HSLINK -P%P -U[DIR_DNLDS] @UPLDS.LST
 <RunProg>MPT P%P N+ F+ R+ R [DIR_DNLDS]
 <RunProg>JMODEM %PF %WK
 <RunProg>DSZ port %P speed %B rz -mrr [DIR_DNLDS]


>


 Edit  Select  Quit <>v^


Auto Engaging Menu

  Auto engaging protocols have sending units that begin by sending a documented
  sequence of characters.  AceComm allows up to 10 separate sequences be
  defined, and associates each sequence with a MACRO STACK.  the MACRO STACK
  can be setup to call the external protocol associated with the sequence.
  "AutoDnLds" is documented in more detail above.  Shown below is a snippet
  reminder display.

Auto Engage Sequence Triggers
Trigger Sequence -- Responding Macro Stack
>rz^M**^X            <RecvZmo>
 HS*^B               <RunProg>HSLINK -P%P -U[DIR_DNLDS] @UP.LST
 ^H ^H ^H ^H ^H ^H   <RunProg>BIMODEM \L%P \R[DIR_DNLDS] Bi.Pth
 MPt ^V^H            <RunProg>MPT P%P N+ F+ R+ R [DIR_DNLDS]
 **EMSI_REQA77E      <SendEMSI_CLI>
 **EMSI_IRQ8E08      <SendEMSI_ICI>


Recv Mail / File Request

  "FileRequest" is a point mail function.

  Selecting File Request function will bring up the menu below if the PRM-data
  directory field for NODELIST points to either



       Page 64              AceComm (tm) v 1.81


Chapter 5  INTERNAL / EXTERNAL PROTOCOLS

           Internal, Defined-External Receiving Units (continued)

    - FIDONET NODELIST and compiled NLIST.IDX file
    - FBL.EXE output .NOD file
  FBL output .NOD file is used in the example below.

 ͻ
 >           1:114/12                   
  Format =>  ZONE:NET/NODE              
 ͼ
 This menu prompts the user for a ZONE:NET/NODE number of the system we want to
 call.  Having entered the above "1:114/12" the menu below is presented.

 1:114/12ͻ
 D:\ACE\fon\ͻ
   1_105.NOD    19595   05/12/93 10:09 
 > 1_114.NOD    11220   05/12/93 10:09 
   1_125.NOD    7886    05/12/93 10:09 
   1_282.NOD    7623    05/12/93 10:09 
   1_382.NOD    10291   05/12/93 10:09 
 ͳGrab Quit <>v^ͼ
 This menu lists FBL output .NOD files found in the directory field NODELIST.
 FBL produces these files and names them according to their ZONE_NET number.
 We want to select the file 1_114.NOD because 1_114.NOD is an extracted listing
 of all NET 114 zone 1, from the FIDONET NODELIST.  Selecting the 1_114.NOD
 file produces the following menu.

 1:114/12ͻ
 1:114/12ͻ
     System Name ORAC/2                              
 Ⱥ           City Phoenix_AZ                          
    Operator Name Eugene_Glover                       
     Phone Number 1-602-277-1334                      
        Baud Rate 9600                                
            Flags H16,CM,XA                           
   .CFG  Password mailman                             
  ͳFile_Request Human call  Poll_for_Mail  Quit ͼ

 Here AceComm has found the desired node information from the file 1_114.NOD.

 Notice the "Phone Number" field contains a long distance number.  The
 following "Dial Filter" statement" contained in "Point Mail Setup" menu is
 used to convert the phone number to a local number.
      1-602-
       (A)        (B)
 Explanation: Field (A) defines what to look for in phone numbers Field (B)
              defines what to replace field (A) with.  Here we left field (B)
              blank.  AceComm then replaces "1-602-" with nothing.



       Page 65              AceComm (tm) v 1.81


Chapter 5  INTERNAL / EXTERNAL PROTOCOLS

           Internal, Defined-External Receiving Units (continued)


 Notice the "Password field.  The following "Password" definition was made in
 "Point Mail Setup" menu.
      1:114/12 mailman

 The selector bar at the bottom of the above menu contains several choices.
 The first being "File Request".  Selecting "File Request" produces the
 following screen.

 Input Window
 
 >FileName:  files
 

 AceComm is prompting for file names.  The example uses the file name "files".
 Many systems will recognize "files" as a MAGIC file name, and send an "all
 files listing" for the system in response.  Pressing <ENTER> alone when
 finished entering file names causes AceComm to begin dialing the target
 system.

     Record Number 1:114/12
     >     System Name   ORAC/2
          Phone Number   1-602-277-1334
          Line Control   9600L,8N1
            Video Type
      Control Flags      AutoMACRO,
           Dial Prefix
          Log on Script
          Capture File
              Password   mailman
         Load KBD File
       Log on triggers
     Last Connect  --   Total Connects 
      0
     Cycles     --      Dial String                       Last
        0                ATEQ0X4DT277-1334
      00:03    00:03     58
     ͳQuit <SpaceBar>-ReCycle <>v^
----------------------------------------------------------------
CONNECT 9600/ARQ
 Address 1:114/12 Using BinkleyTerm-OS/2 Ver. 2.56

Welcome to ORAC/2 - Home of Log/2 (Log for OS/2)
Press <escape> to enter BBS!
ORAC/2
Eugene Glover, Phoenix, AZ USA1-602-277-1334



       Page 66              AceComm (tm) v 1.81


Chapter 5  INTERNAL / EXTERNAL PROTOCOLS

           Internal, Defined-External Receiving Units (continued)

BinkleyTerm, 9600, CM,XA,V32B,HST

  Outgoing  D:\ACE\mail\0072000C.REQ
 File Info  7 06/26/1993 11:55
0        7        0 CPS        00:00        ZEOF
                 CPS                ZDATA
  Incoming  c:\fil\orac.lzh
 File Info  90401 06/24/1993 20:00
90401        289        1089 CPS        01:23        ZSendHexHdr
TIMEOUT

NO CARRIER

OK
----------------------------------------------------------------
AceComm uses it's text based display for the Point Mail protocol displays.

































       Page 67              AceComm (tm) v 1.81


Chapter 5  INTERNAL / EXTERNAL PROTOCOLS

           Internal, External Sender Protocols



Sender Protocols
Internal
>Zmodem 1K
 Zmodem 8K
 Ymodem
 Ymodem 1K
 YmodemG
 Xmodem
 Xmodem 1K
 Ascii file      XON/CTS
External (user defined)
 <RunProg>BIMODEM /L%P /R[DIR_DNLDS] bimodem.pth
 <RunProg>HSLINK -P%P -U[DIR_DNLDS] @UPLDS.LST
 <RunProg>MPT P%P N+ F+ S @UPLDS.LST %WK
 <RunProg>JMODEM S %PF %WK
 <RunProg>DSZ port %P speed %B sz @[DIR_START]\UPLDS.LST





 Setup Menu (Externals)
 Send Mail / File Attach
 Select  Options  Quit  Help <>v^


AceComm contains internal Xmodem, Xmodem 1k, Ymodem, Ymodem 1k, Ymodem G,
Zmodem, and a Zmodem variant ZedZap (8k).

Internal Batch Capable

  AceComm's internal "Batch" capable protocols are capable of sending from a
  LISTFILE.  A LISTFILE is an ascii text file containing <CR> <LF> terminated
  filenames.  One filename per line.  Filenames may contain a full DRIVE:\PATH
  specifier.  AceComm looks in the current directory for a filename
  "UPLDS.LST".  When selecting any of the "Batch" capable internal sending
  units, AceComm will always look for "UPLDS.LST", if the file exists, AceComm
  displays the following screen.

 ķ      AceComm always prompts to send the
  Found UPLDS.LST    from the LISTFILE "UPLDS.LST", when the
  Send contents?     "UPLDS.LST" file exists in the directory.
 >(Y)es/(n)o?:       Pressing <CR> defaults to (Y)es, (n)o
 Ľ   brings up the regular file selection



       Page 68              AceComm (tm) v 1.81


Chapter 5  INTERNAL / EXTERNAL PROTOCOLS

           Internal, External Sender Protocols (continued)

                       menu.


 ķ      If the (Y)es selection was selected,
  UPLDS.LST            AceComm will, after the transfer,
  Delete this file?    present the menu at left, prompting to
 >(Y)es/(n)o?:         delete the LISTFILE, or leave it exist.
 Ľ



The "Regular file selection" menu (below) allows "on the fly" LISTFILE
creation.  The "on the fly" LISTFILE is not named "UPLDS.LST", but a temporary
unique filename is selected.  "On the fly" LISTFILE is deleted after transfer
without any prompt.

     Make Uploads Listķ
     >Batch Tag                        
      Manual entry                     
      Finished  /  ESC-key             
      Select  Quit Ľ

        Batch Tag

        This selection brings up the "FileLister" menu.  This menu allows
        tagging filenames to the LISTFILE.  PRM-data DIR "DNLDS" is the default
        directory displayed by "FileLister" when called by the "Sender
        Protocols" menu.


        Manual entry

        The menu below is presented with the "Manual entry" selection.

  Make Uploads Listķ
   Batch Tag                         
  Input Window
  >FileName:  c:\fil\
  ӺInput Window<ENTER> alone when done
   
  The "Manual entry" filename prompt pre pends the prompt space with any PATH
  found in PRM-data DNLDS field.


  "Batch Tag/ Manual entry" are recorded to a temporary unique LISTFILE as
  explained above.  Temporary unique LISTFILE is automatically deleted after



       Page 69              AceComm (tm) v 1.81


Chapter 5  INTERNAL / EXTERNAL PROTOCOLS

           Internal, External Sender Protocols (continued)

  use.


Single File

    AceComm's internal protocols that send 1 filename per invocation use the
    "Manual entry" window shown below.

  Input Window
  >FileName:  c:\fil\
  Input Window<ENTER> alone when done
  


Externals

  This selection brings up a menu listing up to five configurations for
  external protocol setup/selection.  This menu allows storing configurations
  for external protocols to be used.  The menu storage below functions the same
  as any MACRO stack assigned to a key press.  Here you have a menu where you
  may find it easier to to store specific upload protocol definitions.

  External Protocols (UpLd) 
 ><RunProgram>BIMODEM %WK
  <RunProgram>HSLINK %PF %WK
  <RunProgram>MPT S @UPLDS.LST %WK
  <RunProgram>JMODEM S %PF %WK
  <RunProgram>DSZ sz %PF
  Select  Edit  Quit 


Send Mail / File Attach

  This selection allows the user to send files to EMSI capable mailer
  software.  The menu shown below prompts the user for a FIDONET style
  ZONE:NET/NODE number.

 ķ
 >                                      
  Format =>  ZONE:NET/NODE              
 Ľ

  The number is required for naming a LISTFILE.  LISTFILE in this mode uses
  "FLO" file extension.  AceComm allows normal Tag or manual entry when adding
  filenames to LISTFILE.  Those who want to "File Attach" or are running under
  a HOST as a point mail system will use this option.  Point mail operators may



       Page 70              AceComm (tm) v 1.81


Chapter 5  INTERNAL / EXTERNAL PROTOCOLS

           Internal, External Sender Protocols (continued)

  upload their mail bundles with this "Send Mail" selection.  AceComm requires
  a NODELIST or FBL output .NOD file when using "Send Mail/Attach".  AceComm
  uses the ZONE:NET/NODE number entered above for looking up system information
  about the HOST to be called.  AceComm is able to retrieve the phone number
  and system name from NODELIST/.NOD files.

  










































       Page 71              AceComm (tm) v 1.81


Chapter 6  Telephone Directory Area


 Telephone_directory D:\ACE\fon\ACE.FON, 19 Records
      System Name              Phone Number     Line Control Video  Last On
>1    AceComm Support          1-602-846-2940     19200,8N1   Av/An  25 Dec
 2    Albuquerque ROS <ASP>    1-505-299-5974     19200,8N1   Av/An  00
 3    Animal House             1-601-329-4217     19200,8N1   Av/An  00
 4  * CIS (local phoenix 9600) 468-0285           19200,7E1   Av/An  21 Dec
 5    CIS (phones)             1-800-346-3247     19200,7E1   Av/An  03 May
 6    Comput Connections (PCB) 1-202-547-2008     19200,8N1   Av/An  00
 7    Eagan On-line            1-612-686-8806     19200,8N1   Av/An  00
 8    Exec-PC <ASP>            1-414-789-4210     19200,8N1   Av/An  00
 9    Leprechan Castle (SPIT)  1-601-799-2299     19200,8N1   Av/An  00
 10   PC-Ohio <ASP>            1-216-381-3320     19200,8N1   Av/An  00
 11   Supra Modem BBS          1-503-967-2444     19200,8N1   Av/An  00
 12   Technoids Anonymous      1-602-899-4876     19200,8N1   Av/An  00
 13   The Flying Dutchman      1-406-452-4210     19200,8N1   Av/An  00
 14   The GaRBaGe DuMP <ASP>   1-505-294-5675     19200,8N1   Av/An  00
 15   The Hot Tub Chat Lounge  1-201-617-8054     19200,8N1   Av/An  00
 16   Tool Shop,langs          1-818-891-6780     19200,8N1   Av/An  00
 17   Wizard's Gate <ASP>      1-614-224-1635     19200,8N1   Av/An  00
 18   Xanathar's Castle (TAG)  1-601-728-8023     19200,8N1   Av/An  00
 19   James Roberts (TRIBBS)   1-214-339-4495     19200,8N1   Av/An  24 Dec
  Dial  Edit  <SP>-Que  Circling_dial_queue  Fon_files  Sort  Options
 Add_record  Remove_record  Mass_Change  Import  Paint  Quit  Help <>v^


The Telephone Directory Area lists binary .FON files in their full ASCII
representation.  The current loaded .FON file is identified at the top of the
menu.  Notice that the number of records contained in the '1_114.FON' file is
presented at the top right.  .FON files are not fixed to any certain record
size, and can have records added or deleted, from here, in the Directory list
area.  Maximum record count for a FON file is 1000 records per FON file.
AceComm supports unlimited FON files, and provides easy directory List/Grab
function for changing FON files.

Dial

  Dial the "highlighted" record.  The function continues dialing until:

     (a) a connection has been established

     (b)  USER ABORT.


Edit

  Another menu contains the "highlighted" record's data is presented for
  editing, or just a closer view.  All changes are automatically save to disk.



       Page 72              AceComm (tm) v 1.81


Chapter 6  Telephone Directory Area



<SP>-Que

  Mark the "highlighted" record for 'RedialQue'.


Circular_dial_Queue

  Switch into The 'Que' Menu.  At least 1 record needs be marked "Queued" for
  AceComm to present this area.  From the 'Que' Menu, 'Dial' goes into single
  dial mode, and each record is dialed 1 time, followed by the next record
  until all records in the 'Que' have been dialed.  The 'Que' then revolves
  around to the first record and begins again.  When a connection has been
  established, the record is removed from the 'Que'.

 Circular_Redial_Que D:\ACE\1_114.FON, 6 Records
      System Name            Phone Number     Line Control Vid
>14 - Artemis Lair bbs         1-602-841-4474     9600,8N1    A
 15 - Astroland                1-602-381-8708     9600,8N1    A
 16 - Bob's Place BBS Node 1   1-602-497-2173     2400,8N1    A
 17 - Bob's Place BBS Node 2   1-602-545-8745     9600,8N1    A
 18 - Broadcaster's BBS        1-602-872-9148     9600,8N1    A
 19 - CADE BBS                 1-602-931-3468     2400,8N1    A
  Dial  Edit  <SPACEBAR>-Zap  Telephone_Directory
 Add_record  Remove_record  UnMark_All  Import  Paint  Quit <


Fon_files

  List PRM-data directory .FON, allow selection of new .FON file


Sort

  Sort FON file by ?Ŀ
  >Number of calls    
   Last date called   
   System name field  
   System number      
   Select  Quit 


Options

  Dialing OptionsĿ
  >Inter byte delay                         1    
   Modem Response Timeout when dialing      60   



       Page 73              AceComm (tm) v 1.81


Chapter 6  Telephone Directory Area

   Seconds between re-dial                  1    
   DTR state between re-dial                Off  
   Ring BELL on Dial/Connect                1    
   Select  Quit  Help <>v^


Add_record

  Function appends a new record to the current loaded .FON file, and
  immediately brings up the 'Edit' Menu.  The new record is automatically
  saved.


Remove_record

  The "highlighted" record is removed from the current loaded .FON file.  No
  hole is left, the .FON file is reduced a 'record size' in bytes.


Mass_Change

  Mass Change FON RecordsĿ
  >     Dial Prefix        
           Password        
      Load KBD File        
       Line Control        
         Video Type        
      Flags Control        
         UnMark All        
   Select  Quit <>v^

  All records in a FON file can be updated at one time, with individual record
  member updates.


Import

  o Convert another software's FON type file to AceComm FON file.

  o Merge two AceComm format FON files into one file.

  o Initialize a new FON file of video rows number of blank records.

  "Import" selection brings up the FON file conversion menu displayed below.
   The menu provides the following functions.

  Covert to AceComm FONĿ
                              
  > BOYAN    5                



       Page 74              AceComm (tm) v 1.81


Chapter 6  Telephone Directory Area

    Qmodem   4                
    Qmodem   5                
    Procomm  2.43             
    PcPlus   1                
    PcPlus   2                
    Telemate 3.01 - 4.12      
    TELIX    3.15 - 3.21      
    Combine 2 Ace FON         
    Create blank FON          
   Select  Quit <>v^


Paint

  Customize the current menu only.  All changes are save automatically.




































       Page 75              AceComm (tm) v 1.81


Chapter 6  Telephone Directory Area


Fon.Record Edit Menu

 Telephone_directory D:\ACE\fon\ACE.FON, 19 Records
      System Name              Phone Number     Line Control Video  Last On
>1    AceComm Support          1-602-846-2940     19200,8N1   Av/An  25 Dec
 2  Record Number 1ķ
 3  >     System Name  AceComm Support                                   
 4       Phone Number  1-602-846-2940                                    
 5       Line Control  19200L,8N1                                        
 6         Video Type  Av/An                                             
 7      Control Flags  Macro,DTag,IEMSI,AutoL                            
 8        Dial Prefix                                                    
 9       LogOn Script                                                    
 10      Capture File                                                    
 11          Password  pwd                                               
 12             Alias  Michael Phelps/AceComm                            
 13                ID                                                    
 14     Load KBD File                                                    
 15   Log on triggers  Case  Off                                         
 16 Last Connect  --   Total Connects ĺ
 17  25 Dec 11:24:50am      38                                           
 18 Cycles     --      Dial String                       Last Response ĺ
 19    0               ATEQ0X4DT846-2940                                 
  Di   1723            00:00:00                                          
 Ad Edit  Paint  Quit  Help <>v^Ľ


System Name            AceComm Software Support

  The name defined here, is presented onto the revolving status line (right
  side of status line) when "on line".


Phone Number           1-602-846-2940

  This phone number, although long distance, can be modified by AceComm when
  dialing, with use of "Dial" statements in the Point Mail Menu.

  Example: lets say we are local Phoenix, where our area code is 602, we have
           an entire phone directory of long distance numbers.  The following
           dial statement defined inside "Point Mail Setup" will cause AceComm
           to translate all of the long distance numbers to local numbers.

           Dial 1-602-

           AceComm will see this definition and translate it into anything
           following the definition.  In this case, we did not put anything



       Page 76              AceComm (tm) v 1.81


Chapter 6  Telephone Directory Area

           after the "1-602-", so AceComm will strip "1-602-" from all phone
           numbers that contain "1-602-" as part of the number.  This is valid
           for all phone numbers that are processed thru the AceComm Dialer
           Menu.  Mailer mode, File Requests which get their phone numbers from
           either a FIDO NODELIST, of FBL output .NOD file do use the Dialer
           Menu and do receive number translation from "Dial" statements.


Line Control           2400L,8N1

  Most remote HOSTS will be set up using 8 data bits, No parity, and 1 stop
  bit.  Compuserve uses 7 data bits, Even parity, and 1 stop bit.  AceComm will
  configure the UART to assemble the in coming bit stream into characters,
  based on the configuration defined here.  Baud rate means nothing when
  LOCKBAUD is set, as is with the "L" appended to baud in this example.  Other
  wise, when LOCKBAUD is not set, AceComm will set the UART up to the
  Fon.Record baud rate.

  Note: When LOCKBAUD is not set, AceComm is also capable of resetting the baud
        rate to a connect string.  If you dial out at 2400, and connect at
        9600, and 9600 is detected in the the connect string, AceComm will
        automatically set the baud to 9600.  If LOCKBAUD is set, AceComm leaves
        baud alone.


Terminal Emulation     Av/An

  This option will present the Terminal emulations menu, you may select the
  video ,type you want associated with this record.  "Av/An means AVATAR and
  ANSI video emulation.


Control Flags  Macro,DTag,Capture,Text,IEMSI,AutoL

          Control Flagsͻ
        Tag dial attempts    On          
        Auto log on method   Macro,      
        Open Capture file on On          
        Capture mode         Text,       
       >Allow IEMSI log on   On          
        Allow auto log on    On          
        Edit  Quit <>v^ͼ

  "Script"  when  set,

  AceComm will attempt to load and run the filename defined next to "AutoLogOn
  Script".  If a script file is not found, AceComm ignores the error and
  continues normal operation.  Notes: .SCR files are looked for in the



       Page 77              AceComm (tm) v 1.81


Chapter 6  Telephone Directory Area

  directory defined inside PRM-data Area "Directories"


  "Macro"  when  set,

  AceComm will enable the defined Auto Log on Sequence Triggers and
  corresponding MACRO stacks.


  "DTag"  when  set,

  AceComm will tag un-successful dial attempts (busy, etc.) to the Que Dialer.
  An "*" character appears to the left of a Fon.Record's display line, when it
  is either Q tagged or, D tagged.  When this flag is not set, the only other
  way to Q tag a record is by manually selecting the menu option
  "<SPACEBAR>-Que" from the fon list display.


 "Capture"

 When this flag is selected, a capture file is opened upon Dial/Connect.  Any
 previously open capture file is first closed.


 "Raw"  when set,

 Data to capture file is as it comes in from the modem


 "Text"  when set,

 Data to capture file is filtered of video control codes as applicable to the
 current Video type


 "IEMSI"

 Allow Interactive EMSI log on


 "AutoL"

 Allow auto log on methods (script/macro)


Dialing Prefix

  The Fon.Record dial prefix overrides The PRM-data default prefix.  If this



       Page 78              AceComm (tm) v 1.81


Chapter 6  Telephone Directory Area

  field is null (blank), AceComm uses the PRM-data default dial prefix.


AutoLogOn Script       ACE_S.SCR

  When SCRIPT flag is set, for the current Fon.Record, AceComm will use this
  filename, opening it as a SCRIPT file, and run the contents.  This action
  takes place upon successful Dial/Connect.  If the filename does not exist,
  AceComm simply goes about it's business, and you will log on normally.
  AceComm will look for the SCRIPT filename in PRM-data DIR .SCR path.

  See also: Expandable Macro Parameters <SendStr> [FON_SCR]


Capture File           ACE_S.CAP

  Default filename presented to user when opening a "capture data to file"
  file.

  See also: Expandable MACRO Parameters <SendStr> [FON_CAP]


Password               my/password

  You may define the Fon.Record PASSWORD field to any character combination,
  the field maximum length is 19 characters.

  See also: Expandable MACRO Parameters

  <SendStr> [FON_PWD]

  would replace "[FON_PWD]" with "my/password" for this example.


Alias               Michael Phelps/AceComm

  See also: Expandable MACRO Parameters

  <SendStr> [FON_ALIAS]


ID                 75120,3306

  See also: Expandable MACRO Parameters

  <SendStr> [FON_ID]





       Page 79              AceComm (tm) v 1.81


Chapter 6  Telephone Directory Area

Custom .KBD File       MY.KBD

  KeyBoard File, AceComm will first remember what the current KBD filename is,
  load the Fon.Record's custom KBD file, if defined, and finally restore the
  original KBD file after session disconnect.  Say What?

  You are about to log onto Compuserve.  You have CIS.KBD file defined for the
  Fon.Record.  When dial/connect is detected, AceComm will load the contents of
  CIS.KBD, overlaying your current keyboard MACRO assignments.  When you log
  off of Compuserve, and AceComm detects the carrier drop (no DCD), AceComm
  will load back the original keyboard file, overlaying your custom CIS.KBD.

  You will need to distinguish KBD files from KTS files.  Where a KBD file
  overlays the keyboard MACRO assignments.  The KTS file defines the ultimate
  sequence that will be sent to the modem for a given key-press.  Keys assigned
  a MACRO, are processed as MACRO functions.

  Keys not assigned a MACRO(s) will be sent to the modem, and are candidates
  for KTS.

  Keys with extended codes, are sent as they would be seen in DoorWay mode.
  Normal keys (a-z,A-Z,1-0,CTRL A-CTRL Z, etc.) are sent in their normal lower
  ascii representation (as you would expect).  Now, any of these key-presses
  that have been defined inside the KTS file, are translated into their defined
  sequence.  AceComm & Utilities provides ASCII examples for compiling KTS
  files, as well as KTS.EXE the custom Keyboard Sequence Translation (Tm)
  compiler.


Log on Triggers

  AceComm will respond to a sequence trigger by processing the MACRO stack.
  Log on sequence trigger scanning is available immediately after connect, and
  until the sequence has been found.  When a log on sequence has been
  processed, AceComm stops scanning for the log on sequence.  Auto logon method
  can be set in the flags menu.















       Page 80              AceComm (tm) v 1.81


Chapter 7  File List/Utility Area



 D:\ACEͻ
 > 1_114.FON    26368   06/27/93 07:25 
   ACE.ASM      8269    06/26/93 18:00 
   ACE.CTL      13589   06/25/93 08:04 
   ACE.EXE      196102  06/27/93 07:24 
   ACE.FON      1600    06/27/93 04:13 
   ACE.HLP      44572   06/27/93 07:09 
   ACE.LOG      3694    06/27/93 07:29 
 ...
   ACTL.ASM     101998  06/25/93 14:22 
   Utility  New_Dir  Change_Drive      
  Tag  Delete  Quit  Help <>v^ͼ

Utility

  This selection brings up a sub-menu of pre-defined executable.  AceComm
  contains several sub-menus for this purpose.  Sub-menu selected is determined
  by the "highlighted" files's extension.  The %FN symbol is documented in
  MACRO.DOC.  %FN is an Expandable MACRO Function.  %FN argument to a MACRO
  from anywhere inside the "File Lister" menus is replaced with FULL PATH NAME
  for the current high lighted filename.

 C:\DOCͻ
   A.SNA        1242    06/27/93 07:53 
   ACE.BAK      117893  06/26/93 12:25 
   ACE.CHA      2706    06/27/93 07:46 
 >%FN = C:\DOC\ACE.DOC
   <RunProgram> BB %FN
  ><RunProgram> LIST %FN
   <RunProgram> QEDIT %FN
   <RunProgram> GREP %PF %FN %PF
   <RunProgram> PATCH %FN
   Select  Edit  Quit <>v^
   COVER        213     06/25/93 16:22 
   CREDIT.CRD   2918    06/25/93 15:30 
 ...
   FILE_ID.DIZ  392     06/26/93 13:14 
   Utility  New_Dir  Change_Drive      
  Tag  Delete  Quit  Help <>v^ͼ


New_Dir

  Allows changing directories.  AceComm changes directories right along with
  the display.  When you use AceComm's "Utils" Menu, work is done in the
  currently listed directory unless otherwise redirected via MACRO arguments or



       Page 81              AceComm (tm) v 1.81


Chapter 7  File List/Utility Area

  overriding external executable configurations.

  Notes: AceComm always returns to the starting directory after leaving the
         FileLister Area.
                    D:\ACEͻ
 D:\ACEͺ>>D:\ACE              
 > 1_114.FON    263 >..                  
   ACE.ASM      826 >CAP                 
   ACE.CTL      135 >CVTFON              
   ACE.EXE      196 >FILES               
   ACE.FON      160 >FON                 
   ACE.HLP      445 >KTS                 
   ACE.LOG      369 >MAIL                
   ACE.MAP      920 >SCR                 
   ACE.OBJ      271 >SND                 
   ACE.PRM      378 >XTRA                
   ACEBOX.INC   345 >ZEN                 
   ACEM         253 >F                   
   ACEORDER.FRM 588 Select  Quit <>v^ͼ
   ACET.SCR     809     05/17/93 21:33 
 ...
   ACTL.ASM     101998  06/25/93 14:22 
   Utility  New_Dir  Change_Drive      
  Tag  Delete  Quit   Help <>v^ͼ


Change Drive

  Allows listing another drive.
 D:\ACEͻ
 > 1_114.FON    263>A                    
   ACE.ASM      826 B                    
   ACE.CTL      135 C                    
   ACE.EXE      196 D                    
   ACE.FON      160 E                    
   ACE.HLP      445 Select  Quit <>v^ͼ
   ACE.LOG      3694    06/27/93 07:29 
 ...
   ACTL.ASM     101998  06/25/93 14:22 
   Utility  New_Dir  Change_Drive      
  Tag  Delete  Quit  Help <>v^ͼ


Tagged files

  Tagged files are stored in the file "UPLDS.LST" when tagged from inside the
  <FileLister_> MACRO.  When tagged from any of AceComm's internal protocol
  sending units, tagged filenames are stored into a temporary file.  The



       Page 82              AceComm (tm) v 1.81


Chapter 7  File List/Utility Area

  temporary file is deleted after each use.  UPLDS.LST files are not deleted,
  but instead stored ready.

  AceComm will look for UPLDS.LST when any internal batch capable protocols are
  selected.  If found, AceComm will ask the user is sending the contents of
  UPLDS.LST is desired, if (Y)es, AceComm will attempt to send all filenames
  listed in the UPLDS.LST file, if (n)o, AceComm will present the the File
  Input' menu.

 D:\ACEͻUPLDS.LST
   1_114.FON    26368   06/27/93 07:25 >D:\ACE\1_114.FON
 > ACE.ASM      8269    06/26/93 18:00 
   ACE.CTL      13589   06/25/93 08:04 
   ACE.EXE      196102  06/27/93 07:24 
   ACE.FON      1600    06/27/93 04:13 
   ACE.HLP      44572   06/27/93 07:09 
   ACE_MAIL.CFG 430     06/22/93 14:23 
 ...
   ACTL         591     06/22/93 14:08 
   ACTL.ASM     101998  06/25/93 14:22 
   Utility  New_Dir  Change_Drive      
 ͳTag Delete  Quit  Help <>v^ͼ


Delete

  Delete option presents a full path spec for the high lighted filename,
  prompting confirmation before deletion.
 D:\ACEͻ
   1_114.FON    26368   06/27/93 07:25 
 >ͻ 06/27/93 07:31 
   D:\ACE\A.SNA       06/26/93 18:00 
   Delete this file?  06/27/93 07:31 
  >(Y)es/(n)o?:       06/25/93 08:04 
  ͼ 06/27/93 07:24 
   ACE.FON      1600    06/27/93 04:13 
   ACE.HLP      44572   06/27/93 07:09 
   ACE_DEF.KBD  11120   06/27/93 07:29 
 ...
   ACE_MAIL.CFG 430     06/22/93 14:23 
   Utility  New_Dir  Change_Drive      
  Tag  Delete  Quit  Help <>v^ͼ









       Page 83              AceComm (tm) v 1.81


Chapter 8  Point Mail Functions



Ŀ
 PRM-data   Sub-Menu Areas ĳ
Point Mail SetupĿ
Boss Dataĳ
> Boss Name  Acecomm Software Support BBS             
  Boss Addr  1:114/35                                 
 Boss Phone  1-602-846-2940                           
   Boss Pwd  mailman                                  
  Boss Baud  19200                                    
  Nodelist   C:\FIL                                   
   Mail In   D:\ACE\mail                              
  Mail Out   D:\ACE\mail                              
Sub Menusĳ
 Dial Trans                                           
 Passwords                                            
 Edit  Quit  Help <>v^



o Boss data is used for mail Poll, Send, Request functions from inside the menu
   system (manual).  Automated mail functions require a NODELIST file and
   NLIST.IDX file.


Boss Setup

   Define a system that you point mail from AceComm will allow selection of
   "Boss" from inside the Zone:Net/Node prompt menu.

   See also <PollBoss> macro


Dial filter  --  AceComm will use Dial statements to modify phone numbers.

   Dial filter statements are used when dialing from inside of AceComm's phone
   directory, and or with mail functions.  A long distance BBS directory list
   can be used without editing phone numbers.

   Example: 1-602-454- 1-454
   >Dial filter 1-602-
    Dial filter
    Dial filter
    Dial filter
    Dial filter
    Edit  Quit  Help <>v^




       Page 84              AceComm (tm) v 1.81


Chapter 8  Point Mail Functions


   The following dial statement filter "1-602-" from all phone numbers the
   string is found in.

                  Dial filter 1-602-


   The following dial statement converts "1-602-451" found in phone numbers to
   "1-451".

                  Dial filter 1-602-451 1-451


   Dial statements are required when using point mail functions, because
   NODELIST phone numbers contain area codes.  AceComm uses dial statements to
   know how to modify phone numbers.

Password -- When an address is pass worded, the EMSI password field will be
 used to relay the password to a remote system during mail sessions.

   Example: 1:114/12 mailman
   >   Password
       Password
       Password
       Password
       Password
    Edit  Quit  Help <>v^



NODELIST DIRECTORY


Point mail functions look in the PRM-data directory "NODELIST" for systems
  directories.  Point mail functions require either of two types systems
  directories.

Systems directory type (FIDO  NODELIST)

  FIDO NODELIST is a systems directory that most EMSI capable HOST systems
  use.  AceComm can use a FIDO NODELIST.  To use the FIDO NODELIST, you must
  first compile an INDEX file.  AceComm uses NLIST.IDX.  NLIST.IDX contains a
  quick look up table for Zone:Net/Nodes in the FIDO NODELIST.  The AceComm
  package provides IDX.EXE as a utility to create the NLIST.IDX file.
  NLIST.IDX and the NODELIST are to be found inside of the PRM-data directory
  "NODELIST".





       Page 85              AceComm (tm) v 1.81


Chapter 8  Point Mail Functions

Systems directory type (FBL.EXE output .NOD file)

  NOD file is a NET extraction from the FIDO NODELIST.  FBL.EXE (provided) is
  capable of creating this file.  .NOD files contain a listing for a single
  NET.  .NOD files are very small and may be preferable for point mail use
  where calling 1 or a few pre know NETS is intended.  .NOD files are to be
  found inside of the PRM-data directory "NODELIST".


Automated Mail Services

  Automated (event driven) mail services require a NLIST.IDX,NODELIST.nnn pair
  be present in the NODELIST directory.  FBL output NOD files are not used for
  event drive mail activities.

  When an Event Schedule declares "Mail" as part of the event, AceComm will
  scan the MAIL_OUT directory for *.FLO files.  FLO type files supported are:

    FLO  ; file attach
    CLO  ; continuous
    DLO  ; direct
    OUT
    CUT
    DUT
    REQ  ; request

  AceComm will begin looking in the Nodelist directory for a NLIST.IDX file and
  associated NODELIST.nnn files.  If found, AceComm will look up the target
  systems record, build a Fon.Record with the information, and begin dialing
  with intent to send mail, file requests etc.  Any local systems will require
  a Dial filter statement be defined so that AceComm can translate the long
  distance number (as contained in the Nodelist) into a local one.

   The following dial statement filter "1-602-" from all phone numbers the
   string is found in.
                         Dial filter 1-602-

   If a connection is established, and the mail file is properly processed
   (sent), upon success AceComm deletes the file.  If the session for some
   reason is not successful (modems don't connect properly) and the file is not
   sent, AceComm will again scan the MAIL_OUT directory and process any mail
   files.  AceComm scans the MAIL_OUT directory about every 30 minutes during
   a "Mail" event.

   File Requests .REQ files are considered mail files, and processed in the
   same way.  During a "Mail" event.  Files received during a file request are
   placed into the MAIL_IN directory.




       Page 86              AceComm (tm) v 1.81


Chapter 8  Point Mail Functions

   Filenames contained inside of FLO files, with exception to REQ files are to
   be sent out to the target system.  Filenames that are prefixed with a '#'
   character are made ZERO length after sending.  Filenames prefixed with '^'
   character are deleted upon successful send.


The following has been taken from the "Protocols" menus section.  Receive/Send
Protocols sections present step by step through File Request and File Attach.


Recv Mail / File Request

  "FileRequest" is a point mail function.

  Selecting File Request function will bring up the menu below if the PRM-data
  directory field for NODELIST points to either

    - FIDONET NODELIST and compiled NLIST.IDX file
    - FBL.EXE output .NOD file

  FBL output .NOD file is used in the example below.

 ͻ
 >           1:114/12                   
  Format =>  ZONE:NET/NODE              
 ͼ
 This menu prompts the user for a ZONE:NET/NODE number of the system we want to
 call.  Having entered the above "1:114/12" the menu below is presented.

Send Mail / File Attach

  This selection allows the user to send files to EMSI capable mailer
  software.  The menu shown below prompts the user for a FIDONET style
  ZONE:NET/NODE number.

















       Page 87              AceComm (tm) v 1.81


Chapter 9  Auto Answer Setups



Auto Answer Setups
Answer/Connect - Associated macro stack
>CONNECT
 <HostEcho> <SendStr>^M^L[ACE_ID]^M^JSysop [USER_NAME], [LOCATION]^M^J^J^J^J
Answer/Connect - Associated macro stack
 FAX
 <RunProg>BGFAX /FAX %P Z
Answer/Connect - Associated macro stack


Default macro stack
 <RunProg>BGFAX /FAX %P Z
 Edit  Quit  Help <>V^



o AceComm will process a macro stack based on the Answer/Connect string

o Auto Answer mode can be toggled "On/Off" using a key press assigned the
<AutoAnswer> macro (ALT-E default)

o Auto Answer can be an EVENT, see "Event Scheduler" menu


Answer/Connect

   The sub-string will be looked for in the actual modem response string upon
   Answer/Connect Strings are currently case sensitive.


Associated macro stack

   Macro stack will be processed on "sub-string" found


Default macro stack

   Macro stack to process when sub-string search fails












       Page 88              AceComm (tm) v 1.81


Chapter 10  Event Schedules



Ŀ
 PRM-data   Sub-Menu Areas ĳ
Event Schedules
 Event 00:00-00:05,Mail
>Macro <ChgDir>c:\mail\qm <RunProg>QM scan <ChgDir>[DIR_START]
 Event 01:00-02:00,Mail
 Macro <PollBoss>
 Event
 Macro
 Event 08:00-09:00,Mail
 Macro <PollBoss>
 Event 11:30-12:00,Mail,Host
 Macro <ChgDir>c:\mail\qm <RunProg>QM toss <ChgDir>[DIR_START]
Active = Yes
 Edit  Enabled  Quit  Help <>v^



AceComm will watch the clock for any event start times.  When an event rolls
around the associated macro stack, if any will be processed.

"Mail" events tell AceComm that it is ok to process any *.FLO files contained
inside the "MAIL_OUT" directory.

"Host" events tell AceComm it is ok to Auto Answer the line when RING is
detected.  AceComm uses the UART RING bit and modem status change for detecting
RING.

see Auto Answer Setups for more information about Auto Answer




















       Page 89              AceComm (tm) v 1.81


Chapter 11  "Mondo Menus" (Tm)



o  "Mondo Menus" are user definable menus

o  "Mondo Menus" can be used to group similar macro stacks
   together into one menu

o  "Mondo Menus" can be assigned to a hot key

Master "Mondo"
   Below is the "Mondo Menu" Master menu.  (macro is <Mondos>) A
   key-press may be assigned the <Mondos> macro as a hot key for
   this menu.  It lists five "Mondo" style menus available.

   Each "Mondo Menu" can be assigned a hot key.

F10 =   File  Setup  Phone  Transfer  Mondos  Help 
                                         Ŀ
                                         >1  CIS Functions     
                                          2  OffLine Reader    
                                          3  Mondo Menu #3     
                                          4  Mondo Menu #4     
                                          5  Mondo Menu #5     
                                          Select  Quit  Help 
   Here the first two menus have been given titles.  The titles were entered
   from the setup menu discussed later on.

   The following macros can be used for the five "Mondo Menus".
      <Mondo1>
      <Mondo2>
      <Mondo3>
      <Mondo4>
      <Mondo5>

   If I want to assign a hot key to the "Mondo Menu" labeled "CIS Functions" I
   can go into the PRM-data area "Key Setup" menus and assign a key press to
   the <Mondo1> macro.

   Example:  F11 <Mondo1>



A "Mondo Menu"

   Below is a "Mondo Menu".  This one was created by the author of AceComm as
   an example.  I came up with the idea for "Mondo Menus" a week before the
   1.75 release, and so hadn't had time to document many tried-true Mondo
   setups.  The menus were designed to offer a means for grouping common macro



       Page 90              AceComm (tm) v 1.81


Chapter 11  "Mondo Menus" (Tm)

   stacks into menus.  I wanted to be able to create, change menus and menu
   items at will, as my on line needs changed.  "Mondo Menus" allow this sort
   of configuration flexibility.

   Each "Mondo Menu" has a title and seven function slots.

F10 =   File  Setup  Phone  Transfer  Mondos  Help 
                                        CIS FunctionsĿ
                                        >CIS Forums Script     
                                         CIS Bill Script       
                                         Compose Message       
                                         IBMPRO Forum 2 File   
                                         IBMCOM Forum 2 File   
                                                               
                                         CIS Msg Reference     
                                        (Select) Edit  Quit 



Setup "Mondo"

   Below is the Setup menu for creating "Mondo Menus".

"Mondo Menus" (Tm)
Title field
>- CIS Functions
Description / Associated macro stack pairs
 / CIS Forums Script
 \ <RunScript>cisforum.scr
 / CIS Bill Script
 \ <RunScript>cisbill.scr
 / Compose Message
 \ <SendAscii>%P
 / IBMPRO Forum 2 File
 \ <SendStr>go IbmPro^M <OpenCapture>ibmpro <SendStr>Read New^M
 / IBMCOM Forum 2 File
 \ <SendStr>go IbmCom^M <OpenCapture>ibmcom <SendStr>Read New^M
 /
 \
 / CIS Msg Reference
 \ <RunProg>List cis_msg.ref
(Edit) Quit  Help <>v^

Title field

   The Title field is 15 characters long, this will be the title that appears
   in you "Mondo Menu".




       Page 91              AceComm (tm) v 1.81


Chapter 11  "Mondo Menus" (Tm)

Description / Associated macro stack pairs

   "Description" fields are 20 characters, these will become the menu choices
   displayed from your "Mondo Menu".

   "Associated macro stack" fields are 80 characters, these are the actions
   that take place when you select a "Description" choice.












































       Page 92              AceComm (tm) v 1.81


Chapter 12  Mouse Support



Support for a pointer device has been implemented into AceComm using the
Microsoft Mouse Driver functions.  Your Microsoft compatible mouse should work
with AceComm.

Mouse in Terminal Area

o Pressing the left mouse button with the cursor over blank space sends <CR>.

o Pressing the left mouse button with the cursor over a character sends the
  character.

o Double clicking brings up the TopBar menu.

Mouse with Menus

   To move the vertical highlight bar in the menus, press the left mouse button
   and drag it along, the cursor will follow.  Selections can then be made from
   the lateral selector bar by highlighting the first character and pressing
   the left mouse button.






























       Page 93              AceComm (tm) v 1.81


Chapter 13  ACECOMM DATA FILES

           ACE.PRM / .CTL


ACE.PRM

  ACE.PRM is a binary file which contains all of AceComm's memory, so to
  speak.  When AceComm is started it reads the ACE.PRM file.  All your serial
  data, modem data, the keyboard assignments, menu-usage, customizing and so on
  is stored in ACE.PRM.  PRM-data Area edits the ACE.PRM data, and when
  AutoSave is "ON", all data is saved each time you leave PRM-data Area.  When
  AceComm is terminated, the PRM-data is saved to ACE.PRM.


ACE.CTL

  ACE.PRM can be rebuilt using the ACTL.EXE utility.  ACTL.EXE reads and
  formats a .CTL file into ACE.PRM.  A default .CTL file comes with the AceComm
  package.  The default filename is ACE.CTL.  Any filename is valid with the
  .CTL extension.  PRM2CTL.EXE produces "PRM2CTL.CTL" filename.
































       Page 94              AceComm (tm) v 1.81


Chapter 13  ACECOMM DATA FILES

           KTS files


.KTS/.ASC/.BIN files

  Key Translation Sequence files are used when you want a key press to be
  translated into a sequence of characters.  A good example of KTS is in the
  ANSI.KTS file.  Here, keys such as Up Arrow are defined to send an ansi
  escape sequence that the HOST'S video can read, and bounce back, decrementing
  the cursor position by 1.

  A utility KTS.EXE is provided with the AceComm package, which allows you the
  user to compile .ASC files into .KTS file.

  You can look at the included .ASC files, that come inside KTS_SFX.EXE, as an
  example to work from.  The ANSI.ASC file was compiled by KTS.EXE into
  ANSI.BIN.  ANSI.BIN is exactly the same as ANSI.KTS.  The .BIN extensions is
  used so that a working .KTS file is not overwritten.  You need to rename .BIN
  files to .KTS when ready for use.

  Notes: Keys assigned KTS are processed only if not defined in KBD.  When a
         key is assigned to a MACRO(s), the MACRO(s) take priority and are
         processed.  Do not assign MACRO(s) to key-presses you want to KTS.

  .KTS has it's directory definition optionally defined inside PRM-data area.


























       Page 95              AceComm (tm) v 1.81


Chapter 13  ACECOMM DATA FILES

           KBD files


.KBD

  KBD files give the user ability to keep more than one keyboard layout for
  AceComm operations.

  KBD KeyBoarD files contain the MACRO assignments for the keyboard.  When
  AceComm is first installed, the file "ACE_DEF.KBD" is used as a default
  keyboard (KBD).  When AceComm is started, it reads the "current" KBD file.
  Current KBD file is the default ("ACE_DEF.KBD" or the last KBD Loaded from
  inside the PRM-data menu area.

  When you "Load" a KBD file from inside PRM-data area, The KBD file becomes
  "current".  This means that any changes you make to the key definitions are
  saved to the "current" KBD file.  Updating the "current" KBD file is done
  automatically when leaving PRM-data area when "AutoSave" is "ON" (default).
  When "AutoSave" is "OFF" you need to manually select the "Save" option from
  the main PRM-data menu.  Do not confuse "Save" with "Write".  "Write" is an
  option found inside the "KeyBoarD MACRO Assignments" menu.  "Write does not
  save changes to the "current" KBD file, but prompts the user for a filename,
  and creates or overwrites a new or existing KBD file.  Then "Write" re-loads
  the "current" KBD file.

  KBD files are also used with Fon.Records.  The AceComm package comes with a
  "CIS.KBD" file example.  The ACE.FON file, also provided with the AceComm
  package, contains a record for CIS (local Phoenix).  This Fon.Record (CIS)
  has defined as a KBD file, "CIS.KBD".  When dialing a Fon.Record that
  contains a KBD file definition, AceComm will upon successful Dial/Connect,
  load the KBD file associated with the Fon.Record.  This custom KBD file is
  valid for the time that AceComm detects CARRIER (DCD), or the user loads
  another KBD file from inside the PRM-data area.  When AceComm detects that
  the Dial/Connect call is over, (DCD drops),

  AceComm will:

               Write the Fon.Record's KBD file, saving any changes that may
               have been made to it while on line.

               Re-load the KBD file that was in affect before the connection
               was established to system that had a KBD file associated with
               it's Fon.Record.

  KBD files may be associated to a Fon.Record from inside the telephone
  directory area, "Edit" option.





       Page 96              AceComm (tm) v 1.81


Chapter 13  ACECOMM DATA FILES

           REQ/FLO,LST,SCR,FON files


.REQ/FLO

  Filenames created with ".REQ" extensions are used when making File Requests
  on EMSI FIDONET style systems.  REQ files are a list of <CR> <LF> terminated
  filenames.  This REQ file is sent to the system the File Request is being
  made on, the system will send from the list.

  Filenames created with ".FLO" extensions are used for Attaching (sending)
  files to EMSI FIDONET style systems.  FLO files are a list of <CR> <LF>
  terminated filenames.  AceComm sends from the list (LISTFILE).

  .REQ/FLO has it's directory definition optionally defined inside PRM-data
  area.


.LST

  AceComm creates LISTFILES with .LST extensions.  A .LST extended LISTFILE is
  created from inside the "FileLister" (<FileLister_> macro) area.  Filenames
  "Tagged" from inside "FileLister" are stored inside a file "UPLDS.LST".
  AceComm's internal batch protocols will send from "UPLDS.LST" by default, you
  do have the option of creating another LISTFILE, or entering filenames
  manually.


.SCR

  AceComm forces ".SCR" file extensions onto script files.  Script files may be
  generated automatically using AceComm's AutoScriptGen (Tm).  Script files may
  be loaded from the terminal area, or used as AceComm's only argument when
  starting AceComm.  Script files may be associated with

  Fon.Records from inside "Edit" option.  Script files associated with a
  Fon.Record are:

  Upon successful Dial/Connect AceComm creates an "Event" just prior to exiting
  back to terminal Area.  The "Event" is to run the Script file associated with
  the Fon.Record.  Typically, this Script file will contain some auto log on
  MACROS.  The Script plays out, end of "Event"

  .SCR has it's directory definition optionally defined inside PRM-data area.


.FON




       Page 97              AceComm (tm) v 1.81


Chapter 13  ACECOMM DATA FILES

           REQ/FLO,LST,SCR,FON files (continued)

  AceComm uses a binary .FON file for storing it's telephone directory
  records.  Each record contains data specific to the system.  FON files must
  be edited inside AceComm, using The Edit menu.

  Telephone directory files are forced the ".FON" file extensions.  All
  Fon.Records are stored inside of FON files.  AceComm FON files can hold up to
  1000 records each.  AceComm allows unlimited FON files.  Selection of FON
  files is made available from inside the Fon.List area using "Fon_Files"
  option.

  .FON has it's directory definition optionally defined inside PRM-data area.






































       Page 98              AceComm (tm) v 1.81


Chapter 14  AceComm Macro Language



Reference to characters such as carriage return, space, escape, etc.  are made
in this document.  Reference to a character is made in the following manner.
<CR> <SP> where <CR> refers to a carriage return, and <SP> refers to a space
character.  Macro are bounded by the same <> brackets as character reference.
Character references are not macros.  A complete macro listing follows this
chapter.



o Macros are directives bounded inside of angle brackets < >

o Macros must have a SPACE character in front of the '<' left bracket when
    stacking.

 <ChgDir>[DIR_MAIL] <RunProg>BWAVE <ChgDir>[DIR_START]
                   |                 |
                   |_________________|
                   |
                   Leading space

o Macros may be any combination of CaSe

 <RunProg> jmodem
 <runprog> jmodem


o The MACRO PROCESSOR supports MACRO STACKING MACRO STACKING means multiple
    MACROS per line

 <SendStr>u z ACE0601.ARJ^M <SendZmo>files\ace0601.arj

 <SendStr>u z ACE0601.ARJ^M <RunProg>DSZ sz -m files\ace0601.arj

 <SetDTR> ON <SendStr>ATDT846-2940^M <WaitStr>CONNECT <SendStr>^[^[


o MACRO DATA PARAMETERS are bounded inside of square brackets [ ]

o MACRO DATA PARAMETERS need not have a <SP> character in front of them

o MACRO DATA PARAMETERS must be upper CASE

 <SendStr>[USER_NAME]^MY^M[FON_PWD]
          |          |    |
          |          |    Data Param (Fon.Record password field)
          |          |



       Page 99              AceComm (tm) v 1.81


Chapter 14  AceComm Macro Language

          |          ^M translates into a <CR> (carriage return)
          |
          Data Param (IEMSI user name field)

 <SendStr>[USER_NAME]^M~~~~[PASSWORD]^M
 |        |          |  |  |
 |        |          |  |  IEMSI password field
 |        |          |  |
 |        |          |  One second delay (~ = 1/4 second delay)
 MACRO    |          |
          |          Control character representation for <CR>
          |
          MACRO DATA PARAMETER (IEMSI data)


o MACRO FUNCTION PARAMETERS are prefixed with a % character

 <SendZmo> %PF
  |        |
  |        MACRO FUNCTION PARAMETER (prompt for filename)
  |
  Internal Zmodem sending unit

 <RunProg>dsz port %P speed %B sz %PF %WK <SendStr>^M
                      |        |     |   |
                      |        |     |   |
                      |        |     |   MACRO FUNCTION PARAM
                      |        |     |   (wait for key press)
                      |        |     |
                      |        |     MACRO FUNCTION PARAM
                      |        |     (prompt for filename)
                      |        |
                      |        MACRO FUNCTION PARAM
                      |        (insert ascii baud)
                      |
                      MACRO FUNCTION PARAM
                      (insert ascii port)



Please submit all macro suggestions to:
a)  MSG to Michael Phelps on the AceComm Support BBS
b)  MSG to Michael Phelps on Compuserve UID 75120,3306








       Page 100              AceComm (tm) v 1.81


Chapter 15  Macros list

           Local User Input (LUI) Functions





LUI MACROS require local keyboard input, and so are not suited to un-attended
scripts.  LUI MACROS contain a '_' underscore as the last character inside the
brackets.

<AutoScrGen_>

   Toggle AutoScrGen(tm) mode

   Toggle AutoScript Generation mode On/Off.  When "On" an extended status line
   will appear at the bottom of the TERMINAL screen.  At the far left of the
   extended status line will be the phrase "AutoScriptGen"


<BackBuffer_>

   Menu Area
   Enter Back Buffer Screen Area

   BackBuffer contains the last n lines of display that scrolled off the
   TERMINAL screen.  BackBuffer has a status line of it's own.  The status line
   contains such information as current line position into the buffer, total
   lines buffered, and some of the navigational keys are displayed.  Hold the
   ALT key down for the POP UP REFERENCE available for the BackBuffer area.


<CaptureFile_>

   Toggle Capture File
   Prompts for filename

   Capture will also prompt for append or overwrite.  Capture does absolutely
   NO filtering of any kind.  All data is recorded to file "as it comes in the
   port".  The AceComm package comes with separate utilities which can strip
   video control codes from files.  See also <OpenCapture> filename,
   <CloseCapture>


<CommandShell_>

   Enter Shell to Command Processor/ Operating System

   In most cases "Drop to DOS", if your DOS compatible operating system places



       Page 101              AceComm (tm) v 1.81


Chapter 15  Macros list

           Local User Input (LUI) Functions (continued)

   it's name in the environment where AceComm can find it.  "Shell" is not hard
   wired to COMMAND.COM but the COMMAND PROCESSOR as found in the environmental
   data area.


   Notes: When SWAP is "ON", the serial port is effectively disabled during the
          shell.  When SWAP is "OFF" the serial port remains active and any
          incoming data is handled properly, unless the receive buffer wraps
          around.

<FileRequest_>
   Menu driven EMSI file request function.


<FonListDialer_>

   Menu Area
   Enter .FON List / Dialer

   Dial/.FON directory area.  While AceComm allows manual dialing from inside
   the TERMINAL area, it most convenient to dial from a record contained in one
   of the .FON files available for use from the DIAL area.


<FileLister_>

   Menu Area
   Enter File Lister

   Files lister inside AceComm provides a basic directory list function capable
   of changing directories and drives.  File-marking, deletion, selection for
   appropriate file-utility, etc.  LISTFILES may be created.  UPLDS.LST is a
   file created by the Tag feature inside the File Lister Area.  files tagged
   will be listed inside UPLDS.LST as CR LF terminated strings.  When selecting
   any of AceComm's internal batch capable sending protocols, AceComm will
   check for the existent of the file UPLDS.LST and allow sending from the
   LISTFILE if desired.


<MdmHangUp_>

   Prompts Yes/no before,
   Sends PRM-data MDM_HANGUP string to modem.  Waits 1/2 second, then drops DTR
   for 1 second.

See also    <MdmHangUp> (non LUI)



       Page 102              AceComm (tm) v 1.81


Chapter 15  Macros list

           Local User Input (LUI) Functions (continued)



<PrmDataMenus_>

   Menu Area
   Enter PRM-data Menu Area

   Notes: When AutoSave is "ON", all data changed is automatically saved when
          exiting the PRM-data area.


<RProtocols_>

   Menu Area
   Enter Receive Unit Protocols Area menu


<RunScript_>

   List .SCR directory, Allow selection, Run selected .SCR file

   Lists the PRM-data .SCR directory Allows selection of a .SCR file for
   immediate execution.

   Notes: AceComm allows .SCR file as an argument when started which
          immediately executes the script.


<ScrnSnapShot_>

   Menu Area
   Take Screen Snapshot

   Create a "SnapShot" of the current screen minus any status lines active.
   Prompts for a filename.  Filenames always will have the .SNA extension.
   AceComm can detect and will strip away filename extensions provided by the
   user when they do not match that of the function.  This command is available
   from most ALT POP UP REFERENCE areas.


<ScrnTag_>

   Menu Area
   Enter Screen Tagger Screen Area

   Tagger will allow tagging to the first SPACE_CHAR or press RIGHT-ARROW



       Page 103              AceComm (tm) v 1.81


Chapter 15  Macros list

           Local User Input (LUI) Functions (continued)

   Tagger tags the entire line of text.  Tagger has it's own status line, and a
   block cursor will appear inside of the Tagger mode.  Tagged items will be
   assigned to the next available SHIFT-Fn key.

   Tagger pops up the SHIFT-Fn key window and displays each tagged item, as
   they are tagged.  Tagger is most handy for grabbing filenames for download
   off a BBS screen.  SHIFT-Fn key fires the tagged item back when ready.  This
   command is available from most ALT POP UP REFERENCE areas.


<SProtocols_>

   Menu Area
   Enter Sending Unit Protocols Area


<ViewKeyCombos>

   Bring up Pop up Reference The key press assigned this macro is always
   displayed on the right side of the status line.

   Notes: <ViewKeyCombos> macro does not have the trailing '_' in the text


<TopBar>

   Activate the menu bar at top of screen

   The key press assigned this macro is always displayed on the right side of
   the status line.

   This menu can be brought up inside the terminal area by double clicking the
   left mouse button.




The following macros can be used to call individual menus otherwise choices
from the TopBar single line menu


<FileMenu>

   The TopBar File menu





       Page 104              AceComm (tm) v 1.81


Chapter 15  Macros list

           Local User Input (LUI) Functions (continued)

<HelpMenu>

   The TopBar Help menu

   The key press assigned this macro is always displayed on the right side of
   the status line.


<Mondos>

   The TopBar Mondos menu

   This is a menu that lists and allows menu selection for the Mondo menus.
   (Mondo1 - Mondo5)


<PhoneMenu>

   Calls the <FonListDialer_> macro


<SetupMenu>

   Calls the <PrmDataMenus_> macro


<XfrMenu>

   The TopBar Transfer menu


The following individual Mondo menus can be brought up by themselves.
Otherwise they are selectable from inside the <Mondos> memu.

<Mondo1>

   This macro brings up Mondo menu # 1.

<Mondo2>

   This macro brings up Mondo menu # 2.

<Mondo3>

   This macro brings up Mondo menu # 3.




       Page 105              AceComm (tm) v 1.81


Chapter 15  Macros list

           Local User Input (LUI) Functions (continued)

<Mondo4>

   This macro brings up Mondo menu # 4.

<Mondo5>

   This macro brings up Mondo menu # 5.










































       Page 106              AceComm (tm) v 1.81


Chapter 15  Macros list

           Character I/O Functions



I/O Function Toggles

<AutoAnswer>

   PRM-data MDM_HOST_INIT is sent to the modem when hostmode flag is toggle
   "ON".  PRM-data MDM_INIT is sent to the modem when hostmode flag is toggled
   "OFF".  AceComm begins responding to the RI bit SET, and will send the
   MDM_ANSWER string to the modem when RI BIT becomes asserted.  <HostEcho>
   becomes active.  Upon Answer/Connect an attempt to match modem response
   string those defined in the Auto Answer Setup menu.

   Notes: Auto Answer is also terminated whenever the user dials out from the
          FON LIST MENU AREA.

   See your modems S7 register as an alternative.

See also   Auto Answer Setup menu


<DoorWayMode>

   Toggle doorway mode.  Saves the key press combo on entry, whatever key-combo
   you assign <DoorWayMode> to, is the only way out.  Doorway sends all key
   presses to the modem in their RAW 'un-cooked' form.  Non extended key
   presses are send LOW BYTE ONLY.  Extended key presses are sent LOW BYTE,
   HIGH BYTE.

   Notes: Pressing CONTROL BREAK will always end AceComm.  CONTROL BREAK is a
         back door to the <EndAceComm> macro.  When you exit the program by
         pressing CONTROL BREAK, all data is saved as usual, and program
         cleanup is as it would be using the <EndAceComm> macro.


<HostEcho>

   Toggle Host echo mode.  This macro emulates HostMode's ECHO capability.  It
   does not answer the phone.  However modems set up for auto answer function
   normally.

   Host echo means that characters type locally will be displayed both local
   and sent to the modem.

   Host echo will also translate <CR> into <CR><LF> pairs and <BS> into
   <BS><SP><BS>.



       Page 107              AceComm (tm) v 1.81


Chapter 15  Macros list

           Character I/O Functions (continued)



<LocalEcho>

   Toggle local character echo.  Local key-presses will be echoed to the
   screen.  (same effect as sending "ATE1^M" to the modem)



I/O Flags

Flags can be turned "On" or "OFF" with an argument to the macro

<Scheds>ON     ; enable schedules

<Scheds>OFF    ; disable schedules

<Scheds>       ; disable schedules (no arg defaults to "OFF")


<CTS> on/off

   CTS/RTS hardware handshaking.


<XON> on/off

   XON/XOFF software handshaking


<BitStrip> on/off

   Is AceComm going to turn high ascii characters (above 127d)


I/O Scripts Oriented

<DispText> LABEL_NAME

   Display text defined in a data area of a script file LABEL_NAME is
   descriptive text following {-TEXT_START-} Text is displayed at current
   cursor position Text display is local

------------snip here -------------
<ClearWindow>
<DispText>Intro
<DispText>Ask_Continue



       Page 108              AceComm (tm) v 1.81


Chapter 15  Macros list

           Character I/O Functions (continued)

:GetKey
<GetKey>
   <if>Y
   <goto>Dial
   <if>N
   <goto>End
   <goto>GetKey
:Dial
<INITFONREC>ACECOMM Support BBS      ; Initialize a FON RECORD
<FON_NUM>1-602-846-2940            ;
<FON_BAUD>19200                    ;
<FON_TERM>Av/An                    ;
<FON_REDIAL>                       ; Go into re dial mode
<DispText>Connect
<WAITSTR> your name:
<GetDCD>                           ; <WaitStr> may have timed
   <if>1                           ; out
   <goto>Connect
   <goto>Dial
:Connect
<SENDSTR>Michael Phelps^M
<SENDSTR>Y^M
<SENDSTR>password^M
<WAITSTR>Select:
<SENDSTR>ff
:End
<ENDS>


{-DATA_AREA-}
{-TEXT_START-}Intro
-- Generic Log On Script --
{-TEXT_END-}
{-TEXT_START-}Ask_Continue
Continue (Y/n) {-TEXT_END-}

{-TEXT_START-}Connect
-- Connect --
{-TEXT_END-}
------------snip here -------------


<LocalKeys> on/off

   Enable/disable local LUI key press during script (host mode)




       Page 109              AceComm (tm) v 1.81


Chapter 15  Macros list

           Character I/O Functions (continued)


<SendStr> STRING

   Sends a string to the modem.

       <SendStr>^M

       Send a single CR_CHAR


       <SendStr> Michael Phelps^M

       Notes: the leading SPACE_CHAR part of STRING


      <SendStr>[USER_NAME]^M~~~~Y^M~~~~[FON_PWD]

       Send IEMSI data user name field, a <CR> char, 1 second pause, Y, <CR>
       char, 1 second pause, current Fon.Record.Password.


      <SendStr>[USER_NAME]^M^M[PASSWORD]^M

       Send IEMSI data user name field, 2 <CR> chars, IEMSI data password
       field.



<WaitStr> STRING

   Waits for a CASE sensitive string (sequence of characters) to come in the
   from the modem.  Can TIMEOUT.

   Notes: The example below contains a SPACE_CHAR as the first character of
          STRING.

          <WaitStr> name:


   Arguments to MACROS are taken as is, up until the first <CR> on the line of
   text.

   A normal text editor in ASCII TEXT mode will have placed the CR_CHAR as the
   byte following the ':' character in the example STRING below ' name:'.  File
   Functions internal to AceComm will filter the leading SPACE_CHAR from the
   MACRO ARG.



       Page 110              AceComm (tm) v 1.81


Chapter 15  Macros list

           Character I/O Functions (continued)



<WaitTime> n

   Where n is in seconds Set the timeout value for <WaitStr> (default is 40
   seconds)











































       Page 111              AceComm (tm) v 1.81


Chapter 15  Macros list

           Flags



Protocols Flags


<AutoD> on/off

   Enable/disable auto engage sequence scanning for protocols

   Does not affect auto logons


<Resume> on/off

   Enable/disable file resume (internal zmodem receive)


<Rename> on/off

   Enable/disable file rename (internal zmodem receive)



General Flags


<SwapSpawn> on/off

   Enable/disable swap to EMS/XMS/DISK for <RunProg> macro


<SwapShell> on/off

   Enable/disable swap to EMS/XMS/DISK for <CommandShell_> macro


<DTRExit> on/off

   DTR state for <EndAceComm> macro


<Scheds> on/off

   Enable/disable scheduler





       Page 112              AceComm (tm) v 1.81


Chapter 15  Macros list

           Flags (continued)








<CapMode> Text/Raw

   <CapMode>Raw <OpenCapture>xmas.ans

   Captured data will be stored with or without video control characters.  The
   current video emulation must mach that of the host.


<ChgDir> FILENAME

   Make FILENAME current directory
   This macro can change drives

   <ChgDir>C:\WORK\TXT <ToPrn>melissa.01 <ChgDir>[DIR_START]

   Notes: [DIR_START] is the directory Acecomm is started in.


<CloseCapture>

   Close the current open capture file, or just returns if none is open.

   Capture files a re stamped with date/time when closed.

   Capture files are automatically closed on detection of a loss in carrier.


<FileDel> FILENAME

   If the file exists, it will be deleted without prompt.  Use full path name
   if not in current directory.


<OpenCapture> filename

   Calling this function opens a capture file in the directory path defined
   inside PRM-data Area "Directories" menu, .CAP files.

   Existing capture files are appended to.  DOS eof character may end up just



       Page 113              AceComm (tm) v 1.81


Chapter 15  Macros list

           File Functions

   ahead of the time stamp.

   This function will first close an open capture file, properly saving it to
   disk.

   Capture files are stamped with date/time when opened.


   See <CapMode> macro in I/O Flags


<RunScript> FILENAME

   Open and run FILENAME

   Notes: Just FILENAME no PATH.  PATH found in PRM-data for SCR directory is
           used.


<RunProg> FILENAME

   Spawn an executable file.

   Can search the DOS PATH.

   Can determine files's extension (.COM, .EXE).

   All system ISRS are restored before the spawn takes place.  The serial port
   is un-hooked.  The state of DCD, and LINE CONTROL are left in tact.

   After the spawn the system ISRs AceComm uses are taken back, the serial port
   is re-assumed.

   SWAP FLAG "ON" and XMS,EMS, or DISK swapping takes place.  SWAP FLAG "OFF"
   and AceComm is left in memory, with exception to first restoring the serial
   port and interrupts.


<SetFonFile> FILENAME

   Tacks FILENAME onto the PATH defined in PRM DATA for .FON files.  AceComm
   keeps track of the current(last accessed) .FON file.  FILENAME becomes the
   current .FON file.  <SetFonFile> 1_114.fon <DialRecord> 1


<ToPrn> FILENAME



       Page 114              AceComm (tm) v 1.81


Chapter 15  Macros list

           File Functions (continued)


   Send FILENAME tom the printer.

   Notes: This macro opens the filename PRN using DOS file handle function, and
          writes the file.  Any character translation DOS may do will depend
          upon the IOCTL functions of DOS.  (eof etc.)











































       Page 115              AceComm (tm) v 1.81


Chapter 15  Macros list

           Data Transfer functions




<SendASCII> C:\MSG\COMM\ASCII.TX1

   Outputs from a file to the modem.  Sends the complete file.  Does *NO*
   CONTROL CHARACTER TRANSLATION.  Data sent to the modem is paced for buffer
   FULL, and all handshaking is valid.

   ESC-key press aborts the function.


<SendZmo> FILENAME

   Call internal zmodem sending unit with 1k data frame size.

   ESC-key press aborts the function.


<RecvZmo>

   Call internal zmodem recv unit.  AceComm's internal zmodem receiver is
   capable of up to 8k data frame size.  The receive unit will continue in
   batch mode until the sender stops sending files, or the user terminates the
   transfer.  Files are placed into the directory pointed to in the PRM-data
   area for Downloads.

   ESC-key press aborts the function.


<SendYmo> FILENAME

   Call internal ymodem sending unit with 128 byte data frame size.

   ESC-key press aborts the function.


<SendYmo1k> FILENAME

   Call internal ymodem sending unit with 1k data frame size.

   ESC-key press aborts the function.


<SendYmoG> FILENAME




       Page 116              AceComm (tm) v 1.81


Chapter 15  Macros list

           Data Transfer functions (continued)

   Call internal ymodemG sending unit with 1k data frame size.

   ESC-key press aborts the function.


<SendXmo> FILENAME

   Call internal xmodem sending unit with 128 byte data frame size.

   ESC-key press aborts the function.


<SendXmo1k> FILENAME

   Call internal xmodem sending unit with 1k data frame size.

   ESC-key press aborts the function.


<RecvYmo>

   Call internal ymodem.  The receive unit will continue in batch mode until
   the sender stops sending files, or the user terminates the transfer.  Files
   are placed into the directory pointed to in the PRM-data area for Downloads.

   ESC-key press aborts the function.


<RecvYmo1K>

   Call internal ymodem1K.  The receive unit will continue in batch mode until
   the sender stops sending files, or the user terminates the transfer.  Files
   are placed into the directory pointed to in the PRM-data area for Downloads.

   ESC-key press aborts the function.


<RecvYmoG>

   Call internal ymodemG.  The receive unit will continue in batch mode until
   the sender stops sending files, or the user terminates the transfer.  Files
   are placed into the directory pointed to in the PRM-data area for Downloads.

   ESC-key press aborts the function.





       Page 117              AceComm (tm) v 1.81


Chapter 15  Macros list

           Data Transfer functions (continued)

<RecvXmo> FILENAME

   Call internal xmodem.  Files are placed into the directory pointed to in the
   PRM-data area for Downloads.

   ESC-key press aborts the function.


<RecvXmo1K> FILENAME

   Call internal xmodem1k.  Files are placed into the directory pointed to in
   the PRM-data area for Downloads.

   ESC-key press aborts the function.


<SendEMSI_CLI>

   Send an EMSI_CLI HDR sequence to modem

   BBS mailer front ends that use EMSI handshake protocol will, if EMSI is
   implemented properly, interpret an "EMSI_CLI" HDR sequence, as "this is a
   human caller" and drop to the BBS without any delay.  Note: At this writing
   Front Door, and Binkley recognize EMSI_CLI HDR.  DBridge does not.  See
   default AutoD trigger assignments (ACE.CTL)


<SendEMSI_ICI>

   Send an EMSI_ICI data packet to modem

   EMSI_ICI is a response made by the caller (CLIENT) to a BBS system (HOST)
   which supports Interactive EMSI handshake protocol.  IEMSI data is contained
   inside the PRM-data area.  This data can be used for automating log on when
   call a BBS that supports IEMSI.  See default AutoD trigger assignments
   (ACE.CTL)



Notes: Xmodem/Ymodem Receive units are capable of adopting to frame size.
       128 / 1024 data frames are determined by the sender and can be sent in
       any combination.

       The Internal Zmodem in AceComm is capable of up to 8k data frames.  For
       compatibility, AceComm only uses larger than 1k data frames with it's
       sending unit in mailer modes.  AceComm's zmodem receive unit can handle



       Page 118              AceComm (tm) v 1.81


Chapter 15  Macros list

           Data Transfer functions (continued)

       up to 8k data frames at any time.
       The internal zmodem can make filename management decisions based on the
       status of option flags for "resume" and "rename".














































       Page 119              AceComm (tm) v 1.81


Chapter 15  Macros list

           Modem/Dialing/Fon.Record



Modem/Dialing


<DialNum> PHONE_NUMBER

   Builds a dial string.  Uses PRM-data MDM_DIAL_PREFIX and PHONE_NUMBER Sends
   the dial string to the modem.  One time.  No re dials as this will typically
   take place from terminal area.


<DialRecord> n

   Retrieves the n record found in current .FON file

   Re dials number until CONNECT or USER ABORT

       <SetFonFile> 1_114.FON <DialRecord> 1


<GetDCD>

   Returns 0 or 1 current carrier detect signal
:DIAL
   ...
   <GetDCD>
   <if>1 <goto>CONNECT
         <goto>DIAL
   ...
:CONNECT


<Fon_Redial>

   Presents the FON record to the AceComm re dial function.  See "Fon.Record"
   macros below


<MdmHangUp>

   Sends PRM-data MDM_HANGUP string to modem.  Waits 1/2 second, then drops DTR
   for 1 second.


<PollBoss>



       Page 120              AceComm (tm) v 1.81


Chapter 15  Macros list

           Modem/Dialing/Fon.Record (continued)


   This macros take BOSS data and builds a FLO file.  The macro then creates a
   Fon.Record with the BOSS info and goes into mailer mode.  If the connect is
   un-successful or aborted, the FLO file still exits in the MAIL OUT
   directory.  Any schedule that allows mail will see the FLO file and cause
   the system to be polled again.


<SetDTR> on/off

   SET or RESET UART BIT

        <SetDtr> OFF




Fon.Record


<InitFonRec> RECORD NAME

   This MACRO must be called first.  The MACRO initializes a FON RECORD with
   AceComm defaults.  RECORD NAME is copied into the system name for this
   record.

      <InitFonRec> Compuserve


<Fon_Num> PHONE_NUMBER

   Set the phone number field.  Any dial statements in ACE.CFG will be applied
   to this number when AceComm builds the dial string.

      <Fon_Num>468-0285


<Fon_Baud>BAUD

   If using a locked port, AceComm will ignore this value when getting ready to
   dial.

      <Fon_Baud>19200


<Fon_LineCtrl> DATA_PARITY_STOPBIT



       Page 121              AceComm (tm) v 1.81


Chapter 15  Macros list

           Modem/Dialing/Fon.Record (continued)


   Valid parameters are as follows
         8n1
         7e1
         7n1

      <Fon_LineCtrl>8n1


<Fon_Flags> FLAG, FLAG

   Possible Control Flags

   "Script" when set,

   AceComm will attempt to load and run the filename defined next to "AutoLogOn
   Script".  If a script file is not found, AceComm ignores the error and
   continues normal operation.

   Notes: .SCR files are looked for in the directory defined inside PRM-data
           Area "Directories"


   "Macro"  when  set,

   AceComm will enable the defined Auto Log on Sequence Triggers and
   corresponding MACRO stacks.


   "DTag"  when  set,

   AceComm will tag un-successful dial attempts (busy, etc.) to the Que
   Dialer.  An "*" character appears to the left of a Fon.Record's display
   line, when it is either Q tagged or, D tagged.  When this flag is not set,
   the only other way to Q tag a record is by manually selecting the menu
   option "<SPACEBAR>-Que" from the fon list display.


   "Capture" when  set,

   When this flag is selected, a capture file is opened upon
   Dial/Connect.  Any previously open capture file is first
   closed.


   "Raw"  when set,



       Page 122              AceComm (tm) v 1.81


Chapter 15  Macros list

           Modem/Dialing/Fon.Record (continued)


   Data to capture file is as it comes in from the modem


   "Text"  when set,

   Data to capture file is filtered of video control codes
   as applicable to the current Video type


   "IEMSI"  when  set,

   Allow Interactive EMSI log on

  "AutoL"

  Allow auto log on methods (script/macro)


<Fon_Term> VIDEO_TYPE

      - Valid parameters are as follows

        TTY
        Ansi
        Avatar
        Av/An
        VT102

      <Fon_Term>Av/An


<Fon_CapFile> FILENAME


<Fon_Redial>

   Presents the FON record to the AceComm re dial function.











       Page 123              AceComm (tm) v 1.81


Chapter 15  Macros list

           Misc Functions




<Alarm> SECONDS

   Sound alarm for SECONDS


<BbsEndAceComm>

   This macro will Exit AceComm with an errorlevel based on the current baud
   setting.  Baud is taken from the UART, and if the port is locked, will vary
   from the connect speed.

   Errorlevel is decimal of the first 2 ascii decimal digits of the current
   UART baud setting.

   DTR state is left as is.

   Errorlevels returned are:
                             57 - 57600
                             38 - 38400
                             19 - 19200
                             96 -  9600
                             48 -  4800
                             24 -  2400
                             12 -  1200
                             30 -   300
   Sample use:
:Start
   echo off
   ace
   if errorlevel 96 goto error96
   if errorlevel 57 goto error57
   if errorlevel 48 goto error48
   if errorlevel 38 goto error38
   if errorlevel 24 goto error24
   if errorlevel 19 goto error19
   goto start
:error57
   BBS.EXE 57600
   goto Start
:error38
   BBS.EXE 38400
   goto Start
:error19



       Page 124              AceComm (tm) v 1.81


Chapter 15  Macros list

           Misc Functions (continued)

   BBS.EXE 19200
   goto Start
:error96
   BBS.EXE 9600
   goto Start
:error48
   BBS.EXE 4800
   goto Start
:error24
   BBS.EXE 2400
   goto Start
:error12
   BBS.EXE 1200
   goto Start
:End


<ClearWindow>

   Clear screen. Clears screen above status line


<Delay> SECONDS

   Create program function delay.


<EndAceComm> ERRORLEVEL

   <EndAceComm> 0
   AceComm session end with errorlevel

   Exit AceComm back to the operating system.  End AceComm session.  A QUICK
   snap, no prompt "Are you sure?".  If your on line, your still on line when
   you come back unless "drop DTR on exit is SET"

   See Drop DTR on EXIT flag inside Terminal Area Options

   Notes: Pressing CONTROL BREAK will always end AceComm.  CONTROL BREAK is a
         back door to the <EndAceComm> macro.  When you exit the program by
         pressing CONTROL BREAK, all data is saved as usual, and program
         cleanup is as it would be using the <EndAceComm> macro.


<RingBell> SECONDS




       Page 125              AceComm (tm) v 1.81


Chapter 15  Macros list

           Misc Functions (continued)

   A value of 0 does not ring bell, a value of 1 plays a victory tune, values
   from 2 - 30 ring the internal bell for the number of seconds.  This is the
   same bell sound heard in the Dial/Connect window.



<Wait_To_HHMM> hh:mm

   Wait until hour:minute 24 hour format leading zeros not needed

           <Wait_To_HHMM>4:10    is valid

   Sample use:

    <Wait_To_HHMM>15:45                ; wait till 3:45 pm
    <INITFONREC>A.C.E. Software Support; call Init FON function
    <FON_NUM>1-602-846-2940            ; set phone number
    <FON_BAUD>2400
    <FON_TERM>Av/An                    ; video type for script
    <FON_REDIAL>                       ; call redial function
    <WAITSTR>it a few moments.

    <SENDSTR>^M
    <WAITSTR>s your name:
    <SENDSTR>Michael Phelps^M
    <WAITSTR>ael Phelps [Y,n]?
    <SENDSTR>^M
    <WAITSTR>Password:
    <SENDSTR>melissa_jean^M
    <WAITSTR>Select:
    <SENDSTR>f^M
    <SENDSTR>d^Mz^Mace170.arj^M
    <RecvZmo>
    <WAITSTR>Select:
    <SENDSTR>gyn^M
    <ENDS>
    <ENDS>

   Mark the end of a script.











       Page 126              AceComm (tm) v 1.81


Chapter 16  MACRO Parameter Macros

           Expandable PRM-data Macros



o MACRO parameters are UPPER case only

Fon.Records


[FON_PWD]

   Replaced with the current Fon.Record "password"


[FON_ALIAS]

   Replaced with the current Fon.Record "alias"


[FON_ID]

   Replaced with the current Fon.Record "ID"


[FON_CAP]

   Replaced with the current Fon.Record CAPTURE "filename"


[FON_SCR]

   Replaced with the current Fon.Record SCRIPT "filename"





PRM-data IEMSI


[USER_NAME]

   Replaced with the current PRM-data/IEMSI "User Name"

      <SendStr> [USER_NAME]


[ALIAS]



       Page 127              AceComm (tm) v 1.81


Chapter 16  MACRO Parameter Macros

           Expandable PRM-data Macros (continued)


   Replaced with the current PRM-data/IEMSI "alias"


[LOCATION]

   Replaced with the current PRM-data/IEMSI "location"


[DATA_PNUM]

   Replaced with the current PRM-data/IEMSI "data #"


[VOICE_PNUM]

   Replaced with the current PRM-data/IEMSI "voice #"


[PASSWORD]

   Replaced with the current PRM-data/IEMSI "password"


The following are data from PRM-data DIRECTORY section





PRM-data Directories


[DIR_START]

   Replaced with the current PRM-data/DIR "start up"
   This is the directory AceComm is started in.


[DIR_FON]

   Replaced with the current PRM-data/DIR ".FON"


[DIR_CAP]




       Page 128              AceComm (tm) v 1.81


Chapter 16  MACRO Parameter Macros

           Expandable PRM-data Macros (continued)

   Replaced with the current PRM-data/DIR ".CAP"


[DIR_SCR]

   Replaced with the current PRM-data/DIR ".SCR"


[DIR_KTS]

   Replaced with the current PRM-data/DIR ".KTS"


[DIR_DNLDS]

   Replaced with the current PRM-data/DIR "dnlds"

<ChgDir> [DIR_DNLDS] <RunProgram>DSZ rz -mr <ChgDir> [DIR_START]


[DIR_NODELIST]

   Replaced with the current PRM-data/DIR "nodelist"


[DIR_MAILIN]

   Replaced with the current PRM-data/DIR "mail_in"

[DIR_MAILOUT]

   Replaced with the current PRM-data/DIR "mail_out"





PRM-data Modem


[MDM_INIT]

   Replaced with the current PRM-data/MDM "init"


[DIAL_PREFIX]



       Page 129              AceComm (tm) v 1.81


Chapter 16  MACRO Parameter Macros

           Expandable PRM-data Macros (continued)


   Replaced with the current PRM-data/MDM "dial prefix"


[DIAL_SUFFIX]

   Replaced with the current PRM-data/MDM "dial suffix"


[ANSWER]

   Replaced with the current PRM-data/MDM "answer"


[HANGUP]

   Replaced with the current PRM-data/MDM "hangup"


[OFFHOOK]

   Replaced with the current PRM-data/MDM "off hook"


[ABORT]

   Replaced with the current PRM-data/MDM "abort"


[RESET]

   Replaced with the current PRM-data/MDM "reset"


[ECHO]

   Replaced with the current PRM-data/MDM "echo"


[HOST_INIT]

   Replaced with the current PRM-data/MDM "host init"


[CMD_LINE_TERMINATOR]




       Page 130              AceComm (tm) v 1.81


Chapter 16  MACRO Parameter Macros

           Expandable PRM-data Macros (continued)

   Replaced   with   the   current   PRM-data/MDM  "command  line
   terminator"















































       Page 131              AceComm (tm) v 1.81


Chapter 16  MACRO Parameter Macros

           Expandable Macro Functions




o  Expandable MACRO Functions are UPPER case only

%B
   Insert ascii baud, %B is replaced with current baud setting in ascii
   format.  Current baud setting is UART line speed, if the port is locked,
   this will differ from the modem connect speed.

%P
   Insert ascii port, %P is replaced with current port number is ascii format.
   Port number is 1 based (com1 =1, com2 =2)

%FN   (Valid when used from <FileLister_>)

   Use from File Lister Area, %FN is replaced with currently "highlighted"
   filename.

%PF
   Prompt for filename, %PF is replaced with what you type into the prompt box.

%WK

   Wait for Key press, stops MACRO execution and waits for a key press.
























       Page 132              AceComm (tm) v 1.81


Chapter 17  Scripts







AceComm generates script files automatically when running in AutoScriptGen
mode.  The macro <AutoScrGen_> puts AceComm into AutoScriptGen mode.  AceComm
default keyboard file ACE_DEF.KBD assigns ALT-A to <AutoScrGen_>.


AutoScriptGen first prompts for a filename to use for the script file.  The
extension .SCR will automatically be appended.

Input Window
Enter filename, <ENTER> alone when done, ESC-abort
>=> D:\ACE\CSERVE


Having a filename, AutoScriptGen creates the file and waits for activity.  We
want to call out.  Lets bring up the FON directory and select Compuserve.

 Telephone_directory fon\ACE.FON, 9 Records
      System Name              Phone Number     Line Control V
 1    AceComm Support BBS      1-602-846-2940     19200,8N1   A
>2    CIS (local phoenix 9600) 468-0285           19200,7E1   A
 3    CIS (phones)             1-800-346-3247     2400,7E1    A
 4    Comp USA #2              1-214-620-7993     19200,8N1   A
 5    Supra Modem BBS          1-503-967-2444     19200,8N1   A
 6  - Comput Connections (PCB) 1-202-547-2008     19200,8N1   A
 7  - Comp USE (Dallas TX)     1-214-620-2255     19200,8N1   A
  Dial  Edit  <SPACEBAR>-Que  Circling_dial_queue  Fon_files  S
 Add_record  Remove_record  UnMark_All  Import  Paint  Quit  H

AutoScripGen will write Fon.Record information to the script file in the form
of macro commands.

Below is a simple script file produced by AutoScriptGen.  The first 5 lines are
a result of having selected a Fon.Record to dial from inside the dialing area.
AutoScriptGen has used 4 macro commands to initialize a Fon.Record and a 5'th
macro to call the continuous dialer function.

FILE: CSERVE.SCR

------------snip here -------------
<INITFONREC>CIS (local phoenix 9600)
<FON_NUM>468-0285
<FON_BAUD>19200



       Page 133              AceComm (tm) v 1.81


Chapter 17  Scripts

           AutoScriptGen (Tm)

<FON_TERM>Av/An
<FON_REDIAL>
<SENDSTR>^M
<WAITSTR>Host Name:
<SENDSTR>cis^M
<WAITSTR>User ID:
<SENDSTR>75120,3306^M
<WAITSTR>Password:
<SENDSTR>cis/pwd^M
<WAITSTR>er choice number !
<SENDSTR>go ibmpro^M
<WAITSTR>Press <CR> !
<SENDSTR>^M
<OPENCAPTURE>ibmpro
<WAITSTR>Enter choice !
<SENDSTR>READ NEW^M
<WAITSTR>ress <CR> !
<SENDSTR>^M
<CLOSECAPTURE>
<WAITSTR>Enter choice !
<SENDSTR>off^M
<WAITSTR>Host Name:
<SENDSTR>off^M
<ENDS>
------------snip here -------------

The following example has been used by the author successfully (remember to
insert your password)

Example CIS Billing
------------snip here -------------
<ClearWindow>
<DispText>Intro
<INITFONREC>CIS (local phoenix 9600)
<FON_NUM>468-0285
<FON_LINECTRL>7E1
<FON_BAUD>19200
<FON_TERM>Av/An
<FON_FLAGS>Macro,IEMSI,
<FON_REDIAL>
<LocalKeys>On
<WaitTime>10
<SENDSTR>^M
<SENDSTR>^M
<WAITSTR>Host Name: <SENDSTR>cis^M
<WAITSTR>User ID: <SENDSTR>75120,3306^M



       Page 134              AceComm (tm) v 1.81


Chapter 17  Scripts

           AutoScriptGen (Tm) (continued)

<WAITSTR>Password: <SENDSTR>password/here^M
<WaitTime>20
<WAITSTR>choice number ! <SENDSTR>2^M
<WAITSTR><CR> for more ! <SENDSTR>8^M
<WAITSTR>Enter choice ! <SENDSTR>2^M
<WAITSTR>Enter Choice ! <SENDSTR>2^M <OPENCAPTURE>CISBILL.CAP
<WAITSTR><CR> for more ! <SENDSTR>^M
<WAITSTR>Last page ! <SENDSTR>^M
<WAITSTR>Enter Choice ! <SENDSTR>3^M
<WAITSTR><CR> for More ! <SENDSTR>^M
<WAITSTR>Last Page ! <SENDSTR>^M
<WAITSTR>Enter Choice ! <SENDSTR>4^M
<WAITSTR>Last Page ! <SENDSTR>^M
<WAITSTR>Enter Choice ! <CLOSECAPTURE> <SENDSTR>off^M
<WAITSTR>Host Name: <SENDSTR>off^M
<ENDS>
{-DATA_AREA-}
{-TEXT_START-}Intro
-- Compuserve Billing Information --

   This script captures the current months charges, and a review of the last
   svereal months billing to a capture file "CISBILL.CAP" The script then logs
   off.  The script could be interupted if you have CIS configured to display
   mail and other anouncements on login.

{-TEXT_END-}
------------snip here -------------


The following example has been used by the author successfully (remember to
insert your password)

Example CIS Forums
------------snip here -------------
<ClearWindow>
<DispText>Intro
<INITFONREC>CIS (local phoenix 9600)
<FON_NUM>468-0285
<FON_LINECTRL>7E1
<FON_BAUD>19200
<FON_TERM>Av/An
<FON_REDIAL>
<SENDSTR>~~~~~~~~~^M
<WAITSTR>Host Name: <SENDSTR>cis^M
<WAITSTR>User ID: <SENDSTR>75120,3306^M
<WAITSTR>Password: <SENDSTR>password/here^M




       Page 135              AceComm (tm) v 1.81


Chapter 17  Scripts

           AutoScriptGen (Tm) (continued)

<WAITSTR>er choice number ! <SENDSTR>go share^M
<WAITSTR>Press <CR> ! <SENDSTR>^M
<WAITSTR>Enter choice ! <OPENCAPTURE>share <SENDSTR>READ NEW^M
<WaitTime>500 <WAITSTR>ress <CR> ! <SENDSTR>^M
<WAITSTR>Enter choice ! <CLOSECAPTURE>

<SENDSTR>go ibmcom^M
<WAITSTR>Press <CR> ! <SENDSTR>^M
<WAITSTR>Enter choice ! <OPENCAPTURE>ibmcom <SENDSTR>READ NEW^M
<WaitTime>500 <WAITSTR>ress <CR> ! <SENDSTR>^M
<WAITSTR>Enter choice ! <CLOSECAPTURE>

<SENDSTR>go ibmpro^M
<WAITSTR>Press <CR> ! <SENDSTR>^M
<WAITSTR>Enter choice ! <OPENCAPTURE>ibmpro <SENDSTR>READ NEW^M
<WaitTime>500 <WAITSTR>ress <CR> ! <SENDSTR>^M
<WAITSTR>Enter choice ! <CLOSECAPTURE>

<SENDSTR>off^M
<WAITSTR>Host Name:
<SENDSTR>off^M
<ENDS>
{-DATA_AREA-}
{-TEXT_START-}Intro
-- Compuserve Forums --

   This script captures the new messages for 3 forums.  SHARE, IBMCOM, and
   IBMPRO.  The forums are captured to 3 separate files.  SHARE.CAP,
   IBMCOM.CAP, and IBMPRO.CAP.  The script then logs off.  The script could be
   interupted if you have CIS configured to display mail and other anouncements
   on login.

{-TEXT_END-}
------------snip here -------------















       Page 136              AceComm (tm) v 1.81


Chapter 17  Scripts

           Conditionals, Labels, Gotos, Data Area



         :Label
            Labels begin with ':' character
            Labels are used as arguments to the <goto> macro

         <goto> label
            "Label"  can be defined any where in the script file, either
            before or after a <goto> macro.

         <if> condition
            AceComm supports a set of conditional macros. Conditional
            macros return either 1 or 0.

         {-DATA_AREA-}
            Defines a data area

         {-TEXT_START-}
          see examples
         {-TEXT_END-}


            {-Data_ Area-} will be covered extensively next month with
            many complex scripts as well as complete documentation.

            The following script introduces some un-documented script
            language features.


            Follows is a basic script which includes a data area.

         ------------snip here -------------
         <ClearWindow>
         <DispText>Intro
         <DispText>Ask_Continue
         :GetKey
         <GetKey>
            <if>Y
            <goto>Dial
            <if>N
            <goto>End
            <goto>GetKey
         :Dial
         <INITFONREC>ACECOMM Support BBS      ; Initialize a FON RECORD
         <FON_NUM>1-602-846-2940            ;
         <FON_BAUD>19200                    ;



       Page 137              AceComm (tm) v 1.81


Chapter 17  Scripts

           Conditionals, Labels, Gotos, Data Area (continued)

         <FON_TERM>Av/An                    ;
         <FON_REDIAL>                       ; Go into re dial mode
         <DispText>Connect
         <WAITSTR> your name:
         <GetDCD>                           ; <WaitStr> may have timed
            <if>1                           ; out
            <goto>Connect
            <goto>Dial
         :Connect
         <SENDSTR>Michael Phelps^M
         <SENDSTR>Y^M
         <SENDSTR>password^M
         <WAITSTR>Select:
         <SENDSTR>ff
         :End
         <ENDS>


         {-DATA_AREA-}
         {-TEXT_START-}Intro
         -- Generic Log On Script --
         {-TEXT_END-}
         {-TEXT_START-}Ask_Continue
         Continue (Y/n) {-TEXT_END-}

         {-TEXT_START-}Connect
         -- Connect --
         {-TEXT_END-}
         ------------snip here -------------



------------snip here -------------
    <Wait_To_HHMM>15:45                ; wait till 3:45 pm
    <INITFONREC>A.C.E. Software Support; call Init FON function
    <FON_NUM>1-602-846-2940            ; set phone number
    <FON_BAUD>2400
    <FON_TERM>Av/An                    ; video type for script
    <FON_REDIAL>                       ; call redial function
    <WAITSTR>it a few moments.

    <SENDSTR>^M
    <WAITSTR>s your name:
    <SENDSTR>Michael Phelps^M
    <WAITSTR>ael Phelps [Y,n]?
    <SENDSTR>^M
    <WAITSTR>Password:



       Page 138              AceComm (tm) v 1.81


Chapter 17  Scripts

           Conditionals, Labels, Gotos, Data Area (continued)

    <SENDSTR>melissa_jean^M
    <WAITSTR>Select:
    <SENDSTR>f^M
    <SENDSTR>d^Mz^Mace170.arj^M
    <RecvZmo>
    <WAITSTR>Select:
    <SENDSTR>gyn^M
    <ENDS>
    <ENDS>
------------snip here -------------







































       Page 139              AceComm (tm) v 1.81


Chapter 18  Whats New?



=============================================================
1/16/94 * Release version 1.81
=============================================================
   Some of the setup files have been changed to make the
   default installation easier to use.

- Point mail functions using BOSS info were needlessly aborting
  when NODELIST or NLIST.IDX files were not available.
- Auto Logon was scanning the first 10 fields and ignoring the last
  six.
=============================================================
12/26/93 * Release version 1.8
=============================================================

Update made for 1.8 include:

  AceComm is written in 100% assembly language.  This is how the EXE file
  remains so small.  The movement for menu data to a separate binary file is in
  the workings, this will allow for memory savings, multiple language support,
  and to a limited degree, user customizing.  AceComm for MS-Windows is coming
  along nicely, and like the DOS version, written in assembly language.  The
  GUI version featuring RIPscrip video will be available to registered users
  by March of 94. Those wishing to see pre-release copies can get them.
  Int 14h and FOSSIL support will be seen in a 1.86 release very soon. I have
  them implemented, haven't enabled them yet. I may tie an interrupt handler
  to buffer int 14h, as it's dog gone slow using BIOS the way they are.

- Fixed dialer timeout to recycle where values 60 seconds and greater would not
  timeout, but require a modem response in order to recycle.

- Zmodem receiver file management functions in a more expected manor.  User
  aborts would end with the file time not being updated to the file time sent by
  the remote.  This caused a later resume to be renamed instead.  ACE.DOC
  covers the logic behind file management used with Acecomm's internal zmodem.

- Script/macro processor gets attention every release, this area is very robust
  now.  The scrip language continues to inch along, what is here is very solid.

- AutoScrGen does a better overall job and can handle systems using HOT keys.

- Macro language evolves with each release.  The macro language and scripts
  capability will see the most attention from version to version.

- Terminal emulations saw some minor additions. These always get added to and
  tweaked every version.




       Page 140              AceComm (tm) v 1.81


Chapter 18  Whats New?

- Event schedules are more on line aware, and there is an enable flag where the
  schedules can be turned off completely.

- ACTL (assemble CTL) and PRM2CTL (dis-assemble PRM) utilities are more data
  aware.  The PRM file can be almost 100% cloned across versions.

- LISTFILE prompting for batch uploads will now search the directory for all
  LISTFILES and prompt the user "Send from this file Y/n)" before defaulting to
  the menu.  This allows multiple LISTFILES be ready to go, and used on the
  fly, greatly improving the fast up load selection process.

- Point mail services saw a lot of work and those using pre-release versions
  are getting good results with the scheduler and <PollBoss> macros.

- MDMI.EXE is included for the first time with this release.  MoDeM Install
  will read from an ascii format file of modem definitions.  The file can grow,
  MDMI.EXE will be able to use it as it grows.

- Mouse handler was re-written. Mouse support is much more flexible. Double
  click in terminal mode brings up the TopBar menu.

- KTS key definitions somehow got behind KBD definitions. KTS are back to
  getting first crack at a key press.

- Xmodem was not opening file for 1.75, but dumping to the screen. 1.76 fixed
  this.
  Both Xmodem and Ymodem (G) saw a lot of attention. Mostly YmodemG. This
  protocol is not using file management that the Zmodem uses.

- Fixed a problem where writing the AceComm prompt to the DOS prompt when
  shelling to command processor, AceComm would overwrite any environment
  variables that were defined after the prompt. This will be a noticeable fix
  for many. This caused AceComm to lose it's ability to run programs if any
  PATH statement followed the prompt string.

- A trend for menus to become user definable is in the works. It just seems
  to evolve this way since I wanted to move all the text out to an edit able
  area anyway.













       Page 141              AceComm (tm) v 1.81


Chapter 19  WARRANTY






                    DISCLAIMER - AGREEMENT




Users of AceComm must accept this disclaimer of warranty:

AceComm is supplied as is.  The author disclaims all warranties,
expressed or implied, including, without limitation, the
warranties of merchantability and of fitness for any purpose.
The author assumes no liability for damages, direct or conse-
quential, which may result from the use of AceComm.


































       Page 142              AceComm (tm) v 1.81


Chapter 20  LICENSE


AceComm is not a Public Domain program and is not free.  AceComm is copyright
(C) 1990-1993 by MGP Programming Services.

Non-registered users of this program are granted a limited 30 day license to
evaluate the programs suitability for their requirements.  Any usage of AceComm
beyond the evaluation time period requires registration of each copy of the
program used.  Use of non- registered copies of AceComm beyond the original
evaluation period is prohibited.

AceComm may NOT be modified in any respect, for any reason, including but not
limited to, de-compiling, disassembling, or reverse engineering of the
program.  The opening title screen, help screens, and all other proprietary
program output must never be altered, removed, bypassed or modified by any
means.

You are free to distribute the PUBLICLY AVAILABLE evaluation version of AceComm
to others subject to the above restrictions and also the following:

   A.   No fee is charged for its use.

   B.  No re numeration may be accepted for AceComm.  This does not apply to
        computer access charges the system operators (Sysops) of or
        organizations owning bulletin board systems, on line services, etc...
        may charge subscribers.

   C.  AceComm must be copied in unaltered form, complete with files containing
        license information, the FULL documentation and all accompanying
        files.  The self-extracting archive distributed by MGP Programming
        Services must not be altered in ANY respect.

   D.  All shareware houses/distribution firms must make explicitly clear that
        the diskette purchase containing any shareware program has NOT
        registered the software with the author MGP Programming Services
        Software/Michael G Phelps.
















       Page 143              AceComm (tm) v 1.81


Chapter 20  LICENSE


System Operators may make AceComm available for download only if the above
conditions are met.  The archive (Acennnn.EXE) distributed by AceComm or an
equivalent archive may be made available only in complete form.  Refer to
FILELIST.DOC to verify complete package contents.  If the contents appear
altered or not complete, you may obtain the latest release of AceComm directly
from MGP Programming Services by sending a formatted diskette labeled with the
word "AceComm".  Please include $5 for handling.

The latest version of AceComm is also available on Compuserve.

Commercial distributors of "Public Domain", "Shareware", and/or User Supported
software may distribute AceComm subject to the above conditions only after
obtaining WRITTEN permission from MGP Programming Services.  This condition
statement supersedes all previous agreements.

Please refer to the section entitled registration/ordering section for
additional information on registration, corporate site-licensing and related
topics.
































       Page 144              AceComm (tm) v 1.81


Chapter 20  LICENSE


The above license statement does not apply to the REGISTERED version of
AceComm.  The registered software of MGP Programming Services is protected
under United States Copyright and Trademark Laws.  It must be treated just like
a book with certain exceptions as follows:

   A.  MGP Programming Services authorizes the making of archival copies of the
       registered software for the sole purpose of backing-up your software and
       protecting your investment from possible loss.

   B.  The medium on which the registered software is recorded is transferred
       to the customer, but not the title to the software.

   C.  The customer may resell or distribute unmodified copies of the
       registered software provided the customer has purchased from MGP
       Programming Services one copy of the registered software for each one
       sold or distributed.  The provisions of this software license shall also
       be applicable to third parties receiving copies of the registered
       software from the customer.

   D.  By saying, "just like a book", MGP Programming Services means that the
       registered software may be used by any number of people and may be
       freely moved from one computer location to another so long as there is
       ABSOLUTELY NO POSSIBILITY of it being used at one location while being
       used at another.  Just like a book that cannot be read by two different
       people in two different locations at the same time.

























       Page 145              AceComm (tm) v 1.81


Chapter 20  LICENSE




You can get more help by contacting the
author Michael Phelps at the following

- VOICE 602-846-4563 6 days 12-7pm MST

- BBS   602-846-2940 24 hours

- COMPUSERVE User ID 75120,3306

- FIDONET ADDRESS 1:114/35

- FIDONET ACECOMM ECHO
I distribute the "ACECOMM" echo to
USA NODES, until it makes BACKBONE.

- Write to: AceComm Software Support
            3003 North Central Ave
            Suite 121-171
            Phoenix, AZ  85012  USA





























       Page 146              AceComm (tm) v 1.81


Chapter 21  AceComm Registration



             AceComm (Tm) Version  1.8

AceComm is distributed to you as "Try before you buy" software.

Continued use of the AceComm package requires the registration fee be sent to
the author.

Registering AceComm gives you access to one of the more powerful and innovative
communications programs available.

AceComm registration costs just $45.  (includes shipping) You will receive an
up-to-date printed bound user manual, the very latest AceComm software on disk,
your registration card and serial number, 1 FREE upgrade card, major revision
upgrade notices mailed to you, all future upgrades at very low cost of 20%
registration fee.
    (Wow, major upgrades include printed manual for just $9)
To place an order, please use the order form contained in the file
ACEORDER.FRM, or print directly from the program Help menu.

        800-242-4775  (Toll free) To register by credit card.
        FAX at 713-524-6398
        Part number 10805



























       Page 147              AceComm (tm) v 1.81


Chapter 22  Order Form





                    AceComm & Utilities (Tm)
                         Version  1.8
                          ORDER FORM



FROM:

     Name: ____________________________________________________

[Company]: ____________________________________________________

  [Title]: ____________________________________________________

  Address: ____________________________________________________

     City: ____________________________________________________

    State: ___________________________ Zip Code: ______________

  Country: ___________________________ Phone: _________________





                                   TO:
                                       AceComm Software
                                       3003 N. Central Ave. #121-171
                                       Phoenix, AZ    85012   USA


              Ŀ
        Ŀ                   (R)
      ĳ         o    
           Ŀ   Association of
                      Shareware
        ĳ    o        Professionals
      ĳ        
                MEMBER







       Page 148              AceComm (tm) v 1.81


Chapter 22  Order Form


                    AceComm & Utilities (Tm)
                         Version  1.8
                          ORDER FORM

Telephone   (602) 846-4563     AceComm Support Services
AceComm BBS (602) 846-2940     3003 N. Central Ave Suite 121-171
CompuServe  75120,3306         Phoenix, AZ  85012  USA
================================================================
Individual Registration Licensing use of AceComm and Utilities

- commercial version software  & documentation on diskette
- printed bound manual, upgrade notices)
- 1 upgrade sent FREE (you choose the version)
- all future upgrades at very low cost of 20%
  1'st FREE & all future upgrades include disk/printed manual

for MS-DOS:   1 Purchase at $45 (includes shipping) . . . ______
================================================================
INTERNAL SITE LICENSE for the use of AceComm & Utilities for DOS

- commercial version software  & documentation on diskette
- 1 upgrade sent FREE (you choose the version)
- all future upgrades at very low cost of 20%

  Quantity Registrations
  ----------------------
     10 - 50 ..         at $32 each, nbr computers ___x 32 _____
     50+                call for special discount
     custom features available
     call for quantity manual pricing
================================================================
Overseas add $7.00/order  for shipping and handling        _____

Diskette format (choose one)  5.25" disk (__)  3.5" disk (__)
================================================================
TOTAL PRODUCTS                                             _____

 Sales tax for Arizona residents                   6.5%    _____

TOTAL ORDER                                                _____

For payment by non-USA BANK CHECK, add $40.00              _____

Payment method:                            TOTAL ENCLOSED  _____
           ( ) Check           ( ) Cash
           ( ) Money order
           ( ) Credit card - See instructions in file CREDIT.CRD



       Page 149              AceComm (tm) v 1.81


Chapter 22  Order Form





                    AceComm & Utilities (Tm)
                         Version  1.8
                    Credit Card Order Form








     As a service to AceComm customers who want to register by  credit
     card,  arrangements  have  been  made  with  the  Public Software
     Library (PSL) to  handle  all  credit  card  registrations.   PSL
     accepts Visa, MasterCard, American Express, and Discover Card.

     Non-U.S.   residents  are  encouraged to register by credit card.
     In many  cases,  paying  by  credit  card  will  be  easier  than
     acquiring U.S.  funds.

     PSL will take the order information and forward it to the AceComm
     author,   MGP   Programming  Services  &  Michael  G  Phelps  for
     processing and shipping.
























       Page 150              AceComm (tm) v 1.81


Chapter 22  Order Form



                    AceComm & Utilities (Tm)
                         Version  1.8
          AceComm Software Credit Card Registration Form
                    PSL Part number 10805




     The PSL part number for AceComm is: 10805

     Credit card registrations may be made by the following methods:

     -- Phone PSL at:
        800-242-4775  (Toll free) To register by credit card.
        713-524-6394  To  register  by  credit  card  and  for   order
                      inquiries.

     Be sure to have BOTH the credit card form at the end of this file
     PLUS the order form in the file ORDERFRM.DOC  available  to  give
     order information to PSL.

     ACCURACY in phone ordering is important!  Misspellings can result
     in delays or an erroneous registration.

     -- FAX PSL at 713-524-6398

     -- Email PSL at CompuServe user id 71355,470

     -- Write PSL at:
        The Public (Software) Library
        P.O. Box 35705
        Houston, TX 77235-5705
        USA
        PSL Part number 10805

     For FAX, email, or mail to PSL, send BOTH the credit card form at
     the   end   of  this  file  PLUS  the  order  form  in  the  file
     ORDERFRM.DOC.

     The Public Software Library also  maintains  a  vast  library  of
     shareware  and  public  domain  programs  and  prints  a  monthly
     magazine announcing new releases and general software news.







       Page 151              AceComm (tm) v 1.81


Chapter 22  Order Form





                    AceComm & Utilities (Tm)
                         Version  1.8
          AceComm Software Credit Card Registration Form
                    PSL Part number 10805






     Please complete this form AND the regular order form in the file
     ORDERFRM.DOC and send BOTH *** DIRECTLY *** to:

                        The Public (Software) Library
                        P.O. Box 35705
                        Houston, TX 77235-5705
                        USA


                                        Date ________________________

         Name:  _____________________________________________________

     [Company:] _____________________________________________________

      Address:  _____________________________________________________

             :  _____________________________________________________

             :  _____________________________________________________


         Payment by:   ( ) MasterCard          ( ) Visa
                       ( ) American Express    ( ) Discover Card


     Card #:  ______________________________  Exp. Date:  ___________


     Signature of card holder: ______________________________________

     PSL Part number 10805





       Page 152              AceComm (tm) v 1.81


Chapter 22  Order Form








Ŀ
            AceComm (tm)   version 1.81   1/16/94                          
                                                                           
           Copyright (c) 1990-1994 by MGP Software                         
Ĵ
                                                                           
 AceComm was first released in May of 1993.  The AceComm source code is    
 written in 100% assembly language, using TASM versions 2, and 3.1.  A     
 Windows version of AceComm is well under way, and should be released by   
 March of 94.  All of the generic code written for AceComm DOS version is  
 available to the Windows version.  This allows the two versions to evolve 
 together, and operate much the same.                                      
                                                                           
 Registering AceComm gives you access to one of the more powerful and      
 innovative communications programs available.  AceComm registration costs 
 just $45.  (includes shipping)                                            
                                                                           
 Your registration package includes the printed bound user manual, which   
 is sure to save you back the registration fee in on line time. AceComm's  
 highly configurational interface provides a progressive path to more      
 efficient on line sessions.                                               
                                                                           




 
