-- CHANGESN.ADA   Ver. 3.11   10-JAN-1996   Copyright 1988-1996 John J. Herro
--
-- SOFTWARE INNOVATIONS TECHNOLOGY          http://members.aol.com/AdaTutor
-- 1083 MANDARIN DR NE                      ftp://members.aol.com/AdaTutor
-- PALM BAY FL 32905-4706
--                                          johnherro@aol.com
-- (407) 951-0233                           john.herro%374-38-2@satlink.oau.org
--
-- Used to change the serial number in ADA_TUTR.DAT after registering.
--

with Text_IO, Direct_IO; use Text_IO;
procedure ChangeSN is
   subtype Block_Subtype is String(1 .. 64);
   package Random_IO is new Direct_IO(Block_Subtype); use Random_IO;
   Data_File_Name : constant String := "ADA_TUTR.DAT";
   Data_File      : Random_IO.File_Type;
   Block          : Block_Subtype;            -- Block read from the data file.
   Block_Num      : Random_IO.Count := 40;      -- Number of the current block.
   Place          : Integer;                 -- Index to search for "Serial #".
   Found          : Boolean := False;         -- True when "Serial #" is found.
   Serial_Num     : String(1 .. 5);             -- The serial number, in ASCII.
   Input          : String(1 .. 6);                     -- Input that you type.
   Len            : Integer;                          -- Length of typed input.
   Legal_Note     : constant String := " Copyright 1988-96 John J. Herro ";
                       -- Legal_Note isn't used by the program, but it causes
                       -- most compilers to place this string in the .EXE file.
begin
   Random_IO.Open(Data_File, Mode => Inout_File, Name => Data_File_Name);
   while not Found loop
      Block_Num := Block_Num + 1;
      Read(File => Data_File, Item => Block, From => Block_Num);
      Place := 0;
      while not Found and Place <= 50 loop
         Place := Place + 1;
         Found := Block(Place .. Place + 7) = "Serial #";
      end loop;
   end loop;
   Serial_Num := Block(Place + 10 .. Place + 14);
   Put_Line("Old serial number is " & Serial_Num & ".");
   Put("New serial number:   ");
   Input := Serial_Num & " ";
   Get_Line(Input, Len);
   New_Line;
   Block(Place + 10 .. Place + 14) := Input(1 .. 5);
   Write(File => Data_File, Item => Block, To => Block_Num);
   Close(Data_File);
   Put_Line("Serial number changed to " & Input(1 .. 5) & ".");
exception
   when Random_IO.Name_Error =>
      Put("I'm sorry.  The file " & Data_File_Name);
      Put_Line(" seems to be missing.");
   when Random_IO.End_Error =>
      Put("I'm sorry.  I couldn't find a serial number in ");
      Put_Line(Data_File_Name & ".");
end ChangeSN;
