/*
ONECHAR.C   Ver. 3.11   10-JAN-1996

SOFTWARE INNOVATIONS TECHNOLOGY      http://members.aol.com/AdaTutor
1083 MANDARIN DR NE                  ftp://members.aol.com/AdaTutor
PALM BAY FL 32905-4706
                                     johnherro@aol.com
(407) 951-0233                       john.herro%374-38-2@satlink.oau.org

This file is for use with UNIX.ADA.  It is a Unix System V routine to allow
the capture and return of one character from the terminal.

This program was written by Dave Hill, 7549 Wynford Street, Salt Lake City, UT
84121.  Software Innovations Technology is grateful to Mr. Hill for permission
to include ONECHAR.C with ADA-TUTR.
*/

#include <stdio.h>
#include <termio.h>
char onechar()
{
    static struct termio newsets, oldsets;
    char c;
    ioctl(fileno(stdin), TCGETA, &newsets);
    ioctl(fileno(stdin), TCGETA, &oldsets); /* used by cooked */
    newsets.c_cc[4] = '\001';
    newsets.c_cc[5] = '\0';
    newsets.c_lflag &= ~ (ICANON);
    ioctl(fileno(stdin), TCSETAF, &newsets);
    c = getchar();
    ioctl(fileno(stdin), TCSETAF, &oldsets);
    return (c);
}
