#ifndef	lint
char RCSid[]="$Header: /Nfs/blyth/glob/src/usr.bin/spad/src/RCS/x29out.c,v 1.27 1993/11/13 14:45:23 pb Exp $";
#endif	lint

/* x29out	open an x29 connection & pump the data !
		0 -> OK
		2 -> bad args
		3 -> faild to opeen call
		4 -> read/write error during call
		5 -> RESET/BREAK during call
 */

#ifndef	DEF_TIMEOUT
#define	DEF_TIMEOUT	(60*5)
#endif	DEF_TIMEOUT

#define	PARAMS	(sizeof def_parm)
#define	write_qual(data)		write_qual_len(data, sizeof data)
#define setparameter(i, v) if (i>0 && i<=PARAMS && !ignore_p[i]) parms[i] = v

#include <stdio.h>
#include <ctype.h>
#define	FULL_X25STR
#include "x25b.h"

extern int errno;
extern char* index(), *getenv();

char def_parm[] = { 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
char ignore_p[] = { 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1 };
char parms[PARAMS+1];
int x25;
int ts29=0;
struct x25io x25ioo;
struct x25io x25ioi;

char qual	=   0x08  ;	/* Qualified bit		*/
char inv_clr[]	= { 0x00, 0x01 };	/* Ask other end to clear	*/
char read_param[]={ 0x00, 0x04, 18, 0 };/* Ask other end for params	*/
char ts29_disc[]={ 0x00, 0x012 };	/* Disconnect */
char optargs[]	= "D:INP:S:T:l";
int timeout = DEF_TIMEOUT;
int lf2cr   = 1;
int newline = 0;
int input   = 0;

main(argc, argv)
int argc;
char ** argv;
{	int c;
	extern int optind;
	extern char *optarg;
	char *server = (char *) 0;

	bcopy(def_parm, parms, sizeof parms);

	while ((c = getopt(argc, argv, optargs)) != EOF) switch(c)
	{
	case 'D':	x25b_debug = atoi(optarg);	break;
	case 'I':	input = ! input;		break;
	case 'N':	newline = !newline;		break;
	case 'P':
		{ int i = atoi(optarg);
		  char *val = index(optarg, '=');
		  if (!isdigit(*optarg) || i <= 0 || i >= PARAMS)
		  { x25b_logit(0, "invalid param %s\r\n", optarg); break; }
		  if (val) { ignore_p[i]++; if (!val[1])	   break; }
		  else if (!(val = index(optarg, ':')))
		  { x25b_logit(0, "No : or = in %s\r\n", optarg);  break; }
		  if (!isdigit(*++val))
		  { x25b_logit(0, "invalid preset value %s in %s\r\n",
			val, optarg);				break;
		  }
		  parms[i] = atoi(val);
 		}
		break;
	case 'S':	server = (optarg);		break;
	case 'T':	timeout = atoi(optarg);
			if (timeout <=0) timeout = DEF_TIMEOUT;	break;
	case 'l':	lf2cr = !lf2cr;			break;
	case '?':	x25b_logit(0,
			    "Usage: %s [-%s] address\r\n", argv[0], optargs);
			exit(2);
	}

	if (optind != (argc -1))
	{	x25b_logit(0, "Usage: %s [-%s] address\n", *argv, optargs);
		exit(2);
	}

	_x25b_init_x25io(&x25ioo);
	_x25b_init_x25io(&x25ioi);

	if ((x25=x25b_open_x29(argv[optind], "", 0,
		(server) ? server : getenv("X29SERVER"),
		0, 0, 0, 0))<0)
		exit(3);
	pollloop(x25, fileno(stdin));
	exit((timeout) ? 4 : 0);
}

pollloop(x25, loc)
int loc;
int x25;
{	int	xmask	= 1 << x25;
	int	tmask	= 1 << loc;
	int	defmask = (xmask | ((input) ? 0 : tmask));
	int	max = ((x25 > loc) ? x25 : loc) +1;
	int	mask	= defmask;

	for (; select(max, &mask, 0, 0, 0) > 0 && mask; mask = defmask)
	{ if (mask & xmask)	{ if (process_x25(x25, loc) <= 0) break; }
	  if (mask & tmask)		/* Data from stdin ? */
	  { int rc = process_loc(loc, x25);
	    if (rc < 0)		/* On error, crash out ! */	break;
	    if (rc == 0)			/* EOF -- be more graceful */
	    {	defmask &= ~tmask;		/* Stop reading stdin */
		write_qual(read_param);		/* Ask other end for params */
		if (ts29)			/* Ask other end to clear */
		{	ts29 = 0;
			write_qual(ts29_disc);
			ts29 = 1;
		}
		else write_qual(inv_clr);
		alarm(timeout);			/* Set protective timeout */
		timeout = 0;	/* Now if req_params arrive, close the stream */
	    }
	  }
	}
}

/* Read from the x25 stream & write to the local stream */
process_x25(x25, loc)
int loc;
int x25;
{	char *buff = x25ioi.x_buf;
	int rc	= 1;
	int skip = 0;
	char qbit;
	char flags;
	char tspad;
	int len = x25b_read_data2(x25, &qbit, buff, sizeof x25ioi.x_buf,
		&flags, &tspad, &x25ioi);

	if (len <= 0) return len;

	if (ts29)
	{	if (! (flags & X25F_TSPAD))
			tspad = buff[skip++], len--;
		qbit |= (tspad) ? 0x08 : 0;
	}

	if (qbit & 0x08)
	{	
	char *unset = "<unset>";
	char *a1 = unset;
	char *a2 = unset;
	char *a3 = unset;
	char *a4 = unset;
	char dummy[128];
	int args = ts_buff_decode8(buff+skip+1, dummy, len-1, 0, 4,
		&a1, &a2, &a3, &a4);
	switch(buff[skip])
	{
	case 0x00:	if (!timeout && len == 3 &&
			(buff[skip+1] & 0x7f) == read_param[18]) exit(0);
			x25b_logit(0, "Len %d, %x\n", len, buff[2]); break;
	case 0x01:	exit(0);
	case 0x02:	setparams(buff+skip, len);		break;
	case 0x03:	exit(5);
	case 0x06:	setparams(buff+skip, len);
	case 0x04:	getparams(buff+skip, len);		break;
	case 0x10:	x25b_logit(0, "Connect %s/%s/%s/%s\n",
				a1, a2, a3, a4);		break;
	case 0x11:	if (x25b_debug & 1) x25b_logit(0,
				"Accept %d, %s/%s/%s\n", len, a1, a2, a3);
			ts29++;					break;
	case 0x12:	x25b_logit(0, "Disconnect %x: %s/%s\n",
			(args > 0) ? -1 : *a1, a2, a3);	exit(timeout ? 5 : 0);
	case 0x13:	x25b_logit(0, "Reset %x: %s/%s\n",
			(args > 0) ? -1 : *a1, a2, a3);	exit(5);
	case 0x14:	x25b_logit(0, "Address %s/%s\n", a1, a2);	break;
	default:	x25b_logit(0, "Qbit data %d: %02x %02x %02x\n",
			len, buff[skip], buff[skip+1], buff[skip+2]);	break;
	}
	}
	else
	{	rc = write(fileno(stdout), buff+skip, len);
		if (newline && len > 0 && buff[skip+len-1] != '\n')
			write(fileno(stdout), "\n", 1);
	}

	return (rc > 0 && len > 0) ? rc : -1;
}

/* Read from the local stream & write to the X25 stream */
process_loc(loc, x25)
int loc;
int x25;
{	char *buff = x25ioo.x_buf;
	char *p;
	char flags = (ts29) ? X25F_TSPAD : 0;
	int len  = read(loc, buff, sizeof x25ioo.x_buf);

	if (len <= 0) return len;

	if (lf2cr) for (p=buff;p=index(p,'\n');p++) if (p[-1]!='\r') *p='\r';

	/* Oh dear -- asked to add \n after \r ... */
	if (parms[13] & 2)
	{	char buff2[sizeof x25ioo.x_buf];
		char *p = index(buff, '\r');

		if ((!p) || ((p-buff) >= len))
			;
		else if (p - buff == len -1)
			buff[len++] = '\n';
		else
		{	int i;
			bcopy(p = buff, buff2, len);
			for(i=0; i<len; i++)
				if ((*p++ = buff2[i]) == '\r') *p++ = '\n';
			len = p - buff;
		}
	}

	return x25b_write_data2(x25, (char *)0, buff, len,
		&flags, (char *) 0, &x25ioo);
}

write_qual_len(data, len)
char *data;
int len;
{	if (ts29)
	{	int rc;
		*data = 0x80;
		rc = x25b_write_data(x25, (char *) 0, data, len);
		return (rc < 1) ? rc : rc -1;
	}
	else	return x25b_write_data(x25, &qual, data+1, len-1);
}

setparams(buff, len)		/* message is a list of (num,val) pairs */
char *buff;
int len;
{ int i;
  for (i = 1; i < len; i+= 2) setparameter(buff[i], buff[i+1]);
}

getparams(buff, len)
char *buff;
int len;
{ int i;
  int all = 0;
  char out[PARAMS*2 + 2];

  if (len == 1) len = PARAMS*2 +1, all=1;

  out[1] = 0;
  for (i = 1; i < len; i+=2)
  { int p = (all) ? (i+1)/2 : buff[i];
    out[i+1] = p;
    out[i+2] = parms[p];
  }
  write_qual_len(out, i+1);
}

ts_buff_decode8(raw, buff, len, rem_len, argc, a0, a1, a2, a3)
register char *raw, *buff;
char **a0, **a1, **a2, **a3;
register int len;
int *rem_len;
int argc;
{   char **argv[4];
    int param;

    if (!buff) buff=raw;
    argv[0] = a0;
    argv[1] = a1;
    argv[2] = a2;
    argv[3] = a3;
    if (argc > sizeof argv / sizeof argv[0])
	argc = sizeof argv / sizeof argv[0];

    for (param=0; param < argc; param++)
    {	register int i;
	register char *p;
	if (len ==0)		break;
	if (!*raw)		break;		/* terminating zero octet */
	len--;
	if (!(*raw & 0x80))	return -(param+1);
	if ((i = (*raw++ & 0x3f)) > len) return (param+1) * -11;
	if (argv[param]) *argv[param] = buff;
	for (;i>0; len--, i--) *buff++ = (*raw++) & 0xff;
	*buff++ = '\0';
    }

    if (rem_len) *rem_len = len;

    return param;
}

x25b_logit(mask, format, a1, a2, a3, a4)
int mask;
char *format;
void *a1, *a2, *a3, *a4;
{	fprintf(stderr, format, a1, a2, a3, a4);
	fflush(stderr);
}

x25b_perror(mask, format, a1, a2, a3, a4)
int mask;
char *format;
void *a1, *a2, *a3, *a4;
{	x25b_logit(0, format, a1, a2, a3,a4);
	perror("");
}

int x25b_debug = 0;
