# ifndef	lint
static char RCSid[]="$Header: /Nfs/blyth/glob/src/usr.bin/spad/src/RCS/spad.c,v 1.27 1993/11/15 08:00:00 pb Exp $";
#endif	lint

/* spad:-  multiple client/single server x.29 service.
	   needs Sunlink X.25 software running in (at least) one node
 */

/*"Source code that contains erroneous comments, misspellings, and
 * inconsistent formatting does not inspire much confidence in its robustness
 * or reliability."- R Rochat, "In Search of Good Smalltalk Programming Style"
 */

/* TODO:
 * allow x25log remotely
 * NUI ?
 * allow users to ask for the x25 parameters
 */

/* Copyright (c) A Rawsthorne 1986, 1987 & P Brooks 1987 - 1993
 * not for commercial use
 * this version not to be redistributed except by agreement.
 */

#define	USE_CUDF	/* Want to include CUDF data */
#include "spad.h"
extern char prompt[];

char	def_service[] = SERVICE;
char	servername[] = SERVERNAME;
#ifdef	SERVICEFIRST
char	servicefirst[] = SERVICEFIRST;
#endif

/* LOOP - the main loop of the pad is to wait for input from the X.25 link
   or the terminal.  Input from the X.25 link is copied to the screen.
   Input from the terminal is buffered and may be forwarded to the X.25 link
*/

char *strsave(string)
char * string;
{	char *new = malloc((unsigned long) strlen(string) +1);

	if (!new)	return new;
	strcpy(new, string);
	return new;
}

pollloop(ttymask, sockmask, number)
int ttymask, sockmask, number;
{
  static struct timeval no_delay;
#ifdef	DEXPAND
  static struct timeval sel_tout;
  struct timeval *psel_tout = (role == CLIENT) ? (struct timeval *) NULL : &sel_tout;
#define	SEL_TOUT psel_tout
#else	DEXPAND
#define	SEL_TOUT (struct timeval *)NULL
#endif	DEXPAND
  int defmask = ttymask | sockmask;
  int data = TTY_NODATA;
  int fds = 0;	/* Keep lint etc happy */

#ifdef	DEXPAND
  if (role != CLIENT)
  { sel_tout.tv_sec	= poll_interval / 1000000;
    sel_tout.tv_usec	= poll_interval % 1000000;
    defmask = ttymask;
  }
#endif	DEXPAND

  if (batch)	defmask &= ~ttymask;

  while(1) {
    int extramask = 0;
    int selmask = defmask;

    /* If we aren't reading from the TTY, don't listen to it ! */
    if (reading || suspendedy) selmask &= ~ttymask;	/* kind of ... */

    /* If we know that there is data from file, no need to select */
    if (reading) extramask |= ttymask;

#ifdef	DEXPAND
    /* Think about batch later .... */
    if (role != CLIENT)
    {  /* YUCK !! We really ARE polling !!!! */

      /* OK, we are ONLY listening on X25, so we had better block ... */
      /* Don't block for ever, as the user may foreground the peocess */
      if ((selmask | extramask) == 0)
      {
	int i;
	char first[1];
	struct cciovec iov;
	contp.c_Xtout	= 4 * 100;	/* Only wait this long on "fg" */
	iov.cc_iovbase	= first;
	iov.cc_iovlen	= sizeof(first);
	iov.cc_iovseg	= 0;
	data = TTY_NODATA;

/* ----- NEED TO TEST FOR ZERO COUNT & NOT TIMEOUT ----- */
	if ((i = ccrecv(circuit, &iov, 1, &contp)) > 0)
	{ if (debug & D_1_) fprintf(stderr,
		"Got %d %x (m%x, r%x, e%x, m%x, q%x, i%x, %x/%x)\r\n",
		i, *first,
		contp.c_Xmsg, contp.c_Xrecv, contp.c_Xevent,
		contp.c_Xmbit, contp.c_Xqbit, contp.c_Xiflag,
		contp.c_Xdiag, contp.c_Xcause);
	  extramask |= sockmask;
	}
	else if (debug & D_1_) printf("ccrecv gave %d/%d\r\n", i, errno);
      }
      else if (ccstat(circuit, &contp) > 0)
      {
	if (debug & D_1_) fprintf(stderr,
		"Got (m%x, r%x, e%x, m%x, q%x, i%x, %x/%x)\r\n",
		contp.c_Xmsg, contp.c_Xrecv, contp.c_Xevent,
		contp.c_Xmbit, contp.c_Xqbit, contp.c_Xiflag,
		contp.c_Xdiag, contp.c_Xcause);
	extramask |= sockmask;
      }
    }
    if (debug & D_1_) printf("w%x ", selmask);
#endif	DEXPAND

    /* No select mask -> no select ! */
    /* extra mask -> something waiting -> 0 timeout */
    if (selmask && (fds=select(number, (fd_set *)&selmask, (fd_set *)NULL,
   		 (fd_set *)NULL,
		(extramask) ? &no_delay : SEL_TOUT)) < 0)
    { if(errno == EINTR)	continue;
      perror("select");
      padexit(1);
    }

    if (fds == 0) selmask = 0;
    if (debug & D_1_) printf("%x ", selmask);
    /* Now include the things we didn't select on */
    selmask |= extramask;

    if (debug & D_1_) printf("s%x ", selmask);
    if (debug & D_1_) fprintf(stderr, "s%x ", selmask);
    if (debug & D_1_ && !selmask) fprintf(stdout, "-");
    if (debug & D_1_ && !selmask) fprintf(stderr, "<t/o>");
    if (selmask & sockmask)	totty(fromx25(data));
    if (selmask & ttymask)	fromtty(selmask & sockmask);
    fflush(stdout);
  }
  /* NOTREACHED */
}

/* TOTTY - a packet from the X.25 link has arrived (see "fromx25", later).
   deal with output to terminal. (may be control message)
*/

totty(count)
int count;
{
  int i;
  int qual;

  if(debug & D_1_)
  {	int i;
	fprintf(stderr, "+totty+ %db, f%x %s[",
		count, x25ibuf.x_flags, (ts29) ? "T" : "");
	if (count > (sizeof x25ibuf.x_buf)) count = (sizeof x25ibuf.x_buf);
	for(i=0; i<1+TS29_BYTES; i++)
	    fprintf(stderr, " %02x", (x25ibuf.x_rawbuf)[i]);
	fprintf(stderr, ":");
	if (debug & D_2_) for(i=0; i<count; i++)
	    fprintf(stderr, " %02x", ((unsigned char*)x25ibuf.x_buf)[i]);
	fprintf(stderr, "]\r\n");
  }
  if (count == TTY_NODATA)	return;

  if (x25ibuf.x_flags & X25F_MSG_OOB) switch (x25ibuf.x_send_type)
  {
  case INT_DATA:
    if (param6)	clientmes0(0, "*** INTERUPT received");	return;
  case VC_RESET:
    if (param6)	clientmes0(0, "*** RESET received");	return;
  default:
    fprintf(stderr, "\r\n +++- OOB %02x RECEIVED", x25ibuf.x_send_type);
    if (count) fprintf(stderr, ": data");
    for(i=0; i<count; i++)
		fprintf(stderr, " %02x", (unsigned char) x25ibuf.x_buf[0]);
    fprintf(stderr, "\r\n");
    return;
  }

  if (count == -1) {
    fprintf(stderr, "\r\n +++- Closed By Host\r\n");
    padexit(matching);		/* OK if from tty, unexpected from file */
  }

  /* TS29 REAL qualified data */
  if (((x25ibuf.x_flags & X25F_TSPAD) || ts29) &&
	(x25ibuf.x_send_type & (1 << Q_BIT)))
  { int offset = (x25ibuf.x_flags & X25F_TSPAD) ? 0 : 1;
    int type = (offset) ? x25ibuf.x_buf[0] : x25ibuf.x_tspad;
    int i;
    char *unset = "<unset>";
    char *a1 = unset;
    char *a2 = unset;
    char *a3 = unset;
    char *a4 = unset;
    char buff[128];
    int args = -1;

    fprintf(stderr, "\r\n");
    i = ts_buff_decode8(&(x25ibuf.x_buf[offset]), buff, count, (int *) 0, 4,
		&a1, &a2, &a3, &a4);
    switch (type)
    {
      case 0x00: fprintf(stderr, " +++ Param indication??\r\n");	break;
      case 0x01: fprintf(stderr, " +++ Inv to clear??\r\n");		break;
      case 0x02: fprintf(stderr, " +++ Set param??\r\n");		break;
      case 0x03: fprintf(stderr, " +++ Ind of Break??\r\n");		break;
      case 0x04: fprintf(stderr, " +++ Read param??\r\n");		break;
      case 0x05: fprintf(stderr, " +++ Error??\r\n");			break;
      case 0x06: fprintf(stderr, " +++ Set & read param??\r\n");	break;

      case 0x10: fprintf(stderr, " +++ CONNECT %s -> %s (%s, %s)\r\n",
					a1, a2, a3, a4);
		 args = 4;						break;
      case 0x11: if (a1 != unset && *a1) fprintf(stderr, "*** Connected to: %s\r\n", a1);
		 if (a3 != unset && *a3) fprintf(stderr, "*** %s\r\n", a3);
		 if (a2 != unset && *a2) fprintf(stderr, "***( %s )\r\n", a2);
		 if (i < 0) i = -i;
		 args = 1;						break;
      case 0x12: fprintf(stderr, "*** Call cleared %x by %s\r\n",*a1,a2);
		 if (a3 != unset && *a3) fprintf(stderr, "*** %s\r\n", a3);
		 padexit(0);
      case 0x13: fprintf(stderr, "*** Reset %x by %s\r\n", *a1, a2);
		 if (a3 != unset && *a3) fprintf(stderr, "*** %s\r\n", a3);
		 args = 3;						break;
      case 0x14: fprintf(stderr, " +++ ADDRESS %s - %s\r\n", a1, a2);
		 args = 2;						break;

      default:   fprintf(stderr, " +++ Unknown type %02x\r\n", type);	break;
    }

    if (i < 0 || args > i)
    { fprintf(stderr, " ++  QDxM=%01x, (%d,%d) len %d: %02x",
		x25ibuf.x_send_type, args, i, count, type);
      for(i=offset; i<count; i++)
	fprintf(stderr, " %02x", x25ibuf.x_buf[i] & 0xff);
      fprintf(stderr, " -- Sorry -- ignored\r\n");
    }
    return;
  }

  qual = (x25ibuf.x_flags & X25F_TSPAD) ?
	(x25ibuf.x_tspad & 0x80) : (x25ibuf.x_send_type & (1 << Q_BIT));

  if (((x25ibuf.x_send_type & ~(1 << M_BIT)) || qual) && verbose & V_2_) {
    int i;
    fprintf(stderr, (verbose & V_4_) ?
			"\r\n ++   %sQDxM %02x, len %d, %02x:" :
			"[%s%02x:%d:%02x:",
	(qual) ? (verbose & V_4_) ? "Qual " : "Q" : "",
	x25ibuf.x_send_type, count,
	x25ibuf.x_buf[0] & 0xff);
    for(i=1; i<count; i++)
	fprintf(stderr, "%02x", x25ibuf.x_buf[i] & 0xff);
    fprintf(stderr, (verbose & V_4_) ? "\r\n" : "] ");
  }
  if (x25ibuf.x_flags & X25F_GATE_MSG)
  {	fflush(stdout);
	x25ibuf.x_buf[count] = '\0';
    	fprintf(stderr, "\r\n ++++ %s\r\n", x25ibuf.x_buf);
	return;
  }

  bytesin += count;
  pktsin  += (count-1) / pktisize + 1;
/*-*/
   if (0)
   { int in, out;
     get_pkts(&in, &out);
     if (in != pktsin) fprintf(stderr, "After %d (%d:%d) %d != %d\n",
		count, (count-1) / pktisize + 1, pktisize, in, pktsin);
   }
/*-*/

  if (qual) switch(x25ibuf.x_buf[0]) {
    case 1:	fprintf(stderr, "\r\n +++- Clear requested\r\n");padexit(0);
    case 2:	setparams(count);				break;
    case 4:				getparams(count);	break;
    case 6:	setparams(count);	getparams(count);	break;
    case 3:	/* indication of break */			break;
    case 0x11:	if (! ts29) fprintf(stderr, "\t[set ts29!]\r\n", ts29++); break;
    default:	fprintf(stderr, "Ignore Qual %x\n", x25ibuf.x_buf[0]); break;
  } else {	/* only output processing I'm doing is p13 <LF> insertion */
    if (use_termlogf)
    { for (i = 0; i < count; i++) putc(x25ibuf.x_buf[i], termlogf);
      fflush(termlogf);
    }

    if (! param8) for (i = 0; i < count; i++) {
      char c = x25ibuf.x_buf[i] & eightbitoutput;
#ifdef	TELNETD
      if (telnetd > 0 && c == (char) IAC) putchar(c);
#endif	TELNETD
      putchar(c);
      if (c == '\r' && param13 & 1) putchar('\n');
      if (matching && matchnext(c)) {
	sendnext();
	nextmatch();
      }
    }
    fflush(stdout);
  }
}

/* FROMTTY - there's terminal input ready for processing */

struct timeval zerotp = { 0 /* seconds */, 0 /* microseconds */ };

/* loop round in here to catch all the
   characters that are pending from the keyboard */

fromtty(other)
int other;
{
  int selmask = (1 << fileno(stdin));	/* stdin */

  if (debug & D_4_ || verbose & V_40_) fprintf(stderr, "fromtty(%d) r=%d ", other, reading);
  if (reading)	{ (void) bufferfromfile(reading); return; }
  forwarding = 0;
  /* The select() in main has indicated that there's something there */
  do {
	int c;
    if ((c=charfromtty(0)) == EOF)
    {	static int eofs = 20;
	if (debug & D_4_ || verbose & V_40_)
		{ fprintf(stderr, "eofs=%d ", eofs); fflush(stderr); }
	if (!other && eofs-- <= 0) padexit(0);
	/* Oh dear ... reading from stdin and it is exhasuted */
	/* Send what we have */
	if (xindex) sendtox25(&x25io_tty, xindex, 0 /* flags */, 0/* type */);
	xindex = 0;
	/* Let it get through */
	if (!other) sleep(1);
	return;
    }
    if (debug & D_4_ || verbose & V_40_) fprintf(stderr, "..%02x:%d/%d ",
			c, stdio_bytes_buffered(stdin), feof(stdin));
  } while ((stdio_bytes_buffered(stdin) > 0) ||
       select(fileno(stdin)+1, (fd_set *) &selmask, (fd_set *)NULL, (fd_set *)NULL, &zerotp)==1);
  if (debug & D_4_ || verbose & V_40_) fprintf(stderr, "fromtty() done\n");
  if (forwarding || param4) {
    sendtox25(&x25io_tty, xindex, 0 /* flags */, 0/* type */);
    xindex = 0;
  }
}

/* INPUT PROCESSING:-
	Forwarding, according to parameter 3
	Echoing, according to parameter 2
	LF stuffing, according to parameter 13
	local editing, according to parameter 15
(since these are workstations, I'm not sufficiently worried about efficiency
to bother about mapping echoing, LF and editing parameters into UNIX STTY
parameters.  I'll just do them myself, here)
*/

charfromtty(raw)
int raw;
{ static lastch = '\n';
  int ch;

  if (idle_timeout) { (void) alarm(idle_timeout); idle_warns = 0; }
if (verbose & V_20_)
 { fprintf(stderr, "[%d c] ", stdio_bytes_buffered(stdin));
	fflush(stderr); fflush(stdout); }
  ch = getchar();

#ifdef	TELNETD
  if (telnetd > 0)
  {	int c = telrcv(ch & 0xff);
	if (verbose & V_10_) fprintf(stderr, "%02x->%02x ", ch & 0xff, c & 0xff);
	fflush(stderr);
	if (c == NOT_CHAR)	return NOT_CHAR;
	if (	(c & eightbitinput) == (DEL & eightbitinput) &&
		!native_telnet && 
		(!myopts[TELOPT_ECHO] || !myopts[TELOPT_SGA]))
	{	fprintf(stderr,
	    "\r\n +++- detected <DEL> while %d/%d%d%d/%d%d%d so setting telnet to native mode -+++\r\n",
	echoing,
	myopts[TELOPT_ECHO], myopts[TELOPT_SGA], myopts[TELOPT_BINARY],
	hisopts[TELOPT_ECHO], hisopts[TELOPT_SGA], hisopts[TELOPT_BINARY]);
		set_native_telnet(1, WILL, WILL);
	}
	ch = c;
  }
#endif	TELNETD
  if (debug & D_4_ && ch == EOF) fprintf(stderr, "[EOF]");
  if (ch == EOF) { clearerr(stdin); return ch; }
  if ((ch & eightbitinput) == XOFF && param12)
  {	ch = getchar();
	if (ch == XON)	return NOT_CHAR;
  }
  ch &= eightbitinput;			/* sanity! */
  if (raw) return ch;
  if (ch == unixesc && (lastch == '\n' || lastch == '\r') &&
	!(ch = dounixesc(1))) return NOT_CHAR;
  if (ch == breakinch && !(ch = dobreakin(NOT_CHAR)))  return NOT_CHAR;

  lastch = ch;
  paramch(ch, 1);
  return ch;
}

/* Read some data from the supplied file descriptor.
 * Don't send too much data, as there may be something to come back from
 * the other x25 end
 */
bufferfromfile(file)
FILE *file;
{ char ch = 0;

  errno = 0;
  while(xindex < sizeof ttybuf && (ch = getc(file)) != EOF && ch != '\n')
	paramch(ch, 0);

  if (ch == EOF) {
    if (reading_pipe)
    { int rc = pclose(file);
      fprintf(stderr, (!rc) ?	" +++- Finished piping\r\n" :
				" +++- Finished piping (%04x)\r\n", rc);
    }
    else
    { fprintf(stderr, " +++- Finished reading\r\n");
      fclose(file);
    }
    fflush(stderr);
    if (file == reading) reading = NULL;
    return;
  }

  if (ch == '\n') paramch('\r', 0/*??*/);
  sendtox25(&x25io_tty, xindex, 0 /* flags */, 0/* type */);
  xindex = 0;
}

paramch(ch, process)
char ch;
int process;
{
  if (debug & D_4_) fprintf(stderr, "paramch(%02x, %d) ", ch & 0xff, process);
  if (debug & D_4_) fprintf(stderr, "%d/%d:%02x %02x %02x ", param15, param4,
	param16 & 0xff, param17 & 0xff, param18 & 0xff);
  if (use_termlogf)	putc(ch, termlogf);
  if (param15 & ~param4) {	/* Line Editing ? (not in single char mode) */
    if      (ch == param16) { doerase();	return; }
    else if (ch == param17) { dokill();		return; }
    else if (ch == param18) { doredisplay();	return; }
  }
  if (debug & D_4_) fprintf(stderr, "e=%d ", echoing);
  if (echoing) putchar(ch);

  ttybuf[xindex++] = ch;
  if (ch == '\r') {
    if (echoing && (param13&4)) putchar('\n');
    if (param13&2) {
      ttybuf[xindex] = '\n';
      xindex += 1;
      forwarding |= forwardvec['\n'];
    }
    echoing = do_echo(param2);
  }
  forwarding |= forwardvec[ch];
  if (xindex > sizeof ttybuf) forwarding |= 1;
}

doerase()
{
  if (xindex) {
    xindex--;
    if (echoing && isprint(ttybuf[xindex]))
	printf((verbose & V_RUBOUT) ? "\b_\b" : "\b \b"); /* unecho */
  } else /*if (echoing)*/ printf("\07");
}

dokill()
{
  if (echoing)
    while (xindex) {
      xindex -= 1;
      if (isprint(ttybuf[xindex]))
	printf((verbose & V_RUBOUT) ? "\b$\b" : "\b \b"); /* BS, " ", BS */
    }
  xindex = 0;
}

doredisplay()
{
  int temp = xindex;
  if (!echoing)	return;
  dokill();
  xindex = temp;
  for (temp = 0; temp < xindex; temp++) putchar(ttybuf[temp]);
}

#ifdef	SIGCONT
void resume()
{	int foreground = 0;
#ifdef	TIOCGPGRP
	int proc_group = 0;
#if	defined(__svr4__) || defined(__linux__) || defined(__osf__)
	int cur_group = getpgrp();
#else
	int cur_group = getpgrp(0);
#endif
#endif	TIOCGPGRP

	/* HACK HACK HACK ...
	 * If we can't determine the process group,
	 * Assume that the user backgrounds once,
	 * then foregrounds ....
	 * HACK HACK HACK
	 */
	if (ignore_cont) ignore_cont--;
	else	foreground++;

#ifdef	TIOCGPGRP
	/* If we can find tye TTY's current proc group, do it properly */
	if (ioctl(0, TIOCGPGRP, &proc_group))
	{
		printf("GPGRP 0 failed %d ...\r\n", errno);
	}
	else foreground = (proc_group == cur_group);
#endif	TIOCGPGRP

	if (foreground)
	{	if (!linemode) reresettty();
		suspendedy = 0;
	}
	else
	{	resettty();
		suspendedy = 1;
	}
}
#endif	SIGCONT

dobreakin(c)
int c;
{
  if (c == NOT_CHAR)
  { c = charfromtty(1);
/*?  printcntrlchar(c, 1); No echo !! */
  }
  fflush(stderr);
  switch(c) {
    case 'a':
    case 'A':	if (forbid_some_pad_cmds < 0) goto defalt;
		return dopadmode();
    case 'b':
    case 'B':	if (param7 & 16) params[P_8] = 1;	/* discard output */
		if (param7 & 1) sendinttox25();
		if (param7 & 2) sendresettox25();
		if (param7 & 4) sendindofbreak((param7 & 16) ? 2 : 0, 8, 1);
		xindex = 0;
		if (param7 & 8) return dopadmode(); /* escape to pad mode */
		return 0;
    case 'd':
    case 'D':	return param16;
    case 'e':
    case 'E':	echoing = !echoing;	return 0;
    case '?':
    case 'h':
    case 'H':	printf("\r\n");
		printf("The current DLE escapes are:\r\n");
		printf("a  enter pad mode\r\n");
		printf("b  send a break\r\n");
		printf("d  delete a character\r\n");
		printf("e  toggle echoing\r\n");
		printf("n  ignore the DLE\r\n");
		printf("t  flush data to x25 host\r\n");
#ifdef	TELNETD
		if (telnetd > 0)
		printf("u  toggle telnet native mode\r\n");
#endif	TELNETD
		printf("x  send next two hex digits as a data octet (not yet available)\r\n");
#ifdef	SIGTSTP
		if (forbid_some_pad_cmds)
		printf("z  suspend session (may be backgrounded)\r\n");
#endif	SIGTSTP
		return 0;
    case 'n':
    case 'N':	return 0;
    case 't':
    case 'T':	if (xindex) sendtox25(&x25io_tty, xindex, 0 /*flags*/, 0 /*type*/);
		xindex = 0;
		return 0;
#ifdef	TELNETD
    case 'u':
    case 'U':	if (!telnetd > 0)	goto defalt;
		native_telnet = !native_telnet;
		printf("\r\n +++- now %sin native telnet mode\r\n",
			native_telnet ? "" : "not ");
		set_native_telnet(native_telnet,
			(native_telnet) ? WILL : WONT,
			(native_telnet) ? WILL : WONT);
		return 0;
#endif	TELNETD
    case 'x':
    case 'X':	printf("\r\n +++- sorry -- DLE x nn not yet implemented\r\n");
		return 0;
#ifdef	SIGTSTP
    case 'z':
    case 'Z':	if (forbid_suspend) goto defalt;
		ignore_cont = 1;
		suspendedy = 1;
		resettty();
		kill(getpid(), SIGTSTP);
		return 0;
#endif	SIGTSTP
    defalt:
    default:	if (isalpha(c) && c != breakinch)
		{	fprintf(stderr, "\07");
			fflush(stderr);
			return 0;
		}
		return c;
  }
  /* NOTREACHED */
}

dounixesc(process)
int process;
{
  int c;
  c = charfromtty(1);
  fflush(stderr);
#ifdef	SIGTSTP
  if (c == suspendc) {
    resettty();
    printf("Suspend myself\r\n"); fflush(stdout);
    kill(getpid(), SIGSTOP);
    printf("re-woken\r\n"); fflush(stdout);
    reresettty();
    printf("& off we go ...\r\n"); fflush(stdout);
    return 0;
  }
#endif	SIGTSTP
  if (c == '\n' || c == '\r') return dopadmode();
  /* Oh dear -- not ~^Z, so process it */
  if (c != unixesc) paramch(unixesc, process);
  return c;
}


/* Pad command mode */

/* minimum set of facilities - have you tried logging in to a Series 39? */

dopadmode()
{
  resettty();
  linemode = 1;
  while (cmd(stdin, 1) == 0) {}
  printf("Returning to session\r\n");
  linemode = 0;
  reresettty();
  return 0;
}

struct cmds commands[] = {
  {"all",    3,	T_ALL,	T_NONE,	T_SET, "all parameters (show only)"},
#ifdef	SIGTSTP
  {"bg",     2,	T_BG,	T_NONE,	T_HELP, "background the session", CF_SUSPEND},
#endif	SIGTSTP
  {"break",  3,	T_BREAK,T_NONE,	T_HELP,"send a break"},
  {"breakin",6,	T_BRKIN,T_NONE,	T_SET, "pad breakin character"},
  {"clear",  3,	T_CLR,	T_NONE,	T_HELP, "clear the call"},
  {"clr",    3,	T_CLR,	T_NONE,	T_NONE, "clear the call"},
  {"debug",  5,	T_DEBG,	T_NONE,	T_SET, "debug", CF_RESTRICT},
  {"disconnect", 3, T_DISC,	T_NONE,	T_HELP, "disconnect the call"},
  {"echo",   4,	T_ECHO,	T_NONE,	T_SET, "local echoing (ON/OFF)"},
  {"edit",   4,	T_EDIT,	T_NONE,	T_SET, "local line editing"},
  {"eightbitoutput",7,T_8BIT,	T_NONE,	T_SET, "ouput mask"},
  {"elifhost",8,T_ELIH,	T_NONE,	T_HELP, "host conditional up to endhost"},
  {"elsehost",8,T_ELH,	T_NONE,	T_HELP, "host conditional up to endhost"},
  {"endhost",7,	T_ENDH,	T_NONE,	T_HELP, "end host conditional"},
  {"force",  4,	T_FORCE,T_NONE,	T_HELP, "force parameter to hold value"},
  {"forward",4,	T_FORW,	T_NONE,	T_SET, "forwarding characters:- OR of:\r\n  ++ 1  Alphanumeric characters\r\n  ++ 2  Return\r\n  ++ 4  ESC, BEL, ENQ, ACK\r\n  ++ 8  DEL, CAN, DC2\r\n  ++ 16 ETX, EOT\r\n  ++ 32 HT, LF, VT, FF\r\n  ++ 64 other control chars.\r\n  ++ 127 other characters"},
  {"help",   4,	T_HELP,	T_HELP,	T_HELP, "(Type \"help command\" for more information)"},
  {"idletimeout",4,T_IDLE,	T_NONE,	T_SET, "session idle timeout"},
  {"ifhost", 6,	T_IFH,	T_NONE,	T_HELP, "host conditional up to endhost"},
  {"ignore", 3,	T_IGNR,	T_IGNR,	T_HELP, "ignore host settings of param n"},
  {"intr",   4,	T_INTR,	T_NONE,	T_SET, "unix intr -> BREAK"},
  {"lfinsert",3,T_LFI,	T_NONE,	T_SET, "insertion of LF after CR"},
  {"logfile",4,	T_LOG,	T_NONE,	T_HELP, "select use of logfile", CF_TEXT | CF_RESTRICT},
  {"off",    3,	T_OFF,	T_NONE,	T_ECHO, ""},
  {"on",     2,	T_ON,	T_NONE,	T_ECHO, ""},
  {"par",    3,	T_PAR,	T_NONE,	T_HELP, "show a parameter value"},
  {"param",  5,	T_PARAM,T_NONE,	T_SET,  "arbitary parameter"},
  {"pipe",   4,	T_PIPE,	T_NONE,	T_HELP, "read from a pipe", CF_ASIS|CF_RESTRICT},
  {"quit",   3,	T_QUIT,	T_NONE,	T_HELP, "clear the call and exit"},
  {"read",   4,	T_READ,	T_NONE,	T_HELP, "read from a file", CF_TEXT|CF_RESTRICT},
  {"reset",  3,	T_RESET,T_NONE,	T_HELP,"send a reset"},
  {"set",    3,	T_SET,	T_SET,	T_HELP, "change pad parameters (forward/timeout/echo/edit/lfinsert/breakin/param/verbose/debug/unixesc/eightbitoutput/idletimeout/intr)"},
  {"show",   4,	T_SHOW,	T_SET,	T_HELP, "examine pad parameters (forward/timeout/echo/edit/lfinsert/all/breakin/verbose/debug/unixesc/eightbitoutput/idletimeout/intr)"},
  {"status", 3,	T_STAT,	T_NONE,	T_HELP, "show the status of the call"},
#ifdef	SIGTSTP
  {"suspend",3,	T_SUSP,	T_NONE,	T_HELP, "suspend the session", CF_SUSPEND},
#endif	SIGTSTP
  {"timeout",7,	T_TIMEO,T_NONE,	T_SET, "single character mode (0/1)"},
  {"unforce",4,	T_UFORC,T_NONE,	T_HELP, "allow host to set parameter"},
  {"unixesc",7,	T_UESC,	T_NONE,	T_SET, "unix escape character"},
  {"verbose",4,	T_VERB,	T_NONE,	T_SET, "verbose"},
/*  {"profile",3,	T_PROF,	T_NONE,	T_HELP, "set a terminal profile"}, */
  {NULL,     1,	T_NONE,	T_NONE,	T_NONE, ""}
};

enum ptypes {TOKEN, NUMERIC};

struct {
  enum ptypes ptype;
  enum tokens token;
  enum tokens htoken;
  int value;
  char *string;
} cmdparam[MAXCMDP];

int nparams;			/* how many parameters? */

#include <setjmp.h>

jmp_buf cmdjbuf;

char *currentcmd = "";

/* Set the hostname (if possible) */
sethost(buff, len, def)
char *buff;
int len;
char *def;
{
#ifndef	NOGETHOSTNAME
	if (!gethostname(buff, len) && *buff)	return;
#endif	NOGETHOSTNAME
	strncpy(buff, def, len);
	if (len > 0) buff[len-1] = '\0';
}

cmd(fp, interactive)		/* -1 => EOF, 0 => command, 1 => null cmd */
     FILE *fp;
     int interactive;
{ char thecommand[CMND_LINE_LEN];
  char * thecp;

  if (interactive) {
    if (! *localhost) sethost(localhost, sizeof localhost, "<Amnesia>");
    (void) printf(prompt, localhost);
    (void) fflush(stdout);
  }

  if (interactive)
  { thecp = thecommand;
    while (thecp != thecommand + sizeof thecommand -2)
    { int c = charfromtty(1);
      if (c == NOT_CHAR)	continue;
      if (c == EOF)		return -1;
      if ((c & eightbitinput) == (DEL & eightbitinput))
      { if (thecp == thecommand)	continue;
        if (echoing)
        {	printf((verbose & V_RUBOUT) ? "\b#\b" : "\b \b"); fflush(stdout);}
        thecp--;
        continue;
      }
      if (echoing)
      { putchar(c);
        if ((c & eightbitinput) == '\r') putchar('\n');
        fflush(stdout);
      }
      if ((c & eightbitinput) == '\r' || (c & eightbitinput) == '\n') break;
      *thecp++ = (c & eightbitinput);
    }
    *thecp = '\0';
  }
  else
  { if (fgets(thecommand, sizeof(thecommand), fp) == NULL)
      return -1;
    { int l = strlen(thecommand);
      if (thecommand[l-1] == '\n') thecommand[--l] = '\0';
      if (thecommand[l-1] == '\r') thecommand[--l] = '\0';
    }
  }
  switch(docmd(thecommand, (interactive) ? 0 : fp))
  {
  case 0:	return 0;
  case 1:	return (interactive) ? 0 : 1;	/* Parse error */
  case 2:	return 0;			/* Comment */
  case 3:	return (interactive) ? 1 : 0;	/* Null line */
  default:	return 1;			/* ?? */
  }
  /* NOTREACHED */
}

/* What is the result of this routine ? */
docmd(thecommand, fp)
char *thecommand;
FILE *fp;
{ char *p;
  char cmdbuf[CMND_LINE_LEN];
  if (setjmp(cmdjbuf) == 1) return 1;

  currentcmd = thecommand;
  if (p= index(thecommand, '\n')) *p = 0;
  (void) strcpy(cmdbuf, thecommand);
  if (*cmdbuf == '#')	return 2;	/* comments, indeed. */
  if (*cmdbuf == '@') { docmdf(&cmdbuf[1], 0); return 0; }

  parse(cmdbuf);
  if (nparams == 0) return 3;		/* no stroke offered */
  switch(((cmdparam[0].value & CF_RESTRICT) && forbid_some_pad_cmds) ? T_0 :
 	 ((cmdparam[0].value & CF_SUSPEND ) && forbid_suspend) ? T_0 :
		cmdparam[0].token) {
#ifdef	SIGTSTP
  case T_BG:	background_tty();	return 3;
#endif	SIGTSTP
  case T_BREAK:	dobreakin('b'); /* sendinttox25();sendindofbreak(0); */	break;
  case T_ELIH:	doifhost(fp);						break;
  case T_ELH:	doifhost(fp);						break;
  case T_ENDH:	/* NOTHING */						break;
  case T_FORCE:	doset(101);						break;
  case T_HELP:	dohelp(cmdparam[nparams-1].htoken);			break;
  case T_IFH:	doifhost(fp);						break;
  case T_IGNR:	doignore();						break;
  case T_LOG:	dologfile();						break;
  case T_PIPE:	if (open_pipe())	return 3;			break;
  case T_PROF:	doprofile();						break;
  case T_CLR:
  case T_DISC:
  case T_QUIT:	padexit(0);	/* NOTREACHED */
  case T_READ:	if (open_reading())	return 3;			break;
  case T_RESET:	sendresettox25();					break;
  case T_SET:	doset(0);						break;
  case T_PAR:
  case T_SHOW:	doshow();						break;
  case T_STAT:	dostatus();						break;
#ifdef	SIGTSTP
  case T_SUSP:	suspend_tty();						break;
#endif	SIGTSTP
  case T_UFORC:	doset(-101);						break;
  default:	parserror("Unrecognised key"); dohelp(T_HELP);		break;
  }
  return 0;
}

#ifdef	SIGTSTP
suspend_tty()
{
    kill(getpid(), SIGTSTP);
}

background_tty()
{
    ignore_cont = 1;
    suspendedy = 1;
    resettty();
    suspend_tty();
}
#endif	SIGTSTP

parse(string)
     char *string;
{
  char *skipsp(), *matchtoken();
  int i;
  int text=0;
  int asis=0;

  nparams = MAXCMDP;
  for (i= 0; i < MAXCMDP; i++) {
    cmdparam[i].string = string;

    /* OK, we have command name, so parse it ... */
    if (i == 1)
    {	if (verbose & V_8_) fprintf(stderr, "parse(%s|%s) gave %x\r\n",
		cmdparam[0].string, string, cmdparam[0].value);
	if (cmdparam[0].value & CF_TEXT) text=1;
	if (cmdparam[0].value & CF_ASIS) text=1, asis=1;
	if (!(cmdparam[0].value & (CF_ASIS | CF_TEXT))) canonical(string, 1);
    }

    if (*string == 0)		/* string has run out -- ensure all zapped */
    { cmdparam[i].token	= T_NONE;
      cmdparam[i].htoken= T_NONE;
      cmdparam[i].ptype	= TOKEN;
      cmdparam[i].value	= 0;
      if (nparams == MAXCMDP) nparams = i;
    }
    else if (text)		/* We want text, so just pass it over */
    { while(*string && (*string != ' ' || asis)) string++;
      cmdparam[i].ptype	= TOKEN;
    }
    else if (('a' <= *string) && (*string <= 'z'))	/* A token ? */
      string = matchtoken(i, string);
    else if (('0' <= *string) && (*string <= '9'))	/* A number ? */
    { int base = ((*string == '0') ? 8: 10);
      int val = *string++ -  '0';
      char *ix;
      char hextob[16]; (void) strcpy(hextob, "0123456789abcdef");

      if (*string == 'x')
      { base = 16;
	string++;
      }
      else hextob[10] = 0;

      while (*string && *string != ' ')
	if (ix = index(hextob, *string))
	{ val = val * base + (ix - hextob);
	  string++;
	}
	else parserror("not a pure number");

      cmdparam[i].ptype = NUMERIC;
      cmdparam[i].value = val;
    }
    else			/* just a character */
    { cmdparam[i].ptype = NUMERIC;
      cmdparam[i].value = *string++;
      if (*string || *string == ' ') parserror("more than one character");
    }

    { char *next = skipsp(string);
      *string = '\0';
      string = next;
    }
  }
}

parserror(text)
char *text;
{
  (void) printf("error (%s) in \"", text);
  for (text=currentcmd; *text; text++) if (isprint(*text))
	putchar(*text);
  else	(void) printf("<%02x>", *text & 0xff);
  (void) printf("\" (try `help')\r\n");
  longjmp(cmdjbuf, 1);
}

char *skipsp(s)
     char *s;
{ while (*s == ' ')	s++;
  return s;
}

/* return the number of bytes in result */
canonical(s, force_lower)	/* canonise s in place - interpret: */
register char *s;		/* \r\n, \r, \0nnn, ^[a-z], C-[a-z] */
int force_lower;
{
  register char *o;
  char *base = s;
  int val = 0;	/* Keep kint etc happy */
  o= s;
  while (1) {
    if (*s == '\\') {
      switch (*++s) {
      case 0: *o = 0; return o-base;
      case 'n': *o++ = '\n'; s++; break;
      case 'r': *o++ = '\r'; s++; break;
      case '\\': *o++ = '\\'; s++; break;
      case '0':
	val = 0; s++;
	while (('0' <= *s) && (*s <= '7')) {
	  val = (val << 3) + *s++ - '0';
	}
	*o++ = val; break;
      default:
	*o++ = val;
      }
    } else if (*s == 0) {
      *o = 0; return o - base;
    } else if ((*s == '^') &&
	       ((('a' <= s[1]) && (s[1] <= '~')) ||
		(('A' <= s[1]) && (s[1] <= '_')))) {
      *o++ = (s[1] - 'A' + 1) & ~ ('a' - 'A'); s+= 2;
    } else if ((*s == 'C') && (s[1] == '-') &&
	       ((('a' <= s[2]) && (s[2] <= '~')) ||
		(('A' <= s[2]) && (s[2] <= '_')))) {
      *o++ = (s[2] - 'A' + 1) & ~ ('a' - 'A'); s+= 3;
    } else if (('A' <= *s) && (*s <= 'Z') && force_lower)
      *o++ = *s++ + 'a' - 'A';
    else
      *o++ = *s++;
  }
}

dohelp(type)
     enum tokens type;
{
  struct cmds *cmdp = commands;
  fprintf(stderr, "Press CTRL/P then H in the session for a list of\r\n");
  fprintf(stderr, "  characters that can follow CTRL/P.\r\n");
  (void) fprintf(stderr, "Commands that can be used here are:\r\n");
  fprintf(stderr, "<RETURN> return to session\r\n");
  for (; cmdp->c_cmd; cmdp++) if (cmdp->c_helpcontext == type)
    if (!((cmdp->c_flags & CF_RESTRICT) && forbid_some_pad_cmds) &&
        !((cmdp->c_flags & CF_SUSPEND ) && forbid_suspend) )
      (void) fprintf(stderr, "\"%s\" %s\r\n", cmdp->c_cmd, cmdp->c_helpms);
}

open_pipe()
{ if (nparams < 2)
  { fprintf(stderr, "pipe expects a command\r\n");
    return 0;
  }
  fprintf(stderr, "Call '%s'\r\n", cmdparam[1].string);
  if (! (reading = popen(cmdparam[1].string, "r"))) return 0;

  reading_pipe = 1;
  return 1;
}

open_reading()
{
  if (nparams != 2)
  { fprintf(stderr, "read expects a filename\r\n");
    return 0;
  }
  fprintf(stderr, "Read '%s'\r\n", cmdparam[1].string);
  if (access(cmdparam[1].string, R_OK) ||
      (reading = fopen(cmdparam[1].string, "r")) == NULL) return 0;

  reading_pipe = 0;
  return 1;
}

dologfile()
{ if (nparams < 2)
  { fprintf(stderr, "logfile expects on, off, close, create or append\r\n");
    return 0;
  }
  if (strcmp(cmdparam[1].string, "on") == 0)
  { if (!termlogf)
    { fprintf(stderr, "No logfile to turn on. Open it first.\r\n");
      return 0;
    }
    use_termlogf = 1;
  }
  else if (strcmp(cmdparam[1].string, "off") == 0)
  { if (!termlogf)
    { fprintf(stderr, "No logfile to turn off. Open it first.\r\n");
      return 0;
    }
    use_termlogf = 0;
  }
  else if (strcmp(cmdparam[1].string, "close") == 0)
  { if (!termlogf)
    { fprintf(stderr, "No logfile to close. Open it first.\r\n");
      return 0;
    }
    fclose(termlogf);
    termlogf = (FILE *) 0;
    use_termlogf = 0;
  }
  else if (strcmp(cmdparam[1].string, "create") == 0 ||
	   strcmp(cmdparam[1].string, "append") == 0)
  { if (termlogf)
    { fprintf(stderr, "logfile already open. Use close first\r\n");
      return 0;
    }
    if (nparams != 3)
    { fprintf(stderr, "'logfile %s' expects a filename\r\n", cmdparam[1].string);
      return 0;
    }
    if (termlogf = fopen(cmdparam[2].string,
			(strcmp(cmdparam[1].string, "append") ? "w" : "a")))
      use_termlogf = 1;
    else
    { fprintf(stderr, "failed to open %s:", cmdparam[2].string);
      fflush(stderr);
      perror("");
      return 0;
    }
  }
  else
  { fprintf(stderr, "logfile expects on, off, close, create or append\r\n");
    return 0;
  }
  return 1;
}

doifhost(fp)
FILE *fp;
{ int i;

  if (!fp)
  { fprintf(stderr, "ifhost not useful interactively\r\n");
    return;
  }

  for (i=1; i< nparams; i++)
    if (strcmp(called_char_addr.name ? called_char_addr.name : "",
   	 cmdparam[i].string)==0) break;

  if (i>=nparams) while(1)
  { char cmdbuf[CMND_LINE_LEN];

    if (!fgets(cmdbuf, sizeof cmdbuf, fp))
    { fprintf(stderr, "EOF while in ifhost\r\n");
      break;
    }
    { int l = strlen(cmdbuf);
      if (cmdbuf[l-1] == '\n') cmdbuf[l-1] = '\0';
    }
    parse(cmdbuf);
    if (nparams > 0 && cmdparam[0].token == T_ELIH)
    {	doifhost(fp); return; }
    else if(nparams > 0 &&
	(cmdparam[0].token == T_ENDH || cmdparam[0].token == T_ELH)) break;
  }
}

doignore()
{ if (nparams != 3 || cmdparam[1].ptype != NUMERIC || !dosvalidateonoff())
  { fprintf(stderr, "expected: ignore <param #> [on|off]\r\n"); return; }
  if (0<ignore_p[cmdparam[1].value] || ignore_p[cmdparam[1].value] >= P_MAX)
  { fprintf(stderr, "param should br in range 1 - %d\r\n", P_MAX-1); return; }
  ignore_p[cmdparam[1].value] = (cmdparam[2].token == T_ON);
}

doprofile()
{ if (nparams != 2 /*|| cmdparam[2].type != STRING*/)
  { fprintf(stderr, "expected: profile <termtype>\r\n"); return; }
  docmdf(cmdparam[2].string, 1);
}

dostatus()
{ 
  int in, out;
  get_pkts(&in, &out);
  if (nparams != 1) { fprintf(stderr, "expected: status\r\n"); return; }
  printf(" +++- Call by %s to %s: in %d/%d out %d/%d\r\n",
	x25sbuf.x_username,
	x25sbuf.x_destination,
	bytesin, pktsin,
	bytesout, pktsout);
  if (in != pktsin || out != pktsout)
    printf(" +++- actually  in %d/%d  out %d/%d\r\n",
		bytesin, in, bytesout, out);
  print_facil(&x25sbuf.x_facil, stdout);
}

doset(type)
int type;
/* set or force or unforce
 * set breakin char
 * set debug n
 * set echo ON/OFF
 * set edit ON/OFF
 * set eightbitoutput ON/OFF
 * set forward n
 * set idletimeout ON/OFF
 * set lfinsert n
 * set param n n
 * set timeout n
 * set unixesc char
 * set verbose n
 */
{
  switch (cmdparam[1].token) {
  case T_8BIT:	dos8bit();						break;
  case T_BRKIN:	dosbreakin();						break;
  case T_DEBG:	dosdebug();						break;
  case T_ECHO:	dosecho(type);						break;
  case T_EDIT:	dosedit(type);						break;
  case T_FORW:	dosforward(type);					break;
  case T_IDLE:	dosidle();						break;
  case T_INTR:	dosintr();						break;
  case T_LFI:	doslfinsert(type);					break;
  case T_PARAM:	dosparam(type);						break;
  case T_TIMEO:	dostimeout(type);					break;
  case T_UESC:	dosunixesc();						break;
  case T_VERB:	dosverbose();						break;
  default: fprintf(stderr, "expected: %s forward/timeout/echo/lfinsert/breakin/edit/param/verbose/debug/unixesc/eightbitoutput/idletimeout/intr\r\n",
	(type == -101) ? "unforce" : (type == 101) ? "force" : "set");
  }
}

dosforward(type)
int type;
{
  if (dosvalidatenumber())
  { param3 = cmdparam[2].value;
    if (type == 101)	ignore_p[P_3] = 1;
    if (type == -101)	ignore_p[P_3] = 0;
    showparam(P_3);
    setforward();
  }
  else fprintf(stderr, "expected: %s forward <number>\r\n",
	(type == -101) ? "unforce" : (type == 101) ? "force" : "set");
}

dostimeout(type)
int type;
{
  if (dosvalidatenumber())
  { param4 = cmdparam[2].value;
    if (type == 101)	ignore_p[P_4] = 1;
    if (type == -101)	ignore_p[P_4] = 0;
    showparam(P_4);
  }
  else fprintf(stderr, "expected: %s timeout <number>\r\n",
	(type == -101) ? "unforce" : (type == 101) ? "force" : "set");
}

dosecho(type)
int type;
{
  if (dosvalidateonoff())
  { param2 = (cmdparam[2].token == T_ON);
    setecho();
    if (type == 101)	ignore_p[P_2] = 1;
    if (type == -101)	ignore_p[P_2] = 0;
    showparam(P_2);
  } else
    fprintf(stderr, "expected: %s echo on/off\r\n",
	(type == -101) ? "unforce" : (type == 101) ? "force" : "set");
}

doslfinsert(type)
int type;
{
  if (dosvalidatenumber())
    if (param13 & ~7)
      fprintf(stderr, "LineFeed insert can have bits 1, 2 or 4 set, i.e. 0-7\r\n");
    else
    { param13 = cmdparam[2].value;
      if (type == 101)	ignore_p[P_13] = 1;
      if (type == -101)	ignore_p[P_13] = 0;
      showparam(P_13);
    }
  else
    fprintf(stderr, "expected: %s lfinsert <n>\r\n",
	(type == -101) ? "unforce" : (type == 101) ? "force" : "set");
}

dosparam(type)
int type;
{ int p = cmdparam[2].value;
  int v = cmdparam[3].value;
  
  if (dosvalidatenumber() && 0 < p && p < P_MAX &&
	(cmdparam[3].ptype == NUMERIC ||
	cmdparam[3].token == T_ON || cmdparam[3].token == T_OFF))
  { if (cmdparam[3].token == T_ON)  v = 1;
    if (cmdparam[3].token == T_OFF) v = 0;
    if (type == 101)	ignore_p[p] = 1;
    if (type == -101)	ignore_p[p] = 0;
    setparameter(p, v);
    if (!(verbose & V_4_)) showparam(p);
  }
  else fprintf(stderr, "expected: %s param <number> <number>|ON|OFF\r\n",
	(type == -101) ? "unforce" : (type == 101) ? "force" : "set");
}

dosedit(type)
int type;
{
  if (dosvalidateonoff())
  { param15 = (cmdparam[2].token == T_ON);
    if (type == 101)	ignore_p[P_15] = 1;
    if (type == -101)	ignore_p[P_15] = 0;
    showparam(P_15);
  } else
    fprintf(stderr, "expected: %s edit on/off\r\n",
	(type == -101) ? "unforce" : (type == 101) ? "force" : "set");
}

dosverbose()
{
  if (cmdparam[2].ptype == NUMERIC)
    verbose = cmdparam[2].value;
  else
    fprintf(stderr, "expected: set verbose <n>\r\n");
}

dosdebug()
{
  if (cmdparam[2].ptype == NUMERIC)
    debug = cmdparam[2].value;
  else
    fprintf(stderr, "expected: set debug <n>\r\n");
}

dosbreakin()
{
  if (dosvalidatenumber())
  { breakinch = cmdparam[2].value;
    showparam(P_BRKIN);
  } else
    fprintf(stderr, "expected: set breakin C-x/\\0nnn\r\n");
}

dos8bit()
{
  if (dosvalidateonoff())
  { eightbitoutput = (cmdparam[2].token == T_ON) ? 0xff : 0x7f;
    showparam(P_8BIT);
  } else
    fprintf(stderr, "expected: set eightbitoutput on/off\r\n");
}

dosidle()
{
  if (cmdparam[2].ptype == NUMERIC)
  { idle_timeout = cmdparam[2].value;
    alarm(idle_timeout);
    if (idle_timeout) (void) signal(SIGALRM, SIGARG2 sess_idle_logout);
    showparam(P_IDLE);
  } else
    fprintf(stderr, "expected: set idletimeout <n>\r\n");
}

dosunixesc()
{
  if (dosvalidatenumber())
  { unixesc = cmdparam[2].value;
    showparam(P_UESC);
  } else
    fprintf(stderr, "expected: set unixesc C-x/\\0nnn\r\n");
}


dosvalidateonoff()
{
  enum tokens t = cmdparam[2].token;
  return ((t == T_ON) || (t == T_OFF));
}

dosvalidatenumber()
{
  return cmdparam[2].ptype == NUMERIC;
}

doshow()
/*
 * show all
 * show breakin
 * show debug
 * show echo
 * show edit
 * show forward
 * show timeout
 * show verbose
 */
{
  switch (cmdparam[1].token) {
  case T_8BIT:	showparam(P_8BIT);					break;
  case T_ALL:	{ int i; for(i=1;i<=P_MAX;i++) showparam(i);}		break;
  case T_BRKIN:	showparam(P_BRKIN);					break;
  case T_DEBG:	showparam(P_DEBUG);					break;
  case T_ECHO:	showparam(P_2);						break;
  case T_EDIT:	showparam(P_15);					break;
  case T_FORW:	showparam(P_3);						break;
  case T_IDLE:	showparam(P_IDLE);					break;
  case T_INTR:	showparam(P_INTR);					break;
  case T_TIMEO:	showparam(P_4);						break;
  case T_UESC:	showparam(P_UESC);					break;
  case T_VERB:	showparam(P_VERB);					break;
  default:	fprintf(stderr,
	"expected: show forward/timeout/echo/breakin/edit/all/verbose/debug/unixesc/eightbitoutput/idletimeout/intr\r\n");
  }
}

char *
matchtoken(i, s)
     int i;
     char *s;
{
  struct cmds *cmdp;
  char *p; int n;
  if ((p = index(s, ' ')) == NULL) p = s + strlen(s);
  n = p - s;
  for (cmdp = commands; cmdp->c_cmd; cmdp++)
    if (strncmp(s, cmdp->c_cmd, n) == 0 && n >= cmdp->c_min) break;
  cmdparam[i].htoken = cmdp->c_htoken;
  cmdparam[i].ptype = TOKEN;
  cmdparam[i].token = cmdp->c_token;
  cmdparam[i].value = cmdp->c_flags;
  return p;
}


/* deal with ~/.spad.rc and ~/.spad.<host>.rc files */

dorcfile(host)
     char *host;
{
  char *home = getenv("HOME");
  char fnbuf[MAXFN];
  int quiet = 0;
  if (system_rc || !home || ! *home) { home = SYSTEM_HOME; quiet++; }

  if ((strlen(home) + strlen(host) + 9 + 1) > MAXFN)
  { clientmes0(X25F_CLOSING, "Your HOME directory name is too long!");
    padexit(2);			/* who said paranoia? */
  }
  (void) sprintf(fnbuf, "%s/.spad.rc", home);
  docmdf(fnbuf, quiet);
  (void) sprintf(fnbuf, "%s/.spad.%s.rc", home, host);
  docmdf(fnbuf, quiet);
}

docmdf(fn, quiet)
     char *fn;
     int quiet;
{
  FILE *f;			/* check for read permission in case segid */
  if (access(fn, R_OK) == 0)	/* silently ignore missing */
    if (f = fopen(fn, "r"), f != NULL) { /* or inaccessible files */
      if (!quiet) { fprintf(stderr, "reading commands from %s...\r\n", fn);
      	fflush(stderr);
      }
      while (cmd(f, 0) != -1) {}
      if (!quiet) {
      	fprintf(stderr, "done.\r\n");
      	fflush(stderr);
      }
      fclose(f);
    }
}


/* COMMUNICATIONS routines */

#include <pwd.h>		/* get struct passwd definition */

/* findusername() returns a pointer to a static username string */
char *
findusername()
{   struct passwd *pw;

#ifdef	TELNETD
    if (telnetd != 0)
	return (role == DIRECT && isdigit(*tel_sender)) ? tel_defsend : tel_sender;
#endif	TELNETD
    if (pw = getpwuid(getuid())) return pw->pw_name;
    return "??";
}

/* setuprq initialises the x25sbuf record with the call data.
   for convenience, this is done even in the direct case
*/

setuprq(dest)
     char *dest;
{
#ifdef	notdef
  char *getlogin();
#endif	notdef
  char *user;
  char *addr;
  char *lookup();

  /*--fprintf(stderr, "dest was `%s'\n", dest);--*/
  user = findusername();

#ifdef notdef
  user = getlogin();
  if (user == NULL)
  { struct passwd *pw, *getpwuid();
    pw = getpwuid(getuid());
    if (pw != NULL)
      user = pw->pw_name;
    (void) endpwent();
  }
  if (user == NULL) user = "??";
#endif notdef

  (void) strcpy(x25sbuf.x_username, user);
  if(debug & D_1_) fprintf(stderr, " ++   User %d gives '%s|%s'\r\n",
		getuid(), user, x25sbuf.x_username);
  if (addr=lookup(dest, (char*)0,0, x25sbuf.x_context, x25sbuf.x_network, role))
{ /*--fprintf(stderr, "lookup '%s' gave `%s'\n", dest, addr);--*/
	(void) strcpy(x25sbuf.x_destination, addr);
}
  else	(void) strcpy(x25sbuf.x_destination, (dest) ? dest : "");
  /*--fprintf(stderr, "dest set to `%s'\n", x25sbuf.x_destination);--*/
}

/* fromx25 - a packet has arrived from the X.25 link.
 * in the case of a client, it has actually arrived from the X.25 server
 * returns the number of REAL data bytes read.
*/

/* ARGSUSED */
fromx25(data)
char data;
{				/* used in client and direct */
  int count, acount;

#ifdef	SERVERCODE
  if (role != CLIENT) { return readfromx25(data); } /* DIRECT CONNECTION */
#endif	SERVERCODE

  count = recvfill(clienttoserver, (char *)&x25ibuf, x25hdrsize, 0);
  if(debug & D_1_)
  {	int i;
	fprintf(stderr, "+fromx25  hdr+ %db:", count);
	if (debug & D_2_) for(i=0; i<count; i++)
		fprintf(stderr, " %02x", ((unsigned char *)&x25ibuf)[i]);
	fprintf(stderr, "]\r\n");
  }
  if (count != x25hdrsize)
  { if (count < 0)
    { if (errno == EINTR)
      {	perror(" +++ soft error: client recv");
	fprintf(stderr, "\r"); fflush(stderr);
	return TTY_NODATA;
      }
      resettty();
      perror("client recv");
      padexit(1);
    } else if (count == 0)
    { if (!(x25ibuf.x_flags & X25F_CLOSING))
	fprintf(stderr, "\r\n ++   x25 server closed connection\r\n");
      padexit(1);
    } else
    { resettty();
      fprintf(stderr, "client recv: short delivery - wanted %d, got %d\r\n",
	       x25hdrsize, count);
      return TTY_NODATA;
    }
  }

  if (x25ibuf.x_version != X25IO_VER)
  {   int extra_text, i;
      resettty();
      fprintf(stderr, "client recv: Invalid version %d (%d)\r\n",
	       x25ibuf.x_version, X25IO_VER);
      extra_text = read(clienttoserver, ((char *)&x25ibuf) + x25hdrsize,
    	  sizeof x25ibuf - 1 - x25hdrsize);
      if (extra_text > 0) extra_text += x25hdrsize;
      else extra_text = x25hdrsize;

      fprintf(stderr, " [%d: ", extra_text);
      for (i=0; i<extra_text; i++) fprintf(stderr,
	(isprint(((char *)&x25ibuf)[i])) ? "%c" : "<%02x>",
	((char *)&x25ibuf)[i] & 0xff);
      fprintf(stderr, "]\r\n");
      padexit(1);
  }

  count = (x25ibuf.x_count_ms << 8) + x25ibuf.x_count_ls +1+TS29_BYTES;
  acount = recvfill(clienttoserver, (char *)x25ibuf.x_rawbuf, count, 0);
  if(debug & D_1_)
  {	int i;
	fprintf(stderr, "+fromx25 data+ %d/%db:", count, acount);
	if (debug & D_2_) for(i=0; i<acount; i++)
	  fprintf(stderr, " %02x", ((unsigned char*)x25ibuf.x_rawbuf)[i]);
	fprintf(stderr, "]\r\n");
  }

  if (count != acount)
  { if (acount < 0)
    { perror("client recv B");
      padexit(1);
    } else if (acount == 0)
    { if (!(x25ibuf.x_flags & X25F_CLOSING))
	fprintf(stderr, "\r\n ++   x25 server closed connection (B)\r\n");
      padexit(1);
    } else
    { fprintf(stderr, "client recv B: short delivery - wanted %d, got %d\r\n",
       count, acount);
      padexit(1);
    }
  }
  return count-1-TS29_BYTES;
}

/* sendtox25 - send a packet to the X.25 link.
 * in the client case, we need to send an X25obuf structure to the server
 * count is the DATA part only
 */

sendtox25(x25buf, count, flags, send_type)
     struct x25io *x25buf;
     int count, flags, send_type;
{				/* USED in client and direct */
  x25buf->x_flags	= flags;
  x25buf->x_count_ms	= count / 256;
  x25buf->x_count_ls	= count % 256;
  x25buf->x_send_type	= send_type;

  if (send_type == 0x80) fprintf(stderr, "sendtox25 given duff send_type\n");
  bytesout += count;
  pktsout += (count-1) / pktosize + 1;
/*-*/
   if (0)
   { int in, out;
     get_pkts(&in, &out);
     if (out != pktsout) fprintf(stderr, "After %d (%d:%d) %d != %d\n",
		count, (count-1) / pktisize + 1, pktosize, out, pktsout);
   }
/*-*/

  if(debug & D_1_)
  {	int i;
	fprintf(stderr, "\r\n+C+[t%x, f%x, %db%s:",
			send_type, flags, count, (ts29) ? " (ts29)" : "");
	for(i=0; i<x25hdrsize; i++)
		fprintf(stderr, " %02x", ((unsigned char *)x25buf)[i]);
	fprintf(stderr, ":");
	for(; i<(x25hdrsize+TS29_BYTES); i++)
		fprintf(stderr, " %02x", ((unsigned char *)x25buf)[i]);
	fprintf(stderr, ":");
	if (debug & D_2_) for(; i<(x25hdrsize+count+TS29_BYTES); i++)
		fprintf(stderr, " %02x", ((unsigned char *)x25buf)[i]);
	fprintf(stderr, " (%02x)", ((unsigned char *)x25buf)[i]);
	fprintf(stderr, "]\r\n");
	fflush(stderr);
  }
  if (ts29)
  { x25buf->x_flags |= X25F_TSPAD;
    x25buf->x_tspad = 0;
    /* Convert X29 Q bit to TS29 Q bit */
    if (x25buf->x_send_type & (1 << Q_BIT))
    { x25buf->x_send_type &= ~ (1 << Q_BIT);
      x25buf->x_tspad |= 0x80;
    }
    if (debug & D_1_) fprintf(stderr, "ts29: pad is %02x, hdr is %02x\r\n",
      x25buf->x_tspad,
      x25buf->x_send_type);
  }

  if (role == CLIENT)
  { if (send(clienttoserver, (char *)x25buf,
				x25hdrsize + count+1+TS29_BYTES, 0) < 0)
    { perror("send to server");
      padexit(1);
    }
    return;
  }				/* ELSE direct case */
#ifdef	SERVERCODE
  sendtox25socket(x25buf, count);
#endif	SERVERCODE
}




/* TERMINAL initialisation and restoration */

passintr()
{
  signal(SIGINT, SIG_IGN);
  dobreakin('b');
  signal(SIGINT, SIGARG2 passintr);
}

dosintr()
{
  if (dosvalidatenumber())
  { intr = cmdparam[2].value;
#ifdef	TCHARS
    tcharsa.t_intrc   = intr;
#endif	TCHARS
#ifdef	TERMIO
    termioa.c_cc[VINTR]		= intr;
#endif	TERMIO
    showparam(P_INTR);
  } else
    fprintf(stderr, "expected: set intr C-x/\\0nnn\r\n");
}

settty()
{
#ifdef	TELNETD
  if (telnetd > 0) set_native_telnet(native_telnet,
			(native_telnet) ? WILL : WONT,
			(native_telnet) ? WILL : WONT);
  else if (telnetd == 0)
#endif	TELNETD
  { signal(SIGINT, SIGARG2 passintr);
    /* assume stderr is a tty */

#ifdef	SGTTYB
    ioctl(2, TIOCGETP, &sgttyba);
    bcopy((char *)&sgttyba, (char *)&sgttybb, sizeof(sgttyba));
    sgttyba.sg_flags     &= ~(ECHO | CRMOD);
    sgttyba.sg_erase	= stty_ign;	/* char delete */
    sgttyba.sg_kill	= stty_ign;	/* line delete */
#ifdef	TIOCSETN
    ioctl(2, TIOCSETN, &sgttyba);
#else
    ioctl(2, TIOCSETP, &sgttyba);
#endif
#endif	SGTTYB

#ifdef	TCHARS
    ioctl(2, TIOCGETC, &tcharsa);
    bcopy((char *)&tcharsa, (char *)&tcharsb, sizeof(tcharsa));
    if (intr)	intr = tcharsa.t_intrc;
    else
    { tcharsa.t_intrc	= stty_ign;	/* interrupt */
      intr = NOT_CHAR;
    }
    tcharsa.t_quitc	= stty_ign;	/* quit */
/*tcharsa.t_startc	= stty_ign;	** start output */
/*tcharsa.t_stopc	= stty_ign;	** stop output */
    tcharsa.t_eofc	= stty_ign;	/* end-of-file */
    tcharsa.t_brkc	= stty_ign;	/* input delimiter (like nl) */
    ioctl(2, TIOCSETC, &tcharsa);
#endif	TCHARS

#ifdef	TERMIO
    ioctl(2, TCGETA, &termioa);
    bcopy((char *)&termioa, (char *)&termiob, sizeof(termioa));
    if (intr)	intr = termioa.c_cc[VINTR];
    else
    { termioa.c_cc[VINTR]	= stty_ign;	/* interrupt */
      intr = NOT_CHAR;
    }
    termioa.c_cc[VQUIT]	= stty_ign;	/* quit */
    termioa.c_cc[VMIN]	= 1;
    termioa.c_cc[VTIME]	= 0;
    termioa.c_iflag	&= ~( TERM_I_MASK );
    termioa.c_iflag	|=  ( TERM_I_MASK_COOKED );
    termioa.c_lflag	&= ~( TERM_L_MASK );
    termioa.c_lflag	|=  ( TERM_L_MASK_COOKED );
    ioctl(2, TCSETA, &termioa);
#endif	TERMIO

#ifdef	TIOCGLTC
    ioctl(2, TIOCGLTC, &ltchara);
    bcopy((char *)&ltchara, (char *)&ltcharb, sizeof(ltchara));

    if (ltchara.t_suspc) suspendc = ltchara.t_suspc;
    ltchara.t_suspc	= stty_ign;	/* stop process signal */
    ltchara.t_dsuspc	= stty_ign;	/* delayed stop process signal */
    ltchara.t_rprntc	= stty_ign;	/* reprint line */
    ltchara.t_flushc	= stty_ign;	/* flush output (toggles) */
    ltchara.t_werasc	= stty_ign;	/* word erase */
    ltchara.t_lnextc	= stty_ign;	/* literal next character */
    ioctl(2, TIOCSLTC, &ltchara);
#endif	TIOCGLTC

#ifdef	TIOCLSET
    ioctl(2, TIOCLGET, &lmode);
#endif	TIOCLSET

    setbuf(stdout, stdoutbuf);
  }
  rawtty = 1;
  have_settty ++;
  setmessage();
}

/* Resuming remote connection */
reresettty() {
  if (!have_settty)	{ settty();	return; }
  if (rawtty)	return;

  if ((role == DIRECT) || (role == CLIENT)) {
#ifdef	TELNETD
    if (telnetd > 0) set_native_telnet(native_telnet,
			(trrste) ? WILL : WONT,
			(trrstm) ? WILL : WONT);
    else if (telnetd == 0)
#endif	TELNETD
    {
#ifdef SHELLTOOLBUG
      sleep(2-1);			/* avoid shelltool bug */
#endif SHELLTOOLBUG
#ifdef	SGTTYB
#ifdef	TIOCSETN
      ioctl(2, TIOCSETN, &sgttyba);
#else
      ioctl(2, TIOCSETP, &sgttyba);
#endif
#endif	SGTTYB
#ifdef	TCHARS
      ioctl(2, TIOCSETC, &tcharsa);
#endif	TCHARS
#ifdef	TERMIO
    ioctl(2, TCSETA, &termioa);
#endif	TERMIO
#ifdef	TIOCGLTC
      ioctl(2, TIOCSLTC, &ltchara);
#endif	TIOCGLTC
    }
    rawtty = 1;
  }
}

/* Suspending remote connection */
resettty() {
  if (!rawtty)		return;

  if ((role == DIRECT) || (role == CLIENT))
  {
#ifdef	TELNETD
    if (telnetd > 0)
    { trrste = myopts[TELOPT_ECHO];
      trrstm = myopts[TELOPT_SGA];
      set_native_telnet(native_telnet,
			(native_telnet) ? WONT : WONT,
			(native_telnet) ? WONT : WONT);
    }
    else if (telnetd == 0)
#endif	TELNETD
    { /* Remember just how the tty was for reresettty */
#ifdef	SGTTYB
      ioctl(2, TIOCGETP, &sgttyba);
#endif	SGTTYB
#ifdef	TCHARS
      ioctl(2, TIOCGETC, &tcharsa);
#endif	TCHARS
#ifdef	TERMIO
      ioctl(2, TCGETA, &termioa);
#endif	TERMIO
#ifdef	TIOCGLTC
      ioctl(2, TIOCSLTC, &ltchara);
#endif	TIOCGLTC
#ifdef SHELLTOOLBUG
      sleep(2-1);			/* avoid shelltool bug */
#endif SHELLTOOLBUG
#ifdef	SGTTYB
#ifdef	TIOCSETN
      ioctl(2, TIOCSETN, &sgttybb);
#else
      ioctl(2, TIOCSETP, &sgttybb);
#endif
#endif	SGTTYB
#ifdef	TCHARS
      ioctl(2, TIOCSETC, &tcharsb);
#endif	TCHARS
#ifdef	TERMIO
      ioctl(2, TCSETA, &termiob);
#endif	TERMIO
#ifdef	TIOCGLTC
      ioctl(2, TIOCSLTC, &ltcharb);
#endif	TIOCGLTC
#ifdef	TIOCLSET
      ioctl(2, TIOCLSET, &lmode);
#endif	TIOCLSET
    }
    rawtty = 0;
  }
}


/* CLIENT - specific stuff */

setupclient()
{
  struct sockaddr_in to;
  struct hostent *host = (struct hostent *) 0;	/* Keep lint etc happy */
  char *servers;
  int portn = 0;	/* Keep lint etc happy */
  int count;
  char *next;

  servers = getenv("X29SERVER");
  if (!servers) servers = servername;
  clienttoserver = -1;

#ifdef	SERVICEFORM
  sprintf(service_buf, service_form, X25IO_VER);
#else	SERVICEFORM
#ifdef	SERVICEFIRST
  strcpy(service_buf, servicefirst);
#else
  strcpy(service_buf, service);
#endif
#endif	SERVICEFORM
#if     (X25IO_VER > 5)
  if (((char *)&x25sbuf.x_sbuf.x3_pad3) - ((char *)(&x25sbuf.x_sbuf)) != x25sbuf_size -1)
  { fprintf(stderr, "Internal problem - contact maintainer (x3_pad3 %d/%d)\n",
      ((char *)&x25sbuf.x_sbuf.x3_pad3) - ((char *)(&x25sbuf.x_sbuf)),
      x25sbuf_size);
#ifdef  TELNETD
    sleep(1);
#endif  TELNETD
    exit(1);
  }

  x25sbuf.x_sbuf.x3_pad3 = x25sbuf_size & 0xff;
#endif 

  for (;; strcpy(service_buf, service))
  { if (port) portn = htons(atoi(port));
    else
    { struct servent *sp = getservbyname(service_buf, "tcp");
      if (!sp)
      { if(strcmp(service_buf, service)) continue;
	if (isdigit(*service_buf)) portn = htons(atoi(service_buf));
	else
	{ fprintf(stderr, "no %s/tcp service\r\n", service);
#ifdef	TELNETD
	  sleep(1);
#endif	TELNETD
	  exit(1);
	}
      }
      else portn = sp->s_port;
    }

    /* loop to try multiple servers */
    for(next=servers; next; )
    { char server[128];
      char *this = next;

      next = index(this, ',');
      strcpy(server, this);
      if (next) server[next++ - this] = '\0';
      if (debug & D_1_) fprintf(stderr, "Try %s (%s|%s)\r\n", server, this, servers);

      host = gethostbyname(server);
      if (host == NULL)
      {
#ifndef	IGNORE_MISSING_SERVERS
	fprintf(stderr, " +++- can't find the server %s\r\n", server);
#endif
	continue;
      }
      bzero((char *)&to, sizeof(to));
      bcopy(host->h_addr, (char *)&to.sin_addr, host->h_length);
      to.sin_family = host->h_addrtype;
      to.sin_port = portn;
      clienttoserver = socket(AF_INET, SOCK_STREAM, 0);
      if (clienttoserver < 0)
      { fprintf(stderr, " +++- %s: ", server); fflush(stderr);
	  perror("client socket");
	  continue;
      }
      if (connect(clienttoserver, (struct sockaddr *) &to, sizeof(to)) < 0)
      { fprintf(stderr, " +++- %s: ", server); fflush(stderr);
	  perror("client connect");
	  close(clienttoserver);
	  clienttoserver = -1;
	  continue;
      }
      if (debug & D_1_)
      { int i;
	  fprintf(stderr, " We have %d %d %d %d %d %d %d %d %d %d %d: v%d s%d %d\n",
		((char *)&(x25sbuf.x_facil)) - ((char *)(&x25sbuf)),
		((char *)x25sbuf.x_destination) - ((char *)(&x25sbuf)),
		((char *)x25sbuf.x_calling_dte) - ((char *)(&x25sbuf)),
		((char *)x25sbuf.x_cudf) - ((char *)(&x25sbuf)),
		((char *)x25sbuf.x_username) - ((char *)(&x25sbuf)),
		((char *)&x25sbuf.x_context) - ((char *)(&x25sbuf)),
		((char *)&x25sbuf.x_network) - ((char *)(&x25sbuf)),
		((char *)&x25sbuf.x_cudflen) - ((char *)(&x25sbuf)),
#if	(X25IO_VER > 5)
		((char *)&x25sbuf.x_sbuf.x3_pad1) - ((char *)(&x25sbuf)),
		((char *)&x25sbuf.x_sbuf.x3_pad2) - ((char *)(&x25sbuf)),
		((char *)&x25sbuf.x_sbuf.x3_pad3) - ((char *)(&x25sbuf)),
#else
		0, 0, 0,
#endif
		((char *)x25sbuf.x_buf) - ((char *)(&x25sbuf.x_version)),
		12345678);
	  fprintf(stderr, "++ call %s on port 0x%x: ", server, portn);
	  if (debug & D_2_) for (i=0; i<x25SBUF_size; i++)
	    fprintf(stderr, "%s%02x", (i % 26 == 16) ? "\r\n++ ":" ",
			    ((unsigned char *)x25sbuf.x_buf)[i]);
	  fprintf(stderr, "\r\n");
	  fflush(stderr);
      }
      break;
    }
    if (host || port || !strcmp(service, service_buf)) break;
  }
  if (host == NULL) {
    fprintf(stderr, " +++- can't find the servers! (%s)\r\n", servers);
#ifdef	TELNETD
    sleep(1);
#endif	TELNETD
    exit(1);
  }
  if (clienttoserver < 0)
  { perror("cant find a responding server");
#ifdef	TELNETD
    sleep(1);
#endif	TELNETD
    exit(1);
  }
  sendtox25(&x25sbuf, x25SBUF_size, X25F_SBUF, 0);

  /* Now read back the same info ... */
  while(1)
  { count = fromx25(TTY_NODATA);
    if(x25ibuf.x_flags &  X25F_SBUF && count == x25SBUF_size) break;
    if(x25ibuf.x_flags &  X25F_GATE_MSG)
    { x25ibuf.x_buf[count] = '\0';
      fprintf(stderr, "\r\n ++no call yet-- %s\r\n", x25ibuf.x_buf);
      if (x25ibuf.x_flags &  X25F_CLOSING)
      {
#ifdef	TELNETD
	sleep(1);
#endif	TELNETD
	exit(1);
      }
      continue;
    }
    perror("client readback of setup info");
#ifdef	TELNETD
    sleep(1);
#endif	TELNETD
    exit(1);
  }

  bcopy(x25ibuf.x_buf, x25sbuf.x_buf, x25SBUF_size);
  ybts = (x25sbuf.x_cudflen > 4 && x25sbuf.x_cudf[0]==0x7f &&
     x25sbuf.x_cudf[1]==0xff && x25sbuf.x_cudf[2]==0xff && x25sbuf.x_cudf[3]==0xff);
  if (ybts && is_ts29((char *) x25sbuf.x_cudf, (int) x25sbuf.x_cudflen)) ts29++;

  /* any errors are returned by the server in a textual message
     that impersonates an x25 receive */
}

clientmes3(flags, format, v1, v2, v3)
     int flags;
     char *format;
     void *v1, *v2, *v3;
{
  char *ptr;
  struct x25io x25io_msg;
  init_x25io(&x25io_msg);

  x25io_msg.x_flags |= X25F_GATE_MSG;	/* this is a gateway message */
					/* the gateway is closing */
  if (flags & X25F_CLOSING) {
    logerr(format, v1, v2, v3);
    x25io_msg.x_flags |= X25F_CLOSING;
  }

#define msgbuf	(x25io_msg.x_buf)
  (void) sprintf(msgbuf, format, v1, v2, v3);
  ptr = msgbuf + strlen(msgbuf);
  if (flags & 1)
  { if ((errno < 0) || (errno > sys_nerr))
    { (void) sprintf(ptr, ": invalid errno %d", errno);
    } else
      (void) sprintf(ptr, ": %s", sys_errlist[errno]);
  }
#ifdef	SERVERCODE
  if (role == SERVER)
  { sendtoclient(&x25io_msg, strlen(msgbuf));
    if ((flags & CM_NOLOG) == 0) stampf("(%s) %s\r\n", sender, msgbuf);
  }
  else
#endif	SERVERCODE
    fprintf(stderr, "\r\n%s\r\n", msgbuf);
}

get_pkts(in, out)
int *in, *out;
{
#ifdef	SERVERCODE
  if (role != CLIENT)
  {
#ifdef	sun
    extern lcn;
    X25_L3_STAT_DB pkt_info;
    int llcn;

    pkt_info.sendpkts = -pktsout;
    pkt_info.recvpkts = -pktsin;
    if (!ioctl(s, X25_RD_LCGN, &llcn))
    { pkt_info.lcn = (llcn) ? llcn : lcn;
      if (!ioctl(s, X25_RD_L3_STATISTICS, &pkt_info))
      { *out = pkt_info.sendpkts;
        *in = pkt_info.recvpkts;
        return;
      }
    }
#endif	sun
  }
#endif	SERVERCODE
  *in = pktsin;
  *out = pktsout;
}

padexit(status)
int status;
{ if (bytesin || bytesout || pktsin || pktsout)
  { int in, out;
    fprintf(stderr, " +++- bytes/pkts  in %d/%d  out %d/%d\r\n",
		bytesin, pktsin, bytesout, pktsout);
    get_pkts(&in, &out);
    if (in != pktsin || out != pktsout)
      fprintf(stderr, " +++- actually  in %d/%d  out %d/%d\r\n",
		bytesin, in, bytesout, out);
  }
  fflush(stderr);
  fflush(stdout);
#ifdef	SERVERCODE
  if ((role == SERVER) || (role == DIRECT)) stoplog();
#endif	SERVERCODE
  resettty();
#ifdef	TELNETD
  if (telnetd != 0) sleep(1);
#endif	TELNETD
  exit(status);
}


/* UTILITIES */

/* recvfill - keep "recv"ing until buf has "count" bytes in it */

recvfill(sock, buf, count, flags) /* recv as <count> bytes from sock */
     char *buf;
     int sock, count, flags;
{
  int acount, total;
  char *bufp = buf;
  total = 0;
  while (total < count)
  { acount = recv(sock, bufp, (count - total), flags);
    if (acount < 1)
      return(acount);		/* report any anomoly */
    bufp += acount;
    total += acount;
  }
  return(count);
}

/* LOOKUP - name in directory */
/* Stuff the new info into the standard structure */

char *
lookup(name, ar, arlen, context, network, type)	/* ARGSUSED */
     char *name;
     char *ar;
     int  arlen;
     unsigned char context;
     unsigned char network;
     enum role type;
{
  char *missing_dir = (char *) 0;
  static char dtenumber[256];
#ifdef	NRSDBM
  char *xformat;
  char *yformat;
#endif	NRSDBM
  char gate_name[10][40];
  char gate_addr[10][80];

  if (!name) { fprintf(stderr, "lookup given a null name\n"); return NULL; }
  if (type == DIRECT)	return NULL;	/* Do it later ... */

  gate_name[0][0] = '\0';
  if (lookup_prof(name, dtenumber, prof_file, &x25sbuf,
		ar, arlen,
		gate_name, gate_addr))
	return dtenumber;

  if (lookup_prof(name, dtenumber, sysprof_file, &x25sbuf,
		ar, arlen,
		gate_name, gate_addr))
	return dtenumber;

#ifdef	NRSDBM
  if (type == CLIENT) return NULL;	/* don't do the full lookup */
  if(nrs_init() < 0)  missing_dir = "NRS database";
  else
  { struct host_entry *hp = dbase_find(name, (char *) 0, 0);
    int as;
    int net;

    missing_dir = (char *) 0;
    if (hp != NULL)
	for (as=0; as < addr_spaces; as++)
	    for (net=0; net<hp->n_nets; net++)
    {	char *addr = (char *) 0;
	int gate;

	/* If the user has given a list of address spaces,
	 * try them in the specified order.
	 */
	if (addr_space[as][0] &&
	    strcmp(addr_space[as], hp->n_addrs[net].net_name))
		continue;
	yformat = (char *) 0;
	xformat = (char *) 0;
	for (gate=0; gate<10 && gate_name[gate][0]; gate++)
	  if (!strcmp(hp->n_addrs[net].net_name, gate_name[gate]) &&
		gate_addr[gate][0] == 'y')
	  { yformat = gate_addr[gate]+1; break; }
	for (gate=0; gate<10 && gate_name[gate][0]; gate++)
	  if (!strcmp(hp->n_addrs[net].net_name, gate_name[gate]) &&
		gate_addr[gate][0] == 'x')
	  { xformat = gate_addr[gate]+1; break; }

	if ((context == XCONTEXT || !context) &&
	    hp->n_addrs[net].x29_addr)
	{ char *addr = hp->n_addrs[net].x29_addr +3;
	  char *app = index(addr, '\n');

	  if (app)
	  { *app++ = '\0';
	    if (ar && arlen > 0)
	      if (strlen(app) > arlen)
		clientmes0(0, "Application Relay string too long - ignored");
	      else
		(void) strcpy(ar, app);	/* return app. rel. as-is */
	  }
	  if (xformat)
	  { char *cudf;
	    sprintf(dtenumber, xformat, addr);
	    addr = dtenumber;
	    cudf = index(addr, ':');
	    { *cudf++ = '\0';
	      called_char_addr.cudf = strsave(cudf);
	    }
	  }
	  dbmclose();
	  return addr;
	}

	if ((context == TCONTEXT || !context) && hp->n_addrs[net].ts29_addr)
		addr = hp->n_addrs[net].ts29_addr;
	if (context == FCONTEXT && hp->n_addrs[net].ftp_addr)
		addr = hp->n_addrs[net].ftp_addr;
	if (context == MCONTEXT && hp->n_addrs[net].mail_addr)
		addr = hp->n_addrs[net].mail_addr;
	if (context == JCONTEXT && hp->n_addrs[net].jtmp_addr)
		addr = hp->n_addrs[net].jtmp_addr;
	if (context == NCONTEXT && hp->n_addrs[net].news_addr)
		addr = hp->n_addrs[net].news_addr;

	if (addr)
	{ char *ybts = index(addr, '\n');
	  char *res = addr+3;	/* HACK strip off the `DT ' ... */

	  if (ybts)
	  { *ybts++ = '\0';
	    ybts += 3;
	  }
	  if (yformat)
	  { sprintf(dtenumber, yformat, res, ybts, res);
	    res = dtenumber;
	    ybts = index(res, '/');
	    if (ybts) *ybts++ = '\0';
	  }
	  if (ybts) called_char_addr.ybts = strsave(ybts);
	  dbmclose();
	  return res;
	}
    dbmclose();
    }
  }
#endif	NRSDBM
#ifdef	SERVERCODE
  if (type==SERVER && missing_dir && *missing_dir) perror(missing_dir);
#endif	SERVERCODE
  return(NULL);
}

char *
copy_chartohex(to, from)
char *from;
char *to;
{	int offset = 0;

	for (offset=0; *from; from++, offset++)
	{	int	val;
		switch(*from)
		{	case '0': case '1': case '2': case '3': case '4':
			case '5': case '6': case '7': case '8': case '9':
			val = (*from) - '0';				break;
			case 'a': case 'b': case 'c':
			case 'd': case 'e': case 'f':
			val = (*from) - 'a' + 10;			break;
			case 'A': case 'B': case 'C':
			case 'D': case 'E': case 'F':
			val = (*from) - 'A' + 10;			break;
			default:
			return from;
		}

		if (offset & 1)
			to[offset/2] |= val;
		else	to[offset/2]  = val << 4;
	}
	return from;
}

set_v_profile(buff, len)
char *buff;
int len;
{ if (len > 2 && buff[0] == (char) PRE_CUDF[0])
  { if (termwidth < 0) termwidth = gettermwidth();

    if      (termwidth < 80)	buff[1] = 90;	/* V1 - 72 */
    else if (termwidth < 120)	buff[1] = 94;	/* V5 - 80 */
    else if (termwidth < 132)	buff[1] = 91;	/* V2 - 120*/
    else 			buff[1] = 93;	/* V4 - 132*/
  }
}

/* Build a new CUDF from the supplied info.
 * It may be:
 * <text>
 * :<hextext>
 * ::<pid><hextext>
 * IF it looks as if the protocol ID is missing,
 * THEN prefix it with the specified prefix
 *
 * Type = 0->x29, 1->ybts, 2->copied from remote client
 *
 * TO BE DONE:
 *  set the V parameter correctly.
 */

/* ARGSUSED */
set_cudf(cudf, pcudflen, pref, preflen, data, datalen, type)
     unsigned char *cudf, *pref, *data;
     unsigned char *pcudflen;
     int preflen, datalen, type;
{ int copy = preflen;

  bcopy((char *)pref, (char *)cudf, copy);

  if (datalen > 0 && data[0] == ':')
  { int skip = 1;

    if (data[1] == ':') copy = 0, skip++;
    else	set_v_profile(cudf, copy);

    copy_chartohex(cudf+copy, data + skip);
    *pcudflen = copy + strlen(data+skip)/2;
  }
  /* If it looks like a valid protocol id, pass on asis.
   * Put in hack -- if 01 01 it is an escape, so discard it.
   * Otherwise add a std prefix
   */
  else if (datalen >= 4 && data[0] == 1)
  { if (datalen >= 6 && data[1] == 1)
    {	data    += 2;
	datalen -= 2;
	fprintf(stderr,
	"two 0x01's in cudf, so strip them .. %d: %02x %02x %02x ...\r\n",
		datalen, data[0], data[1], data[2]);
    }
    bcopy((char *)data, (char *)cudf, datalen);
    *pcudflen = datalen;
  }
  else if (copy>=4 && pref[0]==0x7f && pref[1]==0xff && pref[2]==0xff && pref[3]==0xff)
  { /* This is a YBTS .... */
    if (datalen)
    { sprintf((char *) cudf+copy, "%c%s%c%s%c%s%c%s%c%s",
	0x80 | strlen(data), data,
	0x80 | strlen(CALLING), CALLING,
	0x80 | ((qual_serv) ? strlen(qual_serv):0), (qual_serv) ? qual_serv:"",
	0x80 | ((exp_text) ? strlen(exp_text) : 0), (exp_text) ? exp_text : "",
	0x00,
	(unqual_data) ? unqual_data : "");
      datalen = 0;
    }
    *pcudflen = strlen(cudf) + ((unqual_data) ? strlen(unqual_data)+1 : 0);
  }
  else
  { set_v_profile((char *)cudf, copy); 
    if (data && datalen > 0) bcopy((char *)data, (char *)cudf+copy, datalen);
    *pcudflen = datalen + copy;
  }
  ybts = (cudf[0]==0x7f && cudf[1]==0xff && cudf[2]==0xff && cudf[3]==0xff);
  if (ybts && is_ts29((char *) cudf, (int) *pcudflen))	ts29++;
  if (debug & D_1_)
  { int i;
    fprintf(stderr, " ++   Set CUDF%s :",
		(ts29) ? " (TS29)" : (ybts) ? "(YBTS)" : "");
    for (i=0; i<(int) *pcudflen; i++) fprintf(stderr, " %02x", cudf[i]);
    fprintf(stderr, "\r\n");
  }
}


/* MATCHING code for running spad from scripts */

alarmcall()
{
  padexit(14);
}

matchnext(c)
int c;
{
  register int i, j;
  register char *mb = matchbuf, *mp = matchp;
  (void) signal(SIGALRM, SIGARG2 alarmcall);
  (void) alarm(MATCHTIMO);		/* set/reset the alarm */
  matchbuf[matchindex] = c;
  matchindex += 1;
  matchindex &= MATCHMASK;
  matchnchars += 1;
  if (matchnchars < matchlen)
    return(0);
  i = (matchindex - 1) & MATCHMASK;
  j = matchlen - 1;
  while (j > 0)
  { if (mb[i] != mp[j])
      return(0);
    j -= 1;
    i -= 1;
    i &= MATCHMASK;
  }
  return(1);
}

firstmatch()
{
  matchf = fopen(scrfn, "r");
  if (matchf == NULL)
  { perror(scrfn);
    padexit(1);
  }
  matching = 1;
  nextmatch();
}

nextmatch()
{
  static char matchstring[MAXMATCH];
  int matchx = 0;
  int ch, val;
  while ((ch = getc(matchf)) != EOF)
  { if (ch == '\n')
      break;
    if (ch == '\\')
    { ch = getc(matchf);
      switch (ch) {
      case '\n':goto eol;
      case 'n':	matchstring[matchx++] = '\n'; break;
      case 'r':	matchstring[matchx++] = '\r'; break;
      case '\\':matchstring[matchx++] = '\\'; break;
      case '0':	val = 0;
		while ((ch = getc(matchf)) != EOF)
		 if ((ch >= '0') && (ch <= '7')) val = (val << 3) + ch - '0';
		else { matchstring[matchx++] = val; break; }
		ungetc(ch, matchf);
      }
    } else      matchstring[matchx++] = ch;
  }
eol:
  if (matchx == 0)
  { matching = 0;
    (void) alarm(0);
    return;
  }
  matchstring[matchx] = 0;
  matchp	= matchstring;	/* Now update what "match" is looking for */
  matchlen	= matchx;
  matchindex	= 0;
  matchnchars	= 0;
}

sendnext()
{
  int ch;
  while ((ch = getc(matchf)) != EOF && ch != '\n') paramch(ch, 1/*??*/);

  if (feof(matchf)) padexit(0);	/* IE if we've matched the last entry */

  paramch('\r', 1/*??*/);
  sendtox25(&x25io_tty, xindex, 0 /* flags */, 0/* type */);
  xindex = 0;
}

gettermwidth()
{
#ifdef	TIOCGWINSZ
	/* e.g. ultrix */
	{	struct winsize winsize;
		if (!ioctl(0, TIOCGWINSZ, &winsize) ||
		    !ioctl(2, TIOCGWINSZ, &winsize))
		return winsize.ws_col;
	}
#else
#ifdef	TIOCGSIZE
	/* e.g. sun */
	{	struct ttysize ttysize;
		if (!ioctl(0, TIOCGSIZE, &ttysize) ||
		    !ioctl(2, TIOCGSIZE, &ttysize))
		return ttysize.ts_cols;
	}
#endif	TIOCGSIZE
#endif	TIOCGWINSZ
	return 80;	/* default ... */
}

init_x25io(x25io)
struct x25io *x25io;
{ bzero((char *)x25io, sizeof(struct x25io));
  x25io->x_version			= X25IO_VER;
}

init_x25sbuf(x25io)
struct x25io *x25io;
{ init_x25io(x25io);
  x25io->x_ssize			= x25sbuf_size;
  x25io->x_fflags			= 0;
  x25io->x_flags			= 0;
}

/* send interupt */
sendinttox25()
{ struct x25io buf;
  init_x25io(&buf);
  buf.x_buf[0] = 0;
  sendtox25(&buf, 1, X25F_MSG_OOB, INT_DATA /*type*/);
}

/* send reset */
sendresettox25()
{ struct x25io buf;
  init_x25io(&buf);
#ifdef	NO_RESET
  /* KILLS THE SUN */
  fprintf(stderr, "\r\n +++- a SUN kernel bug makes resets dangerous\r\n");
#else	NO_RESET
  sendtox25(&buf, 0, X25F_MSG_OOB, VC_RESET);
#endif	NO_RESET
  if (param6) clientmes0(0, "*** RESET sent");
}

/* Send an indication of break */
sendindofbreak(len, a1, a2)
int len;
char a1, a2;
{ struct x25io buf;
  init_x25io(&buf);
  buf.x_buf[0] = 3;
  buf.x_buf[1] = a1;
  buf.x_buf[2] = a2;
  sendtox25(&buf, 1 + len, 0 /*flags*/, (1 << Q_BIT) /*type*/);
}




/* NAMEIS - the psychiatrist routine
   (It helps resolve the program's role in life!)
*/

nameis(a, b)		/* returns true if last part of a starts with b */
     char *a, *b;
{ char *end = rindex(a, '/');
  int la, lb = strlen(b);
  if (end) a = end + 1;
  la = strlen(a);
  if (la < lb)
    return(0);
  if (strncmp(a, b, lb))
    return(0);
  return(1);
}

print_facil(facil, file)
struct facilities *facil;
FILE *file;
{	fprintf(file, " +++- ");
	if (facil->x4_fflags & (FACIL_F_REVERSE_CHARGE))
		fprintf(file, "%srev chge, ",
			(facil->x4_reverse_charge) ? "" : "no ");
	if (facil->x4_fflags & (FACIL_F_RECVPKTSIZE | FACIL_F_SENDPKTSIZE))
		fprintf(file, "pkt=%d/%d, ",
		facil->x4_recvpktsize, facil->x4_sendpktsize);
	if (facil->x4_fflags & (FACIL_F_RECVWNDSIZE | FACIL_F_SENDWNDSIZE))
		fprintf(file, "wnd=%d/%d, ",
			facil->x4_recvwndsize,	facil->x4_sendwndsize);
	if (facil->x4_fflags & (FACIL_F_RECVTHRUPUT | FACIL_F_SENDTHRUPUT))
		fprintf(file, "thru=%d/%d, ",
			facil->x4_recvthruput, facil->x4_sendthruput);
	if (facil->x4_fflags & FACIL_F_CUG_INDEX)
		fprintf(file, "cug=%x, ", facil->x4_cug_index);
	if (facil->x4_fflags & FACIL_F_FAST_SELECT) fprintf(file, "%s, ",
		(facil->x4_fast_select == FACIL_NO)	? "FS off" :
		(facil->x4_fast_select == FACIL_FCS_CLR)? "FS CLR" :
		(facil->x4_fast_select == FACIL_YES)	? "FS ACC" : "??");
	if (facil->x4_fflags & FACIL_F_RPOA)
		fprintf(file, "rpoa %04x, ", ntohs(facil->x4_rpoa));
	fprintf(file, "\r\n");
}

/* VARARGS */
stampf(s, a1,a2,a3,a4,a5,a6)
char *s;
void *a1, *a2, *a3, *a4, *a5, *a6;
{
	time_t l;
	time(&l);
	fprintf(stderr, "%20.20s:%04x: ", ctime(&l)+4, getpid());
	fprintf(stderr, s, a1,a2,a3,a4,a5,a6);
	fflush(stderr);
}

#ifdef SECURITY

/** Procedures to implement restrictions on who may call what */

#define	MAXARGS	20

int split_argv(buff, args)
register char *buff;
char **args;
{	register char **ap = args;

	ap = args;
	while (*buff) {
		while (*buff == ' ' || *buff == '\t')	buff++;
		if (*buff == '"')
		{	buff++;
			if (ap < &args[MAXARGS-2])	*ap++ = buff;
			while (*buff && *buff != '"')	buff++;
		}
		else
		{	if (ap < &args[MAXARGS-2])	*ap++ = buff;
			while (*buff && *buff != ' ' && *buff != '\t')	buff++;
		}
		if (*buff)				*buff++='\0';
	}
	*ap = (char *) 0;
	return ap - args;
}

#include <ctype.h>

#define	ADDRSIZE	256
#define LINESIZE	1024

char	*a_ok;
char	*a_from;
char	*a_to;
char	*a_context;
char	*a_extra;
char	*a_rep_from;
char	*a_rep_to;
char	*a_calling;
char	*a_call931;
char	*a_rfc931;
char	*rest;

struct {
	char **	ptr;
	char *  key;
} vakues[] = {
	{ &a_ok,	"action" },
	{ &a_from,	"from" }, 
	{ &a_to,	"to" }, 
	{ &a_context,	"context" }, 
	{ &a_extra,	"extra" }, 
	{ &a_rep_from,	"rep_from" }, 
	{ &a_rep_to,	"rep_to" }, 
	{ &a_rep_to,	"ref_to" }, /* TYPO !! */
	{ &a_calling,	"sa" },
	{ &a_calling,	"calling" },
	{ &a_call931,	"call931" },
	{ &a_rfc931,	"rfc931" },
	{ &rest,	"rest" }, 
	{ (char **) 0,	(char *) 0 }
};

/* disallowed() takes two strings, a boolean, two strings and a CUDF:
 * username@host	(or user if local)
 * address		they want to call
 * special		not a real user check, so no "." allowed.
 * context		the current context: x(29), t(s29), f(tp), etc
 * extra		extra addressing info
 * cudf			the Called user date fields (or 0)
 * type			the context (TCONTEXT for TS29)
 *
 * Returns 0 if that is allowed, failing line in auth file otherwise
 * To start server, permission must exist for 'user' to '-STARTSERVER-'
 */

disallowed(real_calling_user, real_called_host, special, context, extra, 
	cudf, type )
char *real_calling_user, *real_called_host, *context, *extra, *cudf, type;
int special;
{
	char	*calling_user = real_calling_user;
	char	*called_host = real_called_host;
	FILE	*afp, *fopen();
	char	line[LINESIZE];
	char	label[ADDRSIZE];
	char	_to[ADDRSIZE];
	char	_from[ADDRSIZE];
	int	cnt=0;
	int	skipping = 0;
	int	is_x29 = (! cudf || cudf[0] == 0x01) && type != TCONTEXT;
	int	is_yb = ! is_x29;
#ifdef DEBUGAUTH
	fprintf(stderr, "disallowed%s: %s, %s\r\n",
		(special) ? " special" : "", calling_user, called_host );
#endif DEBUGAUTH

	if ((afp = fopen(AUTHFILE, "r")) == NULL)
	{	clientmes1(X25F_CLOSING | 1,
			"Cannot open authorisation file %s", AUTHFILE);
		return -2;
	}

	while (fgets(line, sizeof(line), afp))
	{	int	res;
		char	*args[MAXARGS];
		int	comment=0;
		int	fields;
		register char *p;

		cnt++;
		if (*line == '#')	/* Pragmat ? */
		{	/* Named label ? */
			if (skipping && label[0] &&
				!strncmp(line+1, label,strlen(label)))
				skipping = 0;
			continue;
		}
		if (p = index(line, '\n'))	*p = '\0';
		if (p = index(line, '#' ))	{ *p = '\0'; comment++; }
		for (p=line; isspace(*p); p++)	;
		if (!*p)
		{	/* Blank (non-comment) line terminates null SKIP */
			if (!label[0] && !comment)	skipping = 0;
			continue;
		}
		if (skipping)			continue;

		a_ok		= (char *) 0;
		a_from		= (char *) 0;
		a_to		= (char *) 0;
		a_context	= (char *) 0;
		a_extra		= (char *) 0;
		a_rep_from	= (char *) 0;
		a_rep_to	= (char *) 0;
		a_calling	= (char *) 0;
		a_call931	= (char *) 0;
		a_rfc931	= (char *) 0;
		rest		= (char *) 0;

		if ((fields = split_argv(p, args)) < 2)
		{	auth_err("ignored: \"%s\"", cnt, line);
			continue;
		}

		while (fields > 0) {
			char *data = args[fields-1];
			char *equal;
			int i;
			if (!(equal = index(data, '=')))  break;
			fields--;
			if (equal == data && !strcmp(data, "=")) break;
			*equal = '\0';
			for (i=0; vakues[i].key; i++) if (!strcasecmp(vakues[i].key, data))
			{
				if (*(vakues[i].ptr))
					auth_err("%s already set(%s)",
					cnt, data, equal+1);
				else *(vakues[i].ptr) = equal+1;
				break;
			}
			if (! vakues[i].key) 
				auth_err("Unknown key `%s' (%s) [%d/%d]\n",
					cnt, data, equal+1, i, fields);
		}

#define	setv(name, offset) if (fields > offset && !name && strcmp(args[offset], "^")) name = args[offset];
		setv(a_ok,	0);
		setv(a_from,	1);
		setv(a_to,	2);
		setv(a_context,	3);
		setv(a_extra,	4);
		setv(a_rep_from,5);
		setv(a_rep_to,	6);
		setv(a_calling,	7);
		setv(a_call931,	8);
		setv(a_rfc931,	9);
		setv(rest,     10);

		if (!a_ok)
		{	if (! a_rep_from && ! a_rep_to) {
				auth_err("No auth type", cnt);
				continue;
			}
			res = -3;
		}
		else if (!strcmp(a_ok, allow)) res = 0;
		else if (!strcmp(a_ok, block)) res = cnt;
		else if (!strcmp(a_ok, nolog)) res = -1;
		else if (!strncmp(a_ok, skip, SKIPLEN))	res = -2;
		else
		{	auth_err("not %s, %s, %s or %s: \"%s\"",
				cnt, allow, block, skip, nolog, a_ok);
			continue;
		}

		if (a_from && !match(cnt, calling_user, a_from))	continue;
		if (a_to && !match(cnt, called_host, a_to))	continue;
		if (a_rfc931 &&
			(! rfc931user || !match(cnt, rfc931user, a_rfc931)))
							continue;
		if (a_context && context && !match(cnt, context, a_context))
							continue;
		if (a_extra && extra && !match(cnt, extra, a_extra))
							continue;
		if (special && index(a_to, '.'))	continue;

		if (a_rep_from && strcmp(a_rep_from, "^"))
			strcpy(calling_user = _from, a_rep_from);
		if (a_rep_to && strcmp(a_rep_to, "^"))
			strcpy(called_host = _to, a_rep_to);

		/* Force RFC 931 lookup :
		 *	set	set calling_user if RFC 931 worked
		 *	force	set calling_user from RFC 931 even if it fails
		 *	call	do an RFC 931 call, but don't set anything
		 */
		if (a_call931 && strcmp(a_call931, "^")) {
			char buff[1024];
			char *new = find_rfc931();
			int type = 0;

			if (!strcmp(a_call931, "set")) type = 1;
			else if (!strcmp(a_call931, "call")) type = 2;
			else if (!strncmp(a_call931, "force", 5)) type = 3;

			if ((new && type == 1) || type == 3) {
				char *at = index(real_calling_user, '@');
				strcpy(buff, (new) ? new : 
					(a_call931[5] == '-') ?  a_call931+6 :
								"NOUSER");
				if (at) strcat(buff, at);
				if (strcmp(buff, real_calling_user)) { 
					logerr("RFC 931 mismatch: %s -> %s",
						real_calling_user, buff);
					clientmes2(0, "RFC 931: %s -> %s",
						real_calling_user, buff);
					strcpy(real_calling_user, buff);
				}
			}
		}

		/* An attempt to set the Calling dte ? */
		if (a_calling && strcmp(a_calling, "^"))
		{ char *new;
		  char *txt = a_calling;
		  /* x<dte> is only for X.29 calls, y<dte> for YBTS calls */
		  if (*txt == 'x') {
			if (! is_x29) continue;
			txt++;
		  }
		  else if (*txt == 'y') {
			if (! is_yb) continue;
			txt++;
		  }
		  new = malloc(strlen(txt)+1);
		  if (new) {
		    if (calling_dte_malloced) free(calling_dte);
		    strcpy(new, txt);
		    calling_dte = new;
		    calling_dte_malloced = 1;
		  }
		}

		switch (res)
		{
		case -3:	continue;
		case -2:	strcpy(label, a_ok + SKIPLEN);
				skipping = 1;		continue;
		case -1:	dontlog  = 1;		continue;
		case 0:		
		default:	fclose(afp);
				errno = 0;
				cnt = local_auth(
				res,
				real_calling_user, calling_user, real_called_host, called_host, special, context, extra,
				rest);
				if (cnt) clientmes3(X25F_CLOSING,
	"You (%s) are not authorized to call %s (on line %d)",
			real_calling_user, called_host, res);
				return cnt;
		}
	}
	fclose(afp);
	errno = 1;
	clientmes1(X25F_CLOSING | 1,
		"No authorisation by end of file on line %d\n", cnt);
	return -1;
}


/*
 *  MATCH  --  match the strings s1 and s2.
 *		s2 can contain wildcards and lists
 */
match(line, s1, s2)
int line;
char	*s1, *s2;
{
	char *s;	/* for re_comp returns and general messing */
	int n;		/* for re_exec returns */

	char m_address[ADDRSIZE], m_pattern[ADDRSIZE];

	char *re_comp();
	int re_exec();

	if (!strcmp(s2, "^")) return 1;

	/* Make copies of strings, converting to lower case */
	for (s=m_address; *s1; s1++, s++)
		*s = isupper(*s1) ? tolower(*s1) : *s1;
	*s = '\0';

	for (s=m_pattern; *s2; s2++, s++)
		*s = isupper(*s2) ? tolower(*s2) : *s2;
	*s = '\0';

	s = re_comp(m_pattern);
	if (s != 0)
	{	auth_err("Bad regular expression: '%s'", line, m_pattern);
		return 0;
	}

	n = re_exec(m_address);
	if (n < 0)
	{	auth_err("Bad regular (%s) found", line, m_pattern);
		return 0;
	}

	return n;
}

/* VARARGS3 */
auth_err(format, line, a1, a2, a3, a4, a5)
char *format;
int line;
char *a1, *a2, *a3, *a4, *a5;
{	static errs = 2;
	if (errs <= 0)	return;

	errs--;
	fprintf(stderr, "spad: Auth file err %2d: Line %4d: ", errs, line);
	fprintf(stderr, format, a1, a2, a3, a4, a5);
	fprintf(stderr, "\r\n");
	fflush(stderr);
}
#endif SECURITY

/* ARGSUSED */
is_ts29(buff, len)
char *buff;
int len;
{
	char *ts29str = "TS29";
	int  ts29len = strlen(ts29str);

	char *p1 = buff +5;
	int  p1len = p1[-1] & 0x3f;

	char *p2 = p1 + p1len +1;
	int  p2len = p2[-1] & 0x3f;

	char *tail1 = p1 + p1len - ts29len;
	char *tail2 = p2 + p2len - ts29len;

	if (debug)
	  fprintf(stderr, "Try %d'%*.*s', %d'%*.*s', '%4.4s' or '%4.4s'\r\n",
		  p1len, p1len, p1len, p1,
		  p2len, p2len, p2len, p2,
		  tail1, tail2);

	if (p1len >= 4 && !strncasecmp(ts29str, tail1, ts29len)) return 1;
	if (p2len >= 4 && !strncasecmp(ts29str, tail2, ts29len)) return 1;
	return 0;
}
/* Junk code -- re-written 92/2/17
 *	int p1len = buff[4] & 0x3f;
 *	int p2len = buff[4 + p1len +1] & 0x3f;
 *	char *tail = &(buff[4 + p1len + 1 + 1]);
 *	if (debug) fprintf(stderr, "Try %d'%*.*s', %d'%*.*s', '%s'\r\n",
 *		p1len, p1len, p1len, buff + 5,
 *		p2len, p2len, p2len, buff + 6 + p1len, tail);
 *	return (p2len == 4 && (!strncmp(tail, "ts29", 4) ||
 *				!strncmp(tail, "TS29", 4)));
 */

ts_buff_decode8(raw, buff, len, rem_len, argc, a0, a1, a2, a3)
register char *raw, *buff;
int argc;
char **a0, **a1, **a2, **a3;
register int len;
int *rem_len;
{   char **argv[4];
    int param;

    if (!buff) buff=raw;
    argv[0] = a0;
    argv[1] = a1;
    argv[2] = a2;
    argv[3] = a3;
    if (argc > sizeof argv / sizeof argv[0])
	argc = sizeof argv / sizeof argv[0];

    for (param=0; param < argc; param++)
    {	register int i;
	if (len ==0)		break;
	if (!*raw)		break;		/* terminating zero octet */
	len--;
	if (!(*raw & 0x80))	return -(param+1);
	if ((i = (*raw++ & 0x3f)) > len) return (param+1) * -11;
	if (argv[param]) *argv[param] = buff;
	for (;i>0; len--, i--) *buff++ = (*raw++) & 0xff;
	*buff++ = '\0';
    }

    if (rem_len) *rem_len = len;

    return param;
}

/* ARGSUSED */
lookup_prof(name, dtenumber, filename, px25sbuf, ar, arlen,
	gate_name, gate_addr)
char *name;
char *dtenumber;
char *filename;
struct x25io *px25sbuf;
char *ar;
int arlen;
char gate_name[][40];
char gate_addr[][80];
{ FILE *prof;
  char buff[1024];

  if (!name) { fprintf(stderr, "Name was %x\n", name); name = "<Unset>"; }
  if (verbose & V_100_) fprintf(stderr, "Lookup %s\n", name);
  prof = fopen(filename, "r");

  if (!prof)
  { if (verbose & V_100_) fprintf(stderr, "No %s (%d)\n",
      filename, errno);
    return 0;
  }

  while (fgets(buff, sizeof buff, prof) != (char *) NULL)
  { char *start = buff;
    char *end = index(start, ':');
    if (*start == '#' || !end)  continue;

    *end++ = '\0';
    if ((*start == '*') ?
	(!patt_match(start+1, name)) : (!simp_match(start, name))) continue;

    if (verbose & V_100_) fprintf(stderr, "now %s/%s %s", name, start, end);
    for (start=end; start && *start && *start != ':'; start=end)
    { int equal = (start[1] == '=');
      end = index(start, ':');
      while (end && end[-1] == '\\')
      { strcpy(end-1, end); end = index(end, ':'); }
      if (end) *end++ = '\0';
      else  break;
      switch (*start)
      {	case 'a':
		if (equal)
			(void) strcpy(dtenumber, start+2);
		else if (!strncmp(start, "ar=", 3))
			(void) strcpy(ar, start+3);
		else		goto defalt1;				break;
	case 'c':
		if (!equal) goto defalt1;
		px25sbuf->x_cug_index = atobcd(start+2);
		px25sbuf->x_fflags |= FACIL_F_CUG_INDEX;		break;
	case 'd':
		if (!equal) goto defalt1;
		set_cudf(px25sbuf->x_cudf, &(px25sbuf->x_cudflen),
			PRE_CUDF, PRE_CUDFLEN,
			(unsigned char *) start+2, canonical(start+2), 0);	break;
	case 'f':
		if (!equal) goto defalt1;
		if (start[3] || start[2] < '0' || start[2] > '2')
			goto defalt2;
		px25sbuf->x_fast_select = start[2] - '0';
		px25sbuf->x_fflags |= FACIL_F_FAST_SELECT;	break;
	case 'g':
		if (strncmp(start, "gate", 4))	goto defalt1;
	{	char *sep = index(start, '=');
		int i;
		if (!sep)	goto defalt1;
		*sep++ = '\0';
		for (i=0; i<10 && gate_name[i][0]; i++);
		if (i >= 10)	goto defalt1;
		strcpy(gate_name[i], start+4);
		strcpy(gate_addr[i], sep);
		if (i < 9) gate_name[i+1][0] = '\0';
	};								break;
	case 'r':
		if (!equal) goto defalt1;
		if (start[3] || (start[2] != '0' && start[2] != '1'))
			goto defalt2;
		px25sbuf->x_reverse_charge = (start[2] == '1') ? FACIL_YES : FACIL_NO;
		px25sbuf->x_fflags |= FACIL_F_REVERSE_CHARGE;	break;

	case 'S':
		if (!equal) goto defalt1;
		{ char *colon = index(start+2, ':');
		  int n;
		  if (start[2] && start[2] != ':')
			idle_timeout = atoi(start+2);
		  if (colon && (n = atoi(colon+1))) idle_grace = n;
		}						break;
	case 's':
	{	int size;
		if (!equal) goto defalt1;
		size = atoi(start+2);
		switch(size)
		{ case 16: case 32: case 64: case 128: case 256: case 512:
		  case 1024:	if (px25sbuf)
				{	px25sbuf->x_recvpktsize	= size;
					px25sbuf->x_sendpktsize	= size;
					px25sbuf->x_fflags |= FACIL_F_RECVPKTSIZE;
					px25sbuf->x_fflags |= FACIL_F_SENDPKTSIZE;
				}
				else fprintf(stderr, "No sbuf, so pkt size ignored\n");
				break;
		  default:	fprintf(stderr, "bad packet size '%s' (should be 16, 32, 64, 128, 256, 512, or 1024)\n",
					start+2);
				goto defalt2;
		}							break;
	}
	case 'w':
	{	int size;
		if (!equal) goto defalt1;
		size = atoi(start+2);
		switch(size)
		{ case 1: case 2: case 3: case 4: case 5: case 6:
		  case 7:	if (px25sbuf)
				{	px25sbuf->x_recvwndsize	= size;
					px25sbuf->x_sendwndsize	= size;
					px25sbuf->x_fflags |= FACIL_F_RECVWNDSIZE;
					px25sbuf->x_fflags |= FACIL_F_SENDWNDSIZE;
				}
				else fprintf(stderr, "No sbuf, so wnd size ignored\n");
				break;
		  default:	fprintf(stderr, "bad window size '%s' (should be 1-7)\n",
					start+2);	goto defalt2;
		}							break;
	}
	case 'y':
		if (!equal) goto defalt1;
		set_cudf(px25sbuf->x_cudf,
			&(px25sbuf->x_cudflen),
			TS_CUDF, TS_CUDFLEN,
			(unsigned char *) start+2, canonical(start+2), 0);	break;
	case 'p':
	{	char *hash = index(start+1, '#');
		char *equal = index(start+1, '=');
		int param = atoi(start+1);
		int val;

		if (!hash && equal) hash = equal;
		if (!hash || param < 1 || param > P_MAX || (!(val = atoi(hash+1)) && hash[1] != '0'))
			goto defalt2;
		if (preset_b[param])
			fprintf(stderr, "param %d already preset to %d so %d ignored\n",
			param, preset_p[param], val);
		else
		{	preset_p[param] = val, preset_b[param]++;
			if (equal) ignore_p[param]++;
		}
	}								break;
		
	defalt1:
	default:
		end = (char *) 0;
	defalt2:
		fprintf(stderr, "Bad x29 profile string '%s' for %s in %s\n",
			start, buff, filename);
		break;
      }
    }
    if (!*dtenumber)	continue;
    fclose(prof);
    return 1;
  }

  fclose(prof);
  return 0;
}

/* ARGSUSED */
patt_match(patt, name)
char *patt, *name;
{
	/* DO FULL PATTERN MATCHING IN HERE .... */
	return ! strcmp(patt, ".*");
}

simp_match(string, name)
char *string;
char *name;
{ char env_name[sizeof format];
  int namel = strlen(name) +1;
  int i = 0;

  if (aliases < 0)
  { char *env = getenv("SPADALIAS_PREFIX");
    while (env)
    { alias[i++] = env;
      env = index(env, ',');
      if (env) *env++ = '\0';
    }
    for (i=0; i< (sizeof alias / sizeof alias[0]); i++)
    { char *new;
      sprintf(env_name, format, i+1);
      if (env = getenv(env_name)) alias[i] = env;
      if (!alias[i]) break;
      new = (alias[i][0]) ? malloc(strlen(alias[i]) + namel) : (char *) 0;
      if (new) sprintf(new, "%s%s",
		(alias[i][0] == '.') ? name : alias[i],
		(alias[i][0] == '.') ? alias[i] : name);
      alias[i] = new;
    }
    aliases = i;
  }
  for (i=0; i<aliases; i++)
	if (alias[i] && *alias[i] && !strcmp(alias[i], string)) return 1;
  return ! strcmp(string, name);
}

atobcd(s)
char *s;
{
	if (isdigit(*s) && isdigit (s[1]))
		return ((*s) - '0') << 4 | ((s[1] = '0'));
	return 0;
}

int sess_idle_logout()
{ switch(idle_warns++)
  {
  case 0:
	fprintf(stderr, "\r\n +++- Timing out call in next %d seconds\r\n",
	idle_grace);
	(void) signal(SIGALRM, SIGARG2 sess_idle_logout);
	alarm(idle_grace);					break;
  case 1:
	fprintf(stderr, "\r\n +++- Call time out\r\n");		padexit(14);
  }
}

char *nl(data)
char *data;
{	register char *string = data;
	while(string=index(string, '\\')) switch (*++string)
	{
		case 'n': string[-1] = '\r'; string[0] = '\n'; break;
		case 'r': string[-1] = '\r'; string[0] = '\r'; break;
	}
	return data;
}

#ifdef	NOBZERO
bzero(ptr, len)
char *ptr;
{
	while (len-- > 0) *ptr++ = '\0';
}
#endif	NOBZERO

#ifdef	NOBCOPY
bcopy(from, to, len)
char *from;
char *to;
{
	while (len-- > 0) *to++ = *from++;
}
#endif	NOBCOPY

#ifdef	local_auth
/* ARGSUSED */
int sample_local_auth(res, real_calling_user, calling_user, real_called_host,
	called_host, special, context, extra, rest)
int res;
char * real_calling_user;
char * calling_user;
char * real_called_host;
char * called_host;
int special;
char * context;
char * extra;
char * rest;
{
        /* if (res) fprintf(stderr,
		"You are not authorized to call %s (on line %d)\r\n",
		called_host, res);
	*/
	return res;
}
#endif

/* Log an error mesage to errlog */
void logerr(format, a1, a2, a3)
char *format;
void *a1, *a2, *a3;
{
	FILE *use = stderr;
	time_t l;
	time(&l);

	if (errfile && *errfile) { 
		FILE *try = fopen(errfile, "a");
		if (try) use=try;
	}
	fprintf(use, "%20.20s:%04x: ", ctime(&l)+4, getpid());
#ifdef	SERVERCODE
	fprintf(use, "rfc931=%s user=%.*s ip=%x name=%.*s addr=%s: ",
		(rfc931user) ? rfc931user : "",
		sizeof x25sbuf.x_username, x25sbuf.x_username,
		((*((int *)&from.sin_addr))),
		sizeof(x25log.hostname), x25sbuf.x_destination,
		(called_char_addr.dte) ?
			(*(called_char_addr.dte)) ? (called_char_addr.dte) :
						"<null>" :
			"<null dte>");
#endif
	fprintf(use, format, a1, a2, a3);
	{	char *ptr =format;
		while(*ptr) ptr++;
		if (ptr == format || ptr[-1] != '\n') fprintf(use, "\n");
	}
	fflush(use);

	if (use != stderr) fclose(use);
}
/*
  (void) strncpy((char *)x25log.hostcudf,
			(char *)x25sbuf.x_cudf,	sizeof(x25log.hostcudf));
  (void) strncpy(x25log.hostname,
			x25sbuf.x_destination,	sizeof(x25log.hostname));
 */

char *
find_rfc931()
{
#ifdef	USE_RFC931
	unsigned long inlocal;
	unsigned long inremote;
	unsigned short local;
	unsigned short remote;
	extern char *auth_tcpuser3();

        if (rfc931user) return rfc931user;

	if (auth_fd2((servertoclient >= 0) ? servertoclient : 0,
		&inlocal,&inremote,&local,&remote) != -1)
		rfc931user = auth_tcpuser3(inlocal,inremote,local,remote,
			timeout_rfc931);
#endif
	return rfc931user;
}
