#ifndef	lint
static char RCSid[]="$Header: /Nfs/blyth/glob/src/usr.bin/spad/src/RCS/spadtelnet.c,v 1.27 1993/11/13 20:29:08 pb Exp $";
#endif	lint
/* spad:-  multiple client/single server x.29 service.
	   needs Sunlink X.25 software running in (at least) one node
 */

/* Copyright (c) A Rawsthorne 1986, 1987 & P Brooks 1987, 1988
 * not for commercial use
 * this version not to be redistributed except by agreement.
 */

#include "spad.h"
#ifdef	TELNETD
set_telnetd()
{
	telnetd++;
	verbose |= telnet_verbose;
	dup2(0, 1);
	dup2(0, 2);
	setlinebuf(telf);
#ifdef	SERVERCODE
	role = DIRECT;
#endif	SERVERCODE
	forbid_some_pad_cmds = 1;
	forbid_suspend = 1;
}

int non_data = 0;

telrcv(c)
int c;
{	static int state = TS_DATA;

	if (verbose & V_10_)
	{	fprintf(stderr, "<%x%02x>", state, c & 0xff);
		fflush(stderr);
	}

	if (state != TS_DATA) non_data++;

	if (non_data > 15 + 80/*?*/ && (non_data & 15) == 0)
	{
		fprintf(stderr, "Possible loop in telnet non data [%x, %d]\r\n",
			state, non_data);
		/*fprintf(stderr, "Setting verbose to -1 and then sleeping\r\n");
		verbose = -1;*/
		fprintf(stderr, "Quick sleep\r\n");
		fflush(stderr);
		sleep(non_data / 16);
		
	}
	switch (state) {
	case TS_CR:
		state = TS_DATA;
		if (c == 0 || c == '\n') return NOT_CHAR;

	case TS_DATA:
		if ((verbose & V_20_) && (c == 01 || c == 02)) {
			char next;
			fprintf(stderr, "[Setting %s]", (c&1) ? "echo" : "raw");
			fflush(stderr);
			next = getchar();
			fprintf(stderr, "[%02x%02x%02x]", IAC,
				((next & 3) == 0) ? WILL :
				((next & 3) == 1) ? WONT :
				((next & 3) == 2) ? DO : DONT,
				(c & 1) ? TELOPT_ECHO : TELOPT_SGA);
			fflush(stderr);
			fprintf(stderr, "%c%c%c", IAC,
				((next & 3) == 0) ? WILL :
				((next & 3) == 1) ? WONT :
				((next & 3) == 2) ? DO : DONT,
				(c & 1) ? TELOPT_ECHO : TELOPT_SGA);
			fprintf(stderr, "[and junk chars]");
			fflush(stderr);
			getchar();
			getchar();
			return NOT_CHAR;
		}
		else if (c == IAC) {
			state = TS_IAC;
			return NOT_CHAR;
		}
		if (!myopts[TELOPT_BINARY] && c == '\r')
			state = TS_CR;
		if (!myopts[TELOPT_BINARY] && c == '\n')
			c = '\r';
		non_data = 0;
		return c;

	case TS_IAC:
		switch (c) {

		/*
		 * Send the process on the pty side an
		 * interrupt.  Do this with a NULL or
		 * interrupt char; depending on the tty mode.
		 */
		case BREAK:
		case IP:
			interrupt();
			break;

		/*
		 * Are You There?
		 */
		case AYT:
			fprintf(telf, "\010");
			(void) fflush(telf);
			break;

		/*
		 * Erase Character and
		 * Erase Line
		 */
		case EC:
			return (int) '\177';
		case EL:
			return 0;
		/*
		 * Check for urgent data...
		 */
		case DM:	return NOT_CHAR;

		/*
		 * Begin option subnegotiation...
		 */
		case SB:
			state = TS_BEGINNEG;
			return NOT_CHAR;

		case WILL:
		case WONT:
		case DO:
		case DONT:
			state = TS_WILL + (c - WILL);
			return NOT_CHAR;

		case IAC:
			state = TS_DATA;
			return c;
		}
		state = TS_DATA;
		break;

	case TS_BEGINNEG:
		if (c == IAC)
			state = TS_ENDNEG;
		return NOT_CHAR;

	case TS_ENDNEG:
		state = c == SE ? TS_DATA : TS_BEGINNEG;
		return NOT_CHAR;

	case TS_WILL:
		if (verbose & V_10_) fprintf(stderr, "[will%02x%d]", c, hisopts[c]);
		if (!hisopts[c])
			willoption(c, 1);
		state = TS_DATA;
		return NOT_CHAR;

	case TS_WONT:
		if (verbose & V_10_) fprintf(stderr, "[wont%02x%d]", c, hisopts[c]);
		if (hisopts[c])
			willoption(c, 0);
		state = TS_DATA;
		return NOT_CHAR;

	case TS_DO:
		if (verbose & V_10_) fprintf(stderr, "[do%02x%d]", c, myopts[c]);
		if (!myopts[c])		dooption(c, 1);
		state = TS_DATA;
		return NOT_CHAR;

	case TS_DONT:
		if (verbose & V_10_) fprintf(stderr, "[dont%02x%d]", c, myopts[c]);
		if (myopts[c])		dooption(c, 0);
		state = TS_DATA;
		return NOT_CHAR;

	default:
		printf("telnetd: panic state=%d\r\n", state);
		return NOT_CHAR;
	}
	return NOT_CHAR;
}

willoption(option, val)
	int option;
	int val;
{
	char *fmt = dont;

	switch (option) {
	case TELOPT_ECHO:
		/* the client wants local echo -- is this OK ? */
		if (val)
		{	if (!param2)	break;
			echoing = 0;
		}
		else	echoing = param2;

	case TELOPT_BINARY:
	case TELOPT_SGA:
		hisopts[option] = val;
		if (val) fmt = doopt;
	}
	if (non_data < 20) (void) fprintf(telf, fmt, option);
	if (verbose & V_10_) fprintf(stderr, "[%sDO%s%02x]",
		(non_data < 20) ? "" : "skip ",
		(fmt == doopt) ? "" : "NT", option);
	(void) fflush(telf);
}

dooption(option, val)
	int option;
	int val;
{
	char *fmt = wont;

	switch (option) {

	case TELOPT_ECHO:
		if (val) echoing = param2;
		else
		{	static int warn_de = 10;
			if (!param2 && warn_de > 0)
			{	fprintf(stderr, "[Beware double echo]");
				warn_de--;
			}
			echoing = 0;
		}
	case TELOPT_BINARY:
	case TELOPT_SGA:
		myopts[option] = val;
		if (val) fmt = will;
	}
	if (non_data < 20) (void) fprintf(telf, fmt, option);
	if (verbose & V_10_) fprintf(stderr, "[%sW%s%02x]",
		(non_data < 20) ? "" : "skip ",
		(fmt == will) ? "ILL" : "ONT", option);
	(void) fflush(telf);
}

interrupt()
{	fprintf(stderr, "*** INTERUPT\r\n");
	fflush(stderr);
}

do_echo(on)
int on;
{	int res;

	if (telnetd <= 0)	return on;

	res = (myopts[TELOPT_ECHO]) ? on : 0;
	if (verbose & V_10_) fprintf(stderr, " [given %d (%d/%d) give %d] ",
		on, hisopts[TELOPT_ECHO], myopts[TELOPT_ECHO], res);

	return res;
}

set_native_telnet(type, echo, sga)
int type, echo, sga;
{	if (verbose & V_10_) fprintf(stderr, "[set echo %x sga %x]", echo, sga);
	fprintf(telf, "%c%c%c%c%c%c",	IAC, echo, TELOPT_ECHO,
					IAC, sga,  TELOPT_SGA);
	fflush(telf);
	native_telnet = type;
}
#endif	TELNETD
