#ifndef	lint
static char RCSid[]="$Header: /Nfs/blyth/glob/src/usr.bin/spad/src/RCS/spadsun.c,v 1.27 1993/11/13 20:29:10 pb Exp $";
#endif	lint
/* spad:-  multiple client/single server x.29 service.
	   needs Sunlink X.25 software running in (at least) one node
 */

/* Copyright (c) A Rawsthorne 1986, 1987 & P Brooks 1987 - 1993
 * not for commercial use
 * this version not to be redistributed except by agreement.
 */

#define	USE_CUDF
#include "spad.h"
#include <ctype.h>

#ifndef	PBFORMAT
#define	PBFORMAT	"=N=%s"
#endif
#ifndef	MAX_AEF
#define	MAX_AEF	40
#endif	MAX_AEF

int lcn;

char * copy_chartohex();

/*ARGSUSED*/
char *
pbencode(data, buffer, len, context)
char *data;
int len;
char *buffer;
int context;
{
	char buff[40 +1];
	char *bufp = buff;
	char code;
	if (strlen(data) > (((sizeof buff) / 2) -1))
		return 0;
	*bufp++ = '5';
	*bufp++ = '0';
	switch(context)
	{
	default:	code='X';
	}
	code -= 32;
	*bufp++ = (code / 10) + '0';
	*bufp++ = (code % 10) + '0';

	for(; *data; data++)
	{	int n = *data - 32;
		if (n<0 || n > 99)	return 0;
		*bufp++ = (n / 10) + '0';
		*bufp++ = (n % 10) + '0';
	}
	*bufp = '\0';
	sprintf(buffer, PBFORMAT, buff);
	return buffer;
}

/*ARGSUSED*/
void nsap_to_mac(string, structp)
char *string;
struct char_full_addr *structp;
{
#ifdef	SPIDERGATE_MAC
	if (!strncmp(string, "ISO.", 4))
	{	structp->mac_addr = SPIDERGATE_MAC;
#ifdef	SPIDERGATE_LSEL
		structp->lsel	  = SPIDERGATE_LSEL;
#endif	/* SPIDERGATE_LSEL */
	}
#endif	/* SPIDERGATE_MAC */
}

#ifdef	SERVERCODE
#ifdef	sun
/* serverloop - wait for client message or X.25 message */
serverloop()
{
  int n;
  int x25mask	= (1 << s);
  int clientmask= (1 << servertoclient);
  int defmask	= clientmask | x25mask;

  if (s > servertoclient)	n = s + 1;
  else				n = servertoclient + 1;

  while(1)
  { int selmask = defmask;

    if (select(n, &selmask, (int *)NULL, (int *)NULL,
			(struct timeval *)NULL) < 0)
    { perror("server select");
      padexit(1);
    }
    if (selmask & clientmask) sendtox25socket(&x25obuf, readfromclient());
    if (selmask & x25mask)    sendtoclient(&x25ibuf, readfromx25(TTY_NODATA));
  }
}

print_sunparams(facil, file)
FACILITY_DB *facil;
FILE *file;
{ fprintf(file, " +++- %spkts=%d/%d, wnd=%d/%d",
	(facil->reverse_charge) ? "rec chge, " : "",
	facil->recvpktsize,
	facil->sendpktsize,
	facil->recvwndsize,
	facil->sendwndsize);
  if (facil->recvthruput || facil->sendthruput)
    fprintf(file, ", thru=%d/%d:%d/%d",
	facil->recvthruput,
	facil->sendthruput,
	thruput(facil->recvthruput),
	thruput(facil->sendthruput));
  if (facil->cug_req) fprintf(file, ", cug=%x", facil->cug_index);
  fprintf(file, ", %s",
	(facil->fast_select_type == FAST_OFF)	  ? "FS off" :
	(facil->fast_select_type == FAST_CLR_ONLY) ? "FS CLR" :
	(facil->fast_select_type == FAST_ACPT_CLR) ? "FS ACC" : "??");
  if (facil->rpoa_req) fprintf(file, ", rpoa %04x", facil->rpoa);
  fprintf(file, "\r\n");
}

thruput(x)
int x;
{ switch (x)
  {
  case 0:	return 0;
  case 3:	return 75;
  case 4:	return 150;
  case 5:	return 300;
  case 6:	return 600;
  case 7:	return 1200;
  case 8:	return 2400;
  case 9:	return 4800;
  case 10:	return 9600;
  case 11:	return 19200;
  case 12:	return 48000;
  default:	return -x;
  }
}

#define	sunfcs_to_std(x) (x == FAST_OFF) ? FACIL_NO : \
			 (x == FAST_CLR_ONLY ) ? FACIL_FCS_CLR : FACIL_YES
#define	sunrc_to_std(x)	(x == 0 ) ? FACIL_NO : FACIL_YES

set_xparams(facil, sun_facil)
struct facilities *facil;
FACILITY_DB *sun_facil;
{
  facil->x4_fflags |= FACIL_F_REVERSE_CHARGE | FACIL_F_FAST_SELECT;
  facil->x4_reverse_charge=sunrc_to_std(sun_facil->reverse_charge);
  facil->x4_fast_select	= sunfcs_to_std(sun_facil->fast_select_type);
  facil->x4_recvpktsize	= sun_facil->recvpktsize;
  facil->x4_sendpktsize	= sun_facil->sendpktsize;
  facil->x4_recvwndsize	= sun_facil->recvwndsize;
  facil->x4_sendwndsize	= sun_facil->sendwndsize;
  if (sun_facil->cug_req)	facil->x4_fflags |= FACIL_F_CUG_INDEX;
  facil->x4_cug_index		= sun_facil->cug_index;
/*
  facil->x4_recvthruput	= sun_facil->recvthruput;
  facil->x4_sendthruput	= sun_facil->sendthruput;
  if (sun_facil->rpoa_req)	facil->x4_fflags |= FACIL_F_RPOA;
  facil->x4_rpoa		= htons(sun_facil->rpoa);
*/
}

char *sprintf_diag(buff, diag)
char *buff;
X25_CAUSE_DIAG *diag;
{
  if (diag->flags & ~((1 << RECV_DIAG) | (1 << DIAG_TYPE)))
	sprintf(buff, " (flags %02x)", diag->flags); while(*buff) buff++;
  if (!(diag->flags & (1<<RECV_DIAG)))
	sprintf(buff, " (no info)"); while(*buff) buff++;
  sprintf(buff, " %s:", (diag->flags & (1<<DIAG_TYPE)) ? "clear" : "reset");
  while(*buff) buff++;
  sprintf_clr(buff, diag->data, diag->datalen);
}

read_into_ibuf(s, offset)
int s;
int offset;
{ int count;
  int oob_type;
  if (ioctl(s, X25_OOB_TYPE, &oob_type) < 0)
  { stampf("");
    perror("spadd: ioctl X25_OOB_TYPE");
    padexit(1);
  }
  if (oob_type)
  { x25ibuf.x_send_type = oob_type;
    x25ibuf.x_flags |= X25F_MSG_OOB;
    if (oob_type == INT_DATA)	count = recv(s, x25ibuf.x_buf, 1, MSG_OOB);
    else			count = 0;

    if (debug & D_1_) fprintf(stderr, "+  + oob %02x: %2db %02x\r\n",
		oob_type, count, x25ibuf.x_buf[0]);
  } else
  {
    /* YUCK !!!!
     * If TS29 and last subrecord didn't have the more bit set,
     * Then the "header byte" is split between the header byte and
     * the first byte of the data, so read it offset by one byte ...
     */
    errno = 0;
    count = recv(s, x25ibuf.x_rawbuf+offset, sizeof(x25ibuf.x_rawbuf), 0);

    if (ts29) last_ts29_push = !(x25ibuf.x_rawbuf[0] & (1 << M_BIT));

    /* if there is a TS pad character, deal with it */
    if (!offset)
    { char x = x25ibuf.x_send_type;
      x25ibuf.x_send_type = x25ibuf.x_tspad;
      x25ibuf.x_tspad = x;
      x25ibuf.x_flags |= X25F_TSPAD;
      count--;
    }

    count--;
    if (count < 0)
    { int err = errno;
      X25_CAUSE_DIAG diag;

      if (ioctl(s, X25_RD_CAUSE_DIAG, &diag) == 0 &&
		(diag.flags != ((1<<DIAG_TYPE) | (1<<RECV_DIAG)) ||
		 diag.datalen != 2 ||
		 diag.data[0] != 0 ||
		 diag.data[1] != 0))
      { char buff[256];
	sprintf(buff, "Call closed:");
	sprintf_diag(buff + strlen(buff), &diag);
	clientmes0(((err == EBADF || !errno) ? 0 : 1) | X25F_CLOSING, buff);
      }
      else
      { errno = err;
	if (errno != EBADF && errno)
	{	if (role == DIRECT) stampf("");
		perror((role == DIRECT) ? "recv" : "server: x25 recv");
	}
      }
      padexit(1);
    }
  }
  return count;
}

char_mac2bin(text, bin)
char *text;
u_char *bin;
{
	int i;
	for(i=0; i<6; i++)
	{	char *next = copy_chartohex(bin+i, text);
		if (next != text+2)	return 0;
		if ((i == 5) ? *next : *next != '-') return 0;
		next++;
		text = next;
	}
	return 1;
}

openx25()
{				/* used in server and direct case */
  int i, s; char *lookup();
  int new_facil = 0;
  int pending_bytes = 0;
  int type;
  int attempt = -1;
  static int nlinks = -1;
  char *dest = x25sbuf.x_destination;
  FACILITY_DB facil;
  X25_SYSGEN_DB link_params[10];
  int is_llc2 = 0;
  int can_llc2= 0;	/* Can LLC2 be used ? */
  /* int is_x25 = 0; */
  int is_84 = 0;	/* Is it X.25 (84) */

  struct char_full_addr called_pb_addr;
  extern pbgateway;

  /* Now what have we here ?
   * <DTE/NSAP>:<cudf>	\ Old fashioned ..
   * <DTE>/<YBTS>	/ should be phased out
   * =<full address>	New world ...
   * name		Best of all !
   */
  if (debug) { fprintf(stderr, "init: "); print_addr(&called_char_addr, stderr); }
  for (i=0; isdigit(dest[i]); i++);
  type = (i == 0) ? 0 : (i <= MAXHOSTADR) ? 1 : (i <= MAX_AEF) ? 2 : 3;

  switch (dest[i])
  {
  case '\0':	break;				/* Simple number */
  case ':':	dest[i++] = '\0';
		called_char_addr.cudf	= dest+i;
		break;		/* number + cudf */
  case '/':	dest[i++] = '\0';
		called_char_addr.ybts  = dest+i;
		break;
  case '=':	decode_app(dest+i, &called_char_addr, (char *)0);
		dest[i] = '\0';
		break;
  default: {	char * colon = index(dest, ':');
		char * slash = index(dest, '/');
		if (slash && colon && slash < colon) colon = (char *) 0;
		called_char_addr.name = dest;
		if (slash) { *slash++ = '\0'; called_char_addr.ybts = slash; }
		else if (colon) { *colon++ = '\0'; called_char_addr.cudf = colon; };
	    }
  }

  if (type & 1) called_char_addr.dte = dest;
  else if (type &2) called_char_addr.cd_nsap = dest;

  if (debug) { fprintf(stderr, "dest[%d]=%02x, type=%d: ", i, dest[i], type);
	print_addr(&called_char_addr, stderr);
  }
  if (!(called_char_addr.dte) && !(called_char_addr.cd_nsap) &&
 	called_char_addr.name && *(called_char_addr.name))
  { extern pbgateway;
    char buff[1024];
    pbencode(called_char_addr.name, buff, sizeof(buff), 0);
    if (pbgateway)
    {	decode_app(buff, &called_char_addr, (char *)0);
	printf("Use `%s'\n", buff);;
        bcopy(&called_char_addr, &called_pb_addr, sizeof called_char_addr);
    }
    else
    { char *dte;
      bcopy(&called_char_addr, &called_pb_addr, sizeof called_char_addr);
      decode_app(buff, &called_pb_addr, (char *)0);
      can_llc2++;
      dte = lookup(called_char_addr.name, app_relay,
	sizeof(app_relay), x25sbuf.x_context, x25sbuf.x_network, SERVER);
      if (dte == NULL) {
	char buff[1024];
	char *ptr = buff;
	int i;
	int c;
	int cntrl = 0;
	int inquote = 0;

	for (i=0; c = called_char_addr.name[i]; i++) if (! isgraph(c)) {
		if (inquote) {
			inquote = 0;
			*ptr++ = '\'';
		}
		sprintf(ptr, "%s0x%02x", (ptr == buff) ? "" : ", ", c & 0xff);
		while(*ptr) ptr++;
		cntrl++;
	} else {
		if (! inquote) {
			sprintf(ptr, "%s`", (ptr == buff) ? "" : ", ");
			inquote = 1;
			while(*ptr) ptr++;
		}
		*ptr++ = c;
	}
	if (inquote) *ptr++ = '\'';
	*ptr = '\0';
        clientmes2(X25F_CLOSING, "can't find %s in directory%s\r\n",
		/* NOSTRICT */ buff, (cntrl) ? " (duff name)" : "");
        return -2;
      }
      if (strlen(dte) > MAXHOSTADR) called_char_addr.cd_nsap = dte;
      else called_char_addr.dte = dte;
    }
  }
  else if (!(called_char_addr.dte) && !(called_char_addr.cd_nsap))
	called_char_addr.dte = "";

  if (debug) print_addr(&called_char_addr, stderr);
  bzero(add.host, sizeof (add.host));

  if (app_relay && !strncmp(app_relay, "YB =", 4) &&
 	 decode_app(app_relay+3, &called_char_addr, (char *) 0))
  { *app_relay = '\0';
  }
  add.hostlen = called_char_addr.dte ? strlen(called_char_addr.dte) : 0;
  for (i = 0; i < add.hostlen ; i++)
  { char c = called_char_addr.dte[i] - '0';
    if (!(i&1)) c = c << 4;
    add.host[i>>1] |= c;
  }
  
#ifndef	TS_CUDFLEN
#define	TS_CUDFLEN 4
#endif
  if (called_char_addr.ybts) set_cudf(add.data, &(add.datalen), TS_CUDF,
	TS_CUDFLEN, called_char_addr.ybts, strlen(called_char_addr.ybts),2);
  else set_cudf(add.data, &(add.datalen), x25sbuf.x_cudf, x25sbuf.x_cudflen,
	(called_char_addr.cudf) ? called_char_addr.cudf : "",
	(called_char_addr.cudf) ? strlen(called_char_addr.cudf) : 0,2);

  if (called_char_addr.cd_nsap && *(called_char_addr.cd_nsap)) is_84++;
  /* HACK .... */
  if (called_char_addr.mac_addr && *(called_char_addr.mac_addr)) is_llc2++;
  /* HACK .... */
  /* if (called_char_addr.cd_nsap && *(called_char_addr.cd_nsap)); else is_x25++; */

  if (debug & D_1_)
  { fprintf(stderr, " ++   Addr %d: ", add.hostlen);
    for (i=0; i<(add.hostlen+1)/2; i++) fprintf(stderr, "%02x", add.host[i]);
    fprintf(stderr, "\r\n");
    fprintf(stderr, " ++   CUDF %d/%d:", add.datalen, x25sbuf.x_cudflen);
    for (i=0; i<add.datalen; i++) fprintf(stderr, " %02x", add.data[i]);
    fprintf(stderr, "\r\n");
  }

#ifdef	AF_X25
  s = socket(AF_X25, SOCK_STREAM, 0);
#else	/* AF_X25 */
  s = socket(AF_X25, SOCK_STREAM, 0);
#endif	/* AF_X25 */
  if (s < 0)	return(s);			/* we'll become a client */

  if (nlinks < 0)
  {
	int forcelink = (x25_link && *x25_link) ? atoi(x25_link) : -1;
	int maxlink = 10;
	int link;
	int got = -2;

	bzero(link_params, sizeof link_params);

	if (forcelink == 0 && *x25_link != '0') forcelink --;
	if (forcelink >= 0) attempt++;

#ifdef	X25_RD_SYSGEN
	errno = -1;
#ifdef	X25_GET_NLINKS
	if (ioctl(s, X25_GET_NLINKS, &got) == 0)
	{	if (got > 0 && got < 20)
			maxlink = got;
		else if (debug) clientmes1(0, (got == -2) ?
			"Kernel failed to set the number of X.25 links" :
			"Kernel said there were %d X.25 links", got);
	}
	else if (debug) clientmes1(0, "Failed to read number of X.25 links (%d)", errno);
#endif
	for(nlinks=0, link=(forcelink >= 0) ? forcelink : 0;
		link < ((forcelink >= 0) ? forcelink+1 : maxlink); link++)
	{ link_params[nlinks].linkid = link;
	  if (ioctl(s, X25_RD_SYSGEN, &link_params[nlinks]) == 0)
	  { if (!link_params[nlinks].on)
	    { if (forcelink >= 0)
	      { clientmes1(X25F_CLOSING,
		      "Explicit link %d is not running\n", forcelink);
	         return -2;
	      }
	    }
#ifdef	LLC_TYPE
	    /* Only bother trying if LLC2 is the same,
	     * and if the user wants 84, that it can take it
	     */
	    else if ((((link_params[nlinks].link_type == LLC_TYPE) &&
		       (is_llc2 || can_llc2 || is_84)) ||
		      ((link_params[nlinks].link_type != LLC_TYPE) &&
		       !is_llc2)) &&
		     (!is_84 || link_params[nlinks].version == V_1984))
	    	nlinks++;
	    else if (forcelink >= 0)
	    { clientmes3(0, "type=%d, is_llc2=%d, can_llc2=%d",
	        link_params[nlinks].link_type, is_llc2, can_llc2);
	      clientmes2(0, "is_84=%d, version=%d",
	        is_84, link_params[nlinks].version);
	      clientmes1(X25F_CLOSING,
	          "Explicit link %d is not suitable", forcelink);
	      return -2;
	    }
#else	/* LLC_TYPE */
	    else nlinks++;
#endif	/* LLC_TYPE */
	  }
	  else if (forcelink >= 0) 
	  { clientmes1(1 | X25F_CLOSING,
	          "X25_RD_SYSGEN failed on explicit link %d",
	          forcelink);
	    return -2;
	  }
	}
#else
	if (forcelink >= 0)
	{	nlinks = 0;
		link_params[nlinks].linkid = forcelink;
		nlinks++;
	}
	else	for(nlinks=0; nlinks < maxlink; nlink++)
			link_params[nlinks].linkid = nlinks;
#endif
  }
  if (nlinks <= 0)
  { clientmes0(1 | X25F_CLOSING, "No suitable links available");
    return -2;
  }
  if ((i=ioctl(s, X25_RD_FACILITY, &facil)) < 0)
  { clientmes3(1 | X25F_CLOSING, "ioctl X25_RD_FACILITY (on %s gave %d %d)",
 	 called_char_addr.name, i, errno);
    return -2;
  }

  if (debug & D_1_) print_sunparams(&facil, stderr);

  /* HACK HACK Hack Hack hack hack ... start ... hack hack Hack Hack HACK HACK
   *
   * There is a bug in the sun code whereby if you set the thruput to anything
   * other than 0 (e.g. if you leave the value from X25_RD_FACILITY) it fails.
   *
   * HACK HACK Hack Hack hack hack .......... hack hack Hack Hack HACK HACK */
  facil.sendthruput	= 0;
  facil.recvthruput	= 0;
  x25sbuf.x_sendthruput	= 0;
  x25sbuf.x_recvthruput	= 0;
  x25sbuf.x_fflags	&= ~(FACIL_F_SENDTHRUPUT |  FACIL_F_RECVTHRUPUT);
  /* HACK HACK Hack Hack hack hack ... end ... hack hack Hack Hack HACK HACK*/

  /* If it defaulting to FAST SELECT and isn't needed, don't bother
   */

  if(!(x25sbuf.x_fflags & FACIL_F_FAST_SELECT))	/* user specified */
  {	x25sbuf.x_fast_select	= (add.datalen <= MAXNOFS_BYTES) ? FACIL_NO :
								   FACIL_YES;
	x25sbuf.x_fflags		|= FACIL_F_FAST_SELECT;
  }

  /* The buffer is too big to do a non-fast call select -- have to split it */
  if(add.datalen > MAXNOFS_BYTES && x25sbuf.x_fast_select == FACIL_NO)
  { if (!ybts)
    {	clientmes1(X25F_CLOSING,
		"CUDF field is too long (%d bytes) - you need Fast Call Select\r\n", add.datalen);
	return -2;
    }
    pending_bytes = add.datalen - MAXNOFS_BYTES;
    add.data[4] |= 64;	/* let other end know that there is more to come */
    add.datalen -= pending_bytes;
  }

/* How to conver between std representation and sun */
#define	stdfcs_to_sun(x) (x == FACIL_NO) ? FAST_OFF : \
			 (x == FACIL_FCS_CLR) ? FAST_CLR_ONLY : FAST_ACPT_CLR
#define	stdrc_to_sun(x)	(x == FACIL_NO) ? 0 : 1
#define update_facil(mask, new, old) \
  if (x25sbuf.x_fflags & mask && (new != old)) { old=new; new_facil++; }

  /* Copy over the user requirements, if non-zero */
  update_facil(FACIL_F_FAST_SELECT,
	stdfcs_to_sun(x25sbuf.x_fast_select), facil.fast_select_type);
  update_facil(FACIL_F_REVERSE_CHARGE,
	stdrc_to_sun(x25sbuf.x_reverse_charge), facil.reverse_charge);

  update_facil(FACIL_F_RECVPKTSIZE, x25sbuf.x_recvpktsize, facil.recvpktsize);
  update_facil(FACIL_F_SENDPKTSIZE, x25sbuf.x_sendpktsize, facil.sendpktsize);
  update_facil(FACIL_F_RECVWNDSIZE, x25sbuf.x_recvwndsize, facil.recvwndsize);
  update_facil(FACIL_F_SENDWNDSIZE, x25sbuf.x_sendwndsize, facil.sendwndsize);
  update_facil(FACIL_F_CUG_INDEX,   x25sbuf.x_cug_index,   facil.cug_index);
  if (x25sbuf.x_fflags & FACIL_F_CUG_INDEX) facil.cug_req = 1;
/*
  update_facil(FACIL_F_RECVTHRUPUT, x25sbuf.x_recvthruput, facil.recvthruput);
  update_facil(FACIL_F_SENDTHRUPUT, x25sbuf.x_sendthruput, facil.sendthruput);
  update_facil(	FACIL_F_RPOA, x25sbuf.x_rpoa, facil.	rpoa);
*/

  set_xparams(&x25sbuf.x_facil, &facil);
  if (debug) fprintf(stderr, "set_xparams %d < %d ...\n", attempt, nlinks);

  for (; attempt < nlinks; close(s), s = -1, attempt++)
  {
    struct char_full_addr *called_addr = &called_char_addr;
    char *calling_nsap;
  if (debug) fprintf(stderr, "set_xparams .2.\n");
#ifdef	LLC_TYPE
    if (can_llc2 && !is_llc2 && attempt >=0 && link_params[attempt].link_type == LLC_TYPE)
	called_addr = &called_pb_addr;
#endif
    calling_nsap = called_addr->cg_nsap;
#ifdef	DEF_CALLING_NSAP
    if (!calling_nsap) calling_nsap =  DEF_CALLING_NSAP;
#endif
#ifdef	LLC_TYPE
    if (debug) fprintf(stderr, "l=%d, can=%d, is=%d, att=%d, use=%d: %x=%x cd_nsap=%x\n",
	link_params[attempt].linkid, can_llc2, is_llc2, attempt,
	(attempt >=0) ? link_params[attempt].link_type == LLC_TYPE : -99,
	called_addr, &called_pb_addr, called_addr->cd_nsap);
#endif
    if (debug) print_addr(called_addr, stderr);
    if (s < 0)
#ifdef	AF_X25
      s = socket(AF_X25, SOCK_STREAM, 0);
#else	/* AF_X25 */
      s = socket(AF_X25, SOCK_STREAM, 0);
#endif	/* AF_X25 */
    if (s < 0)	return(s);			/* we'll become a client */
#ifdef	X25_WR_MACADDR
    if (called_addr->cd_nsap && *(called_addr->cd_nsap))
    {	X25_MACADDR macaddr;
	FACILITY facility;

	bzero(&macaddr, sizeof macaddr);
	if (!called_addr->mac_addr || !*(called_addr->mac_addr))
		nsap_to_mac(called_addr->cd_nsap, called_addr);
	/*if (!called_addr->mac_addr || !*(called_addr->mac_addr))
	{ clientmes0(1, "No MAC address"); return -2; }
	*/	
 	 if (debug & D_1_)
	{ fprintf(stderr, " ++   NSAP %d: ", strlen(called_addr->cd_nsap));
	  fprintf(stderr, "%s", called_addr->cd_nsap);
	  if (called_addr->mac_addr && *called_addr->mac_addr)
		fprintf(stderr, ", MAC: %s", called_addr->mac_addr);
	  fprintf(stderr, ", LSEL: %s",
		(called_addr->lsel && *(called_addr->lsel)) ?
		called_addr->lsel : "(7e)");
	  fprintf(stderr, "\r\n");
	}

	if (called_addr->lsel && *(called_addr->lsel))
		macaddr.lsel = 0 /* ?? */;
	else macaddr.lsel = 0;

	if (called_addr->mac_addr && *called_addr->mac_addr)
	{  
	  if (!char_mac2bin(called_addr->mac_addr, macaddr.macaddr))
	  { clientmes1(1, "invalid MAC address `%s'", called_addr->mac_addr); return -2; }
	  macaddr.maclen = 6;
#ifdef	X25_WR_MACADDR
	  if (ioctl(s, X25_WR_MACADDR, &macaddr))
	  { clientmes0(1, "ioctl(X25_WR_MACADDR[0])");
	    if (called_addr->lsel && *(called_addr->lsel))
		  macaddr.lsel = 0x7e /* ?? */;
	    else macaddr.lsel = 0x7e;
	    if (ioctl(s, X25_WR_MACADDR, &macaddr))
	    { clientmes0(1, "ioctl(X25_WR_MACADDR[7e])");
	      return -2;
	    }
	    else if (debug & D_1_) fprintf(stderr,
	   	 "MAC address set after forcing to LSEL 7e\n");
	  }
	  else if (debug & D_1_) fprintf(stderr, "MAC address set\n");
#else	X25_WR_MACADDR
	  { clientmes0(1, "ioctl(X25_WR_MACADDR) not supported"); return -2: }
#endif	X25_WR_MACADDR
	}
#ifdef	T_CALLING_AEF
	if (calling_nsap && *calling_nsap)
	{ facility.f_cg_aef_type = AEF_NSAP;
	  facility.f_cg_aef_len = strlen(calling_nsap);
	  copy_chartohex(facility.f_cg_aef, calling_nsap);
	  facility.type = T_CALLING_AEF;
	  if (ioctl(s, X25_SET_FACILITY, &facility))
	  { clientmes1(1, "ioctl(X25_SET_FACILITY) (calling AEF) of %s", calling_nsap);
	    return -2;
	  }
	}
#endif

#ifdef	T_CALLED_AEF
	facility.f_cd_aef_type = AEF_NSAP;
	facility.f_cd_aef_len = strlen(called_addr->cd_nsap);
	copy_chartohex(facility.f_cd_aef, called_addr->cd_nsap);
	facility.type = T_CALLED_AEF;
	if (ioctl(s, X25_SET_FACILITY, &facility))
	{ clientmes1(1, "ioctl(X25_SET_FACILITY) (called AEF) of %s", called_addr->cd_nsap);
	  return -2;
	}
#endif

#ifdef	T_FACILITIES
	if (debug)
	{ facility.type = T_FACILITIES;
	if (ioctl(s, X25_GET_FACILITY, &facility))
	{ clientmes0(1, "ioctl(X25_GET_FACILITY) (facilities)");
	}
	else printf("Facilities set to %x\n", facility.f_facilities);
	}
#endif
    }
#endif
    if (new_facil) /* User changed something ... */
    { if (debug & D_1_)
      { print_facil(&x25sbuf.x_facil, stderr);
        print_sunparams(&facil, stderr);
      }
      if (ioctl (s, X25_WR_FACILITY, &facil) != 0)
      { clientmes1(1 | X25F_CLOSING, "ioctl X25_WR_FACILITY (on %s)", called_addr->name);
        return -2;
      }
    }
    i = 1;
    if (ioctl(s, X25_HEADER, &i) < 0)
    { clientmes1(1 | X25F_CLOSING, "ioctl X25_HEADER (for %s)", called_addr->name);
      return -2;
    }

#ifdef	X25_WR_LOCAL_ADR
    /* Set the calling address */
    if (calling_dte && * calling_dte)
    { CONN_ADR loc_addr;
      int i=0;
      char *text = calling_dte;
      char *hex = (char *) (loc_addr.host);
      bzero (&loc_addr, sizeof loc_addr);

      for (; isdigit(*text); i++, text++)
      { if (i > 15)
	{ clientmes2(1 | X25F_CLOSING, "ioctl Calling address %s too long (for %s)",
		calling_dte, called_addr->name);
          return -2;
        }
      	if (i & 1)	*hex++ |=  ((*text) - '0');
	else		*hex    = (((*text) - '0') << 4);
      }
      loc_addr.hostlen |= text - calling_dte;  /* called DTE len */

      /* Could decode <X.121>:<rest> as per unix-niftp ... */

      if (strlen(calling_dte) < 4) loc_addr.hostlen |= SUBADR_ONLY;

      if (debug & D_1_) {
	fprintf(stderr, "Set calling DTE %02x: %*.*s (%s)\n",
		loc_addr.hostlen & 0xff,
		loc_addr.hostlen & ADR_LEN_MASK,
		loc_addr.hostlen & ADR_LEN_MASK,
		calling_dte, calling_dte);
      }
      if (ioctl(s, X25_WR_LOCAL_ADR, &loc_addr) != 0)
      { clientmes2(1 | X25F_CLOSING, "ioctl X25_WR_LOCAL_ADR %s (for %s)",
		calling_dte, called_addr->name);
        return -2;
      }
    }
#else
	fprintf(stderr, "No X25_WR_LOCAL_ADR\n");
#endif	/* X25_WR_LOCAL_ADR */

#ifdef	ANY_LINK
    add.hostlen |= ANY_LINK;
#endif	/* ANY_LINK */

#ifdef	X25_SET_LINK
    if (attempt >= 0)
    { if (ioctl(s, X25_SET_LINK, &(link_params[attempt].linkid))) {
	clientmes1(1, "ioctl(X25_SET_LINK, %d).", link_params[attempt].linkid);
	if (x25_link && *x25_link) return -2;
	continue;
      }
    }
#endif	/* X25_SET_LINK */

    if (connect(s, (struct sockaddr *)&add, sizeof(add)) >= 0) break;
    { char temp[256];
      char *tempp = temp;
      X25_CAUSE_DIAG diag;

      if (debug & 1)
      { int i;
        fprintf(stderr, "Address was %d:", sizeof(add));
	for (i=0; i<sizeof add; i++)
 	  fprintf(stderr, " %02x", ((char *) &add)[i] & 0xff);
	fprintf(stderr, "\n");
      }
      if (/*(errno == ENOTCONN || errno == EINVAL) &&*/ attempt < nlinks-1)
      {	
	clientmes1(1, (attempt < 0) ?
			"   ... Initial call to `ANY' link failed..." :
			"   ... Call to Link %d failed...",
				link_params[attempt].linkid);
	continue;
      }

      sprintf(tempp, "server X25 call to %s failed %d:",
 	 (called_addr && called_addr->name) ? called_addr->name : "<UnKnown>", errno);
      while(*tempp) tempp++;
      if (ioctl(s, X25_RD_CAUSE_DIAG, &diag) == 0) sprintf_diag(tempp, &diag);
      else sprintf(tempp, " No diag");
      clientmes0(1 | X25F_CLOSING, temp);
      return -2;
    }
  }

  /* set it up to pass over the header byte as well */
  i = 1;
  if (ioctl(s, X25_HEADER, &i) < 0)
  { clientmes1(1 | X25F_CLOSING, "ioctl X25_HEADER (for %s)", called_char_addr.name);
    return -2;
  }
  /* set it up to send partial records only */
  { FACILITY_DB output_params;
    if (ioctl(s, X25_RD_FACILITY, &output_params) < 0)
    { clientmes1(1 | X25F_CLOSING, "ioctl X25_RD_FACILITY (for %s)", called_char_addr.name);
      return -2;
    }
    set_xparams(&x25sbuf.x_facil, &output_params);
    i = (sizeof x25ibuf.x_buf) / output_params.recvpktsize;
    if (i < 0)
    { i = 1;
      clientmes2(0,
	" +++- packetsize is %d but buffer is %d - data may be lost",
	output_params.recvpktsize, sizeof (x25ibuf.x_buf));
    }
    if ((verbose & V_2_)) clientmes2(0, " +++- packetsize is %d so request %d",
		output_params.recvpktsize, i);
    if (ioctl(s, X25_RECORD_SIZE, &i) < 0)
    { clientmes1(1 | X25F_CLOSING, "ioctl X25_RECORD_SIZE (for %s)", called_char_addr.name);
      return -2;
    }
  }

  if (ioctl(s, X25_RD_LCGN, &lcn))
      if ((verbose & V_2_)) clientmes0(1, "Failed to read LCN");

  if (debug & D_1_)
  { if (ioctl (s, X25_RD_FACILITY, &facil) != 0)
      clientmes0(1 , "Failed to read Facilities");
    else print_sunparams(&facil, stderr);
  }

  if (ybts) suck_userdata();

  if (pending_bytes)
  { int qbit = (1 << Q_BIT);
    if (ioctl(s, X25_SEND_TYPE, &qbit) < 0 ) perror("Set Qbit");
    /* Bit ikky -- stuff the CONNECT info into the buffer and send it off */
    add.data[MAXNOFS_BYTES-1] = CONNECT;
    if (send(s,&(add.data[MAXNOFS_BYTES-1]),pending_bytes+1,0)!=pending_bytes+1)
	perror("Send FS data");
    qbit = 0;
    if (ioctl(s, X25_SEND_TYPE, &qbit) < 0 ) perror("Clear Qbit");
    fprintf(stderr, "Send non FS data\r\n");
    /* We really OUGHT to set the CUDF info back as it was ... */
  }

  if (role == SERVER)
  { if(debug & D_1_)
    {	int i;
	fprintf(stderr, "+return setup+ %db:", x25SBUF_size);
	if (debug & D_2_) for(i=0; i<x25SBUF_size; i++)
		fprintf(stderr, " %02x", ((unsigned char *)x25sbuf.x_buf)[i]);
	fprintf(stderr, "]\r\n");
    }
    x25sbuf.x_flags |= X25F_SBUF;
    sendtoclient(&x25sbuf, x25SBUF_size);
  }

  printapprelay();
  return(s);
}

suck_userdata()
{ USER_DATA_DB	o_p;
  while (ioctl(s, X25_RD_USER_DATA, &o_p) == 0)
  { int i;
    fprintf(stderr, "User data: %d: ", o_p.datalen);
    for(i=0; i<o_p.datalen;i++) fprintf(stderr, "%02x", o_p.data[i] & 0xff);
    fprintf(stderr, "\r\n");
    if (o_p.datalen < 124) break;
  }
}

send_reset(s)
int s;
{ X25_CAUSE_DIAG diag;
  diag.flags = 1;
  diag.datalen = 1;
  diag.data[0] = 0;
  if (ioctl(s, X25_WR_CAUSE_DIAG, &diag) < 0)
  { stampf("");
    perror("ioctl X25_WR_CAUSE_DIAG");
    padexit(1);
  }
}

static send_fails = 0;

send_data_2(s, x25buf, buf, count, send_type)
int s;
struct x25io *x25buf;
char *buf;
int count;
int send_type;
{ int loops;
  int max = 3;
  for (loops = max -1; loops > 0; loops--)
  { if ((!(x25buf->x_flags & X25F_MSG_OOB)) &&
	ioctl(s, X25_SEND_TYPE, &send_type) < 0)
    { stampf("spadd: Type %02x ", send_type);
      perror("ioctl X25_SEND_TYPE");
      padexit(1);
    }
    if (send(s, buf, count, (x25buf->x_flags&X25F_MSG_OOB) ? MSG_OOB : 0)<0)
    { int e = errno;
      stampf("");
      errno = e;
      perror("send");
      if (x25buf->x_flags&X25F_MSG_OOB && e == EINPROGRESS)
      	fprintf(stderr, "\rInterupt");
      else fprintf(stderr, "\rSend (%d)", count);
      fprintf(stderr, " failed ... sleep for %d ...\r\n", max - loops);
      sleep(max - loops);
      continue;
    }
    break;
  }
  if (loops <= 0)
  { if (x25buf->x_flags&X25F_MSG_OOB) clientmes0(0,
 	 "Interupt not sent as previous Interupt still outstanding");
    else if (send_fails++ > 5)
    { clientmes1(X25F_CLOSING, "Too many send failures (%d) -- closing call",
   	 send_fails);
      resettty();
      padexit(1);
    }
  }
  else send_fails = 0;
}
#endif	sun
#endif	SERVERCODE
