#ifndef	lint
static char RCSid[]="$Header: /Nfs/blyth/glob/src/usr.bin/spad/src/RCS/spadserv.c,v 1.27 1993/11/13 20:29:07 pb Exp $";
#endif	lint
/* spad:-  multiple client/single server x.29 service.
	   needs Sunlink X.25 software running in (at least) one node
 */

/* Copyright (c) A Rawsthorne 1986, 1987 & P Brooks 1987 - 1993
 * not for commercial use
 * this version not to be redistributed except by agreement.
 */

#define USE_CUDF        /* Want to include CUDF data */
#include "spad.h"
#ifdef	SERVERCODE

sprintf_dtes(buff, data, len)
char *buff;
unsigned char *data;
int len;
{ if (len > 0)
  { int la1 =  data[0]       & 0x0f;
    int la2 = (data[0] >> 4) & 0x0f;
    int bytes = (la1+la2+1)/2;
    if (len > bytes)
    {	int i;
	sprintf(buff, " Addresses %01x/%01x: ", la1, la2);
	while(*buff) buff++;
        for(i=1; bytes; i++, bytes--)
	{ sprintf(buff, "%02x%s", data[i], (bytes == (la2/2)+1) ? " " : "");
	  while(*buff) buff++;
	}
        return i;
    }
  }
  return 0;
}

sprintf_facil(buff, data, len)
char *buff;
unsigned char *data;
int len;
{ int i;
  int skip = 0;

  for (i=0; i<len; i++)	if (skip)
  {	skip--;
	sprintf(buff, " %02x", data[i]);
	while(*buff) buff++;
  }
  else
  {	int args = 0;	/* Keep lint etc happy */

	switch (data[i] & 0xc0)
	{	case 0x00:	args = 1;			break;
		case 0x40:	args = 2;			break;
		case 0x80:	args = 3;			break;
		case 0xc0:	args = data[i+1] +1;		break;
	}

	if (args > (len -i))	goto defalt;

        switch(data[i])
	{
	case 0x00:
	if ((data[i+1] != 0x00) && (data[i+1] != 0xff))	goto defalt;
	sprintf(buff, " NOM call%s", (data[i+1]) ? "ed" : "ing");
	i += args;
	break;

	case 0xc1:
	if (args != 5)	goto defalt;
	sprintf(buff, " Call Duration %02x%02x%02x%02x",
		data[i+2], data[i+3], data[i+4], data[i+5]);
	i += args;
	break;

	case 0xc2:
	if (args != 9)	goto defalt;
	sprintf(buff, " Call stats %02x%02x%02x%02x %02x%02x%02x%02x",
		data[i+2], data[i+3], data[i+4], data[i+5],
		data[i+6], data[i+7], data[i+8], data[i+9]);
	i += args;
	break;

	defalt:
	sprintf(buff, " invalid");
	while(*buff) buff++;
	default:
	sprintf(buff, " facil %02x len %d", data[i], args);
	skip = args;
	}
	while(*buff) buff++;
  }
  if (skip) sprintf(buff, " -- invalid facilities %d byte%s missing",
		skip, (skip == 1) ? "" : "s");
  return i;
}

sprintf_clr(buff, data, len)
char *buff;
char *data;
int len;
{ int i = 0;
  int facil = 0;

  if (i <= len-2)
  { int inc;
    sprintf(buff, " %02x diag %02x", data[i] & 0xff, data[i+1] & 0xff);
    i += 2;
    while(*buff) buff++;

    i += (inc = sprintf_dtes(buff, data + i, len -i));
    while(*buff) buff++;

    if (inc && i <= len-1 && data[i] <= len-i)
    { facil = data[i];
      i++;
      sprintf(buff, (facil) ? " Facilities %d:" : " No Facilities", facil);
      while(*buff) buff++;
    }

    i += sprintf_facil(buff, data + i, facil);
    while(*buff) buff++;

    if (i < len)
    { sprintf(buff, " Data:");
      while(*buff) buff++;
      for(; i<len; i++)
      { sprintf(buff, " %02x", data[i]);
        while(*buff) buff++;
      }
    }
  }
}


/* SERVER - specific stuff */

#include <sys/wait.h>
grimreaper()
{
  union wait status;
  while (wait3(&status, WNOHANG, /* NOSTRICT */ 0) > 0)
    ;  /* NOTHING */
}

doserver(argc, argv)
int argc;
char **argv;
{ char *getopt_format = "L:g:a:e:p:v:";
  int s;			/* temp listening socket */
  int c;
  int portn;
  char *stderrlog = "/dev/null";
  int inetd=0;

#ifdef SECURITY
  /* Do not allow any old user to start a server */
  if ( c = disallowed(findusername(), STARTSERVER, 1, "s", "", (char *) 0, 0) ) {
	fprintf( stderr, "You do not have permission to do that (%d)!\r\n", c);
	exit(1);
  }
#endif SECURITY

  if (argc == 0)
  {
	stderrlog = "/tmp/log.in.spadd";
	inetd++;
  }

  while ((c = getopt(argc, argv, getopt_format)) != EOF)
    switch(c) {
    case 'g':
      debug = atoi(optarg);
      service = SERVICEG;	/* select alternate service name */
      fprintf(stderr, "debugging %d\r\n", debug);		break;
    case 'L':	stderrlog = optarg;				break;
    case 'a':	accntfile = optarg;				break;
    case 'e':	errfile = optarg;				break;
    case 'p':	port = optarg;					break;
    case 'v':	verbose=atoi(optarg);
		fprintf(stderr, "verbose %02x\r\n", verbose);	break;
    case '?':	fprintf(stderr, "Usage: %s [%s]\r\n", argv[0], getopt_format);
      exit(1);
    }
  if (argc && optind != argc)
  { fprintf(stderr, "Usage: %s [%s]\r\n", argv[0], getopt_format);
    exit(1);
  }
  role = SERVER;
  if (debug & D_1_) fprintf(stderr, "I am a server!\r\n");
  else
  { int s;

    switch (fork())
    { case -1:	perror("Fork failed"); exit(1);
      case 0:	break;
      default:	exit(0);
    }

    /*? Was ... for (s = 0; s < 10; s++) (void) open("/dev/null", 0);
	    (void) dup2(0, 1);
	    (void) dup2(0, 2);
    ?*/
    fclose(stdout);
    { if (strcmp(stderrlog, "-") && fopen(stderrlog, "a") == stdout)
      { (void) dup2(1, 2); /* Yuck -- change the fd under stderr's feet */
	setlinebuf(stderr);
      }
      else /* do the best we can ... */
      { if (strcmp(stderrlog, "-"))
	{ fprintf(stderr, "Failed to open log file ");
	  fflush(stderr);
	  perror(stderrlog);
	}
	(void) dup2(2, 1);	/* 1 is now stderr */
	if (fdopen(1, "w") != stdout)
  	fprintf(stderr, "Stdout not as expected !!\r\n");
      }
    }
    /* detatch /dev/tty */
#ifdef	TIOCNOTTY
    if ((s = open("/dev/tty", 2)) >= 0) {
	ioctl(s, TIOCNOTTY, 0);
	(void) close(s);
    }
#endif	TIOCNOTTY
  }

  if (inetd)
  { /*? Find out who called & put it in from ?*/
    int len = sizeof(from);
    servertoclient = 0;
    getpeername(servertoclient, (struct sockaddr *)&from, &len);
    serverprocess();
    stampf("inetd job done\r\n");
    exit(0);
  }

  if (port) portn = htons(atoi(port));
  else
  { struct servent *sp = getservbyname(service, "tcp");
    if (sp == NULL)
    { stampf("no %s/tcp service\r\n", service);
      exit(1);
    }
    portn = sp->s_port;
  }
  s = socket(AF_INET, SOCK_STREAM, 0);
  if (s < 0)
  { stampf("");
    perror("server socket");
    exit(1);
  }
  s_in.sin_family = AF_INET;
  s_in.sin_port = portn;
  if (bind(s, (struct sockaddr *)&s_in, sizeof(s_in)) < 0)
  { stampf("");
    perror("server bind");
    exit(1);
  }
  (void) signal(SIGCHLD, grimreaper);
  (void) listen(s, 5);
  stampf("Listening on %d\r\n", portn);
  for (;;)
  { int len = sizeof(from);
    servertoclient = accept(s, (struct sockaddr *)&from, &len);
    if (servertoclient < 0)
    { if (errno == EINTR) continue;
      stampf("");
      perror("server accept");
      exit(1);
    }
    if (debug & D_1_)		/* one-shot */
    { serverprocess();
      stampf("Debugging job done\r\n");
      exit(0);
    }
    if (fork())
      close(servertoclient);	/* parent branch */
    else
    { close(s);			/* child */
      serverprocess();
    }
  }
}

serverprocess()
{
  int count;
  /* first, agree on size of x25sbuf */
  count = readfromclient();
  /* ??? Check count ??? */
  if (x25obuf.x_ssize != x25sbuf_size)
  { clientmes2(0, "server: we don't agree on the size of an sbuf (%d != %d)",
		x25obuf.x_ssize, x25sbuf_size);
    clientmes0(X25F_CLOSING, "server: Your spad client software is out of date");
    padexit(1);
  }
#if	X25IO_VER > 5
#if	X25IO_VER < 7
  if (x25obuf.x_pad1 || x25obuf.x_pad2 || x25obuf.x_pad3)
#endif
  if (x25obuf.x_pad3 != (x25sbuf_size & 0xff))
  { clientmes2(0,
	"server: we don't agree on the size of an sbuf (%d != %d mod 256)",
	x25obuf.x_pad3, x25sbuf_size & 0xff);
    clientmes0(X25F_CLOSING, "server: Your spad client software is out of date");
    padexit(1);
  }
#endif

   getsender(x25obuf.x_username, &from.sin_addr);
#ifdef SECURITY
  {   int c;

      if ( c = disallowed(sender, x25obuf.x_destination, 0, (char *) 0, "",
			(char *) 0, 0))
      {     clientmes3(X25F_CLOSING | CM_NOLOG,
		    "You (%s) do not have permission to call %s (%d)",
		    sender, x25obuf.x_destination, c);
	    stampf("spadd: %s > %s -- %s on line %d\r\n",
			sender, x25obuf.x_destination, block, c);
	    padexit(1);
      }
  }
#endif SECURITY

  bcopy(x25obuf.x_buf, x25sbuf.x_buf, x25SBUF_size);
  s = openx25();
  if (s < 0)
  { switch (s)
    {
    case -2:	break;
    default:
      stampf("can't open %s for %s\r\n", x25obuf.x_destination, sender);
      clientmes0(1 | X25F_CLOSING | CM_NOLOG, "can't open X25 connection");
    }
    padexit(1);
  }
  stampf("spadd: %s > %s", sender, called_char_addr.dte);
  endhostent();			/* be kind to servers! */

  if (x25sbuf.x_cudflen)
  { int i=0;
    fprintf(stderr, ".");
    if (x25sbuf.x_cudflen >= 3) /* Known protocol id ? */
    { if (ybts) i += 4, fprintf(stderr, "TS.");
      else if (x25sbuf.x_cudf[0] == PRE_CUDF[0] &&
	       x25sbuf.x_cudf[2] == PRE_CUDF[2] &&
	       x25sbuf.x_cudf[3] == PRE_CUDF[3]) switch (x25sbuf.x_cudf[1])
      {	case 90:	i += 4;	fprintf(stderr, "V1.");		break;
	case 91:	i += 4;	fprintf(stderr, "V2.");		break;
	case 92:	i += 4;	fprintf(stderr, "V3.");		break;
	case 93:	i += 4;	fprintf(stderr, "V4.");		break;
	case 94:	i += 4;	fprintf(stderr, "V5.");		break;
      }
    }
    for (; i<x25sbuf.x_cudflen; i++)
      fprintf(stderr, (isprint(x25sbuf.x_cudf[i])) ? "%c" : "<%02x>",
	x25sbuf.x_cudf[i]);
  }
  fprintf(stderr, "\r\n");
  startlog();
  serverloop();
}


/* X.25 message has arrived - put it in x25ibuf ready to the client or tty */

readfromx25(data)
int data;
{ int count;
  int offset = (ts29 && last_ts29_push) ? 0 : TS29_BYTES;

  x25ibuf.x_send_type = 0;
  x25ibuf.x_flags &= ~X25F_TSPAD;
  x25ibuf.x_flags &= ~X25F_MSG_OOB;

  count = read_into_ibuf(s, offset, data);

  if (debug & D_1_)
  { int i;
    fprintf(stderr, "+++ %2db f%x %s [", count, x25ibuf.x_flags,
		(offset) ? " - skip TS29" : " + TS29 byte");
    for(i=0; i<x25hdrsize; i++)
	fprintf(stderr, " %02x", ((unsigned char *)&x25ibuf)[i]);
    fprintf(stderr, ":");
    for(i=0; i<1+TS29_BYTES; i++)
	fprintf(stderr, " %02x", x25ibuf.x_rawbuf[i]);
    fprintf(stderr, ":");
    if (debug & D_2_) for(i=0; i<count; i++)
	fprintf(stderr, " %02x", ((unsigned char *)x25ibuf.x_buf)[i]);
    fprintf(stderr, "]\r\n");
  }
  x25log.pktsin++;
  x25log.bytesin += count;
  return count;
}

sendtoclient(x25buf, count)
struct x25io *x25buf;
int count;
{
  int acount;
  x25buf->x_count_ms = count / 256;
  x25buf->x_count_ls = count % 256;
  if(debug & D_1_)
  {	int i;
	fprintf(stderr, "+toclient+ %db f%x [", count, x25buf->x_flags);
	for(i=0; i<x25hdrsize; i++)
		fprintf(stderr, " %02x", ((unsigned char *)x25buf)[i]);
	fprintf(stderr, ":");
	for(i=0; i<1+TS29_BYTES; i++)
		fprintf(stderr, " %02x", x25buf->x_rawbuf[i]);
	fprintf(stderr, ":");
	if (debug & D_2_) for(i=0; i<count; i++)
		fprintf(stderr, " %02x", ((unsigned char *)x25buf->x_buf)[i]);
	fprintf(stderr, "]\r\n");
  }
  count += x25hdrsize +1 +TS29_BYTES;		/* # of bytes to send */
  acount = send(servertoclient, (char *)x25buf, count, 0);
  if (count != acount)
  { stampf("spadd: short send to client: wanted %d, got %d\r\n",
	   count, acount);
				/* Probably can't send this mess. to client */
    padexit(1);
  }
}

/* message from the client has arrived - send it to X.25 line */
readfromclient()
{
  int count, acount;
  count = recvfill(servertoclient, (char *)&x25obuf, x25hdrsize, 0);
  if (count != x25hdrsize)
  { if (count < 0)
    { stampf("");
      perror("spadd: recv from client");
      padexit(1);
    }
    if (count == 0)
    { stampf("spadd: client closed connection\r\n");
      padexit(1);
    }
    stampf("spadd: short recv A from client - wanted %d, got %d\r\n",
	   x25hdrsize, count);
  }

  if (x25obuf.x_version != X25IO_VER)
  {   resettty();
      stampf("spadd: client recv: Invalid version %d (%d)\r\n",
	       x25obuf.x_version, X25IO_VER);
      padexit(1);
  }

  count = (x25obuf.x_count_ms << 8) + x25obuf.x_count_ls +1 + TS29_BYTES;
  acount = recvfill(servertoclient, x25obuf.x_rawbuf, count, 0);
  if (count != acount)
  { if (count < 0)
    { stampf("");
      perror("spadd: recv from client");
      padexit(1);
    }
    if (count == 0)
    { stampf("spadd: client closed connection (B)\r\n");
      padexit(1);
    }
    stampf("spadd: short recv B from client - wanted %d, got %d\r\n",
	   count, acount);
  }

   if (debug & D_1_)
   { int i;
     fprintf(stderr, "Frm client: %d: %02x:",
		count, x25obuf.x_send_type);
     if (debug & D_2_) for(i=0; i<count;i++)
		fprintf(stderr, " %02x", x25obuf.x_buf[i] & 0xff);
     fprintf(stderr, "\r\n");
   }

  count -= 1+TS29_BYTES;
  x25log.pktsout++;
  x25log.bytesout += count;
  return count;
}

sendtox25socket(x25buf, count)
struct x25io *x25buf;
int count;
{
  int send_type = x25buf->x_send_type;
  char * buf = x25buf->x_buf;

  if (x25buf->x_flags & X25F_TSPAD)
  { count++;
    *--buf = x25buf->x_tspad;
  }

  if(debug & D_1_)
  {	int i;
	fprintf(stderr, "+D[t%x, f%x, %db:",
			send_type, x25buf->x_flags, count);
	if (debug & D_2_) for(i=0; i<count; i++)
		fprintf(stderr, " %02x", ((unsigned char *)buf)[i]);
	fprintf(stderr, "]\r\n");
  }

  /* RESET or normal data ? */
  if (count == 0 && x25buf->x_flags & X25F_MSG_OOB && send_type == VC_RESET)
	send_reset(s);
  else	send_data_2(s, x25buf, buf, count, send_type);

  x25log.pktsout++;
  x25log.bytesout += count;
}

/* LOGGING - for accounting purposes */


struct timeval timeval;
struct timezone tzs;
FILE *Accntf;

startlog()
{
  long fpos; int catch();
#ifdef	SECURITY
  if (dontlog)	return;
#endif	SECURITY

  bzero(&x25log, sizeof x25log);
  x25log.struct_len	= sizeof(x25log);
  x25log.struct_len2	= sizeof(x25log);
  x25log.version	= X25LOG_VER;
  x25log.version2	= X25LOG_VER;
  x25log.format		= '\n';
  (void) strncpy(x25log.username, x25sbuf.x_username,
		sizeof x25sbuf.x_username);
  x25sbuf.x_username[sizeof x25sbuf.x_username -1] = 0;
  if (role == DIRECT
#ifdef	TELNETD
	&& !telnetd
#endif	TELNETD
    )
    * ((int *) &x25log.userhost) = 0;
  else if ((*((int *)&from.sin_addr)) == 0) * ((int *) &x25log.userhost) = -1;
  else x25log.userhost = from.sin_addr;
  (void) strncpy(x25log.hostnum, (called_char_addr.dte) ? called_char_addr.dte : "(NSAP)", sizeof(x25log.hostnum));
  (void) strncpy((char *)x25log.hostcudf,
			(char *)x25sbuf.x_cudf,	sizeof(x25log.hostcudf));
  (void) strncpy(x25log.hostname,
			x25sbuf.x_destination,	sizeof(x25log.hostname));
  (void) gettimeofday(&timeval, &tzs);
  x25log.start		= timeval.tv_sec;
  x25log.pktsout	= 0;
  x25log.bytesout	= 0;
  x25log.pktsin		= 0;
  x25log.bytesin	= 0;
  x25log.finish		= 0;
  Accntf = fopen(accntfile, "a");
  if (Accntf != NULL)
  { fpos = ftell(Accntf);
    fwrite((char *) &x25log, sizeof(x25log), 1, Accntf);
    fflush(Accntf);
    fseek(Accntf, fpos, 0);
    (void) signal(SIGINT, catch);
    (void) signal(SIGHUP, catch);
  }
}

catch()
{
  stoplog();
  padexit(1);
}

stoplog()
{
  if (Accntf != NULL)
  { (void) gettimeofday(&timeval, &tzs);
    x25log.finish = timeval.tv_sec;
    fwrite((char *) &x25log, sizeof(x25log), 1, Accntf);
    fclose(Accntf);
  }
}

char *
janetaddr(s)
     char *s;
{
#ifdef NRSDBM
  static char addrbuf[19];
  struct host_entry *hp = (struct host_entry *) 0;	/* keep lint etc happy */
  char **xp;
  char *hnp;
  static char init = 0;
  if (!init)
  { if (nrs_init() < 0)
    { stampf("spadd: cannot initialise NRS dbm\r\n");
      init = -1;
    }
    else init = 1;
  }

  if (init == 1)
  { int net;
    /* Should have a "format" string in the NETWORKS structure */
    for (net = 0; NRSnetworks[net]; net++)
    { (void) sprintf(addrbuf, "%c.%s", *(NRSnetworks[net]), s);
      if (hp = dbase_get(addrbuf))	break;
    }
    if (hp == NULL)	return(addrbuf+2);
    hnp = strlen(hp->host_name) < strlen(hp->host_alias) ?
      hp->host_name : hp->host_alias;
    for (xp = NRSdomains; *xp; xp++)
      if (strncmp(*xp, hnp, strlen(*xp)) == 0)
	return(hnp + strlen(*xp));
    return hnp;
  }
  else
#endif	NRSDBM
  return s;
}

#ifndef	USERWIDTH
#define USERWIDTH 20
#endif
#ifndef	DESTWIDTH
#define DESTWIDTH 14
#endif
int	destwidth = DESTWIDTH;
int	userwidth = USERWIDTH;

printlog(argc, argv)
int argc;
char **argv;
{ char *getopt_format = "D:a:bd:nqru:";
  char *t;
  FILE *f;
  int	reverse=0;
  int	name=0;
  int	both=0;
  int	quick=0;
  int	max_duff=10;
  int c; char usformat[30];

  while ((c = getopt(argc, argv, getopt_format)) != EOF)
    switch(c) {
    case 'D':	max_duff= atoi(optarg);			break;
    case 'a':	accntfile = optarg;			break;
    case 'b':	both++;					break;
    case 'd':   destwidth=atoi(optarg);			break;
    case 'n':	name++;					break;
    case 'q':	quick++;				break;
    case 'r':	reverse++;				break;
    case 'u':   userwidth=atoi(optarg);			break;
    case '?':
      fprintf(stderr, "Usage: %s [%s]\r\n", argv[0], getopt_format);
      exit(1);
    }
  if (optind != argc) {
    fprintf(stderr, "Usage: %s [%s]\r\n", argv[0], getopt_format);
    exit(1);
  }
  f = fopen(accntfile, "r");
  if (f == NULL) {
    perror(accntfile);
    exit(1);
  }

  if (both) 
  	(void) sprintf(usformat, "%%-%d.%ds %%-%d.%ds %%-%d.%ds ",
 	 userwidth, userwidth, destwidth, destwidth, destwidth, destwidth);
  else if (name)
  	(void) sprintf(usformat, "%%-%d.%ds %%-%d.%ds%%0.0s ",
 	 userwidth, userwidth, destwidth, destwidth);
  else	(void) sprintf(usformat, "%%-%d.%ds %%0.0s%%-%d.%ds ",
 	 userwidth, userwidth, destwidth, destwidth);

  if (reverse) fseek(f, -sizeof(x25log), 2);

  while (fread((char *)&x25log, sizeof(x25log), 1, f) == 1)
  if (	x25log.version == X25LOG_VER &&
	x25log.version2 == X25LOG_VER &&
	x25log.struct_len == sizeof(x25log) &&
	x25log.struct_len2 == sizeof(x25log))
  {
    printf(usformat, getsender(x25log.username, (quick < 2) ? &(x25log.userhost) : (struct in_addr *) 0),
	x25log.hostname,
	(quick | name | both) ? x25log.hostnum : janetaddr(x25log.hostnum));

    if (quick < 2) {
    t = ctime(&x25log.start);
    t[16] = 0;			/* Chop TZ and year ... */
    strncpy(t+1, t+22, 2);	/* year */
    strncpy(t+8, t+8, 2);	/* day of month */
    if (t[8] == ' ') t[8] = '0';
    t[3] = t[7] = '-';
    printf("%s", t+1);
    if (x25log.finish)
    { t = ctime(&x25log.finish);
      t[16] = 0;
      t += 11;
    }
    else t = "Now";
    }
    else {
	t="";
	printf("%*.*s", 16,16, "");
    }
    printf("-%-5s%5d/%-5di %5d/%-5do\n", t,
	   x25log.pktsin, x25log.bytesin, x25log.pktsout, x25log.bytesout);
    if (reverse) fseek(f, -2*sizeof(x25log), 1);
  }
  else
  {	int len = (reverse) ? x25log.struct_len2 : x25log.struct_len;
	int ver = (reverse) ? x25log.version2 : x25log.version;
	static int duff=0;

	fprintf(stderr, "[ Duff entry -- version %d of %d bytes ]\r\n",
		ver, len);
	if (len < 4 || len > 2*sizeof(x25log) || ver < 1 || ver > 127)
	{ fprintf(stderr, "Corrupt log file\r\n");
	  if (duff >= max_duff) break;
	  duff += 10;
	}
	else {
	if (++duff >= max_duff)
	{ fprintf(stderr, "Too many duff entries (use -D20 for more)\r\n");
	  break;
	}
	fseek(f, len - sizeof(x25log), 1);
	}
  }
  exit(0);
}

char *
getsender(user, addr)
     char *user;
     struct in_addr *addr;
{ struct hostent *hostent, *gethostbyaddr();
  char *host, *inet_ntoa();
  if (addr && (*((int *) addr)))
  { char *colon = index(user, ':');
    hostent = gethostbyaddr((char *)addr, sizeof (struct in_addr), AF_INET);
    host = (hostent) ? hostent->h_name : inet_ntoa(*addr);
    if (colon)	(void) sprintf(sender, "%*.*s@%s%s",
			colon-user, colon-user, user, host, colon);
    else	(void) sprintf(sender, "%s@%s", user, host);
  }
  else sprintf(sender, "%s", user);
  return sender;
}

/* Print the application relay string nicely, please
 * Each line seems to be prefixed by "AR "
 */

printapprelay()
{
  char *p, *q;
  p = app_relay;
  while (*p)
  { q = index(p, '\n');
    if (q == NULL)
      q = p + strlen(p) - 1;
    else
      *q = 0;
    clientmes1(0, "Application Relay: %s",
	    (strncmp(p, "AR ", 3) == 0)? p+3 : p);
    p = q + 1;
  }
}

/* -------------------------------------------------------------------------
 * This is the interface to the X.25 world.
 * 
 * The interfaces are:
 * 
 * serverloop()
 * 	wait for client or socket data and process it.
 * 
 * print_<type>params(facil, file)
 * FACILITY_DB *facil;
 * FILE *file;
 * 	print facility info to file.
 * 
 * set_xparams(std_facil, local_facil)
 * struct facilities *std_facil;
 * struct <xx> *local_facil;
 *      convert local x25 facilities info to standard format
 *
 * read_into_ibuf(s, offset)
 *      read data into x25ibuf, offset (for TS29) by 0 or 1.
 *
 * char *sprintf_diag(buff, diag)
 * char *buff;
 * X25_CAUSE_DIAG *diag;
 *
 * openx25()
 *      open a call to dest
 *
 * send_reset(s)
 *      send a reset
 *
 * send_data(s, x25buf, buf, count)
 * struct x25io *x25buf;
 *      send data to remote host
 * -------------------------------------------------------------------------*/
#endif	SERVERCODE
