#ifndef	lint
static char RCSid[]="$Header: /Nfs/blyth/glob/src/usr.bin/spad/src/RCS/spadparam.c,v 1.27 1993/11/13 20:29:05 pb Exp $";
#endif	lint
/* spad:-  multiple client/single server x.29 service.
	   needs Sunlink X.25 software running in (at least) one node
 */

/* Copyright (c) A Rawsthorne 1986, 1987 & P Brooks 1987 - 1993
 * not for commercial use
 * this version not to be redistributed except by agreement.
 */

#include "spad.h"

void initparams();
void setparams();
void setparameter();
void getparams();
void getallparams();
void showparam();
void printcntrlchar();
void setecho();
void setmessage();
void setforward();

/* X.29 PARAMETERS */

char *pad_speeds[] = {
 "110",	"134.5", "300",	"1200",	"600",	"75",	"150",	"1800",	"200",
 "100",	"50",	"75/1200",	"2400",	"4800",	"9600",	"19200","48000",
 "56000",	"64000",	"0"
};

int ux_speeds[] = {0, 50, 75, 110, 134, 150, 200, 300, 600,
		   1200, 1800, 2400, 4800, 9600, 19200, 38400, 0};

void initparams()
{
  int i, su = -1, sx;
#ifdef	SGTTYB
  struct sgttyb sgttyb;
#endif	SGTTYB
#ifdef	TERMIO
  struct termio termio;
#endif	TERMIO
#ifdef	TIOCGLTC
  struct ltchars ltchars;
  ioctl(2, TIOCGLTC, &ltchars);
#endif	TIOCGLTC
#ifdef	SGTTYB
  ioctl(2, TIOCGETP, &sgttyb);
#endif	SGTTYB
#ifdef	TERMIO
  ioctl(2, TCGETA, &termio);
#endif	TERMIO
  params[P_1] = 1;		/* escape enabled */
  params[P_2] = 1;		/* echo on */
  params[P_3] = 48;		/* forward  */
  params[P_4] = 0;		/* timeout = 0 */
  params[P_5] = 0;		/* pad won't flow-control terminal (?) */
  params[P_6] = 1;		/* print PAD messages */
  params[P_7] = 21;		/* break command */
  params[P_8] = 0;		/* don't discard o/p */
  params[P_9] = 0;		/* no crfill */
  params[P_10] = 0;		/* no line wrap */
#ifdef	TELNETD
  if (telnetd != 0)
#endif	TELNETD
#ifdef	SGTTYB
  su = ux_speeds[(int) sgttyb.sg_ispeed];
#endif	SGTTYB
#ifdef	TERMIO
  su = ux_speeds[termio.c_cflag & CBAUD];
#endif	TERMIO
  for (i = 0; (sx = atoi(pad_speeds[i])); i++) if (su == sx) break;
  params[P_11] = (su==sx) ? i : 14;		/* 9600 */
  params[P_12] = 0;		/* user can flow-control pad */
  params[P_13] = 6;		/* CRMOD */
  params[P_14] = 0;		/* no lffill */
  params[P_15] = 1;		/* editing on */
#ifdef	TELNETD
  if (telnetd != 0)
  { params[P_16] = (DEL & eightbitinput);	/* char delete */
    params[P_17] = 0x18;	/* line delete */
    params[P_18] = 0x12;	/* redisplay line */
  }
  else
#endif	TELNETD
  {
#ifdef	SGTTYB
    params[P_16] = sgttyb.sg_erase;	/* char delete */
    params[P_17] = sgttyb.sg_kill;	/* line delete */
#endif	SGTTYB
#ifdef	TERMIO
    params[P_16] = termio.c_cc[VERASE];	/* char delete */
    params[P_17] = termio.c_cc[VKILL];	/* line delete */
#endif	TERMIO
#ifdef	TIOCGLTC
    params[P_18] = ltchars.t_rprntc;/* redisplay line */
#endif	TIOCGLTC
  }
  breakinch = BREAKINCHAR;
#ifdef	INTR2BREAK
    params[P_INTR] = -1;
#endif	INTR2BREAK
  for (i=0; i<P_MAX;i++) if (preset_b[i])
  {	if (verbose & V_2_) fprintf(stderr, "Preset %2d to %3d\r\n", i, preset_p[i]);
	params[i] = preset_p[i];
  }
  setecho();
  setmessage();			/* mostly for telnetd */
  setforward();			/* set up forwarding vector */
  if (!(verbose & V_4_)) return;

  fprintf(stderr, " ++ Initial parameters:\r\n");
  for (i = 1; i <= P_MAX; i++) showparam(i);
  fprintf(stderr, " ++\r\n");
}

void setparams(count)		/* message is a list of (num,val) pairs */
int count;
{
  int i;
  if (verbose & V_4_) fprintf(stderr, " ++ set %d parameters\r\n", (count-1)/2);
  for (i = 1; i < count; i+= 2)
    setparameter((int)x25ibuf.x_buf[i], (int)x25ibuf.x_buf[i+1]);
  if (verbose & V_4_) fprintf(stderr, " ++\r\n");
}

void setparameter(i, v)
int i, v;
{
  if (ignore_p[i])
  { if (verbose & V_4_) { fprintf(stderr, " -- Ignore: "); showparam(i); }
    return;
  }
  params[i] = v;
  if (verbose & V_4_)	showparam(i);
  if (i == P_4)	setmessage();
  if (i == P_3)	setforward();
  if (i == P_2)	setecho();
}

void getparams(count)
int count;
{
  int i;
  struct x25io paramb;
  init_x25io(&paramb);

  if (count == 1) getallparams();
  else
  { paramb.x_buf[0] = 0;
    for (i = 1; i < count; i+=2)
    { int p;
      p = x25ibuf.x_buf[i];
      paramb.x_buf[i] = p;
      paramb.x_buf[i+1] = params[p];
    }
    sendtox25(&paramb, i, 0 /*flags*/, (1 << Q_BIT));
  }
}

void getallparams()
{
  int i;
  struct x25io paramb;
  init_x25io(&paramb);

  paramb.x_buf[0] = 0;
  for (i = 1; i < P_LOCAL; i++)
  { paramb.x_buf[i*2 -1] = i;
    paramb.x_buf[i*2   ] = params[i];
  }
  sendtox25(&paramb, 1 + (P_LOCAL-1)*2, 0 /*flags*/, (1 << Q_BIT));
}

void showparam(i)
int i;
{ fprintf(stderr, (ignore_p[i]) ? " ==%2d:%3d " : " --%2d:%3d ", i,params[i]);
  switch(i) {
  case P_1:  fprintf(stderr, "Local escape %sabled\r\n",
		param1 ? "en" : "(meant to be) dis");			break;
  case P_2: fprintf(stderr, "Echo %s\r\n", param2? "on": "off");	break;
  case P_3: if (param3)
    { char p3buf[CMND_LINE_LEN];
      (void) strcpy(p3buf, "Forwarding on:-");
      if (param3 & 1)	(void) strcat(p3buf, " alphanum,");
      if (param3 & 2)	(void) strcat(p3buf, " RET,");
      if (param3 & 4)	(void) strcat(p3buf, " ESC, BEL, ENQ, ACK,");
      if (param3 & 8)	(void) strcat(p3buf, " DEL, CAN, DC2,");
      if (param3 & 16)	(void) strcat(p3buf, " ETX, EOT,");
      if (param3 & 32)	(void) strcat(p3buf, " HT, LF, VT, FF,");
      if (param3 & 64)	(void) strcat(p3buf, " other ccs,");
      if (param3 & 128)	(void) strcat(p3buf, " other chars,");
      p3buf[strlen(p3buf)-1] = '.'; /* overwrite last comma */
      fprintf(stderr, "%s\r\n", p3buf);
    } else fprintf(stderr, "Forwarding when buffer is full\r\n");	break;
  case P_4: if(param4)
      fprintf(stderr, "Timeout = %5.2f secs\r\n", (float) param4 / 20.0);
    else
      fprintf(stderr, "No forwarding on timeout\r\n");		break;
  case P_5: fprintf(stderr, "Pad will %sflow control terminal\r\n",
			param5?"":"not ");				break;
  case P_6: fprintf(stderr, "PAD");
    if (param6)
    { if (param6&1)	fprintf(stderr, " messages transmitted\r\n");
      if (param6&4)	fprintf(stderr, " prompts in command mode\r\n");
    } else		fprintf(stderr, " messages suppressed\r\n");	break;
  case P_7:	fprintf(stderr, "Break");
    if (param7)
    { if (param7&1)	fprintf(stderr, " sends interrupt,");
      if (param7&2)	fprintf(stderr, " sends reset,");
      if (param7&4)	fprintf(stderr, " sends Indication of Break,");
      if (param7&8)	fprintf(stderr, " (should escape to PAD mode),");
      if (param7&16)	fprintf(stderr, " discards output to terminal");
			fprintf(stderr, "\r\n");
    } else		fprintf(stderr, " ignored\r\n");		break;
  case P_8: fprintf(stderr, "Output is %sdiscarded\r\n", param8?"":"not ");
    break;
  case P_9: fprintf(stderr,(param9)?
	"Crfill = %d\r\n" : "Noccrfill\r\n", param9);		break;
  case P_10: if (param10) fprintf(stderr, "Wrap at column %d\r\n", param10);
    else		fprintf(stderr, "No line wrapping\r\n");	break;
  case P_11: if ((0 <= param11) && (param11 <= 18))
		fprintf(stderr, "Speed %s baud\r\n", pad_speeds[param11]);
    else	fprintf(stderr, "Speed ? ?(%d)\r\n", param11);	break;
  case P_12: fprintf(stderr, "User can%s flow-control (Cntrl/S, Cntrl/Q) PAD\r\n",
	   param12?"":"'t");						break;
  case P_13: if (param13)
    { fprintf(stderr, "<LF> inserted after");
      if (param13&1)	fprintf(stderr, " <CR> to terminal");
      if (param13&2)	fprintf(stderr, " <CR> from terminal");
      if (param13&4)	fprintf(stderr, " <CR> echoed to terminal");
			fprintf(stderr, "\r\n");
      } else		fprintf(stderr, "No <LF> insertion\r\n");	break;
  case P_14: if (param14)	fprintf(stderr, "Lffill = %d\r\n", param14);
    else		fprintf(stderr, "Nolffill\r\n");		break;
  case P_15: fprintf(stderr, "Local Editing %sabled\r\n",
			(param15) ? "en":"dis");			break;
  case P_16: fprintf(stderr, "Local delete char = ");
    printcntrlchar(param16, 1);						break;
  case P_17: fprintf(stderr, "Local line delete char = ");
    printcntrlchar(param17, 1);						break;
  case P_18: fprintf(stderr, "Local redisplay line char = ");
    printcntrlchar(param18, 1);						break;
  case P_BRKIN:	fprintf(stderr, "Break in character = ");
    printcntrlchar(breakinch, 1);					break;
  case P_DEBUG:	fprintf(stderr, "Debug %d\r\n", debug);	break;
  case P_VERB:	fprintf(stderr, "verbose %d\r\n", verbose);	break;
  case P_UESC:	if (unixesc == NOT_CHAR)
		  fprintf(stderr, "Unix escape disabled\r\n");
		else
		{ fprintf(stderr, "Unix escape char = ");
		  printcntrlchar(unixesc, 1);
		}							break;
  case P_8BIT:	fprintf(stderr, "Eightbitoutput o%s\r\n",
				(eightbitoutput & 0x80) ? "n" : "ff");	break;
  case P_IDLE:	fprintf(stderr, "Idletimeout %d\r\n", idle_timeout);	break;
  case P_INTR:	if (intr < 0)
		  fprintf(stderr, "Unix intr disabled\r\n");
		else
		{ fprintf(stderr, "Unix intr char = ");
		  printcntrlchar(intr, 1);
		}							break;
  default:	fprintf(stderr, "funny parameter %d?\r\n", i);
  }
}

void printcntrlchar(c, crlf)
int c, crlf;
{
  if (c == 0)
    fprintf(stderr, "<NONE>");
  else if (c == 0177)
    fprintf(stderr, "<DEL>");
  else if (c > 0 && c < 040)
    fprintf(stderr, "Cntrl/%c", c + 'A' - 1);
  else if (c > 0 && c < 0177)
    fprintf(stderr, "%c", c);
  else if (c == NOT_CHAR)
    fprintf(stderr, "<UNSET>");
  else
    fprintf(stderr, "<%02x>", c & 0xff);

  if (crlf) fprintf(stderr, "\r\n");
}

void setecho()
{
#ifdef	TELNETD
    if (telnetd > 0)
    {	int val;
	switch (x_mode)
	{
		case 0:	val = (param2) ? WONT : WILL;	break;
		case 1:	val = (param2) ? WILL : WONT;	break;
		case 2:	val = (param2) ? DO : DONT;	break;
		default:val = (param2) ? DONT : DO;	break;
	}
	if (native_telnet) val = WILL;
	fprintf(stderr, "%c%c%c", IAC, val, TELOPT_ECHO);
	if (verbose & V_10_) fprintf(stderr, "[%02xE]", val);
	fflush(stderr);
    }
#endif	TELNETD
    echoing = do_echo(param2);
}

void setmessage()			/* P_4 has changed -- use CBREAK or RAW ? */
{
#ifdef	TELNETD
  if (telnetd > 0)
  {	int val;
	switch (y_mode)
	{
		case 0:	val = (param4) ? WONT : WILL;	break;
		case 1:	val = (param4) ? WILL : WONT;	break;
		case 2:	val = (param4) ? DO : DONT;	break;
		default:val = (param4) ? DONT : DO;	break;
	}
	if (native_telnet) val = WILL;
	fprintf(stderr, "%c%c%c", IAC, val, TELOPT_SGA);
	if (verbose & V_10_) fprintf(stderr, "[%02xM]", val);
	fflush(stderr);
  }
  else if (telnetd == 0)
#endif	TELNETD
#ifdef	TERMIO
    { int iflag = termioa.c_iflag;
      int lflag = termioa.c_lflag;

      termioa.c_iflag &= ~( TERM_I_MASK );
      termioa.c_lflag &= ~( TERM_L_MASK );
      if (param4)
      {
        termioa.c_iflag &= ~( TERM_I_MASK_RAW );
        termioa.c_lflag &= ~( TERM_L_MASK_RAW );
	termioa.c_cc[VMIN]  = 1;
	termioa.c_cc[VTIME] = 0;
      }
      else
      {
        termioa.c_iflag &= ~( TERM_I_MASK_COOKED );
        termioa.c_lflag &= ~( TERM_L_MASK_COOKED );
      }
      if (rawtty && (iflag != termioa.c_iflag || lflag != termioa.c_lflag))
		ioctl(2, TCSETA, &termioa);
    }
#endif	TERMIO
#ifdef	SGTTYB
  { int flag = sgttyba.sg_flags;

    sgttyba.sg_flags &= ~(RAW
#ifdef	CBREAK
		| CBREAK
#endif	CBREAK
		);

    if (param4)	  sgttyba.sg_flags |= RAW;
    else	  sgttyba.sg_flags |= 0
#ifdef	CBREAK
		| CBREAK
#else	CBREAK
		| RAW
#endif	CBREAK
		  ;
    if (rawtty && flag != sgttyba.sg_flags) ioctl(2, TIOCSETP, &sgttyba);
  }
#endif	SGTTYB
}

void setforward()			/* initialise forwardvec[] */
{
  int i;
  for (i = 0; i < 128; i++)
    forwardvec[i] = 0;
  if (param3&1)
  { for (i = 'A'; i != 'Z'; i++)
      forwardvec[i] = 1;
    for (i = 'a'; i != 'z'; i++)
      forwardvec[i] = 1;
    for (i = '0'; i != '9'; i++)
      forwardvec[i] = 1;
  }
  if (param3&2)
    forwardvec[0x0d] = 1;		/* CR */
  if (param3&4)
  { forwardvec[0x1b] = 1;		/* ESC */
    forwardvec[0x07] = 1;		/* BEL */
    forwardvec[0x05] = 1;		/* ENQ */
    forwardvec[0x06] = 1;		/* ACK */
  }
  if (param3&8)
  { forwardvec[0x7f] = 1;		/* DEL */
    forwardvec[0x18] = 1;		/* CAN */
    forwardvec[0x12] = 1;		/* DC2 */
  }
  if (param3&16)
  { forwardvec[0x03] = 1;		/* ETX */
    forwardvec[0x04] = 1;		/* EOT */
  }
  if (param3&32)
  { forwardvec[0x09] = 1;		/* HT */
    forwardvec[0x0a] = 1;		/* LF */
    forwardvec[0x0b] = 1;		/* VT */
    forwardvec[0x0c] = 1;		/* FF */
  }
  if (param3&64)
  { forwardvec[0x00] = 1;		/* NUL */
    forwardvec[0x01] = 1;		/* SOH */
    forwardvec[0x02] = 1;		/* STX */
    forwardvec[0x08] = 1;		/* BS */
    forwardvec[0x0e] = 1;		/* SO */
    forwardvec[0x0F] = 1;		/* SI */
    forwardvec[0x10] = 1;		/* DLE */
    forwardvec[0x11] = 1;		/* DC1 */
    forwardvec[0x13] = 1;		/* DC3 */
    forwardvec[0x14] = 1;		/* DC4 */
    forwardvec[0x15] = 1;		/* NAK */
    forwardvec[0x16] = 1;		/* SYN */
    forwardvec[0x17] = 1;		/* ETB */
    forwardvec[0x19] = 1;		/* EM */
    forwardvec[0x1A] = 1;		/* SUB */
    forwardvec[0x1C] = 1;		/* FS */
    forwardvec[0x1D] = 1;		/* GS */
    forwardvec[0x1E] = 1;		/* RS */
    forwardvec[0x1F] = 1;		/* US */
  }
  if (param3&128)
  { for (i = ' '; i != '/'; i++)
      forwardvec[i] = 1;
    for (i = ':'; i != '?'; i++)
      forwardvec[i] = 1;
    for (i = '['; i != '_'; i++)
      forwardvec[i] = 1;
    for (i = '{'; i != '~'; i++)
      forwardvec[i] = 1;
  }
}
