#ifndef	lint
static char RCSid[]="$Header: /Nfs/blyth/glob/src/usr.bin/spad/src/RCS/spadmain.c,v 1.27 1993/11/13 20:29:04 pb Exp $";
#endif	lint
/* spad:-  multiple client/single server x.29 service.
	   needs Sunlink X.25 software running in (at least) one node
 */

/* Copyright (c) A Rawsthorne 1986, 1987 & P Brooks 1987 - 1993
 * not for commercial use
 * this version not to be redistributed except by agreement.
 */

#define USE_CUDF        /* Want to include CUDF data */
#include "spad.h"
#define	EXTERN_SET
#include "spad.h"
#undef	EXTERN_SET

/* MAIN program - parse parameters, decide role, DOIT! */

int pbgateway = 0;

typedef enum {
AP_NAME,
AP_MAC,
AP_CDNSAP,
AP_CGNSAP,
AP_CUDF,
AP_YBTS,
AP_DTE,
AP_NULL
} AP_TYPE;

struct add_parts {
	char	*name;
	AP_TYPE	val;
} addr_parts[] = {
	"NAME", 	AP_NAME,
	"M", 		AP_MAC,
	"MAC", 		AP_MAC,
	"N", 		AP_CDNSAP,
	"NSAP",		AP_CDNSAP,
	"CD_N",		AP_CDNSAP,
	"CD_NSAP",	AP_CDNSAP,
	"CALLED_NSAP",	AP_CDNSAP,
	"CG_N",		AP_CGNSAP,
	"CG_NSAP",	AP_CGNSAP,
	"CALLING_NSAP",	AP_CGNSAP,
	"CUDF",		AP_CUDF,
	"D",		AP_CUDF,
	"YBTS",		AP_YBTS,
	"DTE",		AP_DTE,
	"X121",		AP_DTE,
	"X.121",	AP_DTE,
	"121",		AP_DTE,
	(char *) 0,	AP_NULL
};

AP_TYPE find_val(string, len, structp)
char *string;
int len;
struct add_parts *structp;
{
	for(; structp->name; structp++)
		if (!strncmp(string, structp->name, len) &&
		    strlen(structp->name) == len) return structp->val;
	return AP_NULL;
}

/* Parse <mac addr>.<LSEL>.<NSAP>.<DTE>:<cudf> */
/* Actually "=" ( <key> "=" <value> "=" ) *    */
struct char_full_addr *
decode_app(string, structp, buffp)
char *string;
struct char_full_addr *structp;
char *buffp;
{
	if (!buffp)
	{	buffp = malloc(strlen(string)+1);
		if (!buffp)	return (struct char_full_addr *) 0;
		strcpy(buffp, string);
	}
	if (!structp)
	{	structp = (struct char_full_addr *) malloc(
				sizeof(struct char_full_addr));
		if (!structp)	return (struct char_full_addr *) 0;
		bzero(structp, sizeof(struct char_full_addr));
	}

	while (buffp && *buffp && *buffp == '=')
	{	char *sep = index(buffp+1, '=');
		char *term= (sep) ? index(sep+1, '=') : sep;
		AP_TYPE val;
		if (!sep)	return 0;

		*buffp++ = '\0';
		val = find_val(buffp, sep - buffp, addr_parts);
		switch (val)
		{
		case AP_NAME:	structp->name	= sep+1;	break;
		case AP_MAC:	structp->mac_addr = sep+1;	break;
		case AP_CDNSAP:	structp->cd_nsap= sep+1;	break;
		case AP_CGNSAP:	structp->cg_nsap= sep+1;	break;
		case AP_CUDF:	structp->cudf	= sep+1;	break;
		case AP_YBTS:	structp->ybts	= sep+1;	break;
		case AP_DTE:	structp->dte	= sep+1;	break;
		default:	return 0;
		}
		buffp = term;
	}
	return (!buffp || !*buffp) ? structp : 0;
}

struct char_full_addr *
parse_addr(addr, structp, buffp)
char *addr;
struct char_full_addr *structp;
char *buffp;
{	int i;
	int len;
	char *next;

	if (!buffp)	buffp = malloc(strlen(addr)+1);
	if (!buffp)	return (struct char_full_addr *) 0;
	if (!structp)	structp = (struct char_full_addr *) malloc(sizeof(struct char_full_addr));
	if (!structp)	return (struct char_full_addr *) 0;
	bzero(structp, sizeof(struct char_full_addr));
	strcpy(buffp, addr);

	if (*buffp == '=')	return decode_app(addr, structp, buffp);
	for (i=2; i< (3*(6-1)); i += 3) if (buffp[i] != '-') return (struct char_full_addr *) 0;
	structp->mac_addr = buffp; buffp += 6 * 3; buffp[-1] = '\0';
	
	next = index(buffp, '.');
	if (next != buffp && next != buffp+2) return (struct char_full_addr *) 0;
	structp->lsel = buffp; *next++ = '\0'; buffp = next;

	next = index(buffp, '.');
	len = (next) ? next - buffp : strlen(buffp);
	if (len > 40) return (struct char_full_addr *) 0;
	structp->cd_nsap = buffp; if (next) *next++ = '\0'; buffp = next;
	if (!next) return structp;

	next = index(buffp, ':');
	len = (next) ? next - buffp : strlen(buffp);
	if (len > 15) structp->cd_nsap =  buffp;
	else structp->dte = buffp;
	if (next) *next++ = '\0'; buffp = next;
	if (!next) return structp;

	structp->cudf = buffp;

	return structp;
}

print_addr(structp, file)
struct char_full_addr * structp;
FILE *file;
{
	fprintf(file, "Full address is");
	if (structp->mac_addr)	fprintf(file," mac=`%s'",   structp->mac_addr);
	if (structp->lsel)	fprintf(file," lsel=`%s'",	structp->lsel);
	if (structp->cd_nsap)	fprintf(file," cd_nsap=`%s'", structp->cd_nsap);
	if (structp->cg_nsap)	fprintf(file," cg_nsap=`%s'", structp->cg_nsap);
	if (structp->dte)	fprintf(file," dte=`%s'",	structp->dte);
	if (structp->cudf)	fprintf(file," cudf=`%s'",	structp->cudf);
	if (structp->ybts) fprintf(file, " ybts=`%s'", structp->ybts);
	fprintf(file, "\n");
}

#ifdef	SIGFPE
void pipe_sig(x, y)
int x, y;
{
	printf("sig_pipe(%x, %x) called\n", x, y);
	signal(SIGFPE, SIGARG2 pipe_sig);
}
#endif	SIGFPE

char spad_opts[] = "ABC:DE:GH:I:L:N:P:Q:RS:T:U:W:Ya:b:c:d:e:f:g:hi:l:np:rs:t:v:x:y:z";
char _versions[] = "$Revision: 1.27 $";
char _dates[]	 = "$Date: 1993/11/13 20:29:04 $";

/* NB: We may be setuid when we start !!!!!
 * Wait until the X25 connection is open, THEN setuid(getuid())
 * THEN we can open files, etc.
 */
main(argc, argv)
     int argc;
     char ** argv;
{
  int c;
  char *versions;
  char *dates;
  int breakch = 0;
  char *termlog = (char *) 0;
  int logtype = 0;	/* Keep lint etc happy */
  char *cmd_name = rindex(argv[0], '/');
  char extra[4];
  char *dest;
  if (cmd_name) cmd_name++;
  else cmd_name = argv[0];
  service = def_service;
#ifdef	SERVICEFORM
  service_form = SERVICEFORM;
#endif	SERVICEFORM
  role = DEF_ROLE;
  termlogf = (FILE *) 0;
  extra[0] = '\0';

  if (versions = index(_versions, ' '))
  { char *end = index(++versions, ' ');
    if (end) *end = '\0';
  } else versions=_versions;
  if (dates = index(_dates, ' '))
  { char *end = index(++dates, ' ');
    if (end) *end = '\0';
  } else dates=_dates;

  prof_file = getenv("SPADTABLE");
  if (!(sysprof_file = getenv("SPADSYSTABLE"))) sysprof_file = PROF_FILE;
  if (!(accntfile    = getenv("SPADLOGFILE") )) accntfile    = ACCNTFILE;
#ifdef	LOCALHOST
  strcpy(localhost, LOCALHOST);
#endif
  if (dest = getenv("SPADHOSTNAME")) strcpy(localhost, dest);

  init_x25io(&x25ibuf);
  init_x25io(&x25obuf);
  init_x25io(&x25io_tty);
  init_x25sbuf(&x25sbuf);
  bzero(&called_char_addr, sizeof called_char_addr);
#ifdef	SERVERCODE
  if (nameis(cmd_name, "in.spadd"))	doserver(0, argv);
  if (nameis(cmd_name, "spadd"))	doserver(argc, argv);
  if (nameis(cmd_name, "sunpadd"))	doserver(argc, argv); /* old name */
  if (nameis(cmd_name, "x25log"))	printlog(argc, argv);
#endif	SERVERCODE
#ifdef	TELNETD
  if (nameis(cmd_name, "in.tpadd"))	set_telnetd();
  if (nameis(cmd_name, "in.telnetd"))	set_telnetd();
#endif	TELNETD

  debug=0;
  verbose |= initial_verbose;
  unixesc = NOT_CHAR;	/* cannot be typed */
  idle_timeout	= IDLE_TIMEOUT;
  eightbitoutput = 0x7f;
  system_rc = 0;
#ifdef	SIGFPE
  signal(SIGFPE, SIGARG2 pipe_sig);
#endif	SIGFPE
#ifdef	SIGCONT
  signal(SIGCONT, SIGARG2 resume);
#endif	SIGCONT
  { char *timeout = getenv("SPADSESSIDLETIME");
    if (timeout && *timeout && *timeout != ':') idle_timeout = atoi(timeout);
    if (timeout && (timeout = index(timeout, ':')) && atoi(timeout+1))
		idle_grace = atoi(timeout+1);
  }
#ifdef	SERVERCODE
  {	char *networks = getenv("NETWORKS");
	if (networks)
	{	
		mark_addr_space();
	}
  }
#endif	SERVERCODE
  set_cudf(x25sbuf.x_cudf, &x25sbuf.x_cudflen,
			PRE_CUDF, PRE_CUDFLEN, (unsigned char *)0, 0, 0);
  while ((c = getopt(argc, argv, spad_opts)) != EOF)
    switch(c) {
    case 'A':	forbid_some_pad_cmds = (forbid_some_pad_cmds) ? -1 : 1;
								break;
    case 'a':	accntfile = optarg;				break;
    case 'B':	print_banner = 0;				break;
    case 'b':	breakch = atoi(optarg);				break;
    case 'c':	x25sbuf.x_cug_index = atobcd(optarg);
		x25sbuf.x_fflags |= FACIL_F_CUG_INDEX;		break;
    case 'C':	x25_link = optarg;				break;
/*    case 'C':	role=CLIENT;					break; */
#ifdef	SERVERCODE
    case 'D':	role=DIRECT;					break;
#else	SERVERCODE
    case 'D':	fprintf(stderr, " +++- Direct mode not available\r\n");	break;
#endif	SERVERCODE
    case 'd':	set_cudf(x25sbuf.x_cudf, &x25sbuf.x_cudflen, PRE_CUDF,
		PRE_CUDFLEN, (unsigned char *)optarg, canonical(optarg, 0),0);
					/* interpret escape sequences */
		x25sbuf.x_context = XCONTEXT;			break;
    case 'E':	exp_text=optarg;				break;
    case 'f':	x25sbuf.x_fast_select	= atoi(optarg);
		x25sbuf.x_fflags |= FACIL_F_FAST_SELECT;	break;
    case 'G':	pbgateway++;					break;
    case 'g':	debug = atoi(optarg);
		service = SERVICEG;	/* select alternate service name */
#ifdef	SERVICEFORM
#ifdef	SERVICEGFORM
		service_form = SERVICEGFORM;
#endif	SERVICEGFORM
#endif	SERVICEFORM
		fprintf(stderr, " ++   debug=%d\r\n", debug); break;
    case 'h':
    fprintf(stderr, "The valid flags for %s are:\r\n", argv[0]);
    fprintf(stderr, "  -A disables certain actions after (breakin)-a\r\n");
    fprintf(stderr, "  -a set account file\r\n");
    fprintf(stderr, "  -B removes the login banner\r\n");
    fprintf(stderr, "  -b sets the breakin character\r\n");
/*    fprintf(stderr, "  -C sets the session to be in client mode\r\n"); */
    fprintf(stderr, "  -C selects the X.25 channel to use (if applicable)\r\n");
    fprintf(stderr, "  -c sets the closed user group\r\n");
#ifdef	SERVERCODE
    fprintf(stderr, "  -D tries to set the session to be in direct mode\r\n");
#endif	SERVERCODE
    fprintf(stderr, "  -d sets the called user data field\r\n");
    fprintf(stderr, "  -E sets the explanation text (YBTS ONLY)\r\n");
    fprintf(stderr, "  -e sets the error log file (server only)\r\n");
    fprintf(stderr, "  -f 0=no fast select, 2=fast select\r\n");
    fprintf(stderr, "  -G convert name to PinkBook NSAP\r\n");
    fprintf(stderr, "  -g permits debugging in server and client processes\r\n");
    fprintf(stderr, "  -H set localhost\n");
    fprintf(stderr, "  -h gives this help info\r\n");
#ifdef	POLL_INTERVAL
    fprintf(stderr, "  -I sets the poll interval\r\n");
#endif	POLL_INTERVAL
    fprintf(stderr, "  -i supply initial commands\r\n");
    fprintf(stderr, "  -l log output to file (- is stdout) (-L appends)\r\n");
#ifdef	TELNETD
    fprintf(stderr, "  -n use native telnet mode\r\n");
#endif	TELNETD
#ifdef	SERVERCODE
    fprintf(stderr, "  -N add this network (addr space) to list to try\r\n");
#endif	SERVERCODE
    fprintf(stderr, "  -P <n>[:=][<m>] preset parameter n to m\r\n");
    fprintf(stderr, "  -p allows the server port number to be specified\r\n");
    fprintf(stderr, "  -Q sets the quality of service (YBTS ONLY)\r\n");
    fprintf(stderr, "  -r revesre charge the call\r\n");
    fprintf(stderr, "  -R use system (rather than $HOME) rc files\r\n");
    fprintf(stderr, "  -s allows a script file to interact automatically\r\n");
    fprintf(stderr, "  -S sets the session idle timeout\r\n");
    fprintf(stderr, "  -t supply a file containing a table of addresses\r\n");
    fprintf(stderr, "  -U sets the unqualified data (YBTS ONLY)\r\n");
    fprintf(stderr, "  -v informs user of parameter changes\r\n");
    fprintf(stderr, "  -W wnd:pkt sets the window and packet sizes\r\n");
    fprintf(stderr, "  -x set the X.121 calling (sub)address (if applicable)\r\n");
    fprintf(stderr, "  -Y make YBTS call\r\n");
    fprintf(stderr, "  -y ybts to add to supplied DTE\r\n");
    fprintf(stderr, "  -z toggle interpretation of UN*X interupt character\r\n");
    fprintf(stderr, "  address is numeric (decimal, >= 8 digits), or alphanumeric\r\n");
    fprintf(stderr, "      'uk.ac.' or 'uk.co.' may be omitted for text tables.\r\n");
    fprintf(stderr, "\r\n");					break;
    case 'H':	strcpy(localhost, optarg);			break;
    case 'i':	if (init_commn >= MAX_INIT_COMM)
		 fprintf(stderr, " ++   Initial command `%s' ignored\r\n",optarg);
		else init_comms[init_commn++] = optarg;		break;
#ifdef	POLL_INTERVAL
    case 'I':	{ long n = atol(optarg);
		  if (MIN_POLL <= n && n <= MAX_POLL)
			poll_interval = n;
		  else	fprintf(stderr,
			"Invalid poll interval %d (%d -> %d) - left at %d\r\n",
				n, MIN_POLL, MAX_POLL, poll_interval);
		};						break;
#endif	POLL_INTERVAL
    case 'L':	/* Logging - rearrange file descriptors */
    case 'l':	logtype = c; termlog = optarg;			break;
#ifdef	SERVERCODE
    case 'N':	add_addr_space(optarg);				break;
#endif	SERVERCODE
#ifdef	TELNETD
    case 'n':	native_telnet++;				break;
#endif	TELNETD
    case 'P':	{ int i = atoi(optarg);
		  char *val = index(optarg, '=');
		  if (!isdigit(*optarg) || i <= 0 || i >= P_MAX)
		  { fprintf(stderr, "invalid preset param %s\r\n", optarg);
								break;
		  }
		  if (val)
		  { ignore_p[i]++;
		    if (!val[1])				break;
		  }
		  else if (!(val = index(optarg, '#')) &&
			   !(val = index(optarg, ':')))
		  { fprintf(stderr, "No # or = in %s\r\n", optarg); break; }
		  if (!isdigit(*++val))
		  { fprintf(stderr, "invalid preset value %s in %s\r\n",
			val, optarg);				break;
		  }
		  preset_b[i]++;
		  preset_p[i] = atoi(val);
 		}
		break;
    case 'p':	port = optarg;					break;
    case 'Q':	qual_serv=optarg;				break;
    case 'R':	system_rc++;					break;
    case 'r':	x25sbuf.x_reverse_charge = FACIL_YES;
		x25sbuf.x_fflags |= FACIL_F_REVERSE_CHARGE;	break;
    case 'S':	{ char *colon = index(optarg, ':');
		  int n;
		  if (*optarg && *optarg != ':')
			idle_timeout = atoi(optarg);
		  if (colon && (n = atoi(colon+1))) idle_grace = n;
		}						break;
    case 's':	scrfn = optarg;	if (!isatty(0))	batch++;	break;
    case 't':	prof_file = optarg;				break;
    case 'T':	sysprof_file = optarg;				break;
    case 'U':	unqual_data=optarg;				break;
    case 'v':	verbose = atoi(optarg);
		fprintf(stderr, " ++   verbose=%02x\r\n", verbose); break;
    case 'W':   { int wnd = atoi(optarg);
		  char *colon = index(optarg, ':');
		  int pkt = (colon) ? atoi(colon+1) : 0;
		  switch(wnd)
		  {
		  default: fprintf(stderr, "Bad window size %s (%d) [only 1-7]\n",
			optarg, wnd);
		  case 1:  case 2:  case 3: case 4:  case 5:  case 6:
		  case 7:	x25sbuf.x_recvwndsize	= wnd;
				x25sbuf.x_sendwndsize	= wnd;
				x25sbuf.x_fflags |= FACIL_F_RECVWNDSIZE;
				x25sbuf.x_fflags |= FACIL_F_SENDWNDSIZE;
		  case 0:	break;
		  }
		  switch(pkt)
		  {
		  default: fprintf(stderr, "Bad packet size %s (%d) [ only 16, 32, 64, 128, 256, 512 or 1024]\n",
			colon+1, pkt);
		  case 16:  case 32:  case 64:  case 128:  case 256: case 512:
		  case 1024:	x25sbuf.x_recvpktsize	= pkt;
				x25sbuf.x_sendpktsize	= pkt;
				x25sbuf.x_fflags |= FACIL_F_RECVPKTSIZE;
				x25sbuf.x_fflags |= FACIL_F_SENDPKTSIZE;
		  case 0:	break;
		  }
		}; break;
    case 'x':	calling_dte = optarg; calling_dte_malloced = 0;		break;
    case 'Y':	x25sbuf.x_context = TCONTEXT; ts29++;			break;
    case 'y':	set_cudf(x25sbuf.x_cudf, &x25sbuf.x_cudflen, TS_CUDF,
		TS_CUDFLEN, (unsigned char *)optarg, strlen(optarg),1);
		x25sbuf.x_context = TCONTEXT;				break;
    case 'z':	intr = !intr;						break;
    case '?':	fprintf(stderr,
		"Usage: %s [-%s] address             (-h gives help)\r\n",
				argv[0], spad_opts);
		exit(2);
    }

#ifdef	TELNETD
  if (telnetd > 0)
  { static char buff[128];
    char msg[512];
    int host = 0, port;
    int noprompt = 0;
    /* TPADDOPTS is of the form <ent> [,<ent>]*
     * ent = <IP address regular expr>:<host to call>:<prompt>
     */
    char *next;
    char *this = getenv("TPADOPTS");
    char *c = (char *) 0;	/* Keep lint etc happy */

    /* old fashioned inetd (with calling address) or new one (no args) */
    if (optind == argc)
    { int fromlen = sizeof from;
      if (getpeername(0, &from, &fromlen))
      { fprintf(stderr, "[cant find peer name] ");
	sprintf(tel_sender, "%c%s]", TEL_UNKNOWN, argv[optind]);
      }
      else sprintf(tel_sender, "%08x", from.sin_addr.s_addr);
    }
    else if (sscanf(argv[optind], "%8x.%d", &host, &port) == 2)
    { from.sin_addr.s_addr	= host;
      sprintf(tel_sender, "%08x", host);
    }
    else
    { fprintf(stderr, "[%s] ", argv[optind]);
      sprintf(tel_sender, "%c%s]", TEL_UNKNOWN, argv[optind]);
    }

    if (!this) this = TPADOPTS;
    *msg = '\1';
    *buff = '\0';

    /* See if the calling host has some special options / prompt / ... */
    for(;this; this=next)
    { int len;
      char *colon;
      char *compiled;
      next = index(this, ',');
      len = (next) ? next++ - this : strlen(this);
      strncpy(buff, this, len);
      buff[len] = '\0';
      if (colon = index(buff, ':')) *colon++ = '\0';
      compiled = re_comp(buff);
      if (compiled || !re_exec(tel_sender))	continue;
      /* The calling IP address matched, so set the destination host/prompt */
      if (colon)
      {	char *last = index(colon, ':');
	if (last)
	{ *last++ = '\0';
	  strcpy(msg, last);
	}
	strcpy(buff, colon);
      }
      else *buff = '\0';
      break;
    }

    role=DIRECT;

    /* if not match from TPADOPTS, take extra bits from the command name */
    if ((!(*buff)) && (!strncmp(cmd_name, "in.tpadd", sizeof "in.tpadd" -1)) &&
		cmd_name[sizeof "in.tpadd" -1] == '.')
	strcpy(buff, cmd_name + sizeof "in.tpadd");

    /* Not really telnet mode at all -- raw bytestream */
    if (!strncmp(buff, "-n.", 3))
    {	telnetd = -1;
	strcpy(buff, buff+3);
    }

    /* Suppress prompt */
    if (!strncmp(buff, "-s.", 3))
    {	noprompt = 1;
	strcpy(buff, buff+3);
    }

    /* Now we have a hostname to call, or "FORBID" */
    if (*buff)
    {	if (!strcmp(buff, "FORBID"))
	{ fprintf(stderr, "%s\r\n", (*msg == '\1') ? "Access Denied" : nl(msg));
	  exit(1);
	}
	if ((*msg != '\1')) fprintf(stderr, "%s", nl(msg));
	forbid_some_pad_cmds=1;
	print_banner=0;
    }
    /* Else null buffer -> ask user for destination */
    else
    { int failed = 0;
      if (telnetd > 0)
      { if (force_echo_on&1) fprintf(telf, "%c%c%c", IAC, WONT, TELOPT_ECHO);
	if (force_echo_on&2) fprintf(telf, "%c%c%c", IAC, WILL, TELOPT_BINARY);
	if (force_echo_on&4) fprintf(telf, "%c%c%c", IAC, WONT, TELOPT_SGA);
	if (force_echo_on&8) fprintf(telf, "%c%c%c", IAC, DO, TELOPT_SGA);
	if (force_echo_on&16) fprintf(telf, "%c%c%c", IAC, DONT, TELOPT_SGA);
	if (force_echo_on&32) fprintf(telf, "%c%c%c", IAC, WILL, TELOPT_SGA);
	if (force_echo_on&64) fprintf(telf, "%c%c%c", IAC, WILL, TELOPT_ECHO);
	if (force_echo_on&128) fprintf(telf, "%c%c%c", IAC, DO, TELOPT_ECHO);
      }
      if (*msg == '\1')
      { char *tpad_prompt = getenv("TPADMSG");
	if (!tpad_prompt) tpad_prompt = TPADMSG;
	strcpy(msg, tpad_prompt);
      }
      for (;!failed; noprompt=0)
      {
#define	echo	(telnetd <= 0 || myopts[TELOPT_ECHO]) && !noprompt
	if (!noprompt)
	{ fprintf(stderr, nl(msg), argv[argc-1]);
          (void) fflush(telf);
          (void) fflush(stderr);
	}
        for (c=buff; c < buff + sizeof buff; )
        { int res;
	  char strip;
      	  if (read(0, c, 1) != 1)	{ failed++; break; }
      	  res = (telnetd > 0) ? telrcv((*c) & 0xff) : ((*c) & 0xff);
	  strip = res & eightbitinput;
      	  if (res == NOT_CHAR)	continue;
      	  if (strip == '\n' || strip == '\r')	break;
      	  if (strip == (DEL & eightbitinput))
      	  { if (echo) fprintf(stderr,(c==buff)?"\07":
			  (verbose & V_RUBOUT) ? "\b$\b" : "\b \b");
      	    if (c != buff) c--;
      	    fflush(stderr);
      	    continue;
      	  }
      	  if (echo) fprintf(stderr, "%c", res);
      	  *c++ = strip;
      	  fflush(stderr);
	}
	if (noprompt && buff[0] == '@')
	{	extra[1] = '\0';
		extra[0] = buff[1];
		strcat(tel_defsend, ":");
		strcat(tel_defsend, extra);
		*c = '\0';
		strcpy(buff, buff+3);
		c -= 3;
	}
	if (echo)
	{ fprintf(stderr, "\r\n");
	  fflush(stderr);
	}
	if (c != buff) break;
      }
      if (telnetd > 0)
      { if (force_echo_off&1) fprintf(telf, "%c%c%c", IAC, WILL, TELOPT_ECHO);
	if (force_echo_off&2) fprintf(telf, "%c%c%c", IAC, WONT, TELOPT_BINARY);
	if (force_echo_off&4) fprintf(telf, "%c%c%c", IAC, WILL, TELOPT_SGA);
	if (force_echo_off&8) fprintf(telf, "%c%c%c", IAC, DONT, TELOPT_SGA);
	if (force_echo_off&16) fprintf(telf, "%c%c%c", IAC, DO, TELOPT_SGA);
	if (force_echo_off&32) fprintf(telf, "%c%c%c", IAC, WONT, TELOPT_SGA);
	if (force_echo_off&64) fprintf(telf, "%c%c%c", IAC, WONT, TELOPT_ECHO);
	if (force_echo_off&128) fprintf(telf, "%c%c%c", IAC, DONT, TELOPT_ECHO);
      }
      *c = '\0';
      if (verbose & V_10_) fprintf(stderr, "[%d%d]",
		hisopts[TELOPT_ECHO], myopts[TELOPT_ECHO]);
      if (debug & D_1_) fprintf(stderr,"[ Using %d '%s' ]\r\n", strlen(buff),buff);
    }
    fflush(stderr);
    if (!*buff || *buff == '.' || !strcmp("old", buff))
    { char ** env = (*buff && *buff != '.') ? oldenv : nullenv;
      fflush(stderr);
#ifdef	TELNETN1
      close(1);
      close(2);
      execle(TELNETD1, TELNETN1, tel_sender, 0, env);
#ifdef	TELNETN2
      execle(TELNETD2, TELNETN2, tel_sender, 0, env);
#endif	TELNETN2
      write(0, "exec failed\r\n", 13);
#else	TELNETN1
      write(0, "No host name given\r\n", 20);
#endif	TELNETN1
      sleep(2);
      exit(1);
    }
    dest = buff;
  }
  else
#endif	TELNETD
  if (optind != (argc -1))
  { if (optind == argc && strcmp(cmd_name, COMMANDNAME))
	dest = cmd_name;
    else
    { fprintf(stderr, "Usage: %s [-%s] address             (-h gives help)\r\n",
				argv[0], spad_opts);
      exit(2);
    }
  }
  else dest = argv[optind];

#ifdef	NOT_USED
  if (!dest)
  { char *slash = index(dest, '/');
    char *colon = index(dest, ':');
    char *dash  = index(dest, '-');
    if (dash == dest+2) colon = slash = (char *) 0;
    else dash = (char *) 0;

    if (colon && slash && (slash < colon)) colon = (char *) 0;

    if (colon)
    {	*colon++ = '\0';
	set_cudf(x25sbuf.x_cudf, &x25sbuf.x_cudflen, PRE_CUDF,
		PRE_CUDFLEN, (unsigned char *)colon, canonical(colon, 0), 0);
	x25sbuf.x_context = XCONTEXT;
    }
    else if (slash)
    {	*slash++ = '\0';
	set_cudf(x25sbuf.x_cudf, &x25sbuf.x_cudflen, TS_CUDF,
		 TS_CUDFLEN, (unsigned char *)slash, strlen(slash), 1);
	x25sbuf.x_context = TCONTEXT;
    }
    else if (dash)
    {	if (!parse_addr(dest, &called_char_addr, (char *) 0))
	{   fprintf(stderr, "Invalid LLC2 address `%s'. Should be <mac addr>.<LSEL>.<NSAP>.<DTE>:<cudf>\n",
		dest);
	    fprintf(stderr, "e.g. 08-00-20-00-67-b8.7e.388261100000828990670077.00000801170301:::01000000\n");
	    exit(1);
	}
	print_addr(&called_char_addr, stderr);
	dest = called_char_addr.dte;
	if (!dest) dest = "";
	if (called_char_addr.cudf)
	{    set_cudf(x25sbuf.x_cudf, &x25sbuf.x_cudflen, PRE_CUDF,
		PRE_CUDFLEN, (unsigned char *)called_char_addr.cudf, canonical(called_char_addr.cudf, 0), 0);
	    x25sbuf.x_context = XCONTEXT;
	}
    }
  }
#endif	/* NOT_USED */

  if (!prof_file)
  { char *home = getenv("HOME");
    if (home)
    { prof_file = malloc(strlen(home) + strlen(PRIV_PROF) +2);
      if (prof_file) (void) sprintf(prof_file, "%s/%s", home, PRIV_PROF);
    }
  }

#ifdef SECURITY
  if (role == DIRECT)
  { char *auth;
    int rc;
#ifdef	TELNETD
    if (telnetd != 0 && *tel_sender != TEL_UNKNOWN)
	auth = getsender("telnet", &from.sin_addr);
    else
#endif	TELNETD
    auth = findusername();
    if (rc= disallowed(auth, dest, 0, (char *) 0, extra,
   		 x25sbuf.x_cudf, x25sbuf.x_context))
    { if (errno == 0 || errno == 1) padexit(1);
      fprintf(stderr, " +++- Direct mode not available (%d, %s, %d)\r\n",
		rc, auth, errno);
      role = CLIENT;
    }
  }
#endif SECURITY
  initparams();
  setuprq(dest);		/* set size, username, dest in x25sbuf */
  if (breakch) breakinch = breakch;


#ifdef	SERVERCODE
  if (role != CLIENT && (s = openx25()) < 0) {
    if (role != DIRECT || errno == EPROTONOSUPPORT)
    { role = CLIENT;
      fprintf(stderr, " +++- Direct mode not currently available -- trying client\r\n");
    }
    else {
      if (s != -2) perror("x25 open");
      padexit(1);
    }
  }
#endif	SERVERCODE

  /* In case we are setuid ....
   * X25 open -- now we can go back to the real user ...
   */
  setuid(getuid());
  dorcfile(dest);		/* read .spadrc, .spad<host>rc */
  if (termlog)
  { if (strcmp(termlog, "-") == 0)	/* log to stdout */
    { termlogf = fdopen(dup(1), "w");
      if (termlogf) {
	fclose(stdout);
	(void) fdopen(dup(2), "w");
      }
    }
    else termlogf = fopen(termlog, (logtype == 'l') ? "w" : "a");

    if (!termlogf)
    	fprintf(stderr, "problem with termlogfile - not open\r\n");
    else use_termlogf = 1;
  }

  /* do the command line options */
  { int i; for (i=0; i<init_commn; i++) (void) docmd(init_comms[i], 0); }

#ifdef  SERVERCODE
  if (role != CLIENT)	startlog();
  else
#endif	SERVERCODE
  setupclient();

  /* This is ACTUALLY an "if", but we want to loop if a message arrives
   * instead of an accept -- we wouldn't want to use a goto, now would we ..
   */
  while (ybts) /* Now await the accept */
  { int	count;
    int i;
    char type;
    int atleast = 1;

#define	ACCEPT 0x11
    count = fromx25(TTY_NODATA);
    if (x25ibuf.x_flags & X25F_TSPAD)
    { atleast--;
      type = x25ibuf.x_tspad;
    } else type = x25ibuf.x_buf[0];

    if (debug & D_1_)
    { fprintf(stderr, "Accept: %d: %02x: %02x: ",
		count, x25ibuf.x_send_type, type);
      for(i=atleast-1; i<count;i++)
		fprintf(stderr, " %02x", x25ibuf.x_buf[i] & 0xff);
      fprintf(stderr, "\r\n");
    }

    if (x25ibuf.x_flags & X25F_GATE_MSG)
    { fflush(stdout);
      x25ibuf.x_buf[count] = '\0';
      fprintf(stderr, "\r\n ++++ %s\r\n", x25ibuf.x_buf);
      continue;
    }

    if(count < atleast)
    { fprintf(stderr, "recv acc failed %d (%d)\r\n", count, errno);
      padexit(1);
    }
    if (type != ACCEPT || !(x25ibuf.x_send_type & (1<<Q_BIT)))
    { fprintf(stderr, "invalid ac %d: %02x %02x",
		count, x25ibuf.x_send_type, type);
      for (i=0; i<count; i++)
	fprintf(stderr, " %02x", (unsigned char) x25ibuf.x_buf[i]);
      fprintf(stderr, ": ");
      for (i=0; i<count; i++) fprintf(stderr, "%c",
	isprint((x25ibuf.x_buf[i] & 0x7f)) ? (char) x25ibuf.x_buf[i] : '.');
      fprintf(stderr, "\r\n");
      padexit(1);
    }
    break;
  }

  pktsin = pktsout = bytesin = bytesout = 0;

  if (verbose & V_2_) print_facil(&x25sbuf.x_facil, stderr);

  if (x25sbuf.x_sendpktsize) pktisize = ntohs(x25sbuf.x_sendpktsize);
  if (x25sbuf.x_recvpktsize) pktosize = ntohs(x25sbuf.x_recvpktsize);

  if (breakinch >= 0 && print_banner)
#ifdef	VERBOSE_CNCTMSG
  { fprintf(stderr, "\r\n+++ Spad (%s-%d of %s) connected +++\r\n",
		versions, X25IO_VER, dates);
    fprintf(stderr, "Press ");
    printcntrlchar(breakinch, 0);
    fprintf(stderr, " followed by B to generate an interrupt.\r\n");
    fprintf(stderr, "Press ");
    printcntrlchar(breakinch, 0);
    fprintf(stderr, " followed by A to interact with the gateway PAD.\r\n");
    fprintf(stderr, "Use the PAD command \"clear\" to clear the call.\r\n\n");
    fflush(stderr);
  }
#else /* VERBOSE_CNCTMSG */
  { fprintf(stderr, "\r\n +++- Spad (%s-%d of %s) connected: Breakin char = ",
	versions, X25IO_VER, dates);
    printcntrlchar(breakinch, 1);
    fflush(stderr);
  }
#endif /* VERBOSE_CNCTMSG */

  if (idle_timeout)
  { (void) signal(SIGALRM, SIGARG2 sess_idle_logout); alarm(idle_timeout); }

  {
#ifdef	TIOCGPGRP
#if	defined(__svr4__) || defined(__linux__) || defined(__osf__)
     int cur_group = getpgrp();
#else
     int cur_group = getpgrp(0);
#endif
   /* If we can find tye TTY's current proc group, do it properly */
     int proc_group;
#endif	TIOCGPGRP
     if (!isatty(0));
#ifdef	TIOCGPGRP
     else if (!ioctl(0, TIOCGPGRP, &proc_group) && (proc_group != cur_group))
	suspendedy = 1;
#endif	TIOCGPGRP
     else
	reresettty();
  }
  if (scrfn)		firstmatch();

  switch (role) {
#ifdef	SERVERCODE
  case DIRECT:  pollloop((1 << 0), (1 << s), s + 1);
#endif	SERVERCODE
  case CLIENT:  pollloop((1 << 0), (1 << clienttoserver), clienttoserver+1);
  }
  /* NOTREACHED */
}

/* Indicate that subsequent items are added to the START of the list */
mark_addr_space()
{	addr_pos = 0;	}

/* Add an address space to the middle of a list, leaving the end intact */
add_addr_space(addr_sp)
char *addr_sp;
{	int old;

	if (!strcmp(addr_sp, "END"))
	{	addr_spaces = addr_pos;
		return;
	}

	if (addr_spaces < (sizeof addr_space / sizeof addr_space[0])-1)
		addr_spaces++;

	for (old=addr_spaces; old>addr_pos; old--)
		addr_space[old] = addr_space[old-1];

	addr_space[addr_pos++] = addr_sp;
}
