#ifndef	lint
static char RCSid[]="$Header: /Nfs/blyth/glob/src/usr.bin/spad/src/RCS/spaddex.c,v 1.19 1990/11/25 07:40:13 pb Rel $";
#endif	lint
/* spad:-  multiple client/single server x.29 service.
	   needs Sunlink X.25 software running in (at least) one node
 */

/* Copyright (c) A Rawsthorne 1986, 1987 & P Brooks 1987, 1988
 * not for commercial use
 * this version not to be redistributed except by agreement.
 */

#include "spad.h"
#ifdef	SERVERCODE
#ifdef	DEXPAND
/* serverloop - wait for client message or X.25 message */
serverloop()
{
  int n;
  int x25mask	= (1 << s);
  int clientmask= (1 << servertoclient);
  static struct timeval no_delay;
  static struct timeval sel_tout;
  struct timeval *psel_tout = (role == CLIENT) ?
		(struct timeval *) NULL : &sel_tout;
  int defmask	= clientmask;
  int extramask = 0;

  sel_tout.tv_sec	= poll_interval / 1000000;
  sel_tout.tv_usec	= poll_interval % 1000000;

  if (s > servertoclient)	n = s + 1;
  else				n = servertoclient + 1;

  while(1)
  { int selmask = defmask;

    if (ccstat(circuit, &contp) > 0)
    { /* YUCK !! We really ARE polling !!!! */
      if (debug & D_1_) fprintf(stderr,
		"Got (m%x, r%x, e%x, m%x, q%x, i%x, %x/%x)\r\n",
		contp.c_Xmsg, contp.c_Xrecv, contp.c_Xevent,
		contp.c_Xmbit, contp.c_Xqbit, contp.c_Xiflag,
		contp.c_Xdiag, contp.c_Xcause);
      extramask = x25mask;
    }
    else	extramask = 0;

    if (select(n, &selmask, (int *)NULL, (int *)NULL,
	(extramask) ? &no_delay : psel_tout) < 0)
    { perror("server select");
      padexit(1);
    }
    selmask |= extramask;

    if (selmask & clientmask) sendtox25socket(&x25obuf, readfromclient());
    if (selmask & x25mask)    sendtoclient(&x25ibuf, readfromx25(TTY_NODATA));
  }
}

send_reset(s)
{ contp.c_Xcause = 0;
  contp.c_Xdiag = 0;
  if (ccontrol(circuit, CRESET, &contp) < 0)
  { stampf("");
    perror("ccontrol CRESET");
    padexit(1);
  }
}

send_data_2(s, x25buf, buf, count, send_type)
struct x25io *x25buf;
char *buf;
{ struct cciovec iov;
  iov.cc_iovbase	= buf;
  iov.cc_iovlen	= count;
  iov.cc_iovseg	= 0;
  contp.c_Xiflag	= !!(x25buf->x_flags & X25F_MSG_OOB);
  contp.c_Xqbit	= !!(send_type & (1 << Q_BIT));
  contp.c_Xmbit	= !!(send_type & (1 << M_BIT));
  if (ccsend(circuit, &iov, 1, &contp)<0)
  { stampf("");
    perror("ccsend");
    resettty();
    padexit(1);
  }
}

openx25()
{				/* used in server and direct case */
  int i, s; char *lookup();
  int new_facil = 0;
  char *dest = x25sbuf.x_destination;
  char tsfac[128];	/* How big ?? */
  unsigned char cudf[128];
  unsigned char cudflen;
  char _dte[128];
  char *tsfacp = tsfac;
  char *fromdte = DEXPAND_DTE;
#define	MAX_CHANNELS	4
  unsigned char diag[MAX_CHANNELS];
  unsigned char cause[MAX_CHANNELS];
  int attempt;
  char *channel;

  circuit = ccinit(0, CC_X25);
  if(circuit < 0)
  { if (role == SERVER)
    { clientmes1(1 | X25F_CLOSING, "Dexpand init failed (for %s)", dest);
      return -2;
    }

    /* Use client mode */
    errno = EPROTONOSUPPORT;
    return -1;
  }

  if (dest[0] >'9')
  { dte = lookup(dest, x25sbuf.x_cudf, &x25sbuf.x_cudflen, app_relay,
	sizeof(app_relay), x25sbuf.x_context, x25sbuf.x_network, SERVER);
    if (dte == NULL)
    { clientmes1(X25F_CLOSING, "can't find %s in directory\r\n",
		/* NOSTRICT */ dest);
      return -2;
    }
  } else
  { if ((dest[0] >= '0') && (strlen(dest) >= 8)) dte = dest;
    else
    { clientmes1(X25F_CLOSING, "invalid destination address \"%s\"",
		/* NOSTRICT */dest);
      return -2;
    }
  }

  set_cudf(cudf, &cudflen, x25sbuf.x_cudf, x25sbuf.x_cudflen, "",0, 2);

  if (debug & D_1_)
  { fprintf(stderr, " ++   CUDF %d/%d:", cudflen, x25sbuf.x_cudflen);
    for (i=0; i<cudflen; i++) fprintf(stderr, " %02x", cudf[i]);
    fprintf(stderr, "\r\n");
  }

  /* If it defaulting to FAST SELECT and isn't needed, don't bother
   */

  if(!(x25sbuf.x_fflags & FACIL_F_FAST_SELECT))	/* user specified */
  {	x25sbuf.x_fast_select	=
		(x25sbuf.x_cudflen <= MAXNOFS_BYTES) ? FACIL_NO : FACIL_YES;
	x25sbuf.x_fflags		|= FACIL_F_FAST_SELECT;
  }

  /* Copy over the user requirements, if non-zero */
  if (x25sbuf.x_fflags & (FACIL_F_FAST_SELECT | FACIL_F_REVERSE_CHARGE))
  {	int data = 0;
	if (x25sbuf.x_fflags & FACIL_F_FAST_SELECT)
		data |= (x25sbuf.x_fast_select == FACIL_YES) ? 0x80 : 0x00;
	if (x25sbuf.x_fflags & FACIL_F_REVERSE_CHARGE)
		data |= (x25sbuf.x_reverse_charge == FACIL_YES) ? 0x01 : 0x00;
	*tsfacp++ = 0x01;
	*tsfacp++ = data;
  }

/*
#undef	update_facil
#define	update_facil(set, data,type) if (x24sbuf.x_fflags & set) \
	{ *tsfacp++=type; *tsfacp++=data;}
  update_facil(FACIL_F_recvwndsize,	x25sbuf.x_recvwndsize,	0x00);
  update_facil(FACIL_F_sendwndsize,	x25sbuf.x_sendwndsize,	0x00);
  update_facil(FACIL_F_recvthruput,	x25sbuf.x_recvthruput,	0x00);
  update_facil(FACIL_F_sendthruput,	x25sbuf.x_sendthruput,	0x00);
  update_facil(FACIL_F_cug_req,		x25sbuf.x_cug_index,	0x00);
  update_facil(FACIL_F_recvpktsize,	x25sbuf.x_recvpktsize,	0x00);
  update_facil(FACIL_F_sendpktsize,	x25sbuf.x_sendpktsize,	0x00);
  update_facil(FACIL_F_rpoa_req,	x25sbuf.x_rpoa_req,	0x00);
  update_facil(FACIL_F_rpoa,	x25sbuf.x_rpoa,	0x00);
*/

  set_xparams(&x25sbuf.x_facil, tsfac, tsfacp);

  sprintf(_dte, "%c%s", DEXPAND_CHANS[0], dte);
  contp.c_Xrecv		= COUTGOING;
  contp.c_Xdadr		= _dte;
  contp.c_Xdalen	= strlen(contp.c_Xdadr);
  contp.c_Xgadr		= fromdte;
  contp.c_Xgalen	= strlen(contp.c_Xgadr);
  contp.c_Xud		= (char *) cudf;
  contp.c_Xudlen	= cudflen;
  contp.c_Xfac		= tsfac;
  contp.c_Xfaclen	= tsfacp - tsfac;

  if (debug & D_1_)
  { fprintf(stderr, " ++   Addr %d: `%*.*s'\r\n",
	contp.c_Xdalen, contp.c_Xdalen, contp.c_Xdalen, contp.c_Xdadr);
    print_dexparams(contp.c_Xfac, contp.c_Xfaclen, stderr);
  }

  for (attempt=0, channel=DEXPAND_CHANS;
	*channel && attempt < MAX_CHANNELS;
	attempt++, channel++)
  { contp.c_Xcause = contp.c_Xdiag = errno = 0;
    *_dte = *channel;
    i= ccontrol(circuit, CCONNECT, &contp);
    if (i <= 0)
    { cause[attempt]	= (unsigned char) contp.c_Xcause;
      diag[attempt]	= (unsigned char) contp.c_Xdiag;

     fprintf(stderr, "chan %c: %02x %02x: ", *channel,
	(unsigned char) contp.c_Xcause, (unsigned char) contp.c_Xdiag);
      fflush(stderr);
      perror("dexpand connect");
    }
    else break;
  }
  if (! *channel || attempt >= MAX_CHANNELS)
  { char temp[24 + MAX_CHANNELS*9 + 1 + 100];
    char *tempp = temp;

      sprintf(tempp, "server X25 call to %s failed", dest);
      while(*tempp) tempp++;
      for (i=0; i<MAX_CHANNELS && DEXPAND_CHANS[i]; i++)
      {	sprintf(tempp, ": %c %02x %02x", DEXPAND_CHANS[i], cause[i], diag[i]);
	while(*tempp) tempp++;
      }
      ccontrol(circuit, CCLEAR, &contp);
      ccterm(circuit);
      if (role == SERVER)
      { clientmes0(((errno) ? 1 : 0) | X25F_CLOSING, temp);
	return -2;
      }

      /* Use client mode */
      errno = EPROTONOSUPPORT;
      return -1;
  }
  fprintf(stderr, " +++- Using %c connection\r\n", *channel);

  if (role == SERVER)
  {
    if(debug & D_1_)
    {	int i;
	fprintf(stderr, "+return setup+ %db:", x25SBUF_size);
	if (debug & D_2_) for(i=0; i<x25SBUF_size; i++)
		fprintf(stderr, " %02x", ((unsigned char *)x25sbuf.x_buf)[i]);
	fprintf(stderr, "]\r\n");
    }
    x25sbuf.x_flags |= X25F_SBUF;
    sendtoclient(&x25sbuf, x25SBUF_size);
  }

  printapprelay();
  return(circuit);
}

read_into_ibuf(s, offset, data)
{ int count;
  int extra = (data != TTY_NODATA);
  /* OK, we may have one byte of data already in data.
   * If so, and the M bit is set, read
   */

  if (extra)
  { if (offset == 0)	x25ibuf.x_tspad = data;
    else		x25ibuf.x_buf[0] = data;
  }

  if (extra && !contp.c_Xmbit)	/* All in one ! */
    count = 1;
  else						/* More to read ... */
 
  { struct cciovec iov[2];
    struct cciovec *iovp = &(iov[1]);

    contp.c_Xtout    = 500;		/* Just one tick ... */
    iovp->cc_iovbase = x25ibuf.x_buf;
    iovp->cc_iovlen  = sizeof(x25ibuf.x_buf);
    iovp->cc_iovseg  = 0;

    if (offset == 0)	/* expecting TS29 header */
    { if (!extra)	/* Got to receive extra data */
      {	iovp--;
	iovp->cc_iovbase = (char *) (&(x25ibuf.x_tspad));
	iovp->cc_iovlen  = 1;
	iovp->cc_iovseg  = 0;
      }
    }
    else if (extra) iovp->cc_iovbase++, iovp->cc_iovlen--;

    errno = 0;
    if ((count = ccrecv(circuit, iovp,
		(sizeof(iov)/sizeof(iov[0])) -(iovp-iov), &contp))<0)
    {	stampf("");
	perror("spadd: ccrecv");
	padexit(1);
    }

    if (debug & D_1_) fprintf(stderr, "... %d %x (m%x, r%x, e%x, m%x, q%x, i%x, %x/%x)\r\n",
		count, (*iovp).cc_iovbase[0],
		contp.c_Xmsg, contp.c_Xrecv, contp.c_Xevent,
		contp.c_Xmbit, contp.c_Xqbit, contp.c_Xiflag,
		contp.c_Xdiag, contp.c_Xcause);
    if (extra) count++;
  }

  if (count ==0)
  { char buff[128];
    char *buffp;

    sprintf(buff, "Call closed:");
    for (buffp = buff; *buffp; buffp++);

    contp.c_Xcause	= 0xff;
    contp.c_Xdiag	= 0xff;
    if (ccstat(circuit, &contp) < 0)
	 sprintf(buffp, " no c/g");
    else sprintf(buffp, " %02x %02x", (unsigned char) contp.c_Xcause,
			   (unsigned char) contp.c_Xdiag);
    clientmes0(((errno) ? 1 : 0) | X25F_CLOSING, buff);
    padexit(1);
  }

  { if (ts29) last_ts29_push = !contp.c_Xmbit;

    if (!offset)	x25ibuf.x_flags     |= X25F_TSPAD, count--;
    if (contp.c_Xmbit)	x25ibuf.x_send_type |= (1 << M_BIT);
    if (contp.c_Xqbit)	x25ibuf.x_send_type |= (1 << Q_BIT);

    if (count < 0)
    { if (role != DIRECT) stampf("");
      perror((role == DIRECT) ? "ccrecv" : "server: x25 ccrecv");
      padexit(1);
    }
  }
  return count;
}

print_dexparams(fac, len, file)
unsigned char *fac;
FILE *file;
{ int i;
  fprintf(file, " ++   Facilitites %d:", len);
  for (i=0; i<len; i++) fprintf(file, " %02x", fac[i]);
  fprintf(file, "\r\n");
}

set_xparams(facil, tsfac, tsfacend)
struct facilities *facil;
unsigned char *tsfac, *tsfacend;
{ int i;
  for (; tsfac<tsfacend; tsfac++) switch (*tsfac++)
  {
  case 0x01:	switch(*tsfac & 0xc0)
	{	case 0x00: facil->x4_fast_select = FACIL_NO;
			   facil->x4_fflags |= FACIL_F_FAST_SELECT;	break;
		case 0x80: facil->x4_fast_select = FACIL_YES;
			   facil->x4_fflags |= FACIL_F_FAST_SELECT;	break;
	}	switch(*tsfac & 0x01)
	{	case 0x00: facil->x4_reverse_charge = FACIL_NO;
			   facil->x4_fflags |= FACIL_F_REVERSE_CHARGE;	break;
		case 0x01: facil->x4_reverse_charge = FACIL_YES;
			   facil->x4_fflags |= FACIL_F_REVERSE_CHARGE;	break;
	}	break;
  default:	fprintf(stderr, "Unknown facil %02x (%02x)\r\n",
			tsfac[-1], *tsfac);
  }
}
#endif	DEXPAND
#endif	SERVERCODE
