/* spad:-  multiple client/single server x.29 service.
	   needs Sunlink X.25 software running in (at least) one node
 */

/* Copyright (c) A Rawsthorne 1986, 1987 & P Brooks 1987 - 1993
 * not for commercial use
 * this version not to be redistributed except by agreement.
 */


#ifndef	EXTERN_SET
#ifndef	EXTERN
#define	UNDEF_EXTERN
#define	EXTERN	extern
#endif	/* EXTERN */

/* Decide if this could be a server.
 * default on sun is TRUE
 */
#ifdef	sun
# ifndef NO_SERVERCODE
#  define SERVERCODE
# else
#  if	defined(__svr4__) && ! defined(MLEN)
#   define MLEN
#  endif
# endif	 NO_SERVERCODE
#endif	sun

#ifdef	DEXPAND_DTE
# ifndef DEXPAND
#  define DEXPAND
# endif  DEXPAND
#endif  DEXPAND_DTE

#ifdef	DEXPAND
# ifndef NO_SERVERCODE
#  define SERVERCODE ON
# endif  NO_SERVERCODE
# ifndef DEXPAND_DTE
#  define DEXPAND_DTE	You should have defined DEXPAND_DTE
# endif  DEXPAND_DTE
# ifndef DEXPAND_CHANS
#  define DEXPAND_CHANS "AB"
# endif  DEXPAND_CHANS
#endif	DEXPAND

#ifndef	SERVERCODE
# ifdef	NRSDBM
#  undef NRSDBM			/* only servers can stand and stare */
# endif	NRSDBM
# ifdef SECURITY
#  undef SECURITY		/* Security is all done on the server */
# endif SECURITY
# ifdef TELNETD
#  ifndef REALLY_TELNETD
#   undef TELNETD		/* telnetd is only relevant on a server */
#  endif REALLY_TELNETD
# endif TELNETD
#endif	SERVERCODE

#ifndef	TIMEOUT_RFC931
#define	TIMEOUT_RFC931	30	/* default timeout for RFC 931 */
#endif

#ifdef	DEXPAND
# ifndef MIN_POLL
# define MIN_POLL 50000
# endif  MIN_POLL
# ifndef MAX_POLL
# define MAX_POLL 5000000
# endif  MAX_POLL
# ifndef POLL_INTERVAL
# define POLL_INTERVAL 500000
# endif  POLL_INTERVAL
#endif	DEXPAND

#ifndef	DEF_ROLE
# define DEF_ROLE CLIENT
#endif	DEF_ROLE

#ifdef	TELNETD
# ifndef  NATIVE_TELNET
#  define NATIVE_TELNET	1
# endif   NATIVE_TELNET
#endif	TELNETD

#ifndef	LOCAL_AUTH
#define	local_auth(res, real_calling_user, calling_user, real_called_host, called_host, special, context, extra, rest) sample_local_auth(res, real_calling_user, calling_user, real_called_host, called_host, special, context, extra, rest) 
#endif	LOCAL_AUTH

#define MAXFN 1023
#ifdef	TELNETD
#define	TS_DATA		0	/* base state */
#define	TS_IAC		1	/* look for double IAC's */
#define	TS_CR		2	/* CR-LF ->'s CR */
#define	TS_BEGINNEG	3	/* throw away begin's... */
#define	TS_ENDNEG	4	/* ...end's (suboption negotiation) */
#define	TS_WILL		5	/* will option negotiation */
#define	TS_WONT		6	/* wont " */
#define	TS_DO		7	/* do " */
#define	TS_DONT		8	/* dont " */
#define	telf	stderr
#define	TEL_UNKNOWN	'['
#else	TELNETD
#define	do_echo(on) on
#endif	TELNETD
#define	CM_NOLOG	0x0002	/* Do not log clientmess to log file */

#ifndef	CALLING
#define	CALLING	"TS29"
#endif	CALLING

#ifndef	BREAKINCHAR
#define BREAKINCHAR 0x10	/* DLE == C-P == ^P */
#endif	BREAKINCHAR

#define	XON	0x11
#define	XOFF	0x13

#ifndef	ACCNTFILE
#define ACCNTFILE	"/usr/adm/Padlogx25\0<-- ACCNTFILE patch area -->"
#endif	ACCNTFILE

#ifndef	ADDR_SPACES
#define	ADDR_SPACES	3
#endif	ADDR_SPACES

#ifndef	ADDR_SPACE
#define	ADDR_SPACE	"janet\0<-- addr space 0 -->", "pss\0<-- addr space 1 -->", "\0<-- addr space 2 -->", "\0<-- addr space 3 -->", "\0<-- addr space 4 -->"
#endif	ADDR_SPACE

#ifndef	COMMANDNAME
#define COMMANDNAME	"spad\0<-- COMMANDNAME patch area -->"
#endif	COMMANDNAME

#ifndef	PROF_FILE
#define PROF_FILE	"/etc/x29profile\0<-- PROF_FILE patch area -->"
#endif	PROF_FILE

#ifndef	PRIV_PROF
#define PRIV_PROF	".x29profile\0<-- PRIVPROF patch area -->"
#endif	PRIV_PROF

#ifndef	SERVERNAME
#define	SERVERNAME	"x29-serv\0<-- SERVERNAME patch area -->";
#endif	SERVERNAME

#ifndef AUTHFILE
#define AUTHFILE	"/etc/spad-auth\0<-- AUTHFILE patch area -->"
#endif	AUTHFILE

#ifndef	PROMPT
#define	PROMPT		"%s PAD>\0<---- PROMPT can be patched I suppose ---->"
#endif	PROMPT

#ifndef TPADMSG
#define TPADMSG	"tpad to (<hostname>, \"old\" or RETURN): \0<-patch TPAGMSG->"
#endif	TPADMSG

#ifndef TPADOPTS
#define TPADOPTS	"\0<--------- TPADOPTS can be patched I suppose ---->"
#endif	TPADOPTS

#ifndef TPADECHO_ON
#define TPADECHO_ON	96
#endif  TPADECHO_ON

#ifndef TPADECHO_OFF
#define TPADECHO_OFF	0
#endif  TPADECHO_OFF

#ifdef	TELNETD
# ifndef  NODEFTELNETDN
#  ifndef  TELNETD1
#   define TELNETD1 "/usr/etc/in.Telnetd\0<-- TELNETD1 patch area -->"
#   define TELNETN1 "in.telnetd\0<-- TELNETN1 patch area -->"
#  endif   TELNETD1
#  ifndef  TELNETD2
#   define TELNETD2 "/usr/etc/in.telnetd\0<-- TELNETD2 patch area -->"
#   define TELNETN2 "in.telnetd\0<-- TELNETN2 patch area -->"
#  endif   TELNETD2
# endif  NODEFTELNETDN
#endif	TELNETD

#ifndef   ALIAS1_PREFIX
# ifndef  NOALIAS1_PREFIX
#  define ALIAS1_PREFIX	"uk.ac.\0<-- ALIAS1_PREFIX patch area -->"
# endif   NOALIAS1_PREFIX
#endif    ALIAS1_PREFIX

#ifndef   ALIAS2_PREFIX
# ifndef  NOALIAS2_PREFIX
#  define ALIAS2_PREFIX	"uk.co.\0<-- ALIAS2_PREFIX patch area -->"
# endif   NOALIAS2_PREFIX
#endif    ALIAS2_PREFIX

#ifndef   ALIAS3_PREFIX
#define   ALIAS3_PREFIX (char *) 0
#endif    ALIAS3_PREFIX
#ifndef   ALIAS4_PREFIX
#define   ALIAS4_PREFIX (char *) 0
#endif    ALIAS4_PREFIX
#ifndef   ALIAS5_PREFIX
#define   ALIAS5_PREFIX (char *) 0
#endif    ALIAS5_PREFIX
#ifndef   ALIAS6_PREFIX
#define   ALIAS6_PREFIX (char *) 0
#endif    ALIAS6_PREFIX
#ifndef   ALIAS7_PREFIX
#define   ALIAS7_PREFIX (char *) 0
#endif    ALIAS7_PREFIX
#ifndef   ALIAS8_PREFIX
#define   ALIAS8_PREFIX (char *) 0
#endif    ALIAS8_PREFIX
#ifndef   ALIAS9_PREFIX
#define   ALIAS9_PREFIX (char *) 0
#endif    ALIAS9_PREFIX
#ifndef   ALIAS10_PREFIX
#define   ALIAS10_PREFIX (char *) 0
#endif    ALIAS10_PREFIX
#ifndef   ALIAS11_PREFIX
#define   ALIAS11_PREFIX (char *) 0
#endif    ALIAS11_PREFIX
#ifndef   ALIAS12_PREFIX
#define   ALIAS12_PREFIX (char *) 0
#endif    ALIAS12_PREFIX
#ifndef   ALIAS13_PREFIX
#define   ALIAS13_PREFIX (char *) 0
#endif    ALIAS13_PREFIX
#ifndef   ALIAS14_PREFIX
#define   ALIAS14_PREFIX (char *) 0
#endif    ALIAS14_PREFIX
#ifndef   ALIAS15_PREFIX
#define   ALIAS15_PREFIX (char *) 0
#endif    ALIAS15_PREFIX
#ifndef   ALIAS16_PREFIX
#define   ALIAS16_PREFIX (char *) 0
#endif    ALIAS16_PREFIX
#ifndef   ALIAS17_PREFIX
#define   ALIAS17_PREFIX (char *) 0
#endif    ALIAS17_PREFIX
#ifndef   ALIAS18_PREFIX
#define   ALIAS18_PREFIX (char *) 0
#endif    ALIAS18_PREFIX
#ifndef   ALIAS19_PREFIX
#define   ALIAS19_PREFIX (char *) 0
#endif    ALIAS19_PREFIX
#ifndef   ALIAS20_PREFIX
#define   ALIAS20_PREFIX (char *) 0
#endif    ALIAS20_PREFIX

#ifndef	STTY_IGN
#define	STTY_IGN	-1
#endif	STTY_IGN

#ifndef	INTR
#define	INTR		0
#endif	INTR

#ifndef	IDLE_GRACE
#define	IDLE_GRACE	(60*2)
#endif	IDLE_GRACE

#ifndef	IDLE_TIMEOUT
#define	IDLE_TIMEOUT	0
#endif	IDLE_TIMEOUT

#define	STARTSERVER	"-STARTSERVER-"
#ifndef	SERVICE
#define SERVICE		"spad\0<-- SERVICE patch area -->"
#endif	SERVICE
#ifndef	SERVICEG	/* alt. service for debugging */
#define SERVICEG	"spadg\0<-- SERVICEG patch area -->"
#endif	SERVICEG

#ifndef	SYSTEM_HOME	/* if not using $HOME/.spad.rc, use this */
#define	SYSTEM_HOME	"/etc"
#endif

#define	MAX_INIT_COMM	10	/* Allow 10 initial commands */
/* DEFINITIONS for use with scripts */

#define MAXMATCH 128
#define MATCHMASK (MAXMATCH-1)
#define MATCHTIMO 120		/* seconds */

#define	P_1	1
#define	P_2	2
#define	P_3	3
#define	P_4	4
#define	P_5	5
#define	P_6	6
#define	P_7	7
#define	P_8	8
#define	P_9	9
#define	P_10	10
#define	P_11	11
#define	P_12	12
#define	P_13	13
#define	P_14	14
#define	P_15	15
#define	P_16	16
#define	P_17	17
#define	P_18	18

#define	P_LOCAL	P_18+1
#define	P_BASE	P_LOCAL
#define	P_BRKIN	P_BASE+0
#define	P_DEBUG	P_BASE+1
#define	P_VERB	P_BASE+2
#define	P_UESC	P_BASE+3
#define	P_8BIT	P_BASE+4
#define	P_IDLE	P_BASE+5
#define	P_INTR	P_BASE+6
#define	P_MAX	P_INTR

#define param1 params[1]
#define param2 params[2]
#define param3 params[3]
#define param4 params[4]
#define param5 params[5]
#define param6 params[6]
#define param7 params[7]
#define param8 params[8]
#define param9 params[9]
#define param10 params[10]
#define param11 params[11]
#define param12 params[12]
#define param13 params[13]
#define param14 params[14]
#define param15 params[15]
#define param16 params[16]
#define param17 params[17]
#define param18 params[18]
#define breakinch params[P_BRKIN]
#define debug params[P_DEBUG]
#define verbose params[P_VERB]
#define unixesc params[P_UESC]
#define eightbitoutput params[P_8BIT]
#define	idle_timeout   params[P_IDLE]
#define	intr   params[P_INTR]

#define	D_GEN		1
#define	D_1_		1
#define	D_2_		2
#define	D_4_		4

#define	V_1_		1
#define	V_2_		2
#define	V_4_		4
#define	V_8_		8
#define	V_10_		0x10
#define	V_20_		0x20
#define	V_40_		0x40
#define	V_RUBOUT	0x80
#define	V_100_		0x100

/* BUFFERS and file numbers */
#define ttybuf (x25io_tty.x_buf)
#define	DEL	0xff

#define	clientmes2(p, f, v, w)	clientmes3(p, f, /* NOSTRICT*/ v, w, 0)
#define	clientmes1(p, f, v)	clientmes2(p, f, /* NOSTRICT*/ v, 0)
#define	clientmes0(p, f)	clientmes1(p, f, 0)

#if	!defined(_XOPEN_SOURCE) && defined(__svr4__)
#define	_XOPEN_SOURCE	/* for popen under SunOS 5 */
#include <stdio.h>
#undef	_XOPEN_SOURCE	/* for popen under SunOS 5 */
#else
#include <stdio.h>
#endif

#include <string.h>
#include <errno.h>
#include <signal.h>		/* also needed for script timeouts */
#ifndef	NO_UNISTD
#include <unistd.h>		/* for R_OK */
#else
#include <sys/file.h>		/* for R_OK */
#endif

#ifdef	TELNETD
#include <arpa/telnet.h>	/* for IAC, WILL and TELOPT_ECHO */
#endif	TELNETD

enum role {SERVER, CLIENT, DIRECT};


#if	defined(MEMCPY) || defined(__svr4__) || defined(__hpux__)
#define	bcopy(from, to, n)	memcpy(to, from, n)
#endif	MEMCPY

#if	defined(MEMSET) || defined(__svr4__) || defined(__hpux__)
#define	bzero(ptr, n)		memset(ptr, 0, n)
#endif	MEMSET

#if	defined(STRCHR) || defined(__svr4__) || defined(__hpux__)
#define index			strchr
#define rindex			strrchr
#endif	STRCHR

#if	!defined(NOSGTTY) && (defined(__hpux__) || defined(__hpux))
#define	NOSGTTY
#endif

#if	!defined(fd_set) && (defined(__hpux__))
#define	fd_set	int
#endif

#include <sys/ioctl.h>

/* ------------------- Try to get the tty interface --------------------- */
#ifndef	NOSGTTY
#include <sgtty.h>
#endif	NOSGTTY

#ifdef	CBREAK
#define	TCHARS
#define	SGTTYB
#else	CBREAK
#undef	HUPCL
#undef	TIOCHPCL
#undef	TIOCGETP
#undef	TIOCSETP
#ifndef	FLUSHTTY
#undef	TIOCSETN
#endif
#undef	TIOCEXCL
#undef	TIOCNXCL
#include <termio.h>
#ifdef	ISIG
#define	TERMIO
#endif	ISIG
#endif	CBREAK
/* ------------------- Try to get the tty interface --------------------- */

#ifdef sun
#ifdef	SGTTYB
#ifndef	_SGTTYB_
/* -------------------- mucho sun cock up -------------------- */
#undef	_IOCTL_
#define	tchars	DUP_tchars
#define	ltchars	DUP_ltchars
#define	ttysize	DUP_ttysize
#include <sys/ioctl.h.old>
#undef	tchars
#undef	ltchars
#undef	ttysize
/* -------------------- mucho sun cock up -------------------- */
#endif	_SGTTYB_
#endif	SGTTYB
#endif	sun

#include <sys/types.h>
#ifndef	MLEN
#include <sys/mbuf.h>		/* just for MLEN! */
#endif	MLEN
#include <sys/socket.h>
#ifdef	NOSYSTIME
#include <time.h>
#else	NOSYSTIME
#include <sys/time.h>
#endif	NOSYSTIME

#ifdef	TERMIO
#define	TERM_L_MASK_RAW		ICANON
#define	TERM_L_MASK_COOKED	ECHO
#define	TERM_L_MASK		(TERM_L_MASK_RAW | TERM_L_MASK_COOKED)

#define	TERM_I_MASK_RAW		0
#define	TERM_I_MASK_COOKED	0
#define	TERM_I_MASK_BOTH	( ISTRIP | INLCR | IGNCR | ICRNL )
#define	TERM_I_MASK		(TERM_I_MASK_RAW | TERM_I_MASK_COOKED | TERM_I_MASK_BOTH)

#define	TERM_C_MASK_RAW		0
#define	TERM_C_MASK_COOKED	0
#define	TERM_C_MASK_BOTH	( CS8 )
#define	TERM_C_MASK		(TERM_C_MASK_RAW | TERM_C_MASK_COOKED | TERM_C_MASK_BOTH)
#endif	TERMIO

#ifdef	SIGCONT
void resume();
#endif	SIGCONT



#define MAXCMDP 30		/* max number of words on a command line */
#define	CMND_LINE_LEN	(80*10)	/* Users wont give more than this ... */

#define	CF_TEXT		1	/* the args are text, so leave alone */
#define	CF_ASIS		2	/* pass the rest of line as a single arg */
#define	CF_RESTRICT	4	/* This is a restricted command */
#define	CF_SUSPEND	8	/* This will cause a suspension */

/* (client portion can run on other machines) */

#if defined(sun) && defined(SERVERCODE)
#include <sundev/syncstat.h>	/* for struct ss_dstats &tc. */
#include <netx25/x25_ctl.h>	/* for out-of-band types */
#include <netx25/x25_pk.h>
#include <netx25/x25_ioctl.h>

/* Try to guess which SUNLINK bugs there are ... */
#ifndef	NO_GUESS_SUN_BUGS
#ifndef	X25_RD_LINKADR
#define	NO_RESET
#endif	/* X25_RD_LINKADR */
#endif	/* NO_GUESS_SUN_BUGS */

#endif /* sun && SERVERCODE */

#ifdef	DEXPAND
#include "cci.h"
extern struct ccontrolp contp;
extern int circuit;
#endif	DEXPAND

#include <netinet/in.h>
#include <netdb.h>
#include <ctype.h>

#define	FULL_X25STR
#include "x25b.h"

/* structure for logging accounting info. */
#ifdef SERVERCODE
struct x25log {
  short	struct_len;		/* length of this struct */
  char	version;		/* Struct version number */
  char	username[9];
  struct in_addr userhost;
  char	hostnum[MAXHOSTADR];	/* DTE */
  unsigned char	hostcudf[MAXCUDF];	/* Call User Data Field */
  char	hostname[40];		/* Name requested */
  time_t start;			/* session times */
  time_t finish;
  int	pktsout;
  int	bytesout;
  int	pktsin;
  int	bytesin;
  int	struct_len2;		/* in case looking backwards ! */
  char	version2;
  char	format;
};
#endif	SERVERCODE

#ifdef	NRSDBM
#include "opts.h"
#include "nrs.h"
#endif	NRSDB

enum tokens {
T_0,
T_8BIT,
T_ALL,
T_BG,
T_BREAK,
T_BRKIN,
T_DEBG,
T_ECHO,
T_EDIT,
T_ELIH,
T_ELH,
T_ENDH,
T_FORCE,
T_FORW,
T_IDLE,
T_IFH,
T_IGNR,
T_INTR,
T_HELP,
T_LFI,
T_LOG,
T_NONE,
T_OFF,
T_ON,
T_PARAM,
T_PIPE,
T_QUIT,
T_READ,
T_RESET,
T_SET,
T_SHOW,
T_STAT,
T_SUSP,
T_TIMEO,
T_CLR,
T_DISC,
T_PROF,
T_PAR,
T_UESC,
T_UFORC,
T_VERB
};

struct cmds {
  char *c_cmd;			/* what the user types */
  int  c_min;			/* minimum number of characters */
  enum tokens c_token;		/* what it means */
  enum tokens c_htoken;		/* which list of help messages */
  enum tokens c_helpcontext;	/* when we print the help message */
  char *c_helpms;		/* and the useful info */
  int  c_flags;			/* What type it is ... */
};


struct char_full_addr {
	char	*name;			/* NAME= */
	char	*link;			/* LINK= */
	char	*context;		/* CONTEXT= */
	char	*addr_space;		/* AS= */
	char	*mac_addr;		/* MAC=,	M= */
	char	*lsel;			/* LSEL= */
	char	*cd_nsap;		/* CALLED_NSAP=,CD_NSAP=,	NSAP=,	N= */
	char	*cg_nsap;		/* CALLING_NSAP=,CG_NSAP=, CG_N= */
	char	*dte;			/* DTE= */
	char	*cudf;			/* CUDF=,	D= */
	char	*ybts;			/* YBTS= */
};
struct char_full_addr called_char_addr;


extern char *re_comp();

extern int sys_nerr;
extern char *sys_errlist[];

extern char *getenv();
extern char *index();
extern char *rindex();
extern char *malloc();
extern char *ctime();
extern char *strcpy(), *strcat(), *strncpy();
extern char *getsender();
extern char *nl();

extern void logerr();
extern char *findusername();
extern int sess_idle_logout();
extern char * find_rfc931();
extern void setforward();

#endif	/* EXTERN_SET */

#ifndef	EXTERN
#define	UNDEF_EXTERN
#define	EXTERN
#endif	/* EXTERN */

EXTERN enum role role;

extern int optind;
EXTERN char *optarg;
EXTERN int errno;
EXTERN int initial_verbose;

#ifdef	TELNETD
EXTERN char trrste;
EXTERN char trrstm;
EXTERN char	hisopts[256];
EXTERN char	myopts[256];
EXTERN char	doopt[5];
EXTERN char	dont[5];
EXTERN char	will[5];
EXTERN char	wont[5];

EXTERN char	tel_sender[80];
EXTERN char	tel_defsend[80];
#endif	TELNETD



EXTERN char *calling_dte;
EXTERN int  calling_dte_malloced;

EXTERN char *service;
#ifdef	SERVICEFORM
EXTERN char *service_form;
#endif	SERVICEFORM
EXTERN char service_buf[128];
EXTERN char *accntfile;
EXTERN char *errfile;
EXTERN char *rfc931user;
EXTERN int  timeout_rfc931;

EXTERN int xindex;
EXTERN char suspendc;
EXTERN char localhost[128];
EXTERN char stdoutbuf[BUFSIZ];
EXTERN int  pktisize;
#ifdef	POLL_INTERVAL
EXTERN long poll_interval;
#endif	POLL_INTERVAL
EXTERN int  pktosize;
EXTERN int  suspendedy;
EXTERN int  stty_ign;
EXTERN int  ignore_cont;
EXTERN FILE *reading;	/* Am reading from this file (not tty) */
EXTERN int  reading_pipe;
EXTERN int  rawtty;
EXTERN int  have_settty;	/* Have I ever setttu'ed ? */
EXTERN int  linemode;
EXTERN int  forbid_some_pad_cmds;
EXTERN int  forbid_suspend;
EXTERN int  print_banner;
EXTERN int  idle_warns;
EXTERN int  idle_grace;
EXTERN int  system_rc;	/* Use system rc file -- not $HOME one */
#ifdef	TELNETD
EXTERN int force_echo_on;
EXTERN int force_echo_off;
EXTERN int x_mode;
EXTERN int y_mode;
EXTERN int telnet_verbose;
EXTERN int  telnetd;	/* Am I telnet code invoked by inetd */
EXTERN int  native_telnet; /* Leave the TCP link in native mode ? */
#endif	TELNETD
/* COMMUNICATIONS definitions and data structures */
#if defined(sun) && defined(SERVERCODE)
EXTERN CONN_DB add;
#endif

#ifdef	SERVERCODE
/*extern char *dte;			** the man we're calling */
EXTERN char sender[80];
#endif	SERVERCODE

EXTERN struct x25io x25ibuf, x25obuf, x25sbuf, x25io_tty;

EXTERN int	pktsout;
EXTERN int	bytesout;
EXTERN int	pktsin;
EXTERN int	bytesin;

#ifdef	TELNETD
EXTERN char *nullenv[1];
EXTERN char *oldenv[5];
#endif	TELNETD

EXTERN char *alias[20];
EXTERN int aliases;
EXTERN char format[20];

EXTERN int clienttoserver;		/* client internet socket */
EXTERN FILE *termlogf;			/* for logging the terminal session */
EXTERN int  use_termlogf;		/* logging at the moment ? */

EXTERN char matchbuf[MAXMATCH];

EXTERN int matchindex;
EXTERN int matchnchars;
EXTERN int matchlen;
EXTERN char *matchp;
EXTERN FILE *matchf;
EXTERN char *scrfn;			/* script file name */
EXTERN int matching;
EXTERN int batch;			/* => run with no terminal (from, eg, "at" */
EXTERN char *init_comms[MAX_INIT_COMM];
EXTERN int init_commn;
EXTERN int ybts;			/* is this a YBTS connection ? */
EXTERN int ts29;			/* is this a TS29 connection ? */
EXTERN int echoing;			/* should there be echoing now ? */
/* PAD PARAMETER handling */

EXTERN char forwardvec[128];		/* when shall I forward? */
EXTERN char forwarding;		/* Shall I do you now, Sir? */

EXTERN int params[P_MAX +1];
EXTERN int ignore_p[P_MAX +1];
EXTERN int preset_p[P_MAX +1];
EXTERN int preset_b[P_MAX +1];
EXTERN char def_service[];

#ifdef	SECURITY
EXTERN char	allow[6];
EXTERN char	block[6];
EXTERN char	nolog[6];
EXTERN char	skip[5];
#define	SKIPLEN		(sizeof skip -1)
EXTERN int	dontlog;
#endif	SECURITY
EXTERN int	eightbitinput;
EXTERN char	*prof_file;
EXTERN char	*sysprof_file;
EXTERN char	*qual_serv;
EXTERN char	*exp_text;
EXTERN char	*unqual_data;

EXTERN int  addr_pos;
EXTERN int  addr_spaces;
#define	MAX_ADDR_SPACES	20
EXTERN char *addr_space[MAX_ADDR_SPACES];

EXTERN char *port;
/*extern char *dest; */
EXTERN char *x25_link;
EXTERN int termwidth;
EXTERN int last_ts29_push;		/* first read is accept info */
EXTERN int reverse_charge;

#ifdef SERVERCODE
EXTERN char app_relay[256];
#endif

#ifdef	SERVERCODE
EXTERN struct x25log x25log;

EXTERN int s;	/* s is the socket to x25 software (not used in client) */
EXTERN struct sockaddr_in s_in, from;
EXTERN int servertoclient;		/* server internet socket */
#else	SERVERCODE
#ifdef	TELNETD
EXTERN struct sockaddr_in from;
#endif	TELNETD
#endif	SERVERCODE

#ifdef	SGTTYB
EXTERN struct sgttyb sgttyba, sgttybb;	/* one for alteration, one for keeps */
#endif	SGTTYB
#ifdef	TCHARS
EXTERN struct tchars tcharsa, tcharsb;
#endif	TCHARS
#ifdef	TERMIO
EXTERN struct termio termioa, termiob;
#endif	TERMIO
#ifdef	TIOCGLTC
EXTERN struct ltchars ltchara, ltcharb;		/* for t_suspc */
#endif	TIOCGLTC
#ifdef	TIOCLSET
EXTERN int	lmode;				/* local mode word */
#endif	TIOCLSET


#ifdef	UNDEF_EXTERN
#undef	UNDEF_EXTERN
#undef	EXTERN
#endif	/* UNDEF_EXTERN */

#if	!defined(SIG_VOIDSTAR) && (defined(__ultrix__)|| defined(__osf__) || defined(__hpux__) || defined(__svr4__))
#define	SIG_VOIDSTAR
#endif

/* e.g. SYS VR4 */
#ifdef	SIG_VOIDSTAR
#define	SIGARG2	(void(*)())
#endif

#ifndef	SIGARG2
#define	SIGARG2
#endif

#ifdef	__linux__
#define	stdio_bytes_buffered(fp) ((fp)->_egptr - (fp)->_gptr)
#else
#define stdio_bytes_buffered(fp) ((fp)->_cnt)
#endif
