/*
   hist_key: a key has been found in the history file.  After error
   checking, set up the list structure for the key.

   Kenneth Ingham

   Copyright (C) The University of New Mexico
*/

#include "defs.h"

hist_key(line, cmd_ptr, key_ptr, value_ptr)
char *line;
struct old_cmd_st **cmd_ptr;
struct key_st **key_ptr;
struct val_st **value_ptr;
{
	if (*cmd_ptr == NULL) {
		printf("Bad history file: keyword found before pipeline.\n");
		printf("Ignoring history file.\n");
		return FAIL;
	}

	/* is this the first key for this command? */
	if ((*cmd_ptr)->keys == NULL) {
		(*cmd_ptr)->keys = allocate(struct key_st);
		*key_ptr = (*cmd_ptr)->keys;
	}
	else {
		(*key_ptr)->next = allocate(struct key_st);
		*key_ptr = (*key_ptr)->next;
	}

	(*key_ptr)->next = NULL;
	(*key_ptr)->vals = NULL;
	(*key_ptr)->key_value = strsave(&line[1]);
	*value_ptr = NULL;

	return SUCCESS;
}
