/*
   get_rel_field: we have a relative output format and want a certain
   field from it.  Place the field in 'value' if it exists and return a
   pointer to the string.  If there are problems place a null terminated
   zero length string in 'value' and return NULL as an error condition.

   Kenneth Ingham

   Copyright (C) 1987 The University of New Mexico
*/

#include "defs.h"

char *
get_rel_field(line, field, value)
char *line, *value;
int field;
{
	int i;
	int nfields;
	char *vec[MAX_VEC];

	value[0] = '\0';

	/* break up the line */
	nfields = line_to_vec(line, vec, " \t");

	/* error checking */
	if (nfields <= 0) {
		fprintf(stderr, "'%s' didn't break up into fields.\n",line);
		return NULL;
	}
	if (nfields < field) {
		fprintf(stderr, "Warning: '%s' has only %d fields, not %d\n",
			line, nfields, field);
		return NULL;
	}

	(void) strcpy(value, vec[field-1]);

	for (i=0; i<nfields; i++)
		free(vec[i]);

	return value;
}
