/*
   abs_check: verify that the value has not changed more than the
   allowed absolute amount.

   Kenneth Ingham

   Copyright (C) 1988 The University of New Mexico
*/

#include "defs.h"
#include "y.tab.h"

abs_check(current, prev_val, allowable, cmd, name, line)
char *current;
double allowable;
struct everything *prev_val;
char *cmd, *name, *line;
{
	extern int line_ok;
	double change, previous, value;
	double to_double();

	previous = to_double(prev_val);
	value = atof(current);

	change = value - previous;
	if (change > allowable) {
		if (line_ok) {
			printf("%s had %s change by more than %.2f.\n",
				cmd, name, allowable);
			printf("%s\n",line);
		}
		else {
			printf("Also, it had %s change by more than %.2f.\n",
				name, allowable);
		}
		printf("Previous value %.2f; ",previous);
		printf("current value %.2f.\n", value);
		line_ok = False;
	}
}
