/*
   tchar: convert from an output format type back to the character
   which represents it.

   Kenneth Ingham

   Copyright (C) 1988 The University of New Mexico
*/

#include "defs.h"
#include "y.tab.h"

/*
  structure used to map types back to to characters for printing out
*/
struct type_char {
	int type;
	char c;
};


char
tchar(type)
int type;
{
	int i;
	static struct type_char types[] = {
		{ STRING, 	's'},
		{ INTEGER,	'd'},
		{ FLOAT,	'f'},
		{ KEY,		'k'},
		{ 0,		'\0'}
	};

	for (i=0; types[i].type && types[i].type != type; i++)
		;

	if (types[i].type == NULL) {
		fprintf(stderr, "Internal error, unknown output format ");
		fprintf(stderr, "type %d\n", type);
		exit(1);
	}

	return types[i].c;
}
