/*
   pp_out: pretty print the output of command structure.

   Kenneth Ingham

   Copyright (C) 1987 The University of New Mexico
*/

#include "defs.h"
#include "y.tab.h"

pp_out(of)
struct out_fmt_st *of;
{
	struct rel_out_st *rp;
	struct col_out_st *cp;
	char tchar();

	switch(of->type) {
		case RELATIVE:
			rp = of->out_fmt.rel_fmt;
			while (rp != NULL) {
				printf(" %d %s %%%c", rp->field, rp->name,
					tchar(rp->type));
				rp = rp->next;
			}
			break;
		case COLUMN:
			cp = of->out_fmt.col_fmt;
			while (cp != NULL) {
				printf(" %d-%d %s %%%c", cp->start, cp->end,
					cp->name, tchar(cp->type));
				cp = cp->next;
			}
			break;
		default:
			fprintf(stderr, "Impossible value for output ");
			fprintf(stderr, "format.  type: %d\n", of->type);
			break;
	}
}
