/*
   open_cf: open the control file.  It is either specified on the
   command line or DEF_CONTROL or DEF_CONTROL2.

   To make life easier dealing with lex, the control file is opened as
   stdin.

   Kenneth Ingham

   Copyright (C) 1987 The University of New Mexico
*/

#include "defs.h"

open_cf()
{
	extern char *controlname;
	extern int cflag;
	extern int errno;
	extern char *sys_errlist[];
	FILE *cf;

	if (cflag) { /* specified control file */
		cf = freopen(controlname, "r", stdin);
		if (cf == NULL) {
			fprintf(stderr, "Unable to open '%s': %s\n",
				controlname, sys_errlist[errno]);
			exit(1);
		}
	}
	else { /* try defaults */
		if ((cf = freopen(DEF_CONTROL, "r", stdin)) == NULL) { /* #1 */
			if ((cf = freopen(DEF_CONTROL2, "r", stdin)) == NULL) { /*#2*/
				fprintf(stderr, "Unable to open %s or %s: %s\n",
					DEF_CONTROL, DEF_CONTROL2,
					sys_errlist[errno]);
				exit(1);
			}
			/* if we're here #2 must have worked */
			controlname = DEF_CONTROL2;
		}
		else
			/* if we're here #1 must have worked */
			controlname = DEF_CONTROL;
	}
}
