/*
   hist_value: a value has been found in the history file.  Insert it
   into the list.

   Kenneth Ingham

   Copyright (C) 1988 The University of New Mexico
*/

#include "defs.h"
#include "y.tab.h"

hist_value(line, key_ptr, value_ptr)
char *line;
struct key_st **key_ptr;
struct val_st **value_ptr;
{
	unsigned int len;
	char *sp, *strnsave();

	/* consistency check */
	if (*key_ptr == NULL) {
		printf("Bad history file: value found before keyword.\n");
		printf("Ignoring history file.\n");
		return FAIL;
	}

	/* is this the first value for this key? */
	if ((*key_ptr)->vals == NULL) {
		(*key_ptr)->vals = allocate(struct val_st);
		*value_ptr = (*key_ptr)->vals;
	}
	else {
		(*value_ptr)->next = allocate(struct val_st);
		*value_ptr = (*value_ptr)->next;
	}

	(*value_ptr)->next = NULL;

	/* 
	   find the space which separates the name from the type, then
	   get the name
	*/
	sp = index(&line[2], ' ');
	if (sp == NULL) {
		printf("Garbled history file; no name-type sep.\n");
		printf("Ignoring history file.\n");
		return FAIL;
	}
	len = sp - &line[2];
	(*value_ptr)->name = strnsave(&line[2], len);
	(*value_ptr)->name[len] = '\0';

	sp++; /* sp now points at the type, sp+2 is the first char of val */
	if (!*(sp+1) || !*(sp+2)) {
		printf("Garbled history file; no value.\n");
		printf("Ignoring history file.\n");
		return FAIL;
	}

	switch (*sp) {
		case 's':
			(*value_ptr)->val.type = STRING;
			(*value_ptr)->val.data.string = strsave(sp+2);
			break;
		case 'f':
			(*value_ptr)->val.type = FLOAT;
			(*value_ptr)->val.data.real = atof(sp+2);
			break;
		case 'd':
			(*value_ptr)->val.type = INTEGER;
			(*value_ptr)->val.data.integer = atoi(sp+2);
			break;
		default:
			/* bad condition */
			printf("Unknown data type in history file.\n");
			printf("Offending line: %s\n",line);
			printf("Ignoring history file.\n");
			return FAIL;
			break;
	}

	return SUCCESS;
}
