/*
   do_args: parse the comand line arguments and set variables related to
   them.

   See main for description of flags.

   Kenneth Ingham

   Copyright (C) 1987 The University of New Mexico
*/

#include "defs.h"

do_args(argc, argv)
int argc; 
char *argv[];
{
	extern int pflag, cflag, vflag, nflag, lexverbose;
	extern char *controlname, *histfilename, *myname;

	register int i;
	char *slash;

	/* remember who we are */
	myname = argv[0];
	/* if we have a pathname for a name, keep only the last component */
	if ((slash = rindex(myname, '/')) != NULL)
		myname = slash+1;

	/* defaults */
	pflag = False; cflag = False; vflag = False; nflag = False;
	lexverbose = False;
	histfilename = DEF_HISTFILE;

	for (i=1; i<argc; i++) {
		if (argv[i][0] == '-') {
			switch(argv[i][1]) {
			case 'v':	/* verbse */
				vflag = True;
				break;
			case 'p':	/* pretty-print control file */
				pflag = True;
				break;
			case 'h':	/* specify history file */
				i = getargv(&histfilename, argv, i,
				    "history file name");
				break;
			case 'f':	/* specify control file */
				i = getargv(&controlname, argv, i,
					"controlfile name");
				cflag = True;
				break;
			case 'n':	/* no history */
				nflag = True;
				break;
			default:
				fprintf(stderr, "Unknown flag '%s'\n", argv[i]);
				exit(1);
			}
		}
	}
	if (pflag && vflag)
		lexverbose = True;
}
