/*
   build_rel: build a relative output format structure for the parser

   Kenneth Ingham

   Copyright (C) 1988 The University of New Mexico
*/

#include "defs.h"
#include "y.tab.h"

struct rel_out_st *
build_rel(field, name, type)
char *name, *type;
int field;
{
	extern struct out_fmt_st *key;
	extern int parse_error;
	extern char *myname;
	struct rel_out_st *p;

	p = allocate(struct rel_out_st);
	p->name = name;
	p->field = field;
	p->next = NULL;

	if (type[1] != '\0' || index("dfsk", type[0]) == NULL) {
		fprintf(stderr,"%s: Invalid type specifier ", myname);
		fprintf(stderr,"'%s' for '%s' (rel fmt).\n", type, p->name);
		fprintf(stderr, "Expecting one of 'dfsk'\n");
		parse_error = True;
		return p;
	}

	switch (type[0]) {
		case 'd':
			p->type = INTEGER;
			break;
		case 'f':
			p->type = FLOAT;
			break;
		case 's':
			p->type = STRING;
			break;
		case 'k':
			p->type = KEY;
			key = allocate(struct out_fmt_st);
			key->out_fmt.rel_fmt = p;
			key->type = COLUMN;
			break;
		default:
			/* checked in if above */
			fprintf(stderr,"impossible condition in build_rel\n");
			exit(1);
	}

	return p;
}
