/*
  build_col: build a column out structure for the parser.

  Kenneth Ingham

  Copyright (C) 1988 The University of New Mexico
*/

#include "defs.h"
#include "y.tab.h"

struct col_out_st *
build_col(start, end, name, type)
char *name, *type;
int start, end;
{
	extern struct out_fmt_st *key;
	extern int parse_error;
	extern char *myname;
	struct col_out_st *p;

	p = allocate(struct col_out_st);
	p->name = name;
	p->start = start;
	p->end = end;
	p->next = NULL;

	if (type[1] != '\0' || index("dfsk", type[0]) == NULL) {
		fprintf(stderr,"%s: Invalid type specifier ", myname);
		fprintf(stderr,"'%s' for '%s' (col fmt).\n", type, p->name);
		fprintf(stderr, "Expecting one of 'dfsk'\n");
		parse_error = True;
		return p;
	}

	switch (*type) {
		case 'd':
			p->type = INTEGER;
			break;
		case 'f':
			p->type = FLOAT;
			break;
		case 's':
			p->type = STRING;
			break;
		case 'k':
			p->type = KEY;
			key = allocate(struct out_fmt_st);
			key->out_fmt.col_fmt = p;
			key->type = COLUMN;
			break;
		default:
			/* checked above in if */
			fprintf(stderr,"Impossible condition in build_col\n");
			exit(1);
	}

	if (start > end) {
		fprintf(stderr,"%s: start %d larger than end %d!\n",
			myname, start, end);
		parse_error = True;
	}

	return p;
}
