/*
 * interface for System V pattern matchers
 */
#include "passwd.h"

/*
 * set up some things on a per-system basis here
 */
#define INIT		register char *sp = instring;
#define GETC()		(*sp++)
#define PEEKC()		(*sp)
#define UNGETC(c)	(--sp)
#define RETURN(c)	return;
#define ERROR(c)	regerr(c)
#include <regexp.h>

/*
 * global variables
 */
static char *pattern;		/* points to typed-in pattern */
static char patcomp[BUFSIZ];	/* buffer for compiled pattern */

/*
 * smatch -- set up the pattern to be matched; bomb on error
 */
int smatch(pat)
char *pat;			/* pattern to be matched */
{
	pattern = pat;
	(void) compile(pat, patcomp, &patcomp[BUFSIZ], '\0');
	return(0);
}

/*
 * match -- compare a string to the compiled pattern
 */
match(str)
char *str;			/* string to be compared */
{
	/*
	 * compare appropriately
	 */
	return(step(str, patcomp));
}

/*
 * regerr -- pattern matching error handler
 */
regerr(n)
int n;				/* number of error */
{
	char buf[BUFSIZ];	/* buffer for error message */

	switch(n){
	case 11:
		SPRINTF(buf, "%s: range endpoint too large", pattern);
		break;
	case 16:
		SPRINTF(buf, "%s: bad number", pattern);
		break;
	case 25:
		SPRINTF(buf, "%s: \"\\digit\" out of range", pattern);
		break;
	case 36:
		SPRINTF(buf, "%s: illegal or missing delimiter", pattern);
		break;
	case 41:
		SPRINTF(buf, "%s: no remembered search string", pattern);
		break;
	case 42:
		SPRINTF(buf, "%s: \\( \\) imbalance", pattern);
		break;
	case 43:
		SPRINTF(buf, "%s: too many \\(", pattern);
		break;
	case 44:
		SPRINTF(buf, "%s: more than 2 numbers given in \\{ \\}", pattern);
		break;
	case 45:
		SPRINTF(buf, "%s: } expected after \\", pattern);
		break;
	case 46:
		SPRINTF(buf, "%s: first number exceeds second in \\{ \\}", pattern);
		break;
	case 49:
		SPRINTF(buf, "%s: { } imbalance", pattern);
		break;
	case 50:
		SPRINTF(buf, "%s: regular expression overflow", pattern);
		break;
	default:
		SPRINTF(buf, "%s: unknown regexp error %d", pattern, n);
		break;
	}
	paterr(buf);
}
