#define const
#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <netinet/udp.h>
#include <ctype.h>
#include <sys/time.h>
#include <errno.h>
#include <arpa/tftp.h>

void
checktftp(struct ip *ip, struct udphdr *udp, struct timeval timebuf)
{
     struct in_addr addr;
     unsigned short opcode, port;
     char *what;

     char *data = (char *)udp + sizeof(struct udphdr);
     struct tftphdr *th = (struct tftphdr *)(data);

     memcpy((char *)&port, (char *)&udp->uh_dport, 2);

     if(port == 69){

	  memcpy((char *)&opcode, (char *)&th->th_opcode, 2);

	  what="write";
	  switch(opcode){
	  case RRQ:
	       what="read";
	  case WRQ:
	       outtime(timebuf);
	       printf(" [tftp] ");
	       memcpy((char *)&addr.s_addr, (char *)&ip->ip_src, 4);
	       outhost(addr);
	       memcpy((char *)&port, (char *)&udp->uh_sport, 2);
	       printf(".%d", port);
	       memcpy((char *)&addr.s_addr, (char *)&ip->ip_dst, 4);
	       outhost(addr);
	       printf(" Attempt to %s `%s'.\n",
		      what, &th->th_stuff);
	       fflush(stdout);
	       break;
	  }
     }
}
