 /*
  * utmp_host - extract host name from utmp record, result is static
  * 
  * Author: Wietse Venema <wietse@wzv.win.tue.nl>
  */

#include <sys/types.h>
#include <sys/file.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>

#ifndef O_RDONLY
#include <fcntl.h>
#endif

#include "sys_defs.h"

#ifdef HAS_UTMPX
#include <utmpx.h>
#define _PATH_UTMP	UTMPX_FILE
#else
#include <utmp.h>
#ifdef UTMP_FILE
#define _PATH_UTMP	UTMP_FILE
#endif
#endif

#ifndef _PATH_UTMP
#define _PATH_UTMP      "/etc/utmp"
#endif

#ifndef UT_HOSTSIZE
#define UT_HOSTSIZE	sizeof(((struct UTMP_STRUCT *)0)->ut_host)
#endif

static char name_buf[UT_HOSTSIZE + 2];

/* utmp_host - determine remote hostname from utmp slot */

char   *utmp_host()
{
    struct UTMP_STRUCT utmp;
    int     fd;
    int     slot;

    /*
     * Tack on a '?' to truncated hostnames.
     */
    slot = ttyslot();
    if (slot > 0 && (fd = open(_PATH_UTMP, O_RDONLY, 0)) >= 0) {
	if (lseek(fd, (off_t) (slot * sizeof(utmp)), L_SET) >= 0
	    && read(fd, (char *) &utmp, sizeof(utmp)) == sizeof(utmp)) {
	    strncpy(name_buf, utmp.ut_host, UT_HOSTSIZE);
#ifdef HAS_UTMPX
	    if (utmp.ut_syslen < UT_HOSTSIZE)
		utmp.ut_host[utmp.ut_syslen] = 0;
	    else
#endif
		name_buf[UT_HOSTSIZE] = '?';
	    return (*name_buf ? name_buf : 0);
	}
	close(fd);
    }
    return (0);
}

#ifdef TEST

main()
{
    char   *host;

    host = utmp_host();
    if (host == 0) {
	printf("No hostname information found\n");
	return (1);
    } else {
	printf("%s\n", host);
	return (0);
    }
}

#endif

