.TH SKEY.ACCESS 5
.SH NAME
skey.access \- S/Key password control table
.SH DESCRIPTION
The S/Key password control table (\fIKEYACCESS\fR) is used by
\fIlogin\fR-like programs to determine when UNIX passwords may be used
to access the system.
.IP \(bu
When the table does not exist, there are no password restrictions.  The
user may enter the UNIX password or the S/Key one.
.IP \(bu
When the table does exist, UNIX passwords are permitted only when
explicitly specified.
.IP \(bu
For the sake of sanity, UNIX passwords are always permitted on the
systems console.
.SH "TABLE FORMAT"
The format of the table is one rule per line.  Rules are matched in
order.  The search terminates when the first matching rule is found, or
when the end of the table is reached.
.PP
Rules have the form:
.sp
.in +5
permit condition condition...
.br
deny condition condition...
.in
.PP
where
.I permit
and
.I deny
may be followed by zero or more conditions. Comments begin with a `#\'
character, and extend through the end of the line.  Empty lines or
lines with only comments are ignored.
.PP
A rule is matched when all conditions are satisfied. A rule without
conditions is always satisfied. For example, the last entry could
be a line with just the word
.I deny
on it.
.SH CONDITIONS
.IP "hostname wzv.win.tue.nl"
True when the login comes from host wzv.win.tue.nl.
See the WARNINGS section below.
.IP "internet 131.155.210.0 255.255.255.0"
True when the remote host has an internet address in network
131.155.210.  The general form of a net/mask rule is:
.sp
.ti +5
internet net mask
.sp
The expression is true when the host has an internet address for which
the bitwise and of
.I address
and
.I mask
equals
.IR net.
See the WARNINGS section below.
.IP "port ttya"
True when the login terminal is equal to
.IR /dev/ttya .
Remember that UNIX passwords are always permitted with logins on the
system console.
.IP "user uucp"
True when the user attempts to log in as
.IR uucp .
.IP "group wheel"
True when the user attempts to log in as a member of the
.I wheel
group.
.SH COMPATIBILITY
For the sake of backwards compatibility, the
.I internet
keyword may be omitted from net/mask patterns.
.SH WARNINGS
Several rule types depend on host name or address information obtained
through the network.  What follows is a list of conceivable attacks to
force the system to permit UNIX passwords.
.IP "Host address spoofing (source routing)"
An intruder configures a local interface to an address in a trusted
network and connects to the victim using that source address.  Given
the wrong client address, the victim draws the wrong conclusion from
rules based on host addresses or from rules based on host names derived
from addresses.
.sp
Remedies: (1)  do not permit UNIX passwords with network logins; (2)
use network software that discards source routing information (e.g.
a tcp wrapper).
.PP
Almost every network server must look up the client host name using the
client network address. The next obvious attack therefore is:
.IP "Host name spoofing (bad PTR record)"
An intruder manipulates the name server system so that the client
network address resolves to the name of a trusted host.  Given the
wrong host name, the victim draws the wrong conclusion from rules based
on host names, or from rules based on addresses derived from host
names.
.sp
Remedies: (1) do not permit UNIX passwords with network logins; (2) use
network software that verifies that the hostname resolves to the client
network address (e.g. a tcp wrapper).
.PP
Some applications, such as the UNIX login program, must look up the
client network address using the client host name. In addition to the
previous two attacks, this opens up yet another possibility:
.IP "Host address spoofing (extra A record)"
An intruder manipulates the name server system so that the client host
name (also) resolves to a trusted address.
.sp
Remedies: (1)  do not permit UNIX passwords with network logins; (2)
the skeyaccess() routines ignore network addresses that appear to
belong to someone else.
.SH DIAGNOSTICS
Syntax errors are reported to the syslogd. When an error is found
the rule is skipped.
.SH FILES
KEYACCESS, password control table
.SH AUTHOR
.nf
Wietse Venema
Eindhoven University of Technology
The Netherlands
