/*
 * Sun RPC is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify Sun RPC without charge, but are not authorized
 * to license or distribute it to anyone else except as part of a product or
 * program developed by the user or with the express written consent of
 * Sun Microsystems, Inc.
 *
 * SUN RPC IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 *
 * Sun RPC is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 *
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY SUN RPC
 * OR ANY PART THEREOF.
 *
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even if
 * Sun has been advised of the possibility of such damages.
 *
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */

#if !defined(lint) && defined(SCCSIDS)
static char sccsid[] = "@(#)ti_opts.c	1.3 91/03/11 TIRPC 1.0";
#endif

/*
 *	Copyright 1989 Sun Microsystems, Inc.
 */

#include <stdio.h>
#include <sys/types.h>
#include <tiuser.h>
#include <rpc/rpc.h>
#ifdef _nettli_tiuser_h		/* SunOS 4.1, if true */
#include <nettli/lodg_tli.h>
#else				/* SVR4 */
#include <sys/ticlts.h>
#endif

int
_rpc_negotiate_uid(fd)
int fd;
{
	struct t_optmgmt *options;
	struct t_optmgmt *optionsret;
#ifdef _nettli_tiuser_h
	struct {
		opthdr_t		uid_hdr;
		struct opt_setid	uid_opt;
	} send_in, *opt_out;
#else
	struct {
		struct tcl_opt_hdr	uid_hdr;
		struct tcl_opt_setid	uid_opt;
	} send_in, *opt_out;
#endif
	extern int t_errno;
	extern int errno;

	options = (struct t_optmgmt *)t_alloc(fd, T_OPTMGMT, 0);
	optionsret = (struct t_optmgmt *)t_alloc(fd, T_OPTMGMT, T_OPT);
	if ((options == NULL) || (optionsret == NULL)) {
#ifdef DEBUG
		fprintf(stderr, "No memory\n");
#endif
		return (-1);
	}
#ifdef _nettli_tiuser_h
	send_in.uid_hdr.opt_offset = sizeof (opthdr_t);
	send_in.uid_hdr.next_hdr_offset = 0;
	send_in.uid_opt.type= SETID;
	send_in.uid_opt.id = OPT_UID;
#else
	send_in.uid_hdr.hdr_thisopt_off = sizeof (struct tcl_opt_hdr);
	send_in.uid_hdr.hdr_nexthdr_off = TCL_OPT_NOHDR;
	send_in.uid_opt.setid_type= TCL_OPT_SETID;
	send_in.uid_opt.setid_flg= TCL_IDFLG_UID;
#endif
	options->opt.maxlen = sizeof (send_in);
	options->opt.len = sizeof (send_in);
	options->opt.buf = (char *) &send_in;
	options->flags = T_NEGOTIATE;
	if (t_optmgmt(fd, options, optionsret) == -1) {
#ifdef DEBUG
		fprintf(stderr, "No initial negotiate t_error %d err %d\n",
				t_errno, errno);
#endif
		return (-1);
	}

	options->opt.buf = 0;

	(void) t_free((char *)options, T_OPTMGMT);
	(void) t_free((char *)optionsret, T_OPTMGMT);
	return (0);
}

int
_rpc_get_local_uid(trans, uid_out)
SVCXPRT *trans;
uid_t *uid_out;
{
	struct t_optmgmt *optionsret;

	struct netbuf * abuf;
#ifdef _nettli_tiuser_h
	struct myopts{
		opthdr_t	    uid_hdr;
		struct opt_uid	    uid_opt;
	}  *opt_out;
#else
	struct myopts{
		struct tcl_opt_hdr uid_hdr;
		struct tcl_opt_uid uid_opt;
	}  *opt_out;
#endif

	abuf = (struct netbuf *) trans->xp_p2;
	if (abuf == 0) {
#ifdef DEBUG
		fprintf(stderr, "get_local_uid: null xp_p2\n");
#endif
		return (-1);
	}
	if (abuf->len != sizeof (*opt_out)) {
#ifdef DEBUG
		fprintf(stderr, "get_local_uid: len %d is wrong want %d\n",
			abuf->len, sizeof (*opt_out));
#endif
		return (-1);
	}
	if (abuf->buf == 0) {
#ifdef DEBUG
		fprintf(stderr, "get_local_uid: null data\n");
#endif
		return (-1);
	}
	opt_out= (struct myopts *) abuf->buf;
#ifdef _nettli_tiuser_h
	if (opt_out->uid_opt.type != OPT_UID) {
#ifdef DEBUG
		fprintf(stderr, "get_local_uid: type %d is wrong want %d\n",
			opt_out->uid_opt.type, OPT_UID);
#endif
#else	/* _nettli_tiuser_h */
	if (opt_out->uid_opt.uid_type != TCL_OPT_UID) {
#ifdef DEBUG
		fprintf(stderr, "get_local_uid: type %d is wrong want %d\n",
			opt_out->uid_opt.uid_type, TCL_OPT_UID);
#endif
#endif /* _nettli_tiuser_h */
		return (-1);
	}
#ifdef _nettli_tiuser_h
	*uid_out= opt_out->uid_opt.uid;
#else
	*uid_out= opt_out->uid_opt.uid_val;
#endif
	return (0);
}
