/*
 * Sun RPC is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify Sun RPC without charge, but are not authorized
 * to license or distribute it to anyone else except as part of a product or
 * program developed by the user or with the express written consent of
 * Sun Microsystems, Inc.
 *
 * SUN RPC IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 *
 * Sun RPC is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 *
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY SUN RPC
 * OR ANY PART THEREOF.
 *
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even if
 * Sun has been advised of the possibility of such damages.
 *
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */
/*      @(#)svc_soc.h 1.17 91/03/11 SMI      */

/*
 * svc.h, Server-side remote procedure call interface.
 *
 * Copyright (C) 1984, Sun Microsystems, Inc.
 */

#ifndef _RPC_SVC_SOC_H
#define _RPC_SVC_SOC_H

/*
 * All the following declarations are only for backward compatibility
 * with SUNOS 4.0.
 */

#include <sys/socket.h>
#include <netinet/in.h>

/*
 *  Approved way of getting address of caller
 */
#define svc_getcaller(x) ((struct sockaddr_in *)(x)->xp_rtaddr.buf)

/*
 * Service registration
 *
 * svc_register(xprt, prog, vers, dispatch, protocol)
 *	SVCXPRT *xprt;
 *	u_long prog;
 *	u_long vers;
 *	void (*dispatch)();
 *	int protocol;  /* like TCP or UDP, zero means do not register
 */
#ifdef __cplusplus
extern "C" bool_t svc_register (SVCXPRT *, u_long, u_long, void (*)(struct svc_req *, SVCXPRT *), int);
#elif (__STDC__ || c_plusplus)
extern bool_t svc_register (SVCXPRT *, u_long, u_long, void (*)(struct svc_req *, SVCXPRT *), int);
#else
extern bool_t svc_register ();
#endif

/*
 * Service un-registration
 *
 * svc_unregister(prog, vers)
 *	u_long prog;
 *	u_long vers;
 */
#ifdef __cplusplus
extern "C" void svc_unregister (u_long, u_long);
#elif (__STDC__ || c_plusplus)
extern void svc_unregister (u_long, u_long);
#else
extern void svc_unregister ();
#endif

/*
 * Memory based rpc for testing and timing.
 */
#ifdef __cplusplus
extern "C" SVCXPRT *svcraw_create ();
#elif __STDC__
extern SVCXPRT *svcraw_create (void);
#else
extern SVCXPRT *svcraw_create ();
#endif

/*
 * Udp based rpc. For compatibility reasons
 */
#ifdef __cplusplus
extern "C" SVCXPRT *svcudp_create (int);
extern "C" SVCXPRT *svcudp_bufcreate (int, u_int, u_int);
#elif (__STDC__ || c_plusplus)
extern SVCXPRT *svcudp_create (int);
extern SVCXPRT *svcudp_bufcreate (int, u_int, u_int);
#else
extern SVCXPRT *svcudp_create ();
extern SVCXPRT *svcudp_bufcreate ();
#endif

/*
 * Tcp based rpc.
 */
#ifdef __cplusplus
extern "C" SVCXPRT *svctcp_create (int, u_int, u_int);
extern "C" SVCXPRT *svcfd_create (int, u_int, u_int);
#elif (__STDC__ || c_plusplus)
extern SVCXPRT *svctcp_create (int, u_int, u_int);
extern SVCXPRT *svcfd_create (int, u_int, u_int);
#else
extern SVCXPRT *svctcp_create ();
extern SVCXPRT *svcfd_create ();
#endif

#else

#endif /* !_RPC_SVC_SOC_H */
