/*
 * Sun RPC is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify Sun RPC without charge, but are not authorized
 * to license or distribute it to anyone else except as part of a product or
 * program developed by the user or with the express written consent of
 * Sun Microsystems, Inc.
 *
 * SUN RPC IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 *
 * Sun RPC is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 *
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY SUN RPC
 * OR ANY PART THEREOF.
 *
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even if
 * Sun has been advised of the possibility of such damages.
 *
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */
#if !defined(lint) && defined(SCCSIDS)
static char sccsid[] = "@(#)rac.c 1.4 91/03/11 Copyr 1988 Sun Micro";
#endif

/*
 * rac.c, Copyright (C) 1990, Sun Microsystems, Inc.
 */
/* LINTLIBRARY */
#include	<rpc/rpc.h>
#include	<rpc/rac.h>
#include	<rpc/rac_private.h>

void
rac_drop(cl, h)
CLIENT		*cl;
void		*h;
{
	(void) clnt_control(cl, CLRAC_DROP, (char *) h);
}

enum clnt_stat
rac_poll(cl, h)
CLIENT		*cl;
void		*h;
{
	return ((enum clnt_stat) clnt_control(cl, CLRAC_POLL, (char *) h));
}

enum clnt_stat
rac_recv(cl, h)
CLIENT		*cl;
void		*h;
{
	return ((enum clnt_stat) clnt_control(cl, CLRAC_RECV, (char *) h));
}

void *
rac_send(cl, proc, xargs, argsp, xresults, resultsp, timeout)
CLIENT		*cl;
unsigned long	proc;
xdrproc_t	xargs;
void		*argsp;
xdrproc_t	xresults;
void		*resultsp;
struct timeval	timeout;
{
	struct rac_send_req	req;

	req.proc = proc;
	req.xargs = xargs;
	req.argsp = argsp;
	req.xresults = xresults;
	req.resultsp = resultsp;
	req.timeout = timeout;

	return ((void *) clnt_control(cl, CLRAC_SEND, (char *) &req));
}
