/*
 * Sun RPC is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify Sun RPC without charge, but are not authorized
 * to license or distribute it to anyone else except as part of a product or
 * program developed by the user or with the express written consent of
 * Sun Microsystems, Inc.
 *
 * SUN RPC IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 *
 * Sun RPC is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 *
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY SUN RPC
 * OR ANY PART THEREOF.
 *
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even if
 * Sun has been advised of the possibility of such damages.
 *
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */
#ifndef lint
static        char sccsid[] = "@(#)netdir.c	1.13 91/03/11 TIRPC 1.0";
#endif

/*
 * Copyright (c) 1989 by Sun Microsystems, Inc.
 */

/*
 * netdir.c
 *
 * This is the library routines that do the name to address
 * translation.
 */

#include <stdio.h>
#include <sys/types.h>
#include <tiuser.h>
#include <netdir.h>
#include <netconfig.h>	
#include <string.h>
#include <sys/file.h>
#include <dlfcn.h>

#define SHARED_LIBS

extern int errno;
extern int _nderror;
extern char *_nderrbuf;

static struct translator {
	struct nd_addrlist	*(*gbn)();	/* _netdir_getbyname	*/
	struct nd_hostservlist 	*(*gba)();	/* _netdir_getbyaddr	*/
 	int			(*opt)();	/* _netdir_options	*/
	char			*(*t2u)();	/* _taddr2uaddr		*/
	struct netbuf		*(*u2t)();	/* _uaddr2taddr		*/
	void			*tr_handle;	/* library descriptor	*/
	char			*tr_name;	/* Full path		*/
	struct translator	*next;
};

#ifdef	_dlfcn_h	/* SunOS 4.1 */
extern char *sys_errlist[];
#endif

#ifdef SHARED_LIBS
static struct translator *xlate_list = NULL;
#else
extern struct nd_addrlist *tcp_netdir_getbyname(), *local_netdir_getbyname();
extern struct nd_hostservlist *tcp_netdir_getbyaddr(), *local_netdir_getbyaddr();
int tcp_netdir_options(), local_netdir_options();
char *tcp_taddr2uaddr(), *local_taddr2uaddr();
struct netbuf	*tcp_uaddr2taddr(), *local_uaddr2taddr();

static struct translator initial_list[2] = {
	{tcp_netdir_getbyname,
	 tcp_netdir_getbyaddr,
	 tcp_netdir_options,
	 tcp_taddr2uaddr,
	 tcp_uaddr2taddr,
	 0,
	 "tcpip.so",
	 &initial_list[1]},
	{local_netdir_getbyname,
	 local_netdir_getbyaddr,
	 local_netdir_options,
	 local_taddr2uaddr,
	 local_uaddr2taddr,
	 0,
	 "local.so",
	 NULL}
	};
static struct translator *xlate_list = initial_list;
#endif
 
static struct translator *load_xlate();
extern char *malloc();

/*
 * This routine is the main routine it resolves host/service/xprt triples
 * into a bunch of netbufs that should connect you to that particular
 * service. RPC uses it to contact the binder service (rpcbind)
 */
int
netdir_getbyname(tp, serv, addrs)
	struct netconfig	*tp;	/* The network config entry	*/
	struct nd_hostserv	*serv;	/* the service, host pair	*/
	struct nd_addrlist	**addrs; /* the answer			*/
{
	struct translator	*t;	/* pointer to translator list 	*/
	struct nd_addrlist	*nn;	/* the results			*/
	char			*lr;	/* routines to try		*/
	int			i;	/* counts the routines		*/
#ifdef	_dlfcn_h	/* SunOS 4.1 */
	void			*load_func;
extern	int			t_open(), t_close();

	/*
	 * This code is a hack to force the loading of certain
	 * TLI routines from libnsl in 4.1 that are used by the
	 * loadable n2a libraries supplied with ONC Toolkit.
	 * The test and set is done to ensure the code isn't
	 * optimized away.
	 */
	if ((void *)t_open != NULL)
	    load_func = NULL;
	if ((void *)t_close != NULL)
	    load_func = NULL;
#endif

	if (tp == NULL) {
		_nderror = ND_BADARG;
		return (_nderror);
	}

	for (i = 0; i < tp->nc_nlookups; i++) {
		lr = *((tp->nc_lookups) + i);
		for (t = xlate_list; t; t = t->next) {
			if (strcmp(lr, t->tr_name) == 0) {
				nn = (*(t->gbn))(tp, serv);
				if (nn) {
					*addrs = nn;
					return (0);
				} else {
					if (_nderror < 0) 
						return (_nderror);
					break;
				}
			} 
		}
		/* If we didn't find it try loading it */
		if (!t) {
			if ((t = load_xlate(lr)) != NULL) {
				/* add it to the list */
				t->next = xlate_list;
				xlate_list = t;
				nn = (*(t->gbn))(tp, serv);
				if (nn) {
					*addrs = nn;
					return (0);
				} else {
					if (_nderror < 0)
						return (_nderror);
				}
			}
		}
	}

	return (_nderror);	/* No one works */
}

/*
 * This routine is similar to the one above except that it trys to resolve
 * the name by the address passed.
 */
int
netdir_getbyaddr(tp, serv, addr)
	struct netconfig	*tp;	/* The netconfig entry		*/
	struct nd_hostservlist	**serv;	/* the answer(s)		*/
	struct netbuf		*addr;	/* the address we have		*/
{
	struct translator	*t;	/* pointer to translator list 	*/
	struct nd_hostservlist	*hs;	/* the results			*/
	char			*lr;	/* routines to try		*/
	int			i;	/* counts the routines		*/

	for (i = 0; i < tp->nc_nlookups; i++) {
		lr = *((tp->nc_lookups) + i);
		for (t = xlate_list; t; t = t->next) {
			if (strcmp(lr, t->tr_name) == 0) {
				hs = (*(t->gba))(tp, addr);
				if (hs) {
					*serv = hs;
					return (0);
				} else {
					if (_nderror < 0) 
						return (_nderror);
					break;
				}
			} 
		}
		/* If we didn't find it try loading it */
		if (!t) {
			if ((t = load_xlate(lr)) != NULL) {
				/* add it to the list */
				t->next = xlate_list;
				xlate_list = t;
				hs = (*(t->gba))(tp, addr);
				if (hs) {
					*serv = hs;
					return (0);
				} else {
					if (_nderror < 0)
						return (_nderror);
				}
			}
		}
	}

	return (_nderror);	/* No one works */
}

/*
 * This is the library routine for merging universal addresses with the
 * address of the client caller, so that a address which makes sense
 * can be returned to the client caller.
 * Again it uses the same code as below(uaddr2taddr)
 * to search for the appropriate translation routine. Only it doesn't
 * bother trying a whole bunch of routines since either the transport
 * can merge it or it can't. 
 */
int
netdir_options(tp, option, fd, par)
	struct netconfig	*tp;	/* the netconfig entry		*/
 	int			option;	/* option number		*/
 	int			fd;	/* open file descriptor		*/
 	char			*par;	/* parameters if any		*/
{
	struct translator	*t;	/* pointer to translator list 	*/
	char			*lr,	/* routines to try		*/
				*x;	/* the answer 			*/
	int			i;	/* counts the routines		*/
#ifdef	_dlfcn_h	/* SunOS 4.1 */
	void *load_func;
extern	int			t_optmgmt(), t_free(), t_bind(), t_getstate();
extern	char			*t_alloc();
extern  int			t_errno;

	/*
	 * This code is a hack to force the loading of certain
	 * TLI routines from libnsl in 4.1 that are used by the
	 * loadable n2a libraries supplied with ONC Toolkit.
	 * The test and set is done to ensure the code isn't
	 * optimized away.
	 */
	if ((void *)t_optmgmt != NULL)
	    load_func = NULL;
	if ((void *)t_alloc!= NULL)
	    load_func = NULL;
	if ((void *)t_free != NULL)
	    load_func = NULL;
	if ((void *)t_getstate != NULL)
	    load_func = NULL;
#endif

	if (tp == NULL) {
		_nderror = ND_BADARG;
		return (_nderror);
	}

	for (i = 0; i < tp->nc_nlookups; i++) {
		lr = *((tp->nc_lookups) + i);
		for (t = xlate_list; t; t = t->next) {
			if (strcmp(lr, t->tr_name) == 0) {
			return ((*(t->opt))(tp, option, fd, par));
			} 
		}
		/* If we didn't find it try loading it */
		if (!t) {
			if ((t = load_xlate(lr)) != NULL) {
				/* add it to the list */
				t->next = xlate_list;
				xlate_list = t;
 				return ((*(t->opt))(tp, option, fd, par));
			}
		}
	}

	return (_nderror);	/* No one works */
}

/*
 * This is the library routine for translating universal addresses to
 * transport specific addresses. Again it uses the same code as above
 * to search for the appropriate translation routine. Only it doesn't
 * bother trying a whole bunch of routines since either the transport
 * can translate it or it can't. 
 */
struct netbuf *
uaddr2taddr(tp, addr)
	struct netconfig	*tp;	/* the netconfig entry		*/
	char			*addr;	/* The address in question	*/
{
	struct translator	*t;	/* pointer to translator list 	*/
	struct netbuf		*x;	/* the answer we want 		*/
	char			*lr;	/* routines to try		*/
	int			i;	/* counts the routines		*/
#ifdef	_dlfcn_h	/* SunOS 4.1 */
	void			*load_func;
extern	int			t_open(), t_close();

	/*
	 * This code is a hack to force the loading of certain
	 * TLI routines from libnsl in 4.1 that are used by the
	 * loadable n2a libraries supplied with ONC Toolkit.
	 * The test and set is done to ensure the code isn't
	 * optimized away.
	 */
	if ((void *)t_open != NULL)
	    load_func = NULL;
	if ((void *)t_close != NULL)
	    load_func = NULL;
#endif

	for (i = 0; i < tp->nc_nlookups; i++) {
		lr = *((tp->nc_lookups) + i);
		for (t = xlate_list; t; t = t->next) {
			if (strcmp(lr, t->tr_name) == 0) {
				x = (*(t->u2t))(tp, addr);
				if (x)
					return (x);
				if (_nderror < 0) 
					return (0);
			} 
		}
		/* If we didn't find it try loading it */
		if (!t) {
			if ((t = load_xlate(lr)) != NULL) {
				/* add it to the list */
				t->next = xlate_list;
				xlate_list = t;
				x = (*(t->u2t))(tp, addr);
				if (x)
					return (x);
				if (_nderror < 0)
					return (0);
			}
		}
	}

	return (0);	/* No one works */
}
	
/*
 * This is the library routine for translating transport specific
 * addresses to universal addresses. Again it uses the same code as above
 * to search for the appropriate translation routine. Only it doesn't
 * bother trying a whole bunch of routines since either the transport
 * can translate it or it can't. 
 */
char *
taddr2uaddr(tp, addr)
	struct netconfig	*tp;	/* the netconfig entry		*/
	struct netbuf		*addr;	/* The address in question	*/
{
	struct translator	*t;	/* pointer to translator list 	*/
	char			*lr;	/* routines to try		*/
	char			*x;	/* the answer 			*/
	int			i;	/* counts the routines		*/

	for (i = 0; i < tp->nc_nlookups; i++) {
		lr = *((tp->nc_lookups) + i);
		for (t = xlate_list; t; t = t->next) {
			if (strcmp(lr, t->tr_name) == 0) {
				x = (*(t->t2u))(tp, addr);
				if (x)
					return (x);
				if (_nderror < 0) 
					return (0);
			} 
		}
		/* If we didn't find it try loading it */
		if (!t) {
			if ((t = load_xlate(lr)) != NULL) {
				/* add it to the list */
				t->next = xlate_list;
				xlate_list = t;
				x = (*(t->t2u))(tp, addr);
				if (x)
					return (x);
				if (_nderror < 0)
					return (0);
			}
		}
	}

	return (0);	/* No one works */
}

/*
 * This is the routine that frees the objects that these routines allocate.
 */
void
netdir_free(ptr, type)
	char	*ptr;	/* generic pointer 	*/
	int	type;	/* thing we are freeing */
{
	struct netbuf		*na;
	struct nd_addrlist	*nas;
	struct nd_hostserv	*hs;
	struct nd_hostservlist	*hss;
	int			i;

	switch (type) {
	case ND_ADDR :
		na = (struct netbuf *) ptr;
		free(na->buf);
		free((char *)na);
		break;

	case ND_ADDRLIST :
		nas = (struct nd_addrlist *) ptr;
		for (na = nas->n_addrs, i = 0; i < nas->n_cnt; i++, na++) {
			free(na->buf);
		}
		free((char *)nas->n_addrs);
		free((char *)nas);
		break;

	case ND_HOSTSERV :
		hs = (struct nd_hostserv *) ptr;
		free(hs->h_host);
		free(hs->h_serv);
		free((char *)hs);
		break;

	case ND_HOSTSERVLIST :
		hss = (struct nd_hostservlist *) ptr;
		for (hs = hss->h_hostservs, i = 0; i < hss->h_cnt; i++, hs++) {
			free(hs->h_host);
			free(hs->h_serv);
		}
		free((char *)hss->h_hostservs);
		free((char *)hss);
		break;	
	default :
		_nderror = ND_UKNWN;
		break;
	}
}

/*
 * load_xlate is a routine that will attempt to dynamically link in the
 * file specified by the network configuration structure.
 */
static struct translator *
load_xlate(name)
	char	*name;		/* file name to load */
{
#ifdef SHARED_LIBS
	struct translator	*t;

	/* do a sanity check on the file ... */
	if (access(name, 0) != 0) {
		_nderror = ND_ACCESS;
		return (NULL);
	}
	t = (struct translator *) malloc(sizeof(struct translator));
	if (!t) {
		_nderror = ND_NOMEM;
		return (NULL);
	}
	t->tr_name = strdup(name);
	if (!t->tr_name) {
		_nderror = ND_NOMEM;
		free((char *)t);
		return (NULL);
	}

	/* open for linking */
#ifdef	_dlfcn_h	/* SunOS 4.1 */
	t->tr_handle = dlopen(name, RTLD_LAZY);
#else
	t->tr_handle = dlopen(name, RTLD_NOW);
#endif
	if (t->tr_handle == NULL) {
		_nderror = ND_OPEN;
		goto error;
	}

	/* Resolve the getbyname symbol */
	t->gbn = (struct nd_addrlist *(*)())dlsym(t->tr_handle,
		"_netdir_getbyname");
	if (t->gbn == NULL) {
		_nderror = ND_NOSYM;
		goto error;
	}

	/* resolve the getbyaddr symbol */
	t->gba = (struct nd_hostservlist *(*)())dlsym(t->tr_handle,
		"_netdir_getbyaddr");
	if (t->gba == NULL) {
		_nderror = ND_NOSYM;
		goto error;
	}

	/* resolve the taddr2uaddr symbol */
	t->t2u = (char *(*)())dlsym(t->tr_handle, "_taddr2uaddr");
	if (t->t2u == NULL) {
		_nderror = ND_NOSYM;
		goto error;
	}

	/* resolve the uaddr2taddr symbol */
	t->u2t = (struct netbuf *(*)())dlsym(t->tr_handle,
		"_uaddr2taddr");
	if (t->u2t == NULL) {
		_nderror = ND_NOSYM;
		goto error;
	}

	/* resolve the netdir_options symbol */
	t->opt = (int (*)())dlsym(t->tr_handle, "_netdir_options");
	if (t->opt == NULL) {
		_nderror = ND_NOSYM;
		goto error;
	}
	return (t);
error:
	free((char *)t);
	_nderror = ND_ACCESS;
#else
	_nderror = ND_OPEN;
#endif
	return (NULL);
}

static char *
_buf()
{
	if (_nderrbuf == NULL)
		_nderrbuf = (char *)malloc(128);
	return (_nderrbuf);
}

/*
 * This is a routine that returns a string related to the current
 * error in _nderror.
 */
char *
netdir_sperror()
{
	char	*str = _buf();

	if (str == NULL)
		return (NULL);
	switch (_nderror) {
	case ND_NOMEM :
		(void) sprintf(str, "n2a: memory allocation failed");
		break;
	case ND_OK :
		(void) sprintf(str, "n2a: successful completion");
		break;
	case ND_NOHOST :
		(void) sprintf(str, "n2a: hostname not found");
		break;
	case ND_NOSERV :
		(void) sprintf(str, "n2a: service name not found");
		break;
	case ND_NOSYM :
		(void) sprintf(str, "n2a: symbol missing in shared object - %s", dlerror());
		break;
	case ND_OPEN :
		(void) sprintf(str, "n2a: couldn't open shared object - %s", dlerror());
		break;
	case ND_ACCESS :
		(void) sprintf(str, "n2a: access denied for shared object");
		break;
	case ND_UKNWN :
		(void) sprintf(str, "n2a: attempt to free unknown object");
		break;
	case ND_BADARG :
		(void) sprintf(str, "n2a: bad arguments passed to routine");
		break;
 	case ND_NOCTRL:
 		(void) sprintf(str, "n2a: unknown option passed");
 		break;
 	case ND_FAILCTRL:
 		(void) sprintf(str, "n2a: control operation failed");
 		break;
 	case ND_SYSTEM:
#ifdef	_dlfcn_h	/* SunOS 4.1 */
 		(void) sprintf(str, "n2a: system error: %s", sys_errlist[errno]);
#else
		(void) sprintf(str, "n2a: system error: %s", strerror(errno));
#endif
	default :
		(void) sprintf(str, "n2a: unknown error #%d", _nderror);
		break;
	}
	return (str);
}

/*
 * This is a routine that prints out strings related to the current
 * error in _nderror. Like perror() it takes a string to print with a 
 * colon first.
 */
void
netdir_perror(s)
	char	*s;
{
	char	*err;

	err = netdir_sperror();
	fprintf(stderr, "%s: %s\n", s, err ? err: "nd: error");
	return;
} 
