#! /bin/sh -
#
#   Sun RPC is a product of Sun Microsystems, Inc. and is provided for
#   unrestricted use provided that this legend is included on all tape
#   media and as a part of the software program in whole or part.  Users
#   may copy or modify Sun RPC without charge, but are not authorized
#   to license or distribute it to anyone else except as part of a product or
#   program developed by the user or with the express written consent of
#   Sun Microsystems, Inc.
#  
#   SUN RPC IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
#   WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
#   PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
#  
#   Sun RPC is provided with no support and without any obligation on the
#   part of Sun Microsystems, Inc. to assist in its use, correction,
#   modification or enhancement.
#  
#   SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
#   INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY SUN RPC
#   OR ANY PART THEREOF.
#  
#   In no event will Sun Microsystems, Inc. be liable for any lost revenue
#   or profits or other special, indirect and consequential damages, even if
#   Sun has been advised of the possibility of such damages.
#  
#   Sun Microsystems, Inc.
#   2550 Garcia Avenue
#   Mountain View, California  94043
#
#  @(#)install_librpc.sh	1.5 91/03/11 TIRPC 1.0;from 1.8 89/12/13 SMI
#
#
# The first argument is ${INSTALL}, the second is the version filename,
# the third is ${ROOT}, the fourth is the name of the directory where we'll
# find the shared archive (which should be the name of this system's
# architecture).
#
INSTALL=$1
VERS_FILE=$2
ROOT=$3
NONEX="-m 644"

version=`cat $VERS_FILE`

#
# Install in "$(ROOT)/lib" as "+<name>" with current version number.
#
$INSTALL -o root -g staff librpc.so $ROOT/lib/+librpc.so.$version
$INSTALL -o root -g staff $NONEX librpc.sa $ROOT/lib/+librpc.sa.$version

#
# Move version currently in "$ROOT/lib" to "-<name>".
#
if [ ! -n "$ROOT" -a -f $ROOT/lib/librpc.so.$version ]; then \
	mv -f $ROOT/lib/librpc.so.$version $ROOT/lib/-librpc.so.$version
fi
if [ ! -n "$ROOT" -a -f $ROOT/lib/librpc.sa.$version ]; then \
	mv -f $ROOT/lib/librpc.sa.$version $ROOT/lib/-librpc.sa.$version
fi

#
# Rename new version from "+<name>" to "<name>", and "ranlib" the ".sa"
# file.
#
mv -f $ROOT/lib/+librpc.so.$version $ROOT/lib/librpc.so.$version
mv -f  $ROOT/lib/+librpc.sa.$version $ROOT/lib/librpc.sa.$version
ranlib $ROOT/lib/librpc.sa.$version

