/*
 * Sun RPC is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify Sun RPC without charge, but are not authorized
 * to license or distribute it to anyone else except as part of a product or
 * program developed by the user or with the express written consent of
 * Sun Microsystems, Inc.
 *
 * SUN RPC IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 *
 * Sun RPC is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 *
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY SUN RPC
 * OR ANY PART THEREOF.
 *
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even if
 * Sun has been advised of the possibility of such damages.
 *
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */
/*	@(#)rpcent.h 1.13 91/03/11 SMI	*/

/*
 * rpcent.h,
 * For converting rpc program numbers to names etc.
 *
 * Copyright (C) 1984, Sun Microsystems, Inc.
 */

#ifndef sun 

struct rpcent {
	char	*r_name;	/* name of server for this rpc program */
	char	**r_aliases;	/* alias list */
	int	r_number;	/* rpc program number */
};

#ifdef __cplusplus
extern "C" struct rpcent *getrpcbyname (char *);
extern "C" struct rpcent *getrpcbynumber (int);
extern "C" struct rpcent *getrpcent ();
extern "C" int setrpcent (int);
extern "C" void endrpcent ();
#elif c_plusplus
extern struct rpcent *getrpcbyname (char *);
extern struct rpcent *getrpcbynumber (int);
extern struct rpcent *getrpcent ();
extern int setrpcent (int);
extern void endrpcent ();
#elif __STDC__
extern struct rpcent *getrpcbyname (char *);
extern struct rpcent *getrpcbynumber (int);
extern struct rpcent *getrpcent (void);
extern int setrpcent (int);
extern void endrpcent (void);
#else
extern struct rpcent *getrpcbyname ();
extern struct rpcent *getrpcbynumber ();
extern struct rpcent *getrpcent ();
extern int setrpcent ();
extern void endrpcent ();
#endif

#else

#include <netdb.h>

#endif /* sun */
